/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.database.DatabaseApplicationProperties;
import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.MinimalPatientStudySeriesInstanceModel;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.AnyExplicitStorePresentationContextSelectionPolicy;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkApplicationInformationFederated;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class StudyReceiver {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/StudyReceiver.java,v 1.23 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(StudyReceiver.class);
    protected static String defaultPropertiesFileName = ".com.pixelmed.apps.StudyReceiver.properties";
    protected static String propertyName_CompletedStudiesFolderName = "Application.CompletedStudiesFolderName";
    protected static String propertyName_SleepTimeBetweenPassesToProcessReceivedFiles = "Application.SleepTimeBetweenPassesToProcessReceivedFiles";
    protected static String propertyName_IntervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy = "Application.IntervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy";
    protected String defaultCompletedStudiesFolderName = ".com.pixelmed.apps.StudyReceiver.completedstudies";
    protected String defaultSleepTimeBetweenPassesToProcessReceivedFiles = "60";
    protected String defaultIntervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy = "60";
    protected static int sleepTimeBetweenPassesToProcessReceivedFiles;
    protected static int intervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy;
    protected Properties properties;
    protected NetworkApplicationProperties networkApplicationProperties;
    protected NetworkApplicationInformationFederated networkApplicationInformation;
    protected String ourCalledAETitle;
    protected DatabaseInformationModel databaseInformationModel;
    protected String buildDate = this.getBuildDate();
    protected File completedStudiesFolder;
    protected File savedImagesFolder;
    protected StoredFilePathStrategy storedFilePathStrategy = StoredFilePathStrategy.BYSOPINSTANCEUIDHASHSUBFOLDERS;
    protected String studyHasBeenProcessedColumnName = "PM_STUDYHASBEENPROCESSED";
    protected String studyMostRecentInsertionTimeColumnName = "PM_STUDYMOSTRECENTINSERTIONTIME";
    protected String instanceHasBeenProcessedColumnName = "PM_INSTANCEHASBEENPROCESSED";
    protected String studyInstanceUIDColumnName;
    protected String sopClassUIDColumnName;
    protected String instanceLocalFileNameColumnName;
    protected String instanceLocalFileReferenceTypeColumnName;
    protected String instanceLocalPrimaryKeyColumnName;
    protected String seriesLocalPrimaryKeyColumnName;
    protected static final AttributeList.ReadTerminationStrategy terminateAfterRelationshipGroup;
    private StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher;

    protected String getBuildDate() {
        String string = "";
        try {
            string = new BufferedReader(new InputStreamReader(StudyReceiver.class.getResourceAsStream("/BUILDDATE"))).readLine();
        }
        catch (IOException iOException) {
            slf4jlogger.error("", iOException);
        }
        return string;
    }

    protected void loadProperties(String string) throws IOException {
        this.properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(string);
        this.properties.load(fileInputStream);
        fileInputStream.close();
    }

    protected String renameFileWithHierarchicalPathFromAttributes(File file, AttributeList attributeList, String string, String string2) throws IOException, DicomException, NoSuchAlgorithmException {
        return MoveDicomFilesIntoHierarchy.renameFileWithHierarchicalPathFromAttributes(file, attributeList, string, string2);
    }

    protected void doSomethingWithProcessedDicomFile(String string) {
    }

    protected boolean processStudy(String string) throws DicomException, IOException, Exception {
        boolean bl = false;
        ArrayList arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent(InformationEntity.SERIES, string);
        for (Map map : arrayList) {
            String string2 = (String)map.get(this.seriesLocalPrimaryKeyColumnName);
            ArrayList arrayList2 = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent(InformationEntity.INSTANCE, string2);
            for (Map map2 : arrayList2) {
                String string3 = (String)map2.get(this.instanceLocalFileNameColumnName);
                slf4jlogger.info("processStudy(): processing fileName {}", string3);
                FileInputStream fileInputStream = new FileInputStream(string3);
                DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream, terminateAfterRelationshipGroup);
                dicomInputStream.close();
                fileInputStream.close();
                String string4 = this.renameFileWithHierarchicalPathFromAttributes(new File(string3), attributeList, this.completedStudiesFolder.getCanonicalPath(), "Duplicates");
                slf4jlogger.info("processStudy(): moved fileName {} to {}", string3, string4);
                if (string4 == null) continue;
                this.doSomethingWithProcessedDicomFile(string4);
                String string5 = (String)map2.get(this.instanceLocalPrimaryKeyColumnName);
                this.databaseInformationModel.updateSelectedRecord(InformationEntity.INSTANCE, string5, this.instanceLocalFileNameColumnName, string4);
            }
            bl = true;
        }
        return bl;
    }

    protected boolean processStudyIfComplete(String string) throws DicomException, IOException, Exception {
        boolean bl = false;
        long l = Long.parseLong(this.databaseInformationModel.findSelectedAttributeValuesForSelectedRecord(InformationEntity.STUDY, string, this.studyMostRecentInsertionTimeColumnName));
        long l2 = System.currentTimeMillis();
        slf4jlogger.trace("processStudyIfComplete(): currentTimeMillis = {}", l2);
        slf4jlogger.trace("processStudyIfComplete(): mostRecentInsertionTime = {}", l);
        long l3 = (l2 - l) / 1000L;
        slf4jlogger.trace("processStudyIfComplete(): secondsSinceMostRecentInsertion = {}", l3);
        if (l3 > (long)intervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy) {
            slf4jlogger.debug("processStudyIfComplete(): processing, since old enough");
            bl = this.processStudy(string);
        } else {
            slf4jlogger.debug("processStudyIfComplete(): not processing, since too recent");
        }
        return bl;
    }

    protected void updateStudyMostRecentInsertionTime(String string, long l) throws DicomException {
        slf4jlogger.trace("updateStudyMostRecentInsertionTime(): studyInstanceUID = {}, time = {}", string, l);
        ArrayList arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedKeyValue(InformationEntity.STUDY, this.studyInstanceUIDColumnName, string);
        if (arrayList.size() != 1) {
            throw new DicomException("Internal error: missing or multiple study table records for StudyInstanceUID" + string);
        }
        Map map = (Map)arrayList.get(0);
        String string2 = (String)map.get(this.databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.STUDY));
        this.databaseInformationModel.updateSelectedRecord(InformationEntity.STUDY, string2, this.studyMostRecentInsertionTimeColumnName, Long.toString(l));
        this.databaseInformationModel.updateSelectedRecord(InformationEntity.STUDY, string2, this.studyHasBeenProcessedColumnName, "FALSE");
    }

    protected void doSomethingWithReceivedDicomFile(String string, String string2, String string3, String string4) {
        System.err.println("doSomethingWithReceivedDicomFile(): " + string + " received from " + string2 + " in " + string3 + " is " + string4);
    }

    protected File getCompletedStudiesFolderNameCreatingItIfNecessary(String string) throws IOException {
        File file = new File(string);
        if (file.isAbsolute()) {
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new IOException("Cannot find or create absolute path " + file);
            }
        } else {
            file = new File(FileUtilities.makePathToFileInUsersHomeDirectory(string));
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new IOException("Cannot find or create home directory relative path " + file);
            }
        }
        return file;
    }

    public void activateStorageSCP() throws DicomException, IOException {
        this.shutdownStorageSCP();
        if (this.networkApplicationProperties == null) {
            throw new DicomException("Network application properties not supplied");
        }
        slf4jlogger.trace("Starting up DICOM association listener ...");
        int n = this.networkApplicationProperties.getListeningPort();
        this.storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, this.ourCalledAETitle, this.networkApplicationProperties.getAcceptorMaximumLengthReceived(), this.networkApplicationProperties.getAcceptorSocketReceiveBufferSize(), this.networkApplicationProperties.getAcceptorSocketSendBufferSize(), this.savedImagesFolder, this.storedFilePathStrategy, new OurReceivedObjectHandler(), null, null, null, this.networkApplicationInformation, new AnyExplicitStorePresentationContextSelectionPolicy(), false);
        new Thread(this.storageSOPClassSCPDispatcher).start();
    }

    public void shutdownStorageSCP() {
        if (this.storageSOPClassSCPDispatcher != null) {
            slf4jlogger.trace("Shutdown DICOM association listener ...");
            this.storageSOPClassSCPDispatcher.shutdown();
            this.storageSOPClassSCPDispatcher = null;
        }
    }

    public StudyReceiver(String string) throws DicomException, DicomNetworkException, IOException, InterruptedException {
        this.loadProperties(string);
        this.completedStudiesFolder = this.getCompletedStudiesFolderNameCreatingItIfNecessary(this.properties.getProperty(propertyName_CompletedStudiesFolderName, this.defaultCompletedStudiesFolderName));
        sleepTimeBetweenPassesToProcessReceivedFiles = Integer.valueOf(this.properties.getProperty(propertyName_SleepTimeBetweenPassesToProcessReceivedFiles, this.defaultSleepTimeBetweenPassesToProcessReceivedFiles));
        intervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy = Integer.valueOf(this.properties.getProperty(propertyName_IntervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy, this.defaultIntervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy));
        DatabaseApplicationProperties databaseApplicationProperties = new DatabaseApplicationProperties(this.properties);
        this.savedImagesFolder = databaseApplicationProperties.getSavedImagesFolderCreatingItIfNecessary();
        this.databaseInformationModel = new OurPatientStudySeriesInstanceModel(databaseApplicationProperties.getDatabaseFileName(), databaseApplicationProperties.getDatabaseServerName());
        this.studyInstanceUIDColumnName = this.databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.StudyInstanceUID);
        this.sopClassUIDColumnName = this.databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.SOPClassUID);
        this.instanceLocalFileNameColumnName = this.databaseInformationModel.getLocalFileNameColumnName(InformationEntity.INSTANCE);
        this.instanceLocalFileReferenceTypeColumnName = this.databaseInformationModel.getLocalFileReferenceTypeColumnName(InformationEntity.INSTANCE);
        this.instanceLocalPrimaryKeyColumnName = this.databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.INSTANCE);
        this.seriesLocalPrimaryKeyColumnName = this.databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.SERIES);
        this.networkApplicationProperties = new NetworkApplicationProperties(this.properties, true);
        this.networkApplicationInformation = new NetworkApplicationInformationFederated();
        this.networkApplicationInformation.startupAllKnownSourcesAndRegister(this.networkApplicationProperties);
        this.ourCalledAETitle = this.networkApplicationProperties.getCalledAETitle();
        this.activateStorageSCP();
        new Thread(new WatchDatabaseAndProcessCompleteStudies()).start();
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray.length > 0 ? stringArray[0] : FileUtilities.makePathToFileInUsersHomeDirectory(defaultPropertiesFileName);
            new StudyReceiver(string);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    static {
        terminateAfterRelationshipGroup = new OurReadTerminationStrategy();
    }

    protected class OurPatientStudySeriesInstanceModel
    extends MinimalPatientStudySeriesInstanceModel {
        OurPatientStudySeriesInstanceModel(String string, String string2) throws DicomException {
            super(string, string2);
        }

        @Override
        protected void extendCreateStatementStringWithUserColumns(StringBuffer stringBuffer, InformationEntity informationEntity) {
            if (informationEntity == InformationEntity.STUDY) {
                stringBuffer.append(", ");
                stringBuffer.append(StudyReceiver.this.studyHasBeenProcessedColumnName);
                stringBuffer.append(" ");
                stringBuffer.append("BOOLEAN");
                stringBuffer.append(", ");
                stringBuffer.append(StudyReceiver.this.studyMostRecentInsertionTimeColumnName);
                stringBuffer.append(" ");
                stringBuffer.append("BIGINT");
            } else if (informationEntity == InformationEntity.INSTANCE) {
                stringBuffer.append(", ");
                stringBuffer.append(StudyReceiver.this.instanceHasBeenProcessedColumnName);
                stringBuffer.append(" ");
                stringBuffer.append("BOOLEAN");
            }
        }
    }

    protected class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        protected OurReceivedObjectHandler() {
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                slf4jlogger.debug("Received: {} from {} in {}", string, string3, string2);
                try {
                    new Thread(new ReceivedFileProcessor(string)).start();
                }
                catch (Exception exception) {
                    slf4jlogger.error("Unable to process {} received from {} in {}", string, string3, string2, exception);
                }
            }
        }
    }

    protected class ReceivedFileProcessor
    implements Runnable {
        String receivedFileName;
        AttributeList list;

        ReceivedFileProcessor(String string) {
            this.receivedFileName = string;
        }

        @Override
        public void run() {
            try {
                slf4jlogger.trace("ReceivedFileProcessor.run(): receivedFileName = {}", this.receivedFileName);
                FileInputStream fileInputStream = new FileInputStream(this.receivedFileName);
                DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream, terminateAfterRelationshipGroup);
                dicomInputStream.close();
                fileInputStream.close();
                String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SourceApplicationEntityTitle);
                String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.MediaStorageSOPClassUID);
                StudyReceiver.this.doSomethingWithReceivedDicomFile(this.receivedFileName, string, string2, string3);
                string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
                if (string.length() <= 0) {
                    throw new DicomException("No StudyInstanceUID in received file " + this.receivedFileName);
                }
                StudyReceiver.this.databaseInformationModel.insertObject(attributeList, this.receivedFileName, "C");
                StudyReceiver.this.updateStudyMostRecentInsertionTime(string, System.currentTimeMillis());
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
    }

    protected class WatchDatabaseAndProcessCompleteStudies
    implements Runnable {
        protected WatchDatabaseAndProcessCompleteStudies() {
        }

        @Override
        public void run() {
            boolean bl = false;
            while (!bl) {
                slf4jlogger.trace("WatchDatabaseAndProcessCompleteStudies.run(): Starting or waking up WatchDatabaseAndProcessCompleteStudies ...");
                try {
                    ArrayList arrayList = StudyReceiver.this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntity(InformationEntity.STUDY);
                    for (Map map : arrayList) {
                        boolean bl2;
                        String string2;
                        if (slf4jlogger.isTraceEnabled()) {
                            slf4jlogger.trace("STUDY:");
                            for (String string2 : map.keySet()) {
                                slf4jlogger.trace("\t{} = {}", string2, map.get(string2));
                            }
                        }
                        String string3 = (String)map.get(StudyReceiver.this.databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.STUDY));
                        string2 = (String)map.get(StudyReceiver.this.studyHasBeenProcessedColumnName);
                        boolean bl3 = bl2 = string2 != null && string2.toUpperCase(Locale.US).equals("TRUE");
                        if (bl2) {
                            if (!slf4jlogger.isTraceEnabled()) continue;
                            slf4jlogger.trace("WatchDatabaseAndProcessCompleteStudies.run(): Already processed {}", map.get(StudyReceiver.this.studyInstanceUIDColumnName));
                            continue;
                        }
                        if (slf4jlogger.isDebugEnabled()) {
                            slf4jlogger.debug("WatchDatabaseAndProcessCompleteStudies.run(): Considering {}", map.get(StudyReceiver.this.studyInstanceUIDColumnName));
                        }
                        try {
                            if (!StudyReceiver.this.processStudyIfComplete(string3)) continue;
                            StudyReceiver.this.databaseInformationModel.updateSelectedRecord(InformationEntity.STUDY, string3, StudyReceiver.this.studyHasBeenProcessedColumnName, "TRUE");
                        }
                        catch (Exception exception) {
                            slf4jlogger.error("", exception);
                        }
                    }
                    slf4jlogger.trace("WatchDatabaseAndProcessCompleteStudies.run(): sleeping for " + sleepTimeBetweenPassesToProcessReceivedFiles + " seconds");
                    Thread.currentThread();
                    Thread.sleep(sleepTimeBetweenPassesToProcessReceivedFiles * 1000);
                }
                catch (DicomException dicomException) {
                    slf4jlogger.error("", dicomException);
                }
                catch (InterruptedException interruptedException) {
                    slf4jlogger.trace("WatchDatabaseAndProcessCompleteStudies.run(): interrupted: {}", interruptedException);
                    bl = true;
                }
            }
        }
    }

    protected static class OurReadTerminationStrategy
    implements AttributeList.ReadTerminationStrategy {
        protected OurReadTerminationStrategy() {
        }

        @Override
        public boolean terminate(AttributeList attributeList, AttributeTag attributeTag, long l) {
            return attributeTag.getGroup() > 32;
        }
    }
}

