/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.convert.TIFFException;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.BinaryOutputStream;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherByteAttributeCompressedSeparateFramesOnDisk;
import com.pixelmed.dicom.OtherByteAttributeMultipleCompressedFrames;
import com.pixelmed.dicom.OtherVeryLongAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class AddTIFFOrOffsetTables {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/AddTIFFOrOffsetTables.java,v 1.9 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(AddTIFFOrOffsetTables.class);
    private static final String pixelmedPrivateCreatorForPyramidData = "PixelMed Publishing";
    private static final int pixelmedPrivatePyramidDataGroup = 32735;
    private static final AttributeTag pixelmedPrivatePyramidDataBlockReservation = new AttributeTag(32735, 16);
    private static final AttributeTag pixelmedPrivatePyramidData = new AttributeTag(32735, 4097);
    private static final long UNSIGNED32_MAX_VALUE = 0xFFFFFFFFL;

    private int getTIFFPhotometricFromDICOMPhotometricInterpretation(String string) {
        int n = -1;
        switch (string) {
            case "MONOCHROME1": {
                n = 0;
                break;
            }
            case "MONOCHROME2": {
                n = 1;
                break;
            }
            case "RGB": {
                n = 2;
                break;
            }
            case "PALETTE COLOR": {
                n = 3;
                break;
            }
            case "TRANSPARENCY": {
                n = 4;
                break;
            }
            case "CMYK": {
                n = 5;
                break;
            }
            case "YBR_ICT": {
                n = 6;
                break;
            }
            case "YBR_RCT": {
                n = 6;
                break;
            }
            case "YBR_FULL_422": {
                n = 6;
                break;
            }
            case "CIELAB": {
                n = 8;
            }
        }
        return n;
    }

    private int getTIFFCompressionFromTransferSyntax(String string) {
        int n = 0;
        switch (string) {
            case "1.2.840.10008.1.2": {
                n = 1;
                break;
            }
            case "1.2.840.10008.1.2.1": {
                n = 1;
                break;
            }
            case "1.2.840.10008.1.2.2": {
                n = 1;
                break;
            }
            case "1.2.840.10008.1.2.4.50": {
                n = 7;
                break;
            }
            case "1.2.840.10008.1.2.4.91": {
                n = 33005;
                break;
            }
            case "1.2.840.10008.1.2.4.90": {
                n = 33005;
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long getByteOffsetsAndLengthsOfTileDataFromStartOfFileForPixelDataAttribute(long l, Attribute attribute, int n, int n2, boolean bl, boolean bl2, long[] lArray, long[] lArray2, boolean bl3, long l2, boolean bl4) throws DicomException {
        long l3;
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("0x{} ({} dec): {} {}", Long.toHexString(l), l, attribute.toString(), attribute.getClass());
        }
        if ((l3 = attribute.getVL()) == 0xFFFFFFFFL) {
            if (bl3) {
                throw new DicomException("Planar Configuration with separate planes not supported for compressed pixel data");
            }
            if (attribute instanceof OtherByteAttributeMultipleCompressedFrames) {
                OtherByteAttributeMultipleCompressedFrames otherByteAttributeMultipleCompressedFrames = (OtherByteAttributeMultipleCompressedFrames)attribute;
                l += attribute.getLengthOfBaseOfEncodedAttribute(bl, bl2);
                l += 8L;
                if (bl4) {
                    l += (long)(n * 4);
                }
                byte[][] byArray = otherByteAttributeMultipleCompressedFrames.getFrames();
                File[] fileArray = otherByteAttributeMultipleCompressedFrames.getFiles();
                int n3 = 0;
                if (fileArray != null) {
                    n3 = fileArray.length;
                } else {
                    if (byArray == null) throw new DicomException("Not yet implemented - calculating offsets and lengths from " + attribute.getClass() + " with all frames in one fragment");
                    n3 = byArray.length;
                }
                if (n3 != n) {
                    throw new DicomException("Not yet implemented - calculating offsets and lengths from " + attribute.getClass() + " when number of files not the same as number of frames");
                }
                if (n3 > 0) {
                    for (int i = 0; i < n3; ++i) {
                        File file = null;
                        byte[] byArray2 = null;
                        long l4 = 0L;
                        if (fileArray != null) {
                            file = fileArray[i];
                            l4 = file.length();
                        } else {
                            byArray2 = byArray[i];
                            l4 = byArray2.length;
                        }
                        lArray2[i] = l4;
                        long l5 = l4 % 2L;
                        long l6 = l4 + l5;
                        lArray[i] = l += 8L;
                        if (slf4jlogger.isTraceEnabled()) {
                            slf4jlogger.trace("Frame {} 0x{} ({} dec): length = 0x{} ({} dec)", i, Long.toHexString(l), l, Long.toHexString(l4), l4);
                        }
                        l += l6;
                    }
                }
                l += 8L;
            } else {
                int n4;
                if (!(attribute instanceof OtherByteAttributeCompressedSeparateFramesOnDisk)) throw new DicomException("Not yet implemented - calculating offsets and lengths from " + attribute.getClass());
                OtherByteAttributeCompressedSeparateFramesOnDisk otherByteAttributeCompressedSeparateFramesOnDisk = (OtherByteAttributeCompressedSeparateFramesOnDisk)attribute;
                l += attribute.getLengthOfBaseOfEncodedAttribute(bl, bl2);
                l += 8L;
                if (bl4) {
                    l += (long)(n * 4);
                }
                if ((n4 = otherByteAttributeCompressedSeparateFramesOnDisk.getNumberOfFrames()) != n) {
                    throw new DicomException("Not yet implemented - calculating offsets and lengths from " + attribute.getClass() + " but expected number of frames " + n + "does not match actual number of frames" + n4);
                }
                long[][] lArray3 = otherByteAttributeCompressedSeparateFramesOnDisk.getFrameItemLengths();
                if (lArray3.length != n4) {
                    throw new DicomException("Not yet implemented - calculating offsets and lengths from " + attribute.getClass() + " when number of frames " + n4 + "does not match length of frameItemLengths" + lArray3.length);
                }
                if (n4 > 0) {
                    for (int i = 0; i < n4; ++i) {
                        long l7;
                        long[] lArray4 = lArray3[i];
                        if (lArray4 == null) {
                            throw new DicomException("Not yet implemented - calculating offsets and lengths from " + attribute.getClass() + " but no fragment lengths for frame " + i);
                        }
                        if (lArray4.length == 0) {
                            throw new DicomException("Not yet implemented - calculating offsets and lengths from " + attribute.getClass() + " but missing fragment length for frame " + i);
                        }
                        if (lArray4.length > 1) {
                            throw new DicomException("Not yet implemented - calculating offsets and lengths from " + attribute.getClass() + " when more than one fragment per frame for frame " + i);
                        }
                        lArray2[i] = l7 = lArray4[0];
                        long l8 = l7 % 2L;
                        long l9 = l7 + l8;
                        lArray[i] = l += 8L;
                        if (slf4jlogger.isTraceEnabled()) {
                            slf4jlogger.trace("Frame {} 0x{} ({} dec): length = 0x{} ({} dec)", i, Long.toHexString(l), l, Long.toHexString(l7), l7);
                        }
                        l += l9;
                    }
                }
                l += 8L;
            }
        } else {
            l += attribute.getLengthOfBaseOfEncodedAttribute(bl, bl2);
            long l10 = l3 / (long)n;
            if (n > 0) {
                if (bl3) {
                    long l11 = l10 / l2;
                    for (int i = 0; i < n; ++i) {
                        int n5 = 0;
                        while ((long)n5 < l2) {
                            int n6 = n5 * n + i;
                            lArray2[n6] = l11;
                            lArray[n6] = l;
                            if (slf4jlogger.isTraceEnabled()) {
                                slf4jlogger.trace("DICOM Frame {} TIFF Tile {} 0x{} ({} dec): length = 0x{} ({} dec)", i, n6, Long.toHexString(l), l, Long.toHexString(l11), l11);
                            }
                            l += l11;
                            ++n5;
                        }
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        lArray2[i] = l10;
                        lArray[i] = l;
                        if (slf4jlogger.isTraceEnabled()) {
                            slf4jlogger.trace("Frame {} 0x{} ({} dec): length = 0x{} ({} dec)", i, Long.toHexString(l), l, Long.toHexString(l10), l10);
                        }
                        l += l10;
                    }
                }
                if (attribute.getVL() != attribute.getPaddedVL()) {
                    ++l;
                }
            }
        }
        if (!slf4jlogger.isDebugEnabled()) return l;
        slf4jlogger.debug("getByteOffsetsAndLengthsOfTileDataFromStartOfFileForPixelDataAttribute(): returns 0x{} ({} dec): {} {}", Long.toHexString(l), l);
        return l;
    }

    static long getByteOffsetsAndLengthsOfTileDataFromStartOfFile(AttributeList attributeList, String string, long[][] lArray, long[][] lArray2, long[] lArray3, long[] lArray4, boolean bl, long l, boolean bl2) throws DicomException {
        long l2 = 132L;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = true;
        TransferSyntax transferSyntax = new TransferSyntax(string);
        boolean bl6 = transferSyntax.isExplicitVR();
        boolean bl7 = transferSyntax.isLittleEndian();
        for (Attribute attribute : attributeList.values()) {
            AttributeTag attributeTag = attribute.getTag();
            if (!bl3 && !attributeTag.isFileMetaInformationGroup()) {
                bl3 = true;
                bl4 = bl6;
                bl5 = bl7;
            }
            if (attributeTag.equals(TagFromName.PixelData) || attributeTag.equals(TagFromName.FloatPixelData) || attributeTag.equals(TagFromName.DoubleFloatPixelData)) {
                slf4jlogger.debug("getByteOffsetsAndLengthsOfTileDataFromStartOfFile(): Have PixelData or FloatPixelData or DoubleFloatPixelData");
                lArray3[0] = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.TotalPixelMatrixColumns, 0);
                lArray4[0] = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.TotalPixelMatrixRows, 0);
                int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
                slf4jlogger.debug("getByteOffsetsAndLengthsOfTileDataFromStartOfFile(): numberOfFrames = {}", n);
                int n2 = n * (bl ? (int)l : 1);
                slf4jlogger.debug("getByteOffsetsAndLengthsOfTileDataFromStartOfFile(): numberOfTiles = {}", n2);
                lArray[0] = new long[n2];
                lArray2[0] = new long[n2];
                l2 = AddTIFFOrOffsetTables.getByteOffsetsAndLengthsOfTileDataFromStartOfFileForPixelDataAttribute(l2, attribute, n, n2, bl4, bl5, lArray[0], lArray2[0], bl, l, bl2);
                continue;
            }
            if (attributeTag.equals(pixelmedPrivatePyramidData)) {
                int n = 1;
                SequenceAttribute sequenceAttribute = (SequenceAttribute)attribute;
                l2 += sequenceAttribute.getLengthOfBaseOfEncodedAttribute(bl4, bl5);
                Iterator<SequenceItem> iterator = sequenceAttribute.iterator();
                while (iterator.hasNext()) {
                    l2 += 8L;
                    SequenceItem sequenceItem = iterator.next();
                    AttributeList attributeList2 = sequenceItem.getAttributeList();
                    if (attributeList2 != null) {
                        int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList2, TagFromName.SamplesPerPixel, 0);
                        int n4 = Attribute.getSingleIntegerValueOrDefault(attributeList2, TagFromName.PlanarConfiguration, 0);
                        boolean bl8 = n4 == 1 && n3 > 1;
                        slf4jlogger.debug("getByteOffsetsAndLengthsOfTileDataFromStartOfFile(): for PrivatePyramidData, mergeSamplesPerPixelTiles = {}", bl8);
                        for (Attribute attribute2 : attributeList2.values()) {
                            AttributeTag attributeTag2 = attribute2.getTag();
                            if (attributeTag2.equals(TagFromName.PixelData)) {
                                lArray3[n] = Attribute.getSingleIntegerValueOrDefault(attributeList2, TagFromName.TotalPixelMatrixColumns, 0);
                                lArray4[n] = Attribute.getSingleIntegerValueOrDefault(attributeList2, TagFromName.TotalPixelMatrixRows, 0);
                                int n5 = Attribute.getSingleIntegerValueOrDefault(attributeList2, TagFromName.NumberOfFrames, 1);
                                slf4jlogger.debug("getByteOffsetsAndLengthsOfTileDataFromStartOfFile(): numberOfFrames = {}", n5);
                                int n6 = n5 * (bl ? (int)l : 1);
                                slf4jlogger.debug("getByteOffsetsAndLengthsOfTileDataFromStartOfFile(): numberOfTiles = {}", n6);
                                lArray[n] = new long[n6];
                                lArray2[n] = new long[n6];
                                l2 = AddTIFFOrOffsetTables.getByteOffsetsAndLengthsOfTileDataFromStartOfFileForPixelDataAttribute(l2, attribute2, n5, n6, bl4, bl5, lArray[n], lArray2[n], bl8, n3, false);
                                continue;
                            }
                            l2 += attribute2.getLengthOfEntireEncodedAttribute(bl4, bl5);
                        }
                    }
                    ++n;
                    l2 += 8L;
                }
                l2 += 8L;
                continue;
            }
            long l3 = attribute.getLengthOfEntireEncodedAttribute(bl4, bl5);
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("0x{} ({} dec): {} encoded length = 0x{} ({} dec)", Long.toHexString(l2), l2, attribute.toString(), Long.toHexString(l3), l3);
            }
            l2 += l3;
        }
        long l4 = l2;
        return l4;
    }

    private static void writeUnsigned32Or64Bits(BinaryOutputStream binaryOutputStream, boolean bl, long l) throws IOException {
        if (bl) {
            binaryOutputStream.writeUnsigned64(l);
        } else {
            binaryOutputStream.writeUnsigned32(l);
        }
    }

    static byte[] makeTIFFInPreambleAndAddDataSetTrailingPadding(long l, int n, long[][] lArray, long[][] lArray2, long[] lArray3, long[] lArray4, AttributeList attributeList, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, byte[] byArray, double d, double d2, boolean bl) throws DicomException, IOException {
        slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): useBigTIFF = {}", bl);
        boolean bl2 = true;
        slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): useResolution = {}", bl2);
        boolean bl3 = l8 == 1L && l4 > 8L;
        boolean bl4 = false;
        slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): includeYCbCrSubSampling = {}", bl4);
        boolean bl5 = byArray != null && byArray.length > 0;
        byte[] byArray2 = null;
        slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): byteOffsetFromFileStartOfNextAttributeAfterPixelData = {}", l);
        long l11 = l + 12L;
        slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): offsetofIFD = {}", l11);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        BinaryOutputStream binaryOutputStream = new BinaryOutputStream(byteArrayOutputStream, false);
        binaryOutputStream.write(73);
        binaryOutputStream.write(73);
        if (bl) {
            binaryOutputStream.writeUnsigned16(43);
            binaryOutputStream.writeUnsigned16(8);
            binaryOutputStream.writeUnsigned16(0);
            binaryOutputStream.writeUnsigned64(l11);
        } else {
            binaryOutputStream.writeUnsigned16(42);
            if (l11 > 0xFFFFFFFFL) {
                throw new DicomException("Offset of first IFD is too large to fit in 32 bits 0x" + Long.toHexString(l11) + " (" + l11 + " dec)");
            }
            binaryOutputStream.writeUnsigned32(l11);
        }
        binaryOutputStream.flush();
        binaryOutputStream.close();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        byArray2 = new byte[128];
        System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
        byteArrayOutputStream = new ByteArrayOutputStream(8);
        binaryOutputStream = new BinaryOutputStream(byteArrayOutputStream, false);
        double d3 = d;
        double d4 = d2;
        slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): numberOfPyramidLevels = {}", n);
        for (int i = 0; i < n; ++i) {
            long l12;
            int n2;
            int n3;
            slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): pyramidLevel = {}", i);
            int n4 = lArray[i].length;
            slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): numberOfTiles = {}", n4);
            int n5 = n3 = i == 0 ? 14 : 15;
            if (bl3) {
                ++n3;
            }
            if (bl4) {
                ++n3;
            }
            if (bl5) {
                ++n3;
            }
            if (bl) {
                binaryOutputStream.writeUnsigned64(n3);
            } else {
                binaryOutputStream.writeUnsigned16(n3);
            }
            long l13 = (bl ? 8 : 2) + n3 * (bl ? 20 : 12) + (bl ? 8 : 4);
            slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): lengthOfIFD = {}", l13);
            long l14 = l11 + l13;
            slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): bitsPerSampleOffset = {}", l14);
            boolean bl6 = bl && l8 > 4L || !bl && l8 > 2L;
            long l15 = l14 + (bl6 ? 2L * l8 : 0L);
            slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): xResolutionOffset = {}", l15);
            long l16 = l15 + (long)(bl ? 0 : 8);
            slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): yResolutionOffset = {}", l16);
            long l17 = l16 + (long)(bl ? 0 : 8);
            slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): iccProfileOffset = {}", l17);
            boolean bl7 = n4 > 1;
            long l18 = l17 + (long)(bl5 ? byArray.length : 0);
            slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): tileOffsetsOffset = {}", l18);
            long l19 = l18 + (long)(bl7 ? n4 * (bl ? 8 : 4) : 0);
            slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): tileByteCountsOffset = {}", l19);
            long l20 = i + 1 < n ? l19 + (long)(bl7 ? n4 * (bl ? 8 : 4) : 0) : 0L;
            slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): offsetOfNextIFD = {}", l20);
            if (!bl && l20 > 0xFFFFFFFFL) {
                throw new DicomException("Offset for IFD is too large to fit in 32 bits 0x" + Long.toHexString(l20) + " (" + l20 + " dec)");
            }
            if (i > 0) {
                binaryOutputStream.writeUnsigned16(254);
                binaryOutputStream.writeUnsigned16(4);
                AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, 1L);
                AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, 1L);
            }
            binaryOutputStream.writeUnsigned16(256);
            binaryOutputStream.writeUnsigned16(4);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, 1L);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, lArray3[i]);
            binaryOutputStream.writeUnsigned16(257);
            binaryOutputStream.writeUnsigned16(4);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, 1L);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, lArray4[i]);
            binaryOutputStream.writeUnsigned16(258);
            binaryOutputStream.writeUnsigned16(3);
            if (bl) {
                binaryOutputStream.writeUnsigned64(l8);
                if (l8 <= 4L) {
                    binaryOutputStream.writeUnsigned16((int)l4);
                    binaryOutputStream.writeUnsigned16(l8 > 1L ? (int)l4 : 0);
                    binaryOutputStream.writeUnsigned16(l8 > 2L ? (int)l4 : 0);
                    binaryOutputStream.writeUnsigned16(l8 > 3L ? (int)l4 : 0);
                } else {
                    binaryOutputStream.writeUnsigned64(l14);
                }
            } else {
                binaryOutputStream.writeUnsigned32(l8);
                if (l8 <= 2L) {
                    binaryOutputStream.writeUnsigned16((int)l4);
                    binaryOutputStream.writeUnsigned16(l8 > 1L ? (int)l4 : 0);
                } else {
                    binaryOutputStream.writeUnsigned32(l14);
                }
            }
            binaryOutputStream.writeUnsigned16(259);
            binaryOutputStream.writeUnsigned16(3);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, 1L);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, l5);
            binaryOutputStream.writeUnsigned16(262);
            binaryOutputStream.writeUnsigned16(3);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, 1L);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, i == 0 ? l6 : l7);
            binaryOutputStream.writeUnsigned16(277);
            binaryOutputStream.writeUnsigned16(3);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, 1L);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, l8);
            slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): mmPerPixelX = {}", d3);
            slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): mmPerPixelY = {}", d4);
            long l21 = !bl2 || d3 == 0.0 ? 1L : Math.round(10.0 / d3);
            long l22 = !bl2 || d4 == 0.0 ? 1L : Math.round(10.0 / d4);
            slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): resolutionNumeratorX = {}", l21);
            slf4jlogger.debug("makeTIFFInPreambleAndAddDataSetTrailingPadding(): resolutionNumeratorY = {}", l22);
            binaryOutputStream.writeUnsigned16(282);
            binaryOutputStream.writeUnsigned16(5);
            if (bl) {
                binaryOutputStream.writeUnsigned64(1L);
                binaryOutputStream.writeUnsigned32(l21);
                binaryOutputStream.writeUnsigned32(1L);
            } else {
                binaryOutputStream.writeUnsigned32(1L);
                binaryOutputStream.writeUnsigned32(l15);
            }
            binaryOutputStream.writeUnsigned16(283);
            binaryOutputStream.writeUnsigned16(5);
            if (bl) {
                binaryOutputStream.writeUnsigned64(1L);
                binaryOutputStream.writeUnsigned32(l22);
                binaryOutputStream.writeUnsigned32(1L);
            } else {
                binaryOutputStream.writeUnsigned32(1L);
                binaryOutputStream.writeUnsigned32(l16);
            }
            binaryOutputStream.writeUnsigned16(284);
            binaryOutputStream.writeUnsigned16(3);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, 1L);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, i == 0 ? l9 : 1L);
            binaryOutputStream.writeUnsigned16(296);
            binaryOutputStream.writeUnsigned16(3);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, 1L);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, bl2 ? 3L : 1L);
            binaryOutputStream.writeUnsigned16(322);
            binaryOutputStream.writeUnsigned16(3);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, 1L);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, l2);
            binaryOutputStream.writeUnsigned16(323);
            binaryOutputStream.writeUnsigned16(3);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, 1L);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, l3);
            binaryOutputStream.writeUnsigned16(324);
            binaryOutputStream.writeUnsigned16(bl ? 16 : 4);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, n4);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, bl7 ? l18 : lArray[i][0]);
            binaryOutputStream.writeUnsigned16(325);
            binaryOutputStream.writeUnsigned16(bl ? 16 : 4);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, n4);
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, bl7 ? l19 : lArray2[i][0]);
            if (bl3) {
                binaryOutputStream.writeUnsigned16(339);
                binaryOutputStream.writeUnsigned16(3);
                AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, 1L);
                AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, l10);
            }
            if (bl4) {
                binaryOutputStream.writeUnsigned16(530);
                binaryOutputStream.writeUnsigned16(3);
                AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, 2L);
                binaryOutputStream.writeUnsigned16(i > 0 ? 1 : 1);
                binaryOutputStream.writeUnsigned16(i > 0 ? 1 : 1);
                if (bl) {
                    binaryOutputStream.writeUnsigned32(0L);
                }
            }
            if (bl5) {
                binaryOutputStream.writeUnsigned16(34675);
                binaryOutputStream.writeUnsigned16(7);
                AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, byArray.length);
                AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, l17);
            }
            AddTIFFOrOffsetTables.writeUnsigned32Or64Bits(binaryOutputStream, bl, l20);
            if (bl6) {
                n2 = 0;
                while ((long)n2 < l8) {
                    binaryOutputStream.writeUnsigned16((int)l4);
                    ++n2;
                }
            }
            if (!bl) {
                binaryOutputStream.writeUnsigned32(l21);
                binaryOutputStream.writeUnsigned32(1L);
            }
            if (!bl) {
                binaryOutputStream.writeUnsigned32(l22);
                binaryOutputStream.writeUnsigned32(1L);
            }
            if (byArray != null && byArray.length > 0) {
                binaryOutputStream.write(byArray);
            }
            for (n2 = 0; n2 < n4; ++n2) {
                l12 = lArray[i][n2];
                slf4jlogger.trace("makeTIFFInPreambleAndAddDataSetTrailingPadding(): pyramid level {} tile {} offset = {}", i, n2, l12);
                if (bl) {
                    binaryOutputStream.writeUnsigned64(l12);
                    continue;
                }
                if (l12 > 0xFFFFFFFFL) {
                    throw new DicomException("Offset for frame " + n2 + " is too large to fit in 32 bits 0x" + Long.toHexString(l12) + " (" + l12 + " dec)");
                }
                binaryOutputStream.writeUnsigned32(l12);
            }
            for (n2 = 0; n2 < n4; ++n2) {
                l12 = lArray2[i][n2];
                slf4jlogger.trace("makeTIFFInPreambleAndAddDataSetTrailingPadding(): pyramid level {} tile {} length = {}", i, n2, l12);
                if (bl) {
                    binaryOutputStream.writeUnsigned64(l12);
                    continue;
                }
                if (l12 > 0xFFFFFFFFL) {
                    throw new DicomException("Length for frame " + n2 + " is too large to fit in 32 bits 0x" + Long.toHexString(l12) + " (" + l12 + " dec)");
                }
                binaryOutputStream.writeUnsigned32(l12);
            }
            l11 = l20;
            d3 *= 2.0;
            d4 *= 2.0;
        }
        binaryOutputStream.flush();
        binaryOutputStream.close();
        OtherByteAttribute otherByteAttribute = new OtherByteAttribute(TagFromName.DataSetTrailingPadding);
        ((Attribute)otherByteAttribute).setValues(byteArrayOutputStream.toByteArray());
        attributeList.put(otherByteAttribute);
        return byArray2;
    }

    public AddTIFFOrOffsetTables(String string, String string2, boolean bl, boolean bl2) throws IOException, DicomException, TIFFException, NumberFormatException {
        this(string, string2, bl, bl2, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AddTIFFOrOffsetTables(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException, DicomException, TIFFException, NumberFormatException {
        AttributeList attributeList = new AttributeList();
        attributeList.setDecompressPixelData(false);
        attributeList.read(string);
        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
        if (string3 == null || string3.length() == 0) {
            throw new DicomException("Missing or empty TransferSyntaxUID in " + string);
        }
        if (!new TransferSyntax(string3).isEncapsulated()) {
            if (bl3) {
                throw new DicomException("Cannot add Extended Offset Table for non-encapsulated Transfer Syntax " + string3);
            }
            if (bl4) {
                throw new DicomException("Cannot add Basic Offset Table for non-encapsulated Transfer Syntax " + string3);
            }
        }
        attributeList.removeGroupLengthAttributes();
        attributeList.removeMetaInformationHeaderAttributes();
        attributeList.remove(TagFromName.DataSetTrailingPadding);
        FileMetaInformation.addFileMetaInformation(attributeList, string3, "OURAETITLE");
        byte[] byArray = null;
        if (bl || bl3 || bl4) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            long l;
            long l2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 0);
            long l3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PlanarConfiguration, 0) + 1;
            long l4 = l = (long)this.getTIFFPhotometricFromDICOMPhotometricInterpretation(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PhotometricInterpretation));
            int n = 1;
            if (Attribute.getSingleStringValueOrEmptyString(attributeList, pixelmedPrivatePyramidDataBlockReservation).equals(pixelmedPrivateCreatorForPyramidData) && (object4 = (SequenceAttribute)attributeList.get(pixelmedPrivatePyramidData)) != null && (n = ((SequenceAttribute)object4).getNumberOfItems() + 1) >= 2 && (object3 = (Object)SequenceAttribute.getNamedAttributeFromWithinSelectedItemWithinSequence((SequenceAttribute)object4, 0, TagFromName.PhotometricInterpretation)) != null) {
                String string4 = ((Attribute)object3).getSingleStringValueOrDefault("");
                l4 = this.getTIFFPhotometricFromDICOMPhotometricInterpretation(string4);
            }
            slf4jlogger.debug("AddTIFFOrOffsetTables(): numberOfPyramidLevels = {}", n);
            object4 = new long[n][];
            object3 = new long[n][];
            long[] lArray = new long[n];
            long[] lArray2 = new long[n];
            boolean bl5 = l3 == 2L && l2 > 1L;
            slf4jlogger.debug("AddTIFFOrOffsetTables(): mergeSamplesPerPixelTiles = {}", bl5);
            int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
            int[] nArray = null;
            if (bl4) {
                if (bl3) {
                    slf4jlogger.warn("AddTIFFOrOffsetTables(): Basic Offset Table Item Value is not permitted if Extended Offset Table is present - inserting anyway assuming creating test invalid object");
                }
                nArray = new int[n2];
                object2 = attributeList.get(TagFromName.PixelData);
                if (object2 == null) throw new DicomException("Unable to find PixelData attribute into which to insert BOT");
                if (object2 instanceof OtherByteAttributeMultipleCompressedFrames) {
                    ((OtherByteAttributeMultipleCompressedFrames)object2).setBasicOffsetTable(nArray);
                } else {
                    if (!(object2 instanceof OtherByteAttributeCompressedSeparateFramesOnDisk)) throw new DicomException("Not yet implemented - inserting BOT into " + object2.getClass());
                    ((OtherByteAttributeCompressedSeparateFramesOnDisk)object2).setBasicOffsetTable(nArray);
                }
            }
            object2 = null;
            long[] lArray3 = null;
            if (bl3) {
                object2 = new long[n2];
                lArray3 = new long[n2];
                OtherVeryLongAttribute otherVeryLongAttribute = new OtherVeryLongAttribute(TagFromName.ExtendedOffsetTable);
                ((Attribute)otherVeryLongAttribute).setValues((long[])object2);
                attributeList.put(otherVeryLongAttribute);
                otherVeryLongAttribute = new OtherVeryLongAttribute(TagFromName.ExtendedOffsetTableLengths);
                ((Attribute)otherVeryLongAttribute).setValues(lArray3);
                attributeList.put(otherVeryLongAttribute);
            }
            long l5 = AddTIFFOrOffsetTables.getByteOffsetsAndLengthsOfTileDataFromStartOfFile(attributeList, string3, (long[][])object4, (long[][])object3, lArray, lArray2, bl5, l2, bl4);
            if (bl4) {
                object = object4[0][0];
                for (int i = 0; i < n2; ++i) {
                    reference var33_32 = object4[0][i] - object;
                    if (var33_32 > 0xFFFFFFFFL) {
                        throw new DicomException("Offset for frame is too large to fit in 32 bits 0x" + Long.toHexString((long)var33_32) + " (" + (long)var33_32 + " dec) - cannot create Basic Offset Table");
                    }
                    nArray[i] = (int)var33_32;
                    if (!slf4jlogger.isTraceEnabled() || i >= 10 && i <= n2 - 10) continue;
                    slf4jlogger.trace("AddTIFFOrOffsetTables(): frame[{}] BOT offset {}", i, nArray[i]);
                }
                Attribute attribute = attributeList.get(TagFromName.PixelData);
                if (attribute != null) {
                    if (attribute instanceof OtherByteAttributeMultipleCompressedFrames) {
                        ((OtherByteAttributeMultipleCompressedFrames)attribute).setBasicOffsetTable(nArray);
                    } else if (attribute instanceof OtherByteAttributeCompressedSeparateFramesOnDisk) {
                        ((OtherByteAttributeCompressedSeparateFramesOnDisk)attribute).setBasicOffsetTable(nArray);
                    }
                }
            }
            if (bl3) {
                object = object4[0][0];
                for (int i = 0; i < n2; ++i) {
                    object2[i] = object4[0][i] - object;
                    lArray3[i] = (long)object3[0][i];
                    if (!slf4jlogger.isTraceEnabled() || i >= 10 && i <= n2 - 10) continue;
                    slf4jlogger.trace("AddTIFFOrOffsetTables(): frame[{}] EOT offset {} length {}", i, (long)object2[i], lArray3[i]);
                }
                attributeList.get(TagFromName.ExtendedOffsetTable).setValues((long[])object2);
                attributeList.get(TagFromName.ExtendedOffsetTableLengths).setValues(lArray3);
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("AddTIFFOrOffsetTables(): {}", attributeList.toString());
                }
            }
            if (bl) {
                double[] dArray;
                SequenceAttribute sequenceAttribute;
                SequenceAttribute sequenceAttribute2;
                object = (long)Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
                long l6 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
                long l7 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 0);
                long l8 = this.getTIFFCompressionFromTransferSyntax(string3);
                long l9 = 1L;
                byte[] byArray2 = null;
                Attribute attribute = SequenceAttribute.getNamedAttributeFromWithinSelectedItemWithinSequence(attributeList, TagFromName.OpticalPathSequence, 0, TagFromName.ICCProfile);
                if (attribute != null) {
                    byArray2 = attribute.getByteValues();
                }
                double d = 0.0;
                double d2 = 0.0;
                Attribute attribute2 = attributeList.get(TagFromName.PixelSpacing);
                if (attribute2 == null && (sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence)) != null && (sequenceAttribute = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute2, TagFromName.PixelMeasuresSequence)) != null) {
                    attribute2 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, TagFromName.PixelSpacing);
                }
                if (attribute2 != null && (dArray = attribute2.getDoubleValues()) != null && dArray.length == 2) {
                    d2 = dArray[0];
                    d = dArray[1];
                }
                byArray = AddTIFFOrOffsetTables.makeTIFFInPreambleAndAddDataSetTrailingPadding(l5, n, (long[][])object4, (long[][])object3, lArray, lArray2, attributeList, (long)object, l6, l7, l8, l, l4, l2, l3, l9, byArray2, d, d2, bl2);
            }
        }
        attributeList.write(string2, string3, true, true, byArray);
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            int n = 2;
            int n2 = 2;
            int n3 = stringArray.length;
            boolean bl5 = false;
            if (n3 < n) {
                bl5 = true;
            }
            boolean bl6 = true;
            block22: while (bl6 && n3 > n) {
                switch (string = stringArray[n3 - 1].trim().toUpperCase()) {
                    case "ADDTIFF": {
                        bl = true;
                        --n3;
                        continue block22;
                    }
                    case "DONOTADDTIFF": {
                        bl = false;
                        --n3;
                        continue block22;
                    }
                    case "USEBIGTIFF": {
                        bl2 = true;
                        --n3;
                        continue block22;
                    }
                    case "DONOTUSEBIGTIFF": {
                        bl2 = false;
                        --n3;
                        continue block22;
                    }
                    case "ADDEXTENDEDOFFSETTABLE": {
                        bl3 = true;
                        --n3;
                        continue block22;
                    }
                    case "DONOTADDEXTENDEDOFFSETTABLE": {
                        bl3 = false;
                        --n3;
                        continue block22;
                    }
                    case "ADDBASICOFFSETTABLE": {
                        bl4 = true;
                        --n3;
                        continue block22;
                    }
                    case "DONOTADDBASICOFFSETTABLE": {
                        bl4 = false;
                        --n3;
                        continue block22;
                    }
                }
                if (n3 > n2) {
                    slf4jlogger.error("Unrecognized argument {}", string);
                    bl5 = true;
                }
                bl6 = false;
            }
            if (!bl5) {
                string = stringArray[0];
                String string2 = stringArray[1];
                new AddTIFFOrOffsetTables(string, string2, bl, bl2, bl3, bl4);
            } else {
                System.err.println("Error: Incorrect number of arguments or bad arguments");
                System.err.println("Usage: AddTIFFOrOffsetTables inputFile outputFile [ADDTIFF|DONOTADDTIFF] [USEBIGTIFF|DONOTUSEBIGTIFF] [ADDEXTENDEDOFFSETTABLE|DONOTADDEXTENDEDOFFSETTABLE] [ADDBASICOFFSETTABLE|DONOTADDBASICOFFSETTABLE]");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

