/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.convert.AnalyzeException;
import com.pixelmed.convert.AnalyzeHeader;
import com.pixelmed.convert.CommonConvertedAttributeGeneration;
import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.FunctionalGroupUtilities;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherDoubleAttribute;
import com.pixelmed.dicom.OtherFloatAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;

public class AnalyzeToDicom {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/AnalyzeToDicom.java,v 1.19 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(AnalyzeToDicom.class);

    public static AttributeList generateGeometryFunctionalGroupsFromAnalyzeHeader(AnalyzeHeader analyzeHeader, AttributeList attributeList, int n) throws DicomException {
        attributeList = FunctionalGroupUtilities.createFunctionalGroupsIfNotPresent(attributeList, n);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        AttributeList attributeList2 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(sequenceAttribute);
        SequenceAttribute sequenceAttribute3 = new SequenceAttribute(TagFromName.PixelMeasuresSequence);
        attributeList2.put(sequenceAttribute3);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute3.addItem(attributeList3);
        double d = analyzeHeader.pixdim[1];
        double d2 = analyzeHeader.pixdim[2];
        double d3 = analyzeHeader.pixdim[3];
        DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.PixelSpacing);
        ((Attribute)decimalStringAttribute).addValue(d2);
        ((Attribute)decimalStringAttribute).addValue(d);
        attributeList3.put(decimalStringAttribute);
        decimalStringAttribute = new DecimalStringAttribute(TagFromName.SliceThickness);
        ((Attribute)decimalStringAttribute).addValue(d3);
        attributeList3.put(decimalStringAttribute);
        decimalStringAttribute = new DecimalStringAttribute(TagFromName.SpacingBetweenSlices);
        ((Attribute)decimalStringAttribute).addValue(d3);
        attributeList3.put(decimalStringAttribute);
        sequenceAttribute3 = new SequenceAttribute(TagFromName.PlaneOrientationSequence);
        attributeList2.put(sequenceAttribute3);
        attributeList3 = new AttributeList();
        sequenceAttribute3.addItem(attributeList3);
        Attribute attribute = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        switch (analyzeHeader.orient) {
            case TRANSVERSE_UNFLIPPED: {
                attribute.addValue(1);
                attribute.addValue(0);
                attribute.addValue(0);
                attribute.addValue(0);
                attribute.addValue(-1);
                attribute.addValue(0);
                break;
            }
            case TRANSVERSE_FLIPPED: {
                attribute.addValue(1);
                attribute.addValue(0);
                attribute.addValue(0);
                attribute.addValue(0);
                attribute.addValue(1);
                attribute.addValue(0);
                break;
            }
            case CORONAL_UNFLIPPED: {
                attribute.addValue(1);
                attribute.addValue(0);
                attribute.addValue(0);
                attribute.addValue(0);
                attribute.addValue(0);
                attribute.addValue(1);
                break;
            }
            case CORONAL_FLIPPED: {
                attribute.addValue(1);
                attribute.addValue(0);
                attribute.addValue(0);
                attribute.addValue(0);
                attribute.addValue(0);
                attribute.addValue(-1);
                break;
            }
            case SAGITTAL_UNFLIPPED: {
                attribute.addValue(0);
                attribute.addValue(-1);
                attribute.addValue(0);
                attribute.addValue(0);
                attribute.addValue(0);
                attribute.addValue(1);
                break;
            }
            case SAGITTAL_FLIPPED: {
                attribute.addValue(0);
                attribute.addValue(1);
                attribute.addValue(0);
                attribute.addValue(0);
                attribute.addValue(0);
                attribute.addValue(-1);
                break;
            }
            default: {
                throw new DicomException("Orientation of " + (Object)((Object)analyzeHeader.orient) + " not supported");
            }
        }
        attributeList3.put(attribute);
        short s = analyzeHeader.dim[0] >= 3 ? (analyzeHeader.dim[3] > 0 ? analyzeHeader.dim[3] : (short)1) : (short)1;
        for (int i = 0; i < n; ++i) {
            attribute = new SequenceAttribute(TagFromName.PlanePositionSequence);
            SequenceAttribute.getAttributeListFromSelectedItemWithinSequence(sequenceAttribute2, i).put(attribute);
            AttributeList attributeList4 = new AttributeList();
            ((SequenceAttribute)attribute).addItem(attributeList4);
            DecimalStringAttribute decimalStringAttribute2 = new DecimalStringAttribute(TagFromName.ImagePositionPatient);
            int n2 = i % s;
            switch (analyzeHeader.orient) {
                case TRANSVERSE_UNFLIPPED: 
                case TRANSVERSE_FLIPPED: {
                    ((Attribute)decimalStringAttribute2).addValue(0);
                    ((Attribute)decimalStringAttribute2).addValue(0);
                    ((Attribute)decimalStringAttribute2).addValue(analyzeHeader.pixdim[3] * (float)n2);
                    break;
                }
                case CORONAL_UNFLIPPED: 
                case CORONAL_FLIPPED: {
                    ((Attribute)decimalStringAttribute2).addValue(0);
                    ((Attribute)decimalStringAttribute2).addValue(analyzeHeader.pixdim[2] * (float)n2);
                    ((Attribute)decimalStringAttribute2).addValue(0);
                    break;
                }
                case SAGITTAL_UNFLIPPED: 
                case SAGITTAL_FLIPPED: {
                    ((Attribute)decimalStringAttribute2).addValue(analyzeHeader.pixdim[1] * (float)n2);
                    ((Attribute)decimalStringAttribute2).addValue(0);
                    ((Attribute)decimalStringAttribute2).addValue(0);
                    break;
                }
                default: {
                    throw new DicomException("Orientation of " + (Object)((Object)analyzeHeader.orient) + " not supported");
                }
            }
            attributeList4.put(decimalStringAttribute2);
        }
        return attributeList;
    }

    public static AttributeList generateDICOMPixelDataModuleAttributesFromAnalyzeFile(File file, AnalyzeHeader analyzeHeader, AttributeList attributeList) throws IOException, DicomException, AnalyzeException {
        Object object;
        int n;
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        if ((n = analyzeHeader.dim[0] & 0xFFFF) < 2) {
            throw new DicomException("Cannot convert if less than two dimensions");
        }
        int n2 = analyzeHeader.dim[1] & 0xFFFF;
        int n3 = analyzeHeader.dim[2] & 0xFFFF;
        int n4 = 1;
        if (n > 2) {
            for (int i = 3; i <= n; ++i) {
                n4 *= analyzeHeader.dim[i] & 0xFFFF;
            }
        }
        String string = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Attribute attribute = null;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        switch (analyzeHeader.datatype) {
            case BINARY: {
                throw new DicomException("Conversion of " + (Object)((Object)analyzeHeader.datatype) + " not supported");
            }
            case UNSIGNED_CHAR: {
                attribute = new OtherByteAttribute(TagFromName.PixelData);
                n7 = 0;
                n6 = 8;
                n5 = 1;
                string = "MONOCHROME2";
                break;
            }
            case SIGNED_SHORT: {
                attribute = new OtherWordAttribute(TagFromName.PixelData);
                n7 = 1;
                n6 = 16;
                n5 = 1;
                string = "MONOCHROME2";
                break;
            }
            case SIGNED_INT: {
                throw new DicomException("Conversion of " + (Object)((Object)analyzeHeader.datatype) + " not supported");
            }
            case FLOAT: {
                attribute = new OtherFloatAttribute(TagFromName.FloatPixelData);
                bl3 = false;
                n7 = 0;
                n6 = 32;
                bl = false;
                bl2 = false;
                n5 = 1;
                string = "MONOCHROME2";
                break;
            }
            case COMPLEX: {
                throw new DicomException("Conversion of " + (Object)((Object)analyzeHeader.datatype) + " not supported");
            }
            case DOUBLE: {
                attribute = new OtherDoubleAttribute(TagFromName.DoubleFloatPixelData);
                bl3 = false;
                n7 = 0;
                n6 = 64;
                bl = false;
                bl2 = false;
                n5 = 1;
                string = "MONOCHROME2";
                break;
            }
            case RGB: {
                attribute = new OtherByteAttribute(TagFromName.PixelData);
                n7 = 0;
                n6 = 8;
                n5 = 3;
                string = "RGB";
                break;
            }
            default: {
                throw new DicomException("Conversion of " + (Object)((Object)analyzeHeader.datatype) + " not supported");
            }
        }
        double d = 0.0;
        double d2 = 0.0;
        boolean bl4 = false;
        Object object2 = AnalyzeHeader.getImageDataFile(file);
        BinaryInputStream binaryInputStream = new BinaryInputStream((File)object2, analyzeHeader.bigEndian);
        binaryInputStream.skipInsistently((long)analyzeHeader.vox_offset);
        int n8 = n3 * n2 * n4 * n5;
        if (attribute instanceof OtherByteAttribute) {
            byte[] byArray = new byte[n8];
            binaryInputStream.readInsistently(byArray, 0, n8);
            attribute.setValues(byArray);
        } else if (attribute instanceof OtherWordAttribute) {
            short[] sArray = new short[n8];
            binaryInputStream.readUnsigned16(sArray, 0, n8);
            attribute.setValues(sArray);
        } else if (attribute instanceof OtherFloatAttribute) {
            float[] fArray = new float[n8];
            binaryInputStream.readFloat(fArray, n8);
            attribute.setValues(fArray);
            object = ArrayCopyUtilities.minMax(fArray);
            d = object[0];
            d2 = object[1];
            bl4 = true;
        } else if (attribute instanceof OtherDoubleAttribute) {
            double[] dArray = new double[n8];
            binaryInputStream.readDouble(dArray, n8);
            attribute.setValues(dArray);
            object = ArrayCopyUtilities.minMax(dArray);
            d = object[0];
            d2 = object[1];
            bl4 = true;
        }
        binaryInputStream.close();
        attributeList.put(attribute);
        object2 = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
        ((Attribute)object2).addValue(string);
        attributeList.put((Attribute)object2);
        object2 = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        ((Attribute)object2).addValue(n6);
        attributeList.put((Attribute)object2);
        if (bl) {
            object2 = new UnsignedShortAttribute(TagFromName.BitsStored);
            ((Attribute)object2).addValue(n6);
            attributeList.put((Attribute)object2);
        }
        if (bl2) {
            object2 = new UnsignedShortAttribute(TagFromName.HighBit);
            ((Attribute)object2).addValue(n6 - 1);
            attributeList.put((Attribute)object2);
        }
        object2 = new UnsignedShortAttribute(TagFromName.Rows);
        ((Attribute)object2).addValue(n3);
        attributeList.put((Attribute)object2);
        object2 = new UnsignedShortAttribute(TagFromName.Columns);
        ((Attribute)object2).addValue(n2);
        attributeList.put((Attribute)object2);
        if (bl3) {
            object2 = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
            ((Attribute)object2).addValue(n7);
            attributeList.put((Attribute)object2);
        }
        attributeList.remove(TagFromName.NumberOfFrames);
        if (n4 > 1) {
            object2 = new IntegerStringAttribute(TagFromName.NumberOfFrames);
            ((Attribute)object2).addValue(n4);
            attributeList.put((Attribute)object2);
        }
        object2 = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
        ((Attribute)object2).addValue(n5);
        attributeList.put((Attribute)object2);
        attributeList.remove(TagFromName.PlanarConfiguration);
        if (n5 > 1) {
            object2 = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
            ((Attribute)object2).addValue(0);
            attributeList.put((Attribute)object2);
        }
        if (n5 == 1) {
            double d3 = 1.0;
            double d4 = 0.0;
            object = new CodeStringAttribute(TagFromName.PresentationLUTShape);
            ((Attribute)object).addValue("IDENTITY");
            attributeList.put((Attribute)object);
            object = new DecimalStringAttribute(TagFromName.RescaleSlope);
            ((Attribute)object).addValue(d3);
            attributeList.put((Attribute)object);
            object = new DecimalStringAttribute(TagFromName.RescaleIntercept);
            ((Attribute)object).addValue(d4);
            attributeList.put((Attribute)object);
            object = new LongStringAttribute(TagFromName.RescaleType);
            ((Attribute)object).addValue("US");
            attributeList.put((Attribute)object);
            if (bl4) {
                double d5 = d2 - d;
                double d6 = (d2 + d) / 2.0;
                StringAttribute stringAttribute = new DecimalStringAttribute(TagFromName.WindowWidth);
                ((Attribute)stringAttribute).addValue(d5);
                attributeList.put(stringAttribute);
                stringAttribute = new DecimalStringAttribute(TagFromName.WindowCenter);
                ((Attribute)stringAttribute).addValue(d6);
                attributeList.put(stringAttribute);
                stringAttribute = new CodeStringAttribute(TagFromName.VOILUTFunction);
                ((Attribute)stringAttribute).addValue(attribute instanceof OtherFloatAttribute || attribute instanceof OtherDoubleAttribute ? "LINEAR_EXACT" : "LINEAR");
                attributeList.put(stringAttribute);
            }
        }
        return attributeList;
    }

    public AnalyzeToDicom(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws IOException, DicomException, AnalyzeException {
        this(string, string2, string3, string4, string5, string6, string7, null, null);
    }

    public AnalyzeToDicom(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws IOException, DicomException, AnalyzeException {
        File file = new File(string);
        AnalyzeHeader analyzeHeader = new AnalyzeHeader(file);
        AttributeList attributeList = AnalyzeToDicom.generateDICOMPixelDataModuleAttributesFromAnalyzeFile(file, analyzeHeader, null);
        CommonConvertedAttributeGeneration.generateCommonAttributes(attributeList, string3, string4, string5, string6, string7, string8, string9, true);
        string9 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        if (SOPClass.isEnhancedMultiframeImageStorage(string9)) {
            int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
            AnalyzeToDicom.generateGeometryFunctionalGroupsFromAnalyzeHeader(analyzeHeader, attributeList, n);
        }
        LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.ManufacturerModelName);
        ((Attribute)longStringAttribute).addValue(this.getClass().getName());
        attributeList.put(longStringAttribute);
        CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList);
        attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        try {
            if (stringArray.length != 7) {
                if (stringArray.length == 8) {
                    string = stringArray[7];
                } else if (stringArray.length == 9) {
                    string = stringArray[7];
                    string2 = stringArray[8];
                } else {
                    System.err.println("Error: Incorrect number of arguments");
                    System.err.println("Usage: AnalyzeToDicom inputFile outputFile patientName patientID studyID seriesNumber instanceNumber [modality [SOPClass]]");
                    System.exit(1);
                }
            }
            new AnalyzeToDicom(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6], string, string2);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

