/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.convert.CommonConvertedAttributeGeneration;
import com.pixelmed.convert.RawImageDescription;
import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherDoubleAttribute;
import com.pixelmed.dicom.OtherFloatAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RawToDicomMultiFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/RawToDicomMultiFrame.java,v 1.12 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(RawToDicomMultiFrame.class);
    private static boolean preSpatialDimensionsLeastRapidlyVaryingInOutput = false;

    public static AttributeList generateDICOMPixelDataModuleAttributesFromNRRDFile(File file, RawImageDescription rawImageDescription, AttributeList attributeList) throws IOException, DicomException, NumberFormatException {
        Object object;
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        int n = rawImageDescription.columns;
        int n2 = rawImageDescription.rows;
        int n3 = rawImageDescription.frames;
        slf4jlogger.info("columns = {}", n);
        slf4jlogger.info("rows = {}", n2);
        slf4jlogger.info("numberOfFrames = {}", n3);
        String string = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Attribute attribute = null;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        RawImageDescription.Type type = rawImageDescription.getType();
        switch (type) {
            case INT8: {
                attribute = new OtherByteAttribute(TagFromName.PixelData);
                n6 = 1;
                n5 = 8;
                n4 = 1;
                string = "MONOCHROME2";
                break;
            }
            case UINT8: {
                attribute = new OtherByteAttribute(TagFromName.PixelData);
                n6 = 0;
                n5 = 8;
                n4 = 1;
                string = "MONOCHROME2";
                break;
            }
            case INT16: {
                attribute = new OtherWordAttribute(TagFromName.PixelData);
                n6 = 1;
                n5 = 16;
                n4 = 1;
                string = "MONOCHROME2";
                break;
            }
            case UINT16: {
                attribute = new OtherWordAttribute(TagFromName.PixelData);
                n6 = 0;
                n5 = 16;
                n4 = 1;
                string = "MONOCHROME2";
                break;
            }
            case INT32: {
                throw new DicomException("Conversion of " + (Object)((Object)type) + " not supported");
            }
            case UINT32: {
                throw new DicomException("Conversion of " + (Object)((Object)type) + " not supported");
            }
            case INT64: {
                throw new DicomException("Conversion of " + (Object)((Object)type) + " not supported");
            }
            case UINT64: {
                throw new DicomException("Conversion of " + (Object)((Object)type) + " not supported");
            }
            case FLOAT32: {
                attribute = new OtherFloatAttribute(TagFromName.FloatPixelData);
                bl3 = false;
                n6 = 0;
                n5 = 32;
                bl = false;
                bl2 = false;
                n4 = 1;
                string = "MONOCHROME2";
                break;
            }
            case FLOAT64: {
                attribute = new OtherDoubleAttribute(TagFromName.DoubleFloatPixelData);
                bl3 = false;
                n6 = 0;
                n5 = 64;
                bl = false;
                bl2 = false;
                n4 = 1;
                string = "MONOCHROME2";
                break;
            }
            default: {
                throw new DicomException("Conversion of " + (Object)((Object)type) + " not supported");
            }
        }
        double d = 0.0;
        double d2 = 0.0;
        boolean bl4 = false;
        Object object2 = new BufferedInputStream(new FileInputStream(file));
        BinaryInputStream binaryInputStream = new BinaryInputStream((InputStream)object2, rawImageDescription.isDataBigEndian);
        int n7 = n2 * n * n3 * n4;
        if (attribute instanceof OtherByteAttribute) {
            byte[] byArray = new byte[n7];
            binaryInputStream.readInsistently(byArray, 0, n7);
            attribute.setValues(byArray);
        } else if (attribute instanceof OtherWordAttribute) {
            short[] sArray = new short[n7];
            binaryInputStream.readUnsigned16(sArray, 0, n7);
            attribute.setValues(sArray);
        } else if (attribute instanceof OtherFloatAttribute) {
            float[] fArray = new float[n7];
            binaryInputStream.readFloat(fArray, n7);
            attribute.setValues(fArray);
            object = ArrayCopyUtilities.minMax(fArray);
            d = object[0];
            d2 = object[1];
            bl4 = true;
        } else if (attribute instanceof OtherDoubleAttribute) {
            double[] dArray = new double[n7];
            binaryInputStream.readDouble(dArray, n7);
            attribute.setValues(dArray);
            object = ArrayCopyUtilities.minMax(dArray);
            d = object[0];
            d2 = object[1];
            bl4 = true;
        }
        binaryInputStream.close();
        ((InputStream)object2).close();
        attributeList.put(attribute);
        object2 = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
        ((Attribute)object2).addValue(string);
        attributeList.put((Attribute)object2);
        object2 = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        ((Attribute)object2).addValue(n5);
        attributeList.put((Attribute)object2);
        if (bl) {
            object2 = new UnsignedShortAttribute(TagFromName.BitsStored);
            ((Attribute)object2).addValue(n5);
            attributeList.put((Attribute)object2);
        }
        if (bl2) {
            object2 = new UnsignedShortAttribute(TagFromName.HighBit);
            ((Attribute)object2).addValue(n5 - 1);
            attributeList.put((Attribute)object2);
        }
        object2 = new UnsignedShortAttribute(TagFromName.Rows);
        ((Attribute)object2).addValue(n2);
        attributeList.put((Attribute)object2);
        object2 = new UnsignedShortAttribute(TagFromName.Columns);
        ((Attribute)object2).addValue(n);
        attributeList.put((Attribute)object2);
        if (bl3) {
            object2 = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
            ((Attribute)object2).addValue(n6);
            attributeList.put((Attribute)object2);
        }
        attributeList.remove(TagFromName.NumberOfFrames);
        if (n3 > 1) {
            object2 = new IntegerStringAttribute(TagFromName.NumberOfFrames);
            ((Attribute)object2).addValue(n3);
            attributeList.put((Attribute)object2);
        }
        object2 = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
        ((Attribute)object2).addValue(n4);
        attributeList.put((Attribute)object2);
        attributeList.remove(TagFromName.PlanarConfiguration);
        if (n4 > 1) {
            object2 = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
            ((Attribute)object2).addValue(0);
            attributeList.put((Attribute)object2);
        }
        if (n4 == 1) {
            double d3 = 1.0;
            double d4 = 0.0;
            object = new CodeStringAttribute(TagFromName.PresentationLUTShape);
            ((Attribute)object).addValue("IDENTITY");
            attributeList.put((Attribute)object);
            object = new DecimalStringAttribute(TagFromName.RescaleSlope);
            ((Attribute)object).addValue(d3);
            attributeList.put((Attribute)object);
            object = new DecimalStringAttribute(TagFromName.RescaleIntercept);
            ((Attribute)object).addValue(d4);
            attributeList.put((Attribute)object);
            object = new LongStringAttribute(TagFromName.RescaleType);
            ((Attribute)object).addValue("US");
            attributeList.put((Attribute)object);
            if (bl4) {
                double d5 = d2 - d;
                double d6 = (d2 + d) / 2.0;
                StringAttribute stringAttribute = new DecimalStringAttribute(TagFromName.WindowWidth);
                ((Attribute)stringAttribute).addValue(d5);
                attributeList.put(stringAttribute);
                stringAttribute = new DecimalStringAttribute(TagFromName.WindowCenter);
                ((Attribute)stringAttribute).addValue(d6);
                attributeList.put(stringAttribute);
                stringAttribute = new CodeStringAttribute(TagFromName.VOILUTFunction);
                ((Attribute)stringAttribute).addValue(attribute instanceof OtherFloatAttribute || attribute instanceof OtherDoubleAttribute ? "LINEAR_EXACT" : "LINEAR");
                attributeList.put(stringAttribute);
            }
        }
        return attributeList;
    }

    public RawToDicomMultiFrame(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws IOException, DicomException {
        this(string, string2, string3, string4, string5, string6, string7, string8, null, null);
    }

    public RawToDicomMultiFrame(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws IOException, DicomException, NumberFormatException {
        RawImageDescription rawImageDescription = new RawImageDescription(new File(string));
        File file = new File(string2);
        AttributeList attributeList = RawToDicomMultiFrame.generateDICOMPixelDataModuleAttributesFromNRRDFile(file, rawImageDescription, null);
        CommonConvertedAttributeGeneration.generateCommonAttributes(attributeList, string4, string5, string6, string7, string8, string9, string10, true);
        string10 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        if (SOPClass.isEnhancedMultiframeImageStorage(string10)) {
            // empty if block
        }
        LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.ManufacturerModelName);
        ((Attribute)longStringAttribute).addValue(this.getClass().getName());
        attributeList.put(longStringAttribute);
        CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList);
        attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string3, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        try {
            if (stringArray.length != 8) {
                if (stringArray.length == 9) {
                    string = stringArray[8];
                } else if (stringArray.length == 10) {
                    string = stringArray[8];
                    string2 = stringArray[9];
                } else {
                    System.err.println("Error: Incorrect number of arguments");
                    System.err.println("Usage: RawToDicomMultiFrame formatFile inputFile outputFile patientName patientID studyID seriesNumber instanceNumber [modality [SOPClass]]");
                    System.exit(1);
                }
            }
            new RawToDicomMultiFrame(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6], stringArray[7], string, string2);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

