/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.OtherByteAttributeCompressedSeparateFramesOnDisk;
import com.pixelmed.dicom.OtherByteAttributeMultipleCompressedFrames;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.FileOutputStream;
import java.text.DecimalFormat;

public class UnencapsulateCompressedPixelData {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/UnencapsulateCompressedPixelData.java,v 1.14 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(UnencapsulateCompressedPixelData.class);

    private static String getFileNameExtensionForCompressedPixelData(AttributeList attributeList) {
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
        TransferSyntax transferSyntax = new TransferSyntax(string);
        return transferSyntax.getFileNameExtension();
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 2) {
                DecimalFormat decimalFormat = new DecimalFormat("000000");
                AttributeList attributeList = new AttributeList();
                attributeList.setDecompressPixelData(false);
                attributeList.read(stringArray[0]);
                String string = UnencapsulateCompressedPixelData.getFileNameExtensionForCompressedPixelData(attributeList);
                Attribute attribute = attributeList.getPixelData();
                if (attribute instanceof OtherByteAttributeMultipleCompressedFrames) {
                    OtherByteAttributeMultipleCompressedFrames otherByteAttributeMultipleCompressedFrames = (OtherByteAttributeMultipleCompressedFrames)attribute;
                    byte[][] byArray = otherByteAttributeMultipleCompressedFrames.getFrames();
                    for (int i = 0; i < byArray.length; ++i) {
                        String string2 = stringArray[1] + decimalFormat.format(i + 1) + "." + string;
                        slf4jlogger.info("Writing {}", string2);
                        FileOutputStream fileOutputStream = new FileOutputStream(string2);
                        fileOutputStream.write(byArray[i]);
                        fileOutputStream.close();
                    }
                } else if (attribute instanceof OtherByteAttributeCompressedSeparateFramesOnDisk) {
                    OtherByteAttributeCompressedSeparateFramesOnDisk otherByteAttributeCompressedSeparateFramesOnDisk = (OtherByteAttributeCompressedSeparateFramesOnDisk)attribute;
                    int n = otherByteAttributeCompressedSeparateFramesOnDisk.getNumberOfFrames();
                    for (int i = 0; i < n; ++i) {
                        String string3 = stringArray[1] + decimalFormat.format(i + 1) + "." + string;
                        slf4jlogger.info("Writing {}", string3);
                        FileOutputStream fileOutputStream = new FileOutputStream(string3);
                        fileOutputStream.write(otherByteAttributeCompressedSeparateFramesOnDisk.getByteValuesForSelectedFrame(i));
                        fileOutputStream.close();
                    }
                }
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: UnencapsulateCompressedPixelData inputFile outputFilePrefix");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

