/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeFactory;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CompressedFrameDecoder;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.EncapsulatedInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherByteAttributeCompressedSeparateFramesOnDisk;
import com.pixelmed.dicom.OtherByteAttributeMultipleCompressedFrames;
import com.pixelmed.dicom.OtherByteAttributeOnDisk;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.OtherWordAttributeOnDisk;
import com.pixelmed.dicom.PrivatePixelData;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.StringAttributeAffectedBySpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.dicom.TransferSyntaxFromName;
import com.pixelmed.dicom.UnPackBits;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.metadata.IIOMetadata;

public class AttributeList
extends TreeMap<AttributeTag, Attribute> {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/AttributeList.java,v 1.212 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(AttributeList.class);
    private static final long badAttributeLimit = 10L;
    private static final long maximumLongVRValueLengthThatCanBeAllocated = Integer.MAX_VALUE;
    public static final long maximumShortVRValueLength = 65535L;
    private static final long maximumSaneFixedValueLengthWhenRecoveringFromIncorrectImplicitVRElementEncodinginExplicitVR = 100000L;
    public static final long maximumInMemoryNumberOfCompressedFrames = 1000L;
    protected boolean decompressPixelData = true;
    protected boolean pixelDataWasActuallyDecompressed = false;
    protected boolean pixelDataIsLossy = false;
    protected String lossyMethod = null;
    protected double compressionRatio = 0.0;
    protected IIOMetadata[] iioMetadata = null;
    protected boolean colorSpaceWasConvertedToRGBDuringDecompression = false;
    private boolean colorSpaceWillBeConvertedToRGBDuringDecompression = false;
    private boolean isJPEGFamily = false;
    private boolean isRLE = false;
    private String readerWanted = null;

    protected void checkSanityOfValueLength(long l, byte[] byArray, AttributeTag attributeTag, boolean bl) throws DicomException {
        if (l < 0L) {
            throw new DicomException("Illegal fixed VL (" + l + " dec, 0x" + Long.toHexString(l) + ") - is negative - probably incorrect dataset - giving up");
        }
        if (l > Integer.MAX_VALUE && ValueRepresentation.isUnknownVR(byArray)) {
            throw new DicomException("Illegal fixed VL (" + l + " dec, 0x" + Long.toHexString(l) + ") - is larger than can be allocated for unknown VR - probably incorrect dataset - giving up");
        }
        if (l > 65535L && ValueRepresentation.isShortValueLengthVR(byArray)) {
            if (!(attributeTag.equals(TagFromName.DVHData) || attributeTag.equals(TagFromName.CompensatorTransmissionData) || attributeTag.equals(TagFromName.CompensatorThicknessData) || attributeTag.equals(TagFromName.BlockData) || attributeTag.equals(TagFromName.ContourData) || attributeTag.equals(TagFromName.HistogramData) || attributeTag.equals(TagFromName.TableOfYBreakPoints))) {
                throw new DicomException("Unlikely fixed VL (" + l + " dec, 0x" + Long.toHexString(l) + ") for non-bulk data tag " + attributeTag + " - probably incorrect dataset - giving up");
            }
            slf4jlogger.warn("Allowed fixed VL ({} dec, 0x{}) that is too long to fit in 16 bits for VR {} in Explicit VR Transfer Syntax because it is one of the recognized data elements for which that is often the case ({} {})", l, Long.toHexString(l), ValueRepresentation.getAsString(byArray), AttributeList.getDictionary().getNameFromTag(attributeTag), attributeTag);
        }
        if (bl && l > 100000L) {
            throw new DicomException("Unlikely fixed VL (" + l + " dec, 0x" + Long.toHexString(l) + ") when recovering from incorrect Implicit VR element encoding in Explicit VR Transfer Syntax - giving up");
        }
    }

    public void setDecompressPixelData(boolean bl) {
        this.decompressPixelData = bl;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof AttributeList) {
            AttributeList attributeList = (AttributeList)object;
            if (this.size() == attributeList.size()) {
                for (Attribute attribute : this.values()) {
                    String string;
                    Attribute attribute2 = attributeList.get(attribute.getTag());
                    String string2 = attribute.getDelimitedStringValuesOrDefault("").trim();
                    if (string2.equals(string = attribute2.getDelimitedStringValuesOrDefault("").trim())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (Attribute attribute : this.values()) {
            n += attribute.toString().hashCode();
        }
        return n;
    }

    private AttributeTag readAttributeTag(DicomInputStream dicomInputStream) throws IOException {
        int n = dicomInputStream.readUnsigned16();
        int n2 = dicomInputStream.readUnsigned16();
        return new AttributeTag(n, n2);
    }

    private long readNewSequenceAttribute(Attribute attribute, DicomInputStream dicomInputStream, long l, long l2, SpecificCharacterSet specificCharacterSet, boolean bl, boolean bl2, boolean bl3) throws IOException, DicomException {
        block12: {
            long l3;
            slf4jlogger.trace("readNewSequenceAttribute(): start");
            slf4jlogger.trace("readNewSequenceAttribute(): insideUnknownVRSoForceImplicitVRLittleEndian={}", bl);
            boolean bl4 = l2 == 0xFFFFFFFFL;
            long l4 = l3 = bl4 ? 0xFFFFFFFFL : l + l2 - 1L;
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("readNewSequenceAttribute(): start byteoffset=0x{} ({} dec) lengthToRead={} endByteOffset=0x{} ({} dec)", Long.toHexString(l), l, l2, Long.toHexString(l3), l3);
            }
            try {
                while (bl4 || l < l3) {
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("readNewSequenceAttribute(): loop byteoffset=0x{} ({} dec)", Long.toHexString(l), l);
                    }
                    long l5 = l;
                    AttributeTag attributeTag = this.readAttributeTag(dicomInputStream);
                    l += 4L;
                    slf4jlogger.trace("readNewSequenceAttribute(): tag=" + attributeTag);
                    long l6 = dicomInputStream.readUnsigned32();
                    l += 4L;
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("readNewSequenceAttribute(): loop byteoffset=0x{} ({} dec) {} VL=<0x{}>", Long.toHexString(l), l, attributeTag, Long.toHexString(l6));
                    }
                    if (attributeTag.equals(TagFromName.SequenceDelimitationItem)) {
                        slf4jlogger.trace("readNewSequenceAttribute(): SequenceDelimitationItem");
                        break;
                    }
                    if (attributeTag.equals(TagFromName.Item)) {
                        if (slf4jlogger.isTraceEnabled()) {
                            slf4jlogger.trace("readNewSequenceAttribute(): Item byteoffset=0x{} ({} dec)", Long.toHexString(l), l);
                        }
                        AttributeList attributeList = new AttributeList();
                        attributeList.setDecompressPixelData(bl3);
                        l = attributeList.read(dicomInputStream, l, l6, false, specificCharacterSet, null, null, bl, bl2);
                        slf4jlogger.trace("readNewSequenceAttribute(): back from reading Item byteOffset=" + l);
                        ((SequenceAttribute)attribute).addItem(attributeList, l5);
                        continue;
                    }
                    throw new DicomException("Bad tag " + attributeTag + "(not Item or Sequence Delimiter) in Sequence at byte offset 0x" + Long.toHexString(l) + " (" + l + " dec)");
                }
            }
            catch (EOFException eOFException) {
                slf4jlogger.trace("readNewSequenceAttribute(): Closing on ", eOFException);
                if (!bl4) {
                    throw new EOFException();
                }
            }
            catch (IOException iOException) {
                slf4jlogger.trace("readNewSequenceAttribute(): Closing on ", iOException);
                if (bl4) break block12;
                throw new IOException();
            }
        }
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("readNewSequenceAttribute(): return byteoffset=0x{} ({} dec)", Long.toHexString(l), l);
        }
        slf4jlogger.trace("readNewSequenceAttribute(): end");
        return l;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private long read(DicomInputStream var1_1, long var2_2, long var4_3, boolean var6_4, SpecificCharacterSet var7_5, AttributeTag var8_6, ReadTerminationStrategy var9_7, boolean var10_8, boolean var11_9) throws IOException, DicomException {
        block173: {
            AttributeList.slf4jlogger.trace("read(): start");
            AttributeList.slf4jlogger.trace("read(): Stop tag is {}", new Object[]{var8_6});
            AttributeList.slf4jlogger.trace("read(): insideUnknownVRSoForceImplicitVRLittleEndian=" + var10_8);
            if (var1_1.areReadingDataSet()) {
                AttributeList.slf4jlogger.trace("read(): Testing for deflate and bzip2 TS");
                if (var1_1.getTransferSyntaxToReadDataSet().isDeflated()) {
                    AttributeList.slf4jlogger.trace("read(): Creating new DicomInputStream from deflate");
                    var1_1 = new DicomInputStream(new InflaterInputStream(var1_1, new Inflater(true)), "1.2.840.10008.1.2.1", false);
                    var2_2 = 0L;
                } else if (var1_1.getTransferSyntaxToReadDataSet().isBzip2ed()) {
                    AttributeList.slf4jlogger.trace("read(): Creating new DicomInputStream from bzip2");
                    try {
                        var12_10 = Thread.currentThread().getContextClassLoader().loadClass("org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream");
                        var13_14 = new Class[]{InputStream.class};
                        var14_16 = new Object[]{var1_1};
                        var15_17 /* !! */  = (byte[])((InputStream)var12_10.getConstructor(var13_14).newInstance(var14_16));
                        var1_1 = new DicomInputStream((InputStream)var15_17 /* !! */ , "1.2.840.10008.1.2.1", false);
                        var2_2 = 0L;
                    }
                    catch (InvocationTargetException var12_11) {
                        AttributeList.slf4jlogger.info("read(): Could not decompress bzip2 transfer syntax", var12_11);
                        throw new DicomException("Not a correctly encoded bzip2 bitstream - " + var12_11);
                    }
                    catch (Exception var12_12) {
                        throw new DicomException("Could not instantiate bzip2 codec - " + var12_12);
                    }
                }
            }
            var12_13 = var4_3 == 0xFFFFFFFFL;
            v0 = var13_15 = var12_13 != false ? 0xFFFFFFFFL : var2_2 + var4_3 - 1L;
            if (AttributeList.slf4jlogger.isTraceEnabled()) {
                AttributeList.slf4jlogger.trace("read(): start byteoffset=0x" + Long.toHexString(var2_2) + " (" + var2_2 + " dec) endByteOffset=0x" + Long.toHexString(var13_15) + " (" + var13_15 + " dec) lengthToRead=" + var4_3);
            }
            var15_17 /* !! */  = new byte[2];
            var16_18 = var1_1.getTransferSyntaxInUse().isExplicitVR() != false && var10_8 == false;
            var17_19 = var1_1.getTransferSyntaxInUse().isLittleEndian() != false || var10_8 != false;
            var18_20 = 0;
            var19_21 = 0;
            var20_22 = 1;
            var21_23 = 1;
            var22_24 = 0;
            var23_25 = 0;
            var24_26 = null;
            try {
                while (var12_13 || var2_2 < var13_15) {
                    block175: {
                        block182: {
                            block177: {
                                block180: {
                                    block178: {
                                        block181: {
                                            block179: {
                                                block176: {
                                                    block171: {
                                                        block174: {
                                                            if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                                                AttributeList.slf4jlogger.trace("read(): i.available()=" + var1_1.available());
                                                            }
                                                            if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                                                AttributeList.slf4jlogger.trace("read(): loop byteoffset=0x" + Long.toHexString(var2_2) + " (" + var2_2 + " dec) endByteOffset=0x" + Long.toHexString(var13_15) + " (" + var13_15 + " dec)");
                                                            }
                                                            var24_26 = this.readAttributeTag(var1_1);
                                                            var2_2 += 4L;
                                                            AttributeList.slf4jlogger.trace("read(): tag=" + var24_26);
                                                            if (var8_6 != null && var24_26.equals(var8_6)) {
                                                                AttributeList.slf4jlogger.trace("read(): stopped at " + var24_26);
                                                                return var2_2;
                                                            }
                                                            if (var9_7 != null && var9_7.terminate(this, var24_26, var2_2)) {
                                                                AttributeList.slf4jlogger.trace("read(): stopped at " + var24_26);
                                                                return var2_2;
                                                            }
                                                            if (var1_1.areReadingMetaHeader() && var24_26.getGroup() > 2) {
                                                                var25_27 = var1_1.getTransferSyntaxToReadDataSet();
                                                                if (var25_27 == null) {
                                                                    AttributeList.slf4jlogger.warn("read(): no TransferSyntax to read data set specified in meta header");
                                                                    if (var1_1.markSupported()) {
                                                                        var1_1.mark(2);
                                                                        var26_33 = new byte[2];
                                                                        if (var1_1.read(var26_33, 0, 2) == 2) {
                                                                            var25_27 = Character.isUpperCase((char)var26_33[0]) != false && Character.isUpperCase((char)var26_33[1]) != false ? new TransferSyntax("1.2.840.10008.1.2.1") : new TransferSyntax("1.2.840.10008.1.2");
                                                                        } else {
                                                                            var25_27 = new TransferSyntax("1.2.840.10008.1.2");
                                                                            AttributeList.slf4jlogger.warn("read(): no TransferSyntax in meta header and failed to lookahead to first dataset element so assuming TransferSyntaxToReadDataSet is ImplicitVRLittleEndian");
                                                                        }
                                                                        var1_1.reset();
                                                                    } else {
                                                                        var25_27 = new TransferSyntax("1.2.840.10008.1.2");
                                                                        AttributeList.slf4jlogger.warn("read(): no TransferSyntax in meta header and can't rewind so assuming TransferSyntaxToReadDataSet is ImplicitVRLittleEndian");
                                                                    }
                                                                    var1_1.setTransferSyntaxToReadDataSet(var25_27);
                                                                    if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                                                        AttributeList.slf4jlogger.trace("read(): guessed TransferSyntaxToReadDataSet {}", new Object[]{var1_1.getTransferSyntaxToReadDataSet().getDescription()});
                                                                    }
                                                                }
                                                                var1_1.setReadingDataSet();
                                                                var16_18 = var1_1.getTransferSyntaxInUse().isExplicitVR() != false && var10_8 == false;
                                                                v1 = var17_19 = var1_1.getTransferSyntaxInUse().isLittleEndian() != false || var10_8 != false;
                                                            }
                                                            if (var24_26.equals(TagFromName.ItemDelimitationItem)) {
                                                                AttributeList.slf4jlogger.trace("read(): ItemDelimitationItem");
                                                                var1_1.readUnsigned32();
                                                                return var2_2 += 4L;
                                                            }
                                                            if (var24_26.equals(TagFromName.Item)) {
                                                                var25_28 = var1_1.readUnsigned32();
                                                                AttributeList.slf4jlogger.info("read(): Ignoring bad Item at " + (var2_2 += 4L) + " " + var24_26 + " VL=<0x" + Long.toHexString(var25_28) + ">");
                                                                continue;
                                                            }
                                                            if (var24_26.equals(TagFromName.SequenceDelimitationItem)) {
                                                                var25_29 = var1_1.readUnsigned32();
                                                                AttributeList.slf4jlogger.info("read(): Ignoring bad SequenceDelimitationItem at byteoffset=0x" + Long.toHexString(var2_2 += 4L) + " (" + var2_2 + " dec) " + var24_26 + " VL=<0x" + Long.toHexString(var25_29) + ">");
                                                                continue;
                                                            }
                                                            var25_30 = false;
                                                            var26_34 = false;
                                                            if (var16_18 && var1_1.markSupported()) {
                                                                var25_30 = true;
                                                                var1_1.mark(4);
                                                            }
                                                            if (var16_18) {
                                                                var27_35 /* !! */  = var15_17 /* !! */ ;
                                                                var1_1.readInsistently(var27_35 /* !! */ , 0, 2);
                                                                if (var27_35 /* !! */ [0] == 45 && var27_35 /* !! */ [1] == 45) {
                                                                    AttributeList.slf4jlogger.info("read(): " + var24_26 + " encountered illegal Explicit VR of pair of hyphens in Explicit VR Transfer Syntax at byteoffset=0x" + Long.toHexString(var2_2) + " (" + var2_2 + " dec) ... compensating");
                                                                    var2_2 += 2L;
                                                                    var27_35 /* !! */ [0] = 85;
                                                                    var27_35 /* !! */ [1] = 78;
                                                                } else if (var27_35 /* !! */ [0] == 0 && var27_35 /* !! */ [1] == 0) {
                                                                    AttributeList.slf4jlogger.info("read(): " + var24_26 + " encountered illegal Explicit VR of pair of zero bytes in Explicit VR Transfer Syntax at byteoffset=0x" + Long.toHexString(var2_2) + " (" + var2_2 + " dec) ... compensating");
                                                                    var2_2 += 2L;
                                                                    var27_35 /* !! */ [0] = 85;
                                                                    var27_35 /* !! */ [1] = 78;
                                                                } else if (var25_30 && (var27_35 /* !! */ [0] < 65 || var27_35 /* !! */ [1] < 65)) {
                                                                    AttributeList.slf4jlogger.info("read(): " + var24_26 + " encountered incorrect Implicit VR Element encoding in Explicit VR Transfer Syntax at byteoffset=0x" + Long.toHexString(var2_2) + " (" + var2_2 + " dec) ... compensating");
                                                                    var26_34 = true;
                                                                    var1_1.reset();
                                                                    var27_35 /* !! */ [0] = 85;
                                                                    var27_35 /* !! */ [1] = 78;
                                                                } else {
                                                                    var2_2 += 2L;
                                                                }
                                                            } else {
                                                                var27_35 /* !! */  = AttributeList.getDictionary().getValueRepresentationFromTag(var24_26);
                                                                if (var27_35 /* !! */  == null) {
                                                                    var27_35 /* !! */  = var15_17 /* !! */ ;
                                                                    var27_35 /* !! */ [0] = 85;
                                                                    var27_35 /* !! */ [1] = 78;
                                                                }
                                                            }
                                                            if (var16_18 && !var26_34) {
                                                                if (ValueRepresentation.isShortValueLengthVR(var27_35 /* !! */ )) {
                                                                    var28_36 = var1_1.readUnsigned16();
                                                                    var2_2 += 2L;
                                                                } else {
                                                                    var28_36 = var1_1.readUnsigned16();
                                                                    var2_2 += 2L;
                                                                    if (var28_36 == 0L || var28_36 == 12336L) {
                                                                        var28_36 = var1_1.readUnsigned32();
                                                                        var2_2 += 4L;
                                                                    } else {
                                                                        AttributeList.slf4jlogger.info("read(): {} encountered incorrect short Value Length Form for {} Value Representation in Explicit VR Transfer Syntax at byteoffset=0x" + Long.toHexString(var2_2) + " (" + var2_2 + " dec) ... compensating", new Object[]{var24_26, ValueRepresentation.getAsString(var27_35 /* !! */ )});
                                                                    }
                                                                }
                                                            } else {
                                                                var28_36 = var1_1.readUnsigned32();
                                                                var2_2 += 4L;
                                                            }
                                                            if (var16_18 && ValueRepresentation.isUnknownVR(var27_35 /* !! */ ) && (var30_37 = AttributeList.getDictionary().getValueRepresentationFromTag(var24_26)) != null && ((byte[])var30_37).length >= 2 && (var17_19 || ValueRepresentation.getWordLengthOfValueAffectedByEndianness((byte[])var30_37) == 1)) {
                                                                if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                                                    AttributeList.slf4jlogger.trace("read(): byteoffset 0x" + Long.toHexString(var2_2) + " (" + var2_2 + " dec) for tag " + var24_26 + " consider overriding explicit VR " + ValueRepresentation.getAsString(var27_35 /* !! */ ) + " with " + ValueRepresentation.getAsString((byte[])var30_37));
                                                                }
                                                                if (!ValueRepresentation.isSequenceVR((byte[])var30_37)) {
                                                                    if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                                                        AttributeList.slf4jlogger.trace("read(): byteoffset 0x" + Long.toHexString(var2_2) + " (" + var2_2 + " dec) for tag " + var24_26 + " overriding explicit VR " + ValueRepresentation.getAsString(var27_35 /* !! */ ) + " with " + ValueRepresentation.getAsString((byte[])var30_37));
                                                                    }
                                                                    var27_35 /* !! */ [0] = var30_37[0];
                                                                    var27_35 /* !! */ [1] = var30_37[1];
                                                                } else if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                                                    AttributeList.slf4jlogger.trace("read(): byteoffset 0x" + Long.toHexString(var2_2) + " (" + var2_2 + " dec) for tag " + var24_26 + " not overriding explicit VR " + ValueRepresentation.getAsString(var27_35 /* !! */ ) + " with SQ until later when we can signal content is IVRLE");
                                                                }
                                                            }
                                                            if (var24_26.isPrivateCreator()) {
                                                                var27_35 /* !! */ [0] = 76;
                                                                var27_35 /* !! */ [1] = 79;
                                                            }
                                                            if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                                                AttributeList.slf4jlogger.trace("read(): byteoffset 0x" + Long.toHexString(var2_2) + " (" + var2_2 + " dec) " + var24_26 + " VR=<" + ValueRepresentation.getAsString(var27_35 /* !! */ ) + "> VL=<0x" + Long.toHexString(var28_36) + ">");
                                                            }
                                                            var30_37 = null;
                                                            if (!ValueRepresentation.isSequenceVR(var27_35 /* !! */ ) && (!ValueRepresentation.isUnknownVR(var27_35 /* !! */ ) || var28_36 != 0xFFFFFFFFL && (!var24_26.isPrivate() || !ClinicalTrialsAttributes.isSafePrivateSequenceAttribute(this.getPrivateCreatorString(var24_26), var24_26)))) break block174;
                                                            if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                                                AttributeList.slf4jlogger.trace("read(): byteoffset 0x" + Long.toHexString(var2_2) + " (" + var2_2 + " dec) for tag " + var24_26 + " is SQ or UN with undefined length to be treated as an SQ");
                                                            }
                                                            var30_37 = new SequenceAttribute(var24_26);
                                                            var2_2 = this.readNewSequenceAttribute((Attribute)var30_37, var1_1, var2_2, var28_36, var7_5, ValueRepresentation.isUnknownVR(var27_35 /* !! */ ) != false || var10_8 != false, var11_9, this.decompressPixelData);
                                                            break block175;
                                                        }
                                                        if (var28_36 == 0xFFFFFFFFL) break block176;
                                                        this.checkSanityOfValueLength(var28_36, var27_35 /* !! */ , var24_26, var26_34);
                                                        try {
                                                            var30_37 = AttributeFactory.newAttribute(var24_26, var27_35 /* !! */ , var28_36, var1_1, var7_5, var16_18, var22_24, var2_2, var11_9);
                                                        }
                                                        catch (Exception var31_38) {
                                                            AttributeList.slf4jlogger.error("", var31_38);
                                                            var30_37 = null;
                                                            var1_1.skipInsistently(var28_36);
                                                            if ((long)(++var23_25) <= 10L) break block171;
                                                            throw new DicomException("Too many bad attributes - probably not a DICOM dataset at all - giving up");
                                                        }
                                                    }
                                                    var2_2 += var28_36;
                                                    break block175;
                                                }
                                                if (var28_36 != 0xFFFFFFFFL || !var24_26.equals(TagFromName.PixelData)) break block175;
                                                var31_39 = var18_20 * var19_21 * var21_23;
                                                AttributeList.slf4jlogger.trace("read(): Undefined length encapsulated Pixel Data: words per frame " + var31_39);
                                                var32_43 = var1_1.getTransferSyntaxInUse();
                                                var33_44 = var32_43.getUID();
                                                AttributeList.slf4jlogger.trace("read(): Undefined length encapsulated Pixel Data: TransferSyntax UID " + (String)var33_44);
                                                this.extractCompressedPixelDataCharacteristics(var32_43);
                                                var34_45 = false;
                                                var35_46 = new EncapsulatedInputStream(var1_1, this.isJPEGFamily, this.isRLE);
                                                if (!this.decompressPixelData) break block177;
                                                AttributeList.slf4jlogger.debug("read(): decompress Pixel Data");
                                                if (!var33_44.equals("1.3.6.1.4.1.5962.300.2")) break block178;
                                                if (var22_24 != 1) break block179;
                                                var36_48 = new byte[var31_39 * var20_22];
                                                for (var37_52 = 0; var37_52 < var20_22; ++var37_52) {
                                                    var35_46.read(var36_48, var37_52 * var31_39, var31_39);
                                                }
                                                var30_37 = new OtherByteAttribute(var24_26);
                                                var30_37.setValues(var36_48);
                                                var34_45 = true;
                                                break block180;
                                            }
                                            if (var22_24 != 2) break block181;
                                            var36_49 = new short[var31_39 * var20_22];
                                            for (var37_52 = 0; var37_52 < var20_22; ++var37_52) {
                                                var35_46.readUnsigned16(var36_49, var37_52 * var31_39, var31_39);
                                            }
                                            var30_37 = new OtherWordAttribute(var24_26);
                                            var30_37.setValues(var36_49);
                                            var34_45 = true;
                                            break block180;
                                        }
                                        throw new DicomException("Encapsulated data of more than 2 bytes per sample not supported (got " + var22_24 + ")");
                                    }
                                    if (!this.isRLE) ** GOTO lbl340
                                    AttributeList.slf4jlogger.debug("read(): TransferSyntax.RLE");
                                    var36_50 = Attribute.getSingleIntegerValueOrDefault(this, TagFromName.PlanarConfiguration, 1) == 1;
                                    var37_52 = var18_20 * var19_21;
                                    if (var22_24 == 1) {
                                        AttributeList.slf4jlogger.trace("read(): bytesPerSample = 1");
                                        var38_54 /* !! */  = new byte[var31_39 * var20_22];
                                        AttributeList.slf4jlogger.trace("read(): Number of frames = " + var20_22);
                                        AttributeList.slf4jlogger.trace("read(): wordsPerFrame = " + var31_39);
                                        AttributeList.slf4jlogger.trace("read(): pixelsPerFrame = " + var37_52);
                                        var39_59 = 0;
                                        for (var40_62 = 0; var40_62 < var20_22; ++var40_62) {
                                            AttributeList.slf4jlogger.trace("read(): frame = " + var40_62);
                                            var41_72 = (int)var35_46.readUnsigned32LittleEndian();
                                            AttributeList.slf4jlogger.trace("read(): Number of segments = " + var41_72);
                                            var42_77 = new long[15];
                                            var35_46.readUnsigned32LittleEndian(var42_77, 0, 15);
                                            for (var43_84 = 0; var43_84 < 15; ++var43_84) {
                                                if (var42_77[var43_84] % 2L == 0L) continue;
                                                AttributeList.slf4jlogger.error("read(): fragment offset for segment " + var43_84 + " is not even length (" + var42_77[var43_84] + ") but ignoring and using odd offset anyway");
                                            }
                                            if (var36_50) {
                                                var43_84 = 0;
                                                for (var44_89 = 0; var44_89 < var21_23; ++var44_89) {
                                                    var45_92 = var35_46.getOffsetOfNextByteToReadFromStartOfFragment();
                                                    AttributeList.slf4jlogger.trace("read(): At fragment offset " + var45_92);
                                                    var46_97 = (int)var42_77[var44_89] - var45_92;
                                                    if (var46_97 > 0) {
                                                        var35_46.skipInsistently(var46_97);
                                                    } else if (var46_97 < 0) {
                                                        throw new DicomException("Already read past start of next segment " + var44_89 + " - at " + var45_92 + " need to be at " + var42_77[var44_89]);
                                                    }
                                                    var47_99 = UnPackBits.decode(var35_46, var38_54 /* !! */ , var39_59 + var43_84, var37_52);
                                                    var43_84 += var37_52;
                                                }
                                            } else {
                                                for (var43_84 = 0; var43_84 < var21_23; ++var43_84) {
                                                    var44_90 = new byte[var37_52];
                                                    var45_92 = var35_46.getOffsetOfNextByteToReadFromStartOfFragment();
                                                    var46_97 = (int)var42_77[var43_84] - var45_92;
                                                    if (var46_97 > 0) {
                                                        var35_46.skipInsistently(var46_97);
                                                    } else if (var46_97 < 0) {
                                                        throw new DicomException("Already read past start of next segment " + var43_84 + " - at " + var45_92 + " need to be at " + var42_77[var43_84]);
                                                    }
                                                    var47_99 = UnPackBits.decode(var35_46, var44_90, 0, var37_52);
                                                    for (var48_100 = 0; var48_100 < var37_52; ++var48_100) {
                                                        var38_54 /* !! */ [var39_59 + var48_100 * var21_23 + var43_84] = var44_90[var48_100];
                                                    }
                                                }
                                            }
                                            var35_46.nextFrame();
                                            var39_59 += var31_39;
                                        }
                                        try {
                                            var35_46.readSequenceDelimiter();
                                        }
                                        catch (IOException var40_63) {
                                            System.err.println("Error: Incorrectly terminated encapsulated pixel data - ignoring and creating PixelData anyway - " + var40_63);
                                        }
                                        var34_45 = true;
                                        var30_37 = new OtherByteAttribute(var24_26);
                                        var30_37.setValues(var38_54 /* !! */ );
                                        this.pixelDataWasActuallyDecompressed = true;
                                        this.colorSpaceWasConvertedToRGBDuringDecompression = false;
                                    } else if (var22_24 == 2) {
                                        var38_54 /* !! */  = (byte[])new short[var31_39 * var20_22];
                                        AttributeList.slf4jlogger.trace("read(): Number of frames = " + var20_22);
                                        AttributeList.slf4jlogger.trace("read(): wordsPerFrame = " + var31_39);
                                        AttributeList.slf4jlogger.trace("read(): pixelsPerFrame = " + var37_52);
                                        var39_59 = 0;
                                        for (var40_64 = 0; var40_64 < var20_22; ++var40_64) {
                                            AttributeList.slf4jlogger.trace("read(): frame = " + var40_64);
                                            var41_73 = (int)var35_46.readUnsigned32LittleEndian();
                                            AttributeList.slf4jlogger.trace("read(): Number of segments = " + var41_73);
                                            var42_78 = new long[15];
                                            var35_46.readUnsigned32LittleEndian(var42_78, 0, 15);
                                            for (var43_85 = 0; var43_85 < 15; ++var43_85) {
                                                if (var42_78[var43_85] % 2L == 0L) continue;
                                                System.err.println("Error: fragment offset for segment " + var43_85 + " is not even length (" + var42_78[var43_85] + ") but ignoring and using odd offset anyway");
                                            }
                                            if (var36_50) {
                                                var43_85 = 0;
                                                var44_89 = 0;
                                                for (var45_93 = 0; var45_93 < var21_23; ++var45_93) {
                                                    var46_98 = new byte[var37_52];
                                                    var47_99 = var35_46.getOffsetOfNextByteToReadFromStartOfFragment();
                                                    var48_101 = (int)var42_78[var44_89] - var47_99;
                                                    if (var48_101 > 0) {
                                                        var35_46.skipInsistently(var48_101);
                                                    } else if (var48_101 < 0) {
                                                        throw new DicomException("Already read past start of next segment " + var44_89 + " - at " + var47_99 + " need to be at " + var42_78[var44_89]);
                                                    }
                                                    var47_99 = UnPackBits.decode(var35_46, var46_98, 0, var37_52);
                                                    var48_102 = new byte[var37_52];
                                                    var49_104 = var35_46.getOffsetOfNextByteToReadFromStartOfFragment();
                                                    var50_105 = (int)var42_78[++var44_89] - var49_104;
                                                    if (var50_105 > 0) {
                                                        var35_46.skipInsistently(var50_105);
                                                        if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                                            AttributeList.slf4jlogger.trace("read(): Skipped {} to segment offset {}", new Object[]{var50_105, var42_78[var44_89]});
                                                        }
                                                    } else if (var50_105 < 0) {
                                                        throw new DicomException("Already read past start of next segment " + var44_89 + " - at " + var49_104 + " need to be at " + var42_78[var44_89]);
                                                    }
                                                    var47_99 = UnPackBits.decode(var35_46, var48_102, 0, var37_52);
                                                    for (var49_104 = 0; var49_104 < var37_52; ++var49_104) {
                                                        var38_54 /* !! */ [var39_59 + var43_85 + var49_104] = (short)(((var46_98[var49_104] & 255) << 8) + (var48_102[var49_104] & 255));
                                                    }
                                                    var43_85 += var37_52;
                                                    ++var44_89;
                                                }
                                            } else {
                                                throw new DicomException("RLE of PlanarConfiguration == 0 for 2 bytes per sample not supported");
                                            }
                                            var35_46.nextFrame();
                                            var39_59 += var31_39;
                                        }
                                        try {
                                            var35_46.readSequenceDelimiter();
                                        }
                                        catch (IOException var40_65) {
                                            AttributeList.slf4jlogger.error("read(): Incorrectly terminated encapsulated pixel data - ignoring and creating PixelData anyway - " + var40_65);
                                        }
                                        var34_45 = true;
                                        var30_37 = new OtherWordAttribute(var24_26);
                                        var30_37.setValues((short[])var38_54 /* !! */ );
                                        this.pixelDataWasActuallyDecompressed = true;
                                        this.colorSpaceWasConvertedToRGBDuringDecompression = false;
                                    } else {
                                        throw new DicomException("RLE of more than 2 bytes per sample not supported (got " + var22_24 + ")");
lbl340:
                                        // 1 sources

                                        CompressedFrameDecoder.scanForCodecs();
                                        this.pixelDataWasActuallyDecompressed = true;
                                        AttributeList.slf4jlogger.debug("Based on Transfer Syntax, colorSpaceWillBeConvertedToRGBDuringDecompression = {}", new Object[]{this.colorSpaceWillBeConvertedToRGBDuringDecompression});
                                        if (this.readerWanted != null) {
                                            var36_51 = CompressedFrameDecoder.selectReaderFromCodecsAvailable(this.readerWanted, (String)var33_44, var22_24);
                                            if (var36_51 != null) {
                                                var37_53 /* !! */  = null;
                                                var38_55 /* !! */  = null;
                                                AttributeList.slf4jlogger.trace("read(): Using columns = " + var19_21);
                                                AttributeList.slf4jlogger.trace("read(): Using rows = " + var18_20);
                                                AttributeList.slf4jlogger.trace("read(): Using frames = " + var20_22);
                                                AttributeList.slf4jlogger.trace("read(): Using samplesPerPixel = " + var21_23);
                                                AttributeList.slf4jlogger.trace("read(): Using bytesPerSample = " + var22_24);
                                                var39_60 = var19_21 * var18_20 * var21_23;
                                                var40_66 = (long)var39_60 * (long)var20_22;
                                                this.iioMetadata = new IIOMetadata[var20_22];
                                                for (var42_79 = 0; var42_79 < var20_22; ++var42_79) {
                                                    block172: {
                                                        AttributeList.slf4jlogger.trace("read(): Starting frame " + var42_79);
                                                        var43_86 = ImageIO.createImageInputStream(var35_46);
                                                        var36_51.setInput(var43_86, true, true);
                                                        AttributeList.slf4jlogger.trace("read(): Calling reader.read()");
                                                        var44_91 = null;
                                                        try {
                                                            var44_91 = var36_51.read(0);
                                                        }
                                                        catch (IIOException var45_94) {
                                                            AttributeList.slf4jlogger.error("", var45_94);
                                                            if (!AttributeList.slf4jlogger.isTraceEnabled()) break block172;
                                                            AttributeList.slf4jlogger.trace("read(): \"{}\"", new Object[]{var45_94.toString()});
                                                        }
                                                    }
                                                    AttributeList.slf4jlogger.trace("read(): Back from frame reader.read()");
                                                    if (var44_91 == null) {
                                                        AttributeList.slf4jlogger.error("read(): Reader {} {} {} returned null image for Transfer Syntax {}", new Object[]{var36_51.getOriginatingProvider().getDescription(Locale.US), var36_51.getOriginatingProvider().getVendorName(), var36_51.getOriginatingProvider().getVersion(), var33_44});
                                                    } else {
                                                        AttributeList.slf4jlogger.trace("read(): Back from frame {} reader.read(), BufferedImage={}", new Object[]{var42_79, var44_91});
                                                        var45_95 = var44_91.getData();
                                                        var46_97 = var45_95.getNumDataElements();
                                                        AttributeList.slf4jlogger.trace("read(): getNumDataElements={}", new Object[]{var46_97});
                                                        if (var46_97 == var21_23) {
                                                            var47_99 = var45_95.getTransferType();
                                                            AttributeList.slf4jlogger.trace("read(): getTransferType={}", new Object[]{var47_99});
                                                            if (var47_99 == 0) {
                                                                if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                                                    AttributeList.slf4jlogger.trace("read(): Getting {}{} channel byte data", new Object[]{var21_23 > 1 ? "interleaved " : "", var21_23});
                                                                }
                                                                var48_103 /* !! */  = (byte[])var45_95.getDataElements(0, 0, var19_21, var18_20, null);
                                                                if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                                                    AttributeList.slf4jlogger.trace("read(): Decompressed byte array length expected ", new Object[]{var48_103 /* !! */ .length, var39_60});
                                                                }
                                                                if (var37_53 /* !! */  == null) {
                                                                    if (var20_22 == 1) {
                                                                        var37_53 /* !! */  = var48_103 /* !! */ ;
                                                                    } else if (var40_66 < 0x7FFFFFFFL) {
                                                                        AttributeList.slf4jlogger.trace("read(): Allocating {} bytes as single array for all frames", new Object[]{var40_66});
                                                                        var37_53 /* !! */  = new byte[(int)var40_66];
                                                                    } else {
                                                                        throw new DicomException("Single array of all frames too large to allocate");
                                                                    }
                                                                }
                                                                if (var48_103 /* !! */  != null) {
                                                                    System.arraycopy(var48_103 /* !! */ , 0, var37_53 /* !! */ , var39_60 * var42_79, var39_60);
                                                                }
                                                            } else if (var47_99 == 2 || var47_99 == 1) {
                                                                if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                                                    AttributeList.slf4jlogger.trace("read(): Getting {}{} channel byte data", new Object[]{var21_23 > 1 ? "interleaved " : "", var21_23});
                                                                }
                                                                var48_103 /* !! */  = (byte[])((short[])var45_95.getDataElements(0, 0, var19_21, var18_20, null));
                                                                if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                                                    AttributeList.slf4jlogger.trace("read(): Decompressed short array length {} expected {}", new Object[]{var48_103 /* !! */ .length, var39_60});
                                                                }
                                                                if (var38_55 /* !! */  == null) {
                                                                    if (var20_22 == 1) {
                                                                        var38_55 /* !! */  = var48_103 /* !! */ ;
                                                                    } else if (var40_66 < 0x7FFFFFFFL) {
                                                                        AttributeList.slf4jlogger.trace("read(): Allocating {} shorts as single array for all frames", new Object[]{var40_66});
                                                                        var38_55 /* !! */  = (byte[])new short[(int)var40_66];
                                                                    } else {
                                                                        throw new DicomException("Single array of all frames too large to allocate");
                                                                    }
                                                                }
                                                                if (var48_103 /* !! */  != null) {
                                                                    System.arraycopy(var48_103 /* !! */ , 0, var38_55 /* !! */ , var39_60 * var42_79, var39_60);
                                                                }
                                                            }
                                                        }
                                                    }
                                                    var35_46.nextFrame();
                                                }
                                                AttributeList.slf4jlogger.trace("read(): Have now read all the frames");
                                                try {
                                                    var35_46.readSequenceDelimiter();
                                                }
                                                catch (IOException var42_80) {
                                                    System.err.println("Error: Incorrectly terminated encapsulated pixel data - ignoring and creating PixelData anyway - " + var42_80);
                                                }
                                                AttributeList.slf4jlogger.trace("read(): Have now absorbed the sequence delimiter");
                                                if (var37_53 /* !! */  != null) {
                                                    var30_37 = new OtherByteAttribute(var24_26);
                                                    var30_37.setValues(var37_53 /* !! */ );
                                                    this.pixelDataWasActuallyDecompressed = true;
                                                    this.colorSpaceWasConvertedToRGBDuringDecompression = this.colorSpaceWillBeConvertedToRGBDuringDecompression;
                                                } else if (var38_55 /* !! */  != null) {
                                                    var30_37 = new OtherWordAttribute(var24_26);
                                                    var30_37.setValues((short[])var38_55 /* !! */ );
                                                    this.pixelDataWasActuallyDecompressed = true;
                                                    this.colorSpaceWasConvertedToRGBDuringDecompression = this.colorSpaceWillBeConvertedToRGBDuringDecompression;
                                                }
                                                AttributeList.slf4jlogger.trace("read(): Have now created the PixelData attribute");
                                                var34_45 = true;
                                                try {
                                                    AttributeList.slf4jlogger.trace("read(): Calling dispose() on reader");
                                                    var36_51.dispose();
                                                }
                                                catch (Exception var42_81) {
                                                    AttributeList.slf4jlogger.error("", var42_81);
                                                }
                                            }
                                        } else {
                                            AttributeList.slf4jlogger.trace("read(): Unrecognized Transfer Syntax {} for encapsulated PixelData", new Object[]{var33_44});
                                            throw new DicomException("Unrecognized Transfer Syntax " + (String)var33_44 + " for encapsulated PixelData");
                                        }
                                    }
                                }
                                AttributeList.slf4jlogger.debug("colorSpaceWasConvertedToRGBDuringDecompression = {}", new Object[]{this.colorSpaceWasConvertedToRGBDuringDecompression});
                                break block182;
                            }
                            AttributeList.slf4jlogger.debug("read(): Do not decompress Pixel Data");
                            var36_47 = System.currentTimeMillis();
                            if ((long)var20_22 <= 1000L || !var35_46.framesAreSeparated()) {
                                AttributeList.slf4jlogger.debug("read(): read all compressed frames into memory");
                                if (var35_46.framesAreSeparated()) {
                                    var38_56 = true;
                                    AttributeList.slf4jlogger.debug("read(): frames are separated in encapsulated input");
                                    var39_61 = new byte[var20_22][];
                                    for (var40_67 = 0; var40_67 < var20_22; ++var40_67) {
                                        AttributeList.slf4jlogger.trace("read(): Doing compressed frame {}", new Object[]{var40_67});
                                        if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                            AttributeList.slf4jlogger.trace("read(): at position byteOffset + encapsulatedBytesRead = 0x{} ({} dec)", new Object[]{Long.toHexString(var2_2 + var35_46.getBytesRead()), var2_2 + var35_46.getBytesRead()});
                                        }
                                        var41_74 = new ArrayList<byte[]>();
                                        var42_82 = new ArrayList<E>();
                                        var43_87 = 0;
                                        var44_89 = 0;
                                        do {
                                            if ((var44_89 = var35_46.read(var45_96 = new byte[1024])) <= 0) continue;
                                            var41_74.add(var45_96);
                                            var42_82.add(new Integer(var44_89));
                                            var43_87 += var44_89;
                                        } while (var44_89 > 0);
                                        AttributeList.slf4jlogger.trace("read(): bytesTotal = {} for frame {}", new Object[]{var43_87, var40_67});
                                        var45_96 = null;
                                        if (var43_87 > 0) {
                                            var45_96 = new byte[var43_87];
                                            var46_97 = 0;
                                            for (var47_99 = 0; var47_99 < var41_74.size(); ++var47_99) {
                                                var48_103 /* !! */  = (byte[])var41_74.get(var47_99);
                                                var49_104 = (Integer)var42_82.get(var47_99);
                                                AttributeList.slf4jlogger.trace("read(): b length = {}", new Object[]{var49_104});
                                                System.arraycopy(var48_103 /* !! */ , 0, var45_96, var46_97, var49_104);
                                                var46_97 += var49_104;
                                            }
                                        } else {
                                            AttributeList.slf4jlogger.error("read(): Premature end of encapsulated PixelData - no data for frame {} (numbered from 1) - expected {} frames - ignoring this PixelData element", new Object[]{var40_67 + 1, var20_22});
                                            var38_56 = false;
                                        }
                                        var39_61[var40_67] = var45_96;
                                        var35_46.nextFrame();
                                    }
                                    try {
                                        var35_46.readSequenceDelimiter();
                                    }
                                    catch (IOException var40_68) {
                                        System.err.println("Error: Incorrectly terminated encapsulated pixel data - ignoring and creating PixelData anyway - " + var40_68);
                                    }
                                    if (var38_56) {
                                        var30_37 = new OtherByteAttributeMultipleCompressedFrames(var24_26, (byte[][])var39_61);
                                    }
                                } else {
                                    AttributeList.slf4jlogger.debug("read(): frames are not separated in encapsulated input");
                                    var38_57 = new ArrayList<byte[]>();
                                    var39_61 = new ArrayList<E>();
                                    var40_69 = 0;
                                    var41_75 = 0;
                                    do {
                                        if ((var41_75 = var35_46.read((byte[])(var42_82 = new byte[1024]))) <= 0) continue;
                                        var38_57.add((byte[])var42_82);
                                        var39_61.add(new Integer(var41_75));
                                        var40_69 += var41_75;
                                    } while (var41_75 > 0);
                                    AttributeList.slf4jlogger.debug("read(): bytesTotal = {}", new Object[]{var40_69});
                                    var42_82 = null;
                                    if (var40_69 > 0) {
                                        var42_82 = new byte[var40_69];
                                        var43_87 = 0;
                                        for (var44_89 = 0; var44_89 < var38_57.size(); ++var44_89) {
                                            var45_96 = (byte[])var38_57.get(var44_89);
                                            var46_97 = (Integer)var39_61.get(var44_89);
                                            AttributeList.slf4jlogger.trace("read(): b length = {}", new Object[]{var46_97});
                                            System.arraycopy(var45_96, 0, var42_82, var43_87, var46_97);
                                            var43_87 += var46_97;
                                        }
                                    } else {
                                        throw new DicomException("Premature end of encapsulated PixelData - no data for frames");
                                    }
                                    var30_37 = new OtherByteAttributeMultipleCompressedFrames(var24_26, (byte[])var42_82);
                                }
                            } else {
                                AttributeList.slf4jlogger.debug("read(): leave all compressed frames on disk");
                                if (var35_46.framesAreSeparated()) {
                                    var38_58 = new long[var20_22][];
                                    var39_61 = new long[var20_22][];
                                    for (var40_70 = 0; var40_70 < var20_22; ++var40_70) {
                                        AttributeList.slf4jlogger.trace("read(): Doing compressed frame {}", new Object[]{var40_70});
                                        var41_76 = 0;
                                        var42_83 = 0;
                                        var43_88 = new byte[1024];
                                        do {
                                            var42_83 = var35_46.read(var43_88);
                                            var41_76 += var42_83;
                                        } while (var42_83 > 0);
                                        AttributeList.slf4jlogger.debug("read(): bytesTotal = {}", new Object[]{var41_76});
                                        if (var41_76 <= 0) {
                                            throw new DicomException("Premature end of encapsulated PixelData - no data for frame " + (var40_70 + 1) + " (numbered from 1) - expected " + var20_22 + " frames");
                                        }
                                        AttributeList.slf4jlogger.trace("read(): byteOffset = {} for frame {}", new Object[]{var2_2, var40_70});
                                        var38_58[var40_70] = var35_46.getByteOffsetsOfItemsForCurrentFrame(var2_2);
                                        var39_61[var40_70] = var35_46.getItemLengthsForCurrentFrame();
                                        var35_46.nextFrame();
                                    }
                                    try {
                                        var35_46.readSequenceDelimiter();
                                    }
                                    catch (IOException var40_71) {
                                        System.err.println("Error: Incorrectly terminated encapsulated pixel data - ignoring and creating PixelData anyway - " + var40_71);
                                    }
                                    var30_37 = new OtherByteAttributeCompressedSeparateFramesOnDisk(var24_26, var1_1, var38_58, (long[][])var39_61);
                                } else {
                                    throw new DicomException("Internal error: should not get here since supposed to have checked earlier and left in memory");
                                }
                            }
                            var34_45 = true;
                            this.pixelDataWasActuallyDecompressed = false;
                            if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                AttributeList.slf4jlogger.trace("read(): read of compressed bytes into buffers done in {} ms", new Object[]{System.currentTimeMillis() - var36_47});
                            }
                        }
                        if (!var34_45) {
                            AttributeList.slf4jlogger.debug("read(): skipping encapsulated pixel data");
                            while (var35_46.skip(1024L) > 0L) {
                            }
                        }
                        var36_47 = var35_46.getBytesRead();
                        AttributeList.slf4jlogger.trace("read(): encapsulatedBytesRead = " + var36_47);
                        var2_2 += var36_47;
                        if (var36_47 != 0L) {
                            this.compressionRatio = (long)var19_21 * (long)var18_20 * (long)var21_23 * (long)var22_24 * (long)var20_22 * 1000L / var36_47;
                            this.compressionRatio /= 1000.0;
                            AttributeList.slf4jlogger.trace("read(): compressionRatio = {}", new Object[]{this.compressionRatio});
                        }
                        AttributeList.slf4jlogger.trace("read(): Done with encapsulated pixel data");
                    }
                    if (var30_37 == null) continue;
                    if (AttributeList.slf4jlogger.isTraceEnabled()) {
                        AttributeList.slf4jlogger.trace("read(): {}", new Object[]{var30_37.toString()});
                    }
                    if (this.get(var24_26) != null) {
                        System.err.println("Error: Illegal duplicate tag in dataset - " + var24_26 + " - replacing previous occurence");
                    }
                    this.put(var24_26, (Attribute)var30_37);
                    if (var24_26.equals(TagFromName.FileMetaInformationGroupLength)) {
                        if (var1_1.areReadingMetaHeader()) {
                            AttributeList.slf4jlogger.trace("read(): Found meta-header");
                            if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                AttributeList.slf4jlogger.trace("read(): Length attribute class={}", new Object[]{var30_37.getClass()});
                            }
                            if (!AttributeList.$assertionsDisabled && var10_8) {
                                throw new AssertionError();
                            }
                            var31_40 = var30_37.getSingleIntegerValueOrDefault(0);
                            var2_2 = this.read(var1_1, var2_2, var31_40, false, null, var8_6, var9_7, false, false);
                            var33_44 = var1_1.getTransferSyntaxToReadDataSet();
                            if (var33_44 == null) {
                                System.err.println("Error: Transfer Syntax UID was not specified in Meta Information Header so guessing");
                                var1_1.guessTransferSyntaxToReadDataSet();
                            }
                            var1_1.setReadingDataSet();
                            if (var6_4) {
                                AttributeList.slf4jlogger.trace("read(): Stopping after meta-header");
                            } else {
                                AttributeList.slf4jlogger.trace("read(): Calling read");
                                var2_2 = this.read(var1_1, var2_2, 0xFFFFFFFFL, false, null, var8_6, var9_7, false, false);
                                if (AttributeList.slf4jlogger.isTraceEnabled()) {
                                    AttributeList.slf4jlogger.trace("read(): Back from read after metaheader: now undefinedLength={} byteoffset=0x{} ({} dec) endByteOffset={}", new Object[]{var12_13, Long.toHexString(var2_2), var2_2, var13_15});
                                }
                            }
                            break;
                        }
                        AttributeList.slf4jlogger.trace("read(): Ignoring unexpected FileMetaInformationGroupLength outside meta information header");
                        continue;
                    }
                    if (var24_26.equals(TagFromName.TransferSyntaxUID)) {
                        AttributeList.slf4jlogger.trace("read(): Have TransferSyntaxUID attribute");
                        if (var1_1.areReadingMetaHeader()) {
                            AttributeList.slf4jlogger.trace("read(): Have TransferSyntaxUID attribute in Meta Information Header");
                            var31_41 = var30_37.getSingleStringValueOrEmptyString();
                            AttributeList.slf4jlogger.trace("read(): tsuid = {}", new Object[]{var31_41});
                            var1_1.setTransferSyntaxToReadDataSet(var31_41.length() > 0 ? new TransferSyntax(var31_41) : null);
                            continue;
                        }
                        AttributeList.slf4jlogger.trace("read(): Ignoring unexpected TransferSyntaxUID outside meta information header");
                        continue;
                    }
                    if (var24_26.equals(TagFromName.SpecificCharacterSet)) {
                        var7_5 = new SpecificCharacterSet(var30_37.getStringValues(), var30_37.getByteValues());
                        continue;
                    }
                    if (var24_26.equals(TagFromName.Columns)) {
                        var19_21 = var30_37.getSingleIntegerValueOrDefault(0);
                        AttributeList.slf4jlogger.trace("read(): Setting columns = " + var19_21);
                        continue;
                    }
                    if (var24_26.equals(TagFromName.Rows)) {
                        var18_20 = var30_37.getSingleIntegerValueOrDefault(0);
                        AttributeList.slf4jlogger.trace("read(): Setting rows = " + var18_20);
                        continue;
                    }
                    if (var24_26.equals(TagFromName.NumberOfFrames)) {
                        var20_22 = var30_37.getSingleIntegerValueOrDefault(1);
                        AttributeList.slf4jlogger.trace("read(): Setting frames = {}", new Object[]{var20_22});
                        continue;
                    }
                    if (var24_26.equals(TagFromName.SamplesPerPixel)) {
                        var21_23 = var30_37.getSingleIntegerValueOrDefault(1);
                        AttributeList.slf4jlogger.trace("read(): Setting samplesPerPixel = {}", new Object[]{var21_23});
                        continue;
                    }
                    if (var24_26.equals(TagFromName.BitsAllocated)) {
                        var22_24 = (var30_37.getSingleIntegerValueOrDefault(16) - 1) / 8 + 1;
                        AttributeList.slf4jlogger.trace("read(): Setting bytesPerSample = {}", new Object[]{var22_24});
                        continue;
                    }
                    if (!var24_26.equals(TagFromName.PixelRepresentation)) continue;
                    var31_42 = var30_37.getSingleIntegerValueOrDefault(0);
                    var11_9 = var31_42 == 1;
                    AttributeList.slf4jlogger.trace("read(): Setting isSignedPixelRepresentation = {} because PixelRepresentation = {}", new Object[]{var11_9, var31_42});
                }
            }
            catch (EOFException var25_31) {
                AttributeList.slf4jlogger.trace("read(): Closing on ", var25_31);
                if (!var12_13) {
                    throw new EOFException();
                }
            }
            catch (IOException var25_32) {
                AttributeList.slf4jlogger.trace("read(): Closing on ", var25_32);
                if (var12_13) break block173;
                throw new IOException();
            }
        }
        AttributeList.slf4jlogger.trace("read(): end");
        return var2_2;
    }

    public long readOnlyMetaInformationHeader(DicomInputStream dicomInputStream) throws IOException, DicomException {
        return this.read(dicomInputStream, dicomInputStream.getByteOffsetOfStartOfData(), 0xFFFFFFFFL, true, null, null, null, false, false);
    }

    public long read(DicomInputStream dicomInputStream, AttributeTag attributeTag) throws IOException, DicomException {
        return this.read(dicomInputStream, dicomInputStream.getByteOffsetOfStartOfData(), 0xFFFFFFFFL, false, null, attributeTag, null, false, false);
    }

    public long read(DicomInputStream dicomInputStream, AttributeTag attributeTag, ReadTerminationStrategy readTerminationStrategy) throws IOException, DicomException {
        return this.read(dicomInputStream, dicomInputStream.getByteOffsetOfStartOfData(), 0xFFFFFFFFL, false, null, attributeTag, readTerminationStrategy, false, false);
    }

    public long read(DicomInputStream dicomInputStream, ReadTerminationStrategy readTerminationStrategy) throws IOException, DicomException {
        return this.read(dicomInputStream, dicomInputStream.getByteOffsetOfStartOfData(), 0xFFFFFFFFL, false, null, null, readTerminationStrategy, false, false);
    }

    public long read(DicomInputStream dicomInputStream) throws IOException, DicomException {
        return this.read(dicomInputStream, dicomInputStream.getByteOffsetOfStartOfData(), 0xFFFFFFFFL, false, null, null, null, false, false);
    }

    public long read(String string, String string2, boolean bl, boolean bl2) throws IOException, DicomException {
        return this.read(string, string2, bl, bl2, null, null);
    }

    private long read(String string, String string2, boolean bl, boolean bl2, AttributeTag attributeTag, ReadTerminationStrategy readTerminationStrategy) throws IOException, DicomException {
        long l = 0L;
        InputStream inputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            File file = new File(string);
            inputStream = new FileInputStream(file);
            if (bl2) {
                inputStream = new BufferedInputStream(inputStream);
            }
            if (((BinaryInputStream)(filterInputStream = new DicomInputStream(inputStream, string2, bl))).getFile() == null) {
                ((BinaryInputStream)filterInputStream).setFile(file);
            }
            l = this.read((DicomInputStream)filterInputStream, attributeTag, readTerminationStrategy);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (DicomException dicomException) {
            throw dicomException;
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return l;
    }

    public long read(String string, String string2, boolean bl, boolean bl2, ReadTerminationStrategy readTerminationStrategy) throws IOException, DicomException {
        return this.read(string, string2, bl, bl2, null, readTerminationStrategy);
    }

    public long read(String string, String string2, boolean bl, boolean bl2, AttributeTag attributeTag) throws IOException, DicomException {
        return this.read(string, string2, bl, bl2, attributeTag, null);
    }

    public long readOnlyMetaInformationHeader(String string) throws IOException, DicomException {
        long l = 0L;
        InputStream inputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            inputStream = new FileInputStream(string);
            inputStream = new BufferedInputStream(inputStream);
            filterInputStream = new DicomInputStream(inputStream, null, true);
            l = this.readOnlyMetaInformationHeader((DicomInputStream)filterInputStream);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (DicomException dicomException) {
            throw dicomException;
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return l;
    }

    public long read(String string) throws IOException, DicomException {
        return this.read(string, null, true, true);
    }

    public long read(String string, AttributeTag attributeTag) throws IOException, DicomException {
        return this.read(string, null, true, true, attributeTag);
    }

    public long read(String string, ReadTerminationStrategy readTerminationStrategy) throws IOException, DicomException {
        return this.read(string, null, true, true, null, readTerminationStrategy);
    }

    public long read(File file) throws IOException, DicomException {
        return this.read(file.getCanonicalPath());
    }

    public long read(File file, AttributeTag attributeTag) throws IOException, DicomException {
        return this.read(file.getCanonicalPath(), attributeTag);
    }

    public long read(File file, ReadTerminationStrategy readTerminationStrategy) throws IOException, DicomException {
        return this.read(file.getCanonicalPath(), readTerminationStrategy);
    }

    public long readOnlyMetaInformationHeader(File file) throws IOException, DicomException {
        return this.readOnlyMetaInformationHeader(file.getCanonicalPath());
    }

    protected void writeFragment(DicomOutputStream dicomOutputStream) throws IOException, DicomException {
        for (Attribute attribute : this.values()) {
            attribute.write(dicomOutputStream);
        }
    }

    public void write(DicomOutputStream dicomOutputStream, boolean bl) throws IOException, DicomException {
        DeflaterOutputStream deflaterOutputStream = null;
        OutputStream outputStream = null;
        for (Attribute attribute : this.values()) {
            boolean bl2;
            boolean bl3 = attribute.getTag().getGroup() == 0;
            boolean bl4 = bl2 = attribute.getTag().getGroup() > 2;
            if (bl2) {
                if (dicomOutputStream.getTransferSyntaxToWriteDataSet().isDeflated()) {
                    deflaterOutputStream = new DeflaterOutputStream((OutputStream)dicomOutputStream, new Deflater(9, true));
                    dicomOutputStream = new DicomOutputStream(deflaterOutputStream, null, "1.2.840.10008.1.2.1");
                } else if (dicomOutputStream.getTransferSyntaxToWriteDataSet().isBzip2ed()) {
                    try {
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream");
                        Class[] classArray = new Class[]{OutputStream.class};
                        Object[] objectArray = new Object[]{dicomOutputStream};
                        outputStream = (OutputStream)clazz.getConstructor(classArray).newInstance(objectArray);
                        dicomOutputStream = new DicomOutputStream(outputStream, null, "1.2.840.10008.1.2.1");
                    }
                    catch (Exception exception) {
                        throw new DicomException("Could not instantiate bzip2 codec - " + exception);
                    }
                }
                dicomOutputStream.setWritingDataSet();
            }
            if (!bl2 && !bl && !bl3) continue;
            attribute.write(dicomOutputStream);
        }
        if (deflaterOutputStream != null) {
            deflaterOutputStream.finish();
        }
        if (outputStream != null) {
            outputStream.close();
        }
    }

    public void write(DicomOutputStream dicomOutputStream) throws IOException, DicomException {
        this.write(dicomOutputStream, true);
    }

    public void write(OutputStream outputStream, String string, boolean bl, boolean bl2) throws IOException, DicomException {
        this.write(outputStream, string, bl, bl2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream, String string, boolean bl, boolean bl2, boolean bl3, byte[] byArray) throws IOException, DicomException {
        if (bl2) {
            outputStream = new BufferedOutputStream(outputStream);
        }
        try {
            DicomOutputStream dicomOutputStream = new DicomOutputStream(outputStream, bl ? "1.2.840.10008.1.2.1" : null, string, byArray);
            this.write(dicomOutputStream, bl);
            dicomOutputStream.close();
        }
        finally {
            if (bl3) {
                outputStream.close();
            }
        }
    }

    public void write(OutputStream outputStream, String string, boolean bl, boolean bl2, boolean bl3) throws IOException, DicomException {
        this.write(outputStream, string, bl, bl2, bl3, null);
    }

    public void write(String string, String string2, boolean bl, boolean bl2, byte[] byArray) throws IOException, DicomException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.write(fileOutputStream, string2, bl, bl2, true, byArray);
    }

    public void write(String string, String string2, boolean bl, boolean bl2) throws IOException, DicomException {
        this.write(string, string2, bl, bl2, null);
    }

    public void write(String string) throws IOException, DicomException {
        String string2 = Attribute.getSingleStringValueOrEmptyString(this, TagFromName.TransferSyntaxUID);
        if (string2.length() != 0 && !string2.equals("1.2.840.10008.1.2.1")) {
            throw new DicomException("TransferSyntaxUID in File Meta Information is not Explicit VR Little Endian");
        }
        this.write(string, "1.2.840.10008.1.2.1", true, true);
    }

    public void write(File file, String string, boolean bl, boolean bl2, byte[] byArray) throws IOException, DicomException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.write(fileOutputStream, string, bl, bl2, true, byArray);
    }

    public void write(File file, String string, boolean bl, boolean bl2) throws IOException, DicomException {
        this.write(file, string, bl, bl2, null);
    }

    public void write(File file) throws IOException, DicomException {
        String string = Attribute.getSingleStringValueOrEmptyString(this, TagFromName.TransferSyntaxUID);
        if (string.length() != 0 && !string.equals("1.2.840.10008.1.2.1")) {
            throw new DicomException("TransferSyntaxUID in File Meta Information is not Explicit VR Little Endian");
        }
        this.write(file, "1.2.840.10008.1.2.1", true, true);
    }

    @Override
    public Attribute put(AttributeTag attributeTag, Attribute attribute) throws NullPointerException, ClassCastException {
        if (attribute == null || attributeTag == null) {
            throw new NullPointerException();
        }
        return super.put(attributeTag, attribute);
    }

    public Attribute put(Attribute attribute) {
        if (attribute == null) {
            throw new NullPointerException();
        }
        return this.put(attribute.getTag(), attribute);
    }

    public Attribute get(AttributeTag attributeTag) {
        return (Attribute)super.get(attributeTag);
    }

    public boolean isImage() {
        return this.getPixelData() != null;
    }

    public boolean isEnhanced() {
        return this.get(TagFromName.SharedFunctionalGroupsSequence) != null || this.get(TagFromName.PerFrameFunctionalGroupsSequence) != null;
    }

    public boolean isSRDocument() {
        return this.get(TagFromName.ContentSequence) != null;
    }

    public static DicomDictionary getDictionary() {
        return DicomDictionary.StandardDictionary;
    }

    public Attribute remove(AttributeTag attributeTag) {
        return (Attribute)super.remove(attributeTag);
    }

    public void removeRecursively(AttributeTag attributeTag) {
        for (Attribute attribute : this.values()) {
            if (!(attribute instanceof SequenceAttribute)) continue;
            Iterator<SequenceItem> iterator = ((SequenceAttribute)attribute).iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList;
                SequenceItem sequenceItem = iterator.next();
                if (sequenceItem == null || (attributeList = sequenceItem.getAttributeList()) == null) continue;
                attributeList.remove(attributeTag);
            }
        }
        this.remove(attributeTag);
    }

    public void removeGroup(int n) {
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            AttributeTag attributeTag = (AttributeTag)iterator.next();
            if (attributeTag.getGroup() != n) continue;
            iterator.remove();
        }
    }

    public void replaceWithZeroLengthIfPresent(AttributeTag attributeTag) throws DicomException {
        Attribute attribute = this.get(attributeTag);
        if (attribute != null) {
            Attribute attribute2 = AttributeFactory.newAttribute(attributeTag, AttributeList.getDictionary().getValueRepresentationFromTag(attributeTag));
            this.put(attributeTag, attribute2);
        }
    }

    @Override
    public void replace(AttributeTag attributeTag, String string) throws DicomException {
        Attribute attribute = AttributeFactory.newAttribute(attributeTag, AttributeList.getDictionary().getValueRepresentationFromTag(attributeTag));
        attribute.addValue(string);
        this.put(attributeTag, attribute);
    }

    public void replaceWithValueIfPresent(AttributeTag attributeTag, String string) throws DicomException {
        Attribute attribute = this.get(attributeTag);
        if (attribute != null) {
            Attribute attribute2 = AttributeFactory.newAttribute(attributeTag, AttributeList.getDictionary().getValueRepresentationFromTag(attributeTag));
            attribute2.addValue(string);
            this.put(attributeTag, attribute2);
        }
    }

    public void replaceWithDummyValueIfPresent(AttributeTag attributeTag, String string) throws DicomException {
        this.replaceWithValueIfPresent(attributeTag, string);
    }

    public void removePrivateAttributes() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (attribute.getTag().isPrivate()) {
                iterator.remove();
                continue;
            }
            if (!(attribute instanceof SequenceAttribute)) continue;
            Iterator<SequenceItem> iterator2 = ((SequenceAttribute)attribute).iterator();
            while (iterator2.hasNext()) {
                AttributeList attributeList;
                SequenceItem sequenceItem = iterator2.next();
                if (sequenceItem == null || (attributeList = sequenceItem.getAttributeList()) == null) continue;
                attributeList.removePrivateAttributes();
            }
        }
    }

    public void removeUnsafePrivateAttributes() {
        AttributeTag attributeTag;
        Attribute attribute;
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Object object;
            attribute = (Attribute)iterator.next();
            attributeTag = attribute.getTag();
            boolean bl = false;
            if (attributeTag.isPrivate()) {
                if (ClinicalTrialsAttributes.isSafePrivateAttribute(attributeTag, this)) {
                    object = this.getPrivateCreatorTag(attributeTag);
                    hashSet.add(object);
                } else {
                    iterator.remove();
                    bl = true;
                }
            }
            if (bl || !(attribute instanceof SequenceAttribute)) continue;
            object = ((SequenceAttribute)attribute).iterator();
            while (object.hasNext()) {
                AttributeList attributeList;
                SequenceItem sequenceItem = (SequenceItem)object.next();
                if (sequenceItem == null || (attributeList = sequenceItem.getAttributeList()) == null) continue;
                attributeList.removeUnsafePrivateAttributes();
            }
        }
        iterator = this.values().iterator();
        while (iterator.hasNext()) {
            attribute = (Attribute)iterator.next();
            attributeTag = attribute.getTag();
            if (!attributeTag.isPrivateCreator() || hashSet.contains(attributeTag)) continue;
            iterator.remove();
        }
    }

    public AttributeTag getPrivateCreatorTag(AttributeTag attributeTag) {
        int n = attributeTag.getGroup();
        int n2 = attributeTag.getElement();
        int n3 = (n2 & 0xFF00) >> 8;
        return new AttributeTag(n, n3);
    }

    public String getPrivateCreatorString(AttributeTag attributeTag) {
        AttributeTag attributeTag2 = this.getPrivateCreatorTag(attributeTag);
        String string = Attribute.getSingleStringValueOrEmptyString(this, attributeTag2).trim();
        return string;
    }

    public Attribute get(AttributeTag attributeTag, String string) {
        Attribute attribute = null;
        if (attributeTag.isPrivate()) {
            int n = attributeTag.getGroup();
            for (int i = 0; i < 256; ++i) {
                String string2 = Attribute.getSingleStringValueOrEmptyString(this, new AttributeTag(n, i));
                if (!string2.equals(string)) continue;
                attribute = this.get(new AttributeTag(n, i << 8 | attributeTag.getElement() & 0xFF));
                break;
            }
        }
        return attribute;
    }

    public Attribute getPixelData() {
        return PrivatePixelData.getPixelData(this);
    }

    public void removeCommandGroupAttributes() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            int n = attribute.getTag().getGroup();
            if (n != 0) continue;
            iterator.remove();
        }
    }

    public void removeMetaInformationHeaderAttributes() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            int n = attribute.getTag().getGroup();
            if (n != 2 && n != 0) continue;
            iterator.remove();
        }
    }

    public void removeGroupLengthAttributes() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Object object;
            Attribute attribute = (Attribute)iterator.next();
            if (attribute instanceof SequenceAttribute) {
                object = ((SequenceAttribute)attribute).iterator();
                while (object.hasNext()) {
                    AttributeList attributeList;
                    SequenceItem sequenceItem = (SequenceItem)object.next();
                    if (sequenceItem == null || (attributeList = sequenceItem.getAttributeList()) == null) continue;
                    attributeList.removeGroupLengthAttributes();
                }
                continue;
            }
            object = attribute.getTag();
            if (((AttributeTag)object).getElement() != 0 || ((AttributeTag)object).getGroup() == 2) continue;
            iterator.remove();
        }
        this.remove(TagFromName.LengthToEnd);
    }

    public void removeOverlayAttributes() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getTag().isOverlayGroup()) continue;
            iterator.remove();
        }
    }

    public void removeCurveAttributes() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getTag().isCurveGroup()) continue;
            iterator.remove();
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Attribute)iterator.next()).toString(AttributeList.getDictionary()));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Attribute)iterator.next()).toString(dicomDictionary));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getDelimitedStringValuesOrDefault(String string, NumberFormat numberFormat, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "";
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(string3);
            stringBuffer.append(((Attribute)iterator.next()).getDelimitedStringValuesOrDefault(string, numberFormat));
            string3 = string2;
        }
        return stringBuffer.toString();
    }

    public void setFileUsedByOnDiskAttributes(File file) {
        for (Attribute attribute : this.values()) {
            if (attribute instanceof OtherByteAttributeOnDisk) {
                ((OtherByteAttributeOnDisk)attribute).setFile(file);
                continue;
            }
            if (!(attribute instanceof OtherWordAttributeOnDisk)) continue;
            ((OtherWordAttributeOnDisk)attribute).setFile(file);
        }
    }

    public Attribute putNewAttribute(AttributeTag attributeTag, SpecificCharacterSet specificCharacterSet) throws DicomException {
        Attribute attribute = null;
        byte[] byArray = AttributeList.getDictionary().getValueRepresentationFromTag(attributeTag);
        if (byArray == null) {
            throw new DicomException("No such data element as " + attributeTag + " in dictionary");
        }
        attribute = AttributeFactory.newAttribute(attributeTag, byArray, specificCharacterSet);
        if (attribute == null) {
            throw new DicomException("Could not create attribute for tag " + attributeTag);
        }
        super.put(attributeTag, attribute);
        return attribute;
    }

    public Attribute putNewAttribute(AttributeTag attributeTag) throws DicomException {
        return this.putNewAttribute(attributeTag, null);
    }

    public void setSpecificCharacterSet(SpecificCharacterSet specificCharacterSet) {
        if (specificCharacterSet != null) {
            for (Attribute attribute : this.values()) {
                if (attribute == null) continue;
                if (attribute instanceof SequenceAttribute) {
                    Iterator<SequenceItem> iterator = ((SequenceAttribute)attribute).iterator();
                    while (iterator.hasNext()) {
                        AttributeList attributeList;
                        SequenceItem sequenceItem = iterator.next();
                        if (sequenceItem == null || (attributeList = sequenceItem.getAttributeList()) == null) continue;
                        attributeList.setSpecificCharacterSet(specificCharacterSet);
                    }
                    continue;
                }
                if (!(attribute instanceof StringAttributeAffectedBySpecificCharacterSet)) continue;
                ((StringAttributeAffectedBySpecificCharacterSet)attribute).setSpecificCharacterSet(specificCharacterSet);
            }
        }
    }

    public SpecificCharacterSet getSuitableSpecificCharacterSetForAllStringValues() {
        return new SpecificCharacterSet(this);
    }

    public void insertSuitableSpecificCharacterSetForAllStringValues() throws DicomException {
        SpecificCharacterSet specificCharacterSet = this.getSuitableSpecificCharacterSetForAllStringValues();
        if (specificCharacterSet != null) {
            String string = specificCharacterSet.getValueToUseInSpecificCharacterSetAttribute();
            if (string != null && string.length() > 0) {
                this.putNewAttribute(TagFromName.SpecificCharacterSet).addValue(string);
            } else {
                this.remove(TagFromName.SpecificCharacterSet);
            }
            this.setSpecificCharacterSet(specificCharacterSet);
        }
    }

    public static void clearByteOffset(AttributeList attributeList) {
        for (Attribute attribute : attributeList.values()) {
            if (attribute == null || !(attribute instanceof SequenceAttribute)) continue;
            Iterator<SequenceItem> iterator = ((SequenceAttribute)attribute).iterator();
            while (iterator.hasNext()) {
                SequenceItem sequenceItem = iterator.next();
                if (sequenceItem == null) continue;
                sequenceItem.setByteOffset(0L);
                AttributeList attributeList2 = sequenceItem.getAttributeList();
                if (attributeList2 == null) continue;
                AttributeList.clearByteOffset(attributeList2);
            }
        }
    }

    private void extractCompressedPixelDataCharacteristics(TransferSyntax transferSyntax) {
        String string = transferSyntax.getUID();
        this.isJPEGFamily = transferSyntax.isJPEGFamily();
        this.isRLE = string.equals("1.2.840.10008.1.2.5");
        this.colorSpaceWasConvertedToRGBDuringDecompression = false;
        this.colorSpaceWillBeConvertedToRGBDuringDecompression = false;
        this.pixelDataIsLossy = false;
        this.lossyMethod = null;
        this.compressionRatio = 0.0;
        this.readerWanted = null;
        if (!this.isRLE) {
            if (this.isJPEGFamily) {
                if (string.equals("1.2.840.10008.1.2.4.50") || string.equals("1.2.840.10008.1.2.4.51") || string.equals("1.2.840.10008.1.2.4.55")) {
                    this.readerWanted = "JPEG";
                    this.colorSpaceWillBeConvertedToRGBDuringDecompression = true;
                    this.pixelDataIsLossy = true;
                    this.lossyMethod = "ISO_10918_1";
                } else if (string.equals("1.2.840.10008.1.2.4.91")) {
                    this.readerWanted = "JPEG2000";
                    this.colorSpaceWillBeConvertedToRGBDuringDecompression = true;
                    this.pixelDataIsLossy = true;
                    this.lossyMethod = "ISO_15444_1";
                } else if (string.equals("1.2.840.10008.1.2.4.90")) {
                    this.readerWanted = "JPEG2000";
                    this.colorSpaceWillBeConvertedToRGBDuringDecompression = true;
                } else if (string.equals("1.2.840.10008.1.2.4.57") || string.equals("1.2.840.10008.1.2.4.70")) {
                    this.readerWanted = "jpeg-lossless";
                    this.colorSpaceWillBeConvertedToRGBDuringDecompression = false;
                } else if (string.equals("1.2.840.10008.1.2.4.80")) {
                    this.readerWanted = "jpeg-ls";
                    this.colorSpaceWillBeConvertedToRGBDuringDecompression = false;
                } else if (string.equals("1.2.840.10008.1.2.4.81")) {
                    this.readerWanted = "jpeg-ls";
                    this.colorSpaceWillBeConvertedToRGBDuringDecompression = false;
                    this.pixelDataIsLossy = true;
                    this.lossyMethod = "ISO_14495_1";
                } else {
                    this.readerWanted = "JPEG";
                    this.colorSpaceWillBeConvertedToRGBDuringDecompression = true;
                    slf4jlogger.warn("Unrecognized JPEG family Transfer Syntax " + string + " for encapsulated PixelData - guessing " + this.readerWanted);
                }
            } else {
                slf4jlogger.warn("Unrecognized Transfer Syntax " + string + " for encapsulated PixelData - cannot find reader");
            }
        }
    }

    public IIOMetadata getIIOMetadata(int n) {
        return this.iioMetadata == null ? null : this.iioMetadata[n];
    }

    public void insertLossyImageCompressionHistoryIfDecompressed(boolean bl) throws DicomException {
        if ((this.pixelDataWasActuallyDecompressed || bl) && this.pixelDataIsLossy) {
            Attribute attribute = new CodeStringAttribute(TagFromName.LossyImageCompression);
            attribute.addValue("01");
            this.put(attribute);
            if (this.lossyMethod != null && this.lossyMethod.length() > 0) {
                String[] stringArray;
                Object object;
                attribute = this.get(TagFromName.LossyImageCompressionMethod);
                if (attribute == null) {
                    attribute = new CodeStringAttribute(TagFromName.LossyImageCompressionMethod);
                    this.put(attribute);
                }
                int n = 0;
                if (attribute.getVM() == 0) {
                    attribute.addValue(this.lossyMethod);
                    n = 0;
                } else {
                    object = attribute.getStringValues();
                    if (((String[])object).length > 0 && object[((String[])object).length - 1] != null && !((String)object[((Object)object).length - 1]).equals(this.lossyMethod)) {
                        n = ((Object)object).length;
                        attribute.addValue(this.lossyMethod);
                    }
                }
                object = this.get(TagFromName.LossyImageCompressionRatio);
                if (object == null) {
                    object = new DecimalStringAttribute(TagFromName.LossyImageCompressionRatio);
                    this.put((Attribute)object);
                }
                if (((Attribute)object).getVM() <= n) {
                    while (--n > 0) {
                        ((Attribute)object).addValue("");
                    }
                    if (this.compressionRatio > 0.0) {
                        ((Attribute)object).addValue(this.compressionRatio);
                    } else {
                        ((Attribute)object).addValue("");
                    }
                } else if (((Attribute)object).getVM() == n + 1 && ((stringArray = ((Attribute)object).getStringValues())[n].length() == 0 || stringArray[n].equals("0")) && this.compressionRatio > 0.0) {
                    ((Attribute)object).setValue(Double.toString(this.compressionRatio));
                }
            }
        }
    }

    public void insertLossyImageCompressionHistoryIfDecompressed() throws DicomException {
        this.insertLossyImageCompressionHistoryIfDecompressed(false);
    }

    public String getDecompressedPhotometricInterpretation() throws DicomException {
        String string = Attribute.getSingleStringValueOrEmptyString(this, TagFromName.PhotometricInterpretation);
        return this.getDecompressedPhotometricInterpretation(string);
    }

    public String getDecompressedPhotometricInterpretation(String string) {
        if (this.colorSpaceWillBeConvertedToRGBDuringDecompression && (string.equals("YBR_FULL_422") || string.equals("YBR_FULL") || string.equals("YBR_PARTIAL_422") || string.equals("YBR_PARTIAL_420") || string.equals("YBR_RCT") || string.equals("YBR_ICT"))) {
            string = "RGB";
        }
        return string;
    }

    public void correctDecompressedImagePixelModule(boolean bl) throws DicomException {
        Object object;
        if (Attribute.getSingleIntegerValueOrDefault(this, TagFromName.SamplesPerPixel, 0) > 1) {
            Object object2;
            Object object3;
            if ((this.pixelDataWasActuallyDecompressed && this.colorSpaceWasConvertedToRGBDuringDecompression || bl && this.colorSpaceWillBeConvertedToRGBDuringDecompression) && !((String)(object3 = Attribute.getSingleStringValueOrEmptyString(this, TagFromName.PhotometricInterpretation))).equals(object2 = this.getDecompressedPhotometricInterpretation((String)object3))) {
                slf4jlogger.debug("correctDecompressedImagePixelModule(): changing PhotometricInterpretation from {} to RGB", object3);
                object = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
                ((Attribute)object).addValue((String)object2);
                this.put((Attribute)object);
            }
            if ((this.pixelDataWasActuallyDecompressed || bl) && this.isJPEGFamily) {
                slf4jlogger.debug("correctDecompressedImagePixelModule(): setting PlanarConfiguration to 0 (was {})", Attribute.getSingleStringValueOrEmptyString(this, TagFromName.PlanarConfiguration));
                object3 = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
                ((Attribute)object3).addValue(0);
                this.put((Attribute)object3);
            }
        }
        for (Object object2 : this.values()) {
            if (object2 == null || !(object2 instanceof SequenceAttribute)) continue;
            object = ((SequenceAttribute)object2).iterator();
            while (object.hasNext()) {
                AttributeList attributeList;
                SequenceItem sequenceItem = object.next();
                if (sequenceItem == null || (attributeList = sequenceItem.getAttributeList()) == null) continue;
                attributeList.correctDecompressedImagePixelModule(bl);
            }
        }
    }

    public void correctDecompressedImagePixelModule() throws DicomException {
        this.correctDecompressedImagePixelModule(false);
    }

    public String buildInstanceTitleFromAttributeList() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.PatientName));
        stringBuffer.append("[");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.PatientID));
        stringBuffer.append("]");
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.StudyID));
        stringBuffer.append("[");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.StudyDate));
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.StudyDescription));
        stringBuffer.append("]");
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.SeriesNumber));
        stringBuffer.append("[");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.Modality));
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.SeriesDescription));
        stringBuffer.append("]");
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.InstanceNumber));
        stringBuffer.append(":");
        return stringBuffer.toString();
    }

    public static String buildInstanceTitleFromAttributeList(AttributeList attributeList) {
        return attributeList == null ? "" : attributeList.buildInstanceTitleFromAttributeList();
    }

    public static Set<String> findAllNestedReferencedSOPInstanceUIDs(AttributeList attributeList, Set<String> set) {
        if (set == null) {
            set = new HashSet<String>();
        }
        for (Attribute attribute : attributeList.values()) {
            if (attribute == null || !(attribute instanceof SequenceAttribute)) continue;
            Iterator<SequenceItem> iterator = ((SequenceAttribute)attribute).iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList2;
                SequenceItem sequenceItem = iterator.next();
                if (sequenceItem == null || (attributeList2 = sequenceItem.getAttributeList()) == null) continue;
                for (Attribute attribute2 : attributeList2.values()) {
                    String string;
                    if (attribute2 == null || !attribute2.getTag().equals(TagFromName.ReferencedSOPInstanceUID) || (string = attribute2.getSingleStringValueOrEmptyString()).length() <= 0) continue;
                    set.add(string);
                }
                AttributeList.findAllNestedReferencedSOPInstanceUIDs(attributeList2, set);
            }
        }
        return set;
    }

    public static Set<String> findAllNestedReferencedSOPInstanceUIDs(AttributeList attributeList) {
        return AttributeList.findAllNestedReferencedSOPInstanceUIDs(attributeList, new HashSet<String>());
    }

    public Set<String> findAllNestedReferencedSOPInstanceUIDs(Set<String> set) {
        return AttributeList.findAllNestedReferencedSOPInstanceUIDs(this, set);
    }

    public Set<String> findAllNestedReferencedSOPInstanceUIDs() {
        return this.findAllNestedReferencedSOPInstanceUIDs(new HashSet<String>());
    }

    public static AttributeList makeAttributeListFromKeywordAndValuePairs(String[] stringArray, int n, int n2) throws DicomException {
        AttributeList attributeList = new AttributeList();
        while (n2 > 0) {
            AttributeTag attributeTag = AttributeList.getDictionary().getTagFromName(stringArray[n]);
            if (attributeTag == null) {
                throw new DicomException("Keyword not in dictionary " + stringArray[n]);
            }
            attributeList.replace(attributeTag, stringArray[n + 1]);
            n += 2;
            n2 -= 2;
        }
        return attributeList;
    }

    static void test(String[] stringArray) {
        Object object;
        try {
            object = new AttributeTag(32, 13);
            try {
                Class<CodeStringAttribute> clazz = CodeStringAttribute.class;
                Class[] classArray = new Class[]{AttributeTag.class};
                Object[] objectArray = new Object[]{object};
                Attribute attribute = (Attribute)clazz.getConstructor(classArray).newInstance(objectArray);
                System.err.println("made an " + attribute);
            }
            catch (Exception exception) {
                throw new DicomException("Could not instantiate an attribute for " + object + ": " + exception);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("do it buffered, looking for metaheader, no uid specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], null, true, true);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
            if (stringArray.length > 1) {
                System.err.println("also writing it unchanged to " + stringArray[1]);
                ((AttributeList)object).write(stringArray[1], "1.2.840.10008.1.2.1", true, true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("do it unbuffered, looking for metaheader, no uid specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], null, true, false);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
        System.err.println("do it buffered, looking for metaheader, EVRLE specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], "1.2.840.10008.1.2.1", true, true);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("do it unbuffered, looking for metaheader, EVRLE specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], "1.2.840.10008.1.2.1", true, false);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("do it buffered, no metaheader, no uid specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], null, false, true);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("do it unbuffered, no metaheader, no uid specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], null, false, false);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("do it buffered, no metaheader, IVRLE specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], "1.2.840.10008.1.2", false, true);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("do it unbuffered, no metaheader, IVRLE specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], "1.2.840.10008.1.2", false, false);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 3 && stringArray[2].equals("TEST")) {
            AttributeList.test(stringArray);
        } else if (stringArray.length > 0) {
            String string = null;
            String string2 = null;
            String string3 = "1.2.840.10008.1.2.1";
            String string4 = null;
            boolean bl = true;
            if (stringArray.length == 1) {
                string2 = stringArray[0];
            } else if (stringArray.length == 2) {
                string2 = stringArray[0];
                string4 = stringArray[1];
            } else if (stringArray.length == 3) {
                string2 = stringArray[0];
                string3 = TransferSyntaxFromName.getUID(stringArray[1]);
                string4 = stringArray[2];
            } else if (stringArray.length == 4) {
                string = TransferSyntaxFromName.getUID(stringArray[0]);
                string2 = stringArray[1];
                string3 = TransferSyntaxFromName.getUID(stringArray[2]);
                string4 = stringArray[3];
            } else if (stringArray.length == 5) {
                string = TransferSyntaxFromName.getUID(stringArray[0]);
                string2 = stringArray[1];
                string3 = TransferSyntaxFromName.getUID(stringArray[2]);
                string4 = stringArray[3];
                bl = !stringArray[4].toUpperCase(Locale.US).contains("NO");
            }
            try {
                AttributeList attributeList = new AttributeList();
                long l = System.currentTimeMillis();
                attributeList.setDecompressPixelData(false);
                attributeList.read(string2, string, string == null || string.length() == 0, true);
                slf4jlogger.debug("main(): read - done in {} ms", System.currentTimeMillis() - l);
                if (string4 == null) {
                    slf4jlogger.info("Dumping ...\n{}", attributeList.toString());
                } else {
                    attributeList.removeGroupLengthAttributes();
                    attributeList.removeMetaInformationHeaderAttributes();
                    attributeList.remove(TagFromName.DataSetTrailingPadding);
                    attributeList.correctDecompressedImagePixelModule();
                    FileMetaInformation.addFileMetaInformation(attributeList, string3, "OURAETITLE");
                    long l2 = System.currentTimeMillis();
                    attributeList.write(string4, string3, bl, true);
                    slf4jlogger.debug("main(): write - done in {} ms", System.currentTimeMillis() - l);
                }
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
    }

    public static interface ReadTerminationStrategy {
        public boolean terminate(AttributeList var1, AttributeTag var2, long var3);
    }
}

