/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;

public abstract class ContentItemWithValue
extends ContentItem {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ContentItemWithValue.java,v 1.13 2025/01/29 10:58:06 dclunie Exp $";
    protected String valueType;
    protected CodedSequenceItem conceptName;
    protected String referencedContentItemIdentifier;

    private void extractContentItemWithValueCommonAttributes() {
        this.valueType = Attribute.getSingleStringValueOrNull(this.list, TagFromName.ValueType);
        this.conceptName = CodedSequenceItem.getSingleCodedSequenceItemOrNull(this.list, TagFromName.ConceptNameCodeSequence);
    }

    protected ContentItemWithValue(ContentItem contentItem, AttributeList attributeList) {
        super(contentItem, attributeList);
        this.extractContentItemWithValueCommonAttributes();
    }

    protected ContentItemWithValue(ContentItem contentItem, String string, String string2, CodedSequenceItem codedSequenceItem, String string3, String string4) throws DicomException {
        super(contentItem, string2, string3, string4);
        this.valueType = string;
        Attribute attribute = new CodeStringAttribute(TagFromName.ValueType);
        attribute.addValue(string);
        this.list.put(attribute);
        this.conceptName = codedSequenceItem;
        if (codedSequenceItem != null) {
            attribute = new SequenceAttribute(TagFromName.ConceptNameCodeSequence);
            ((SequenceAttribute)attribute).addItem(codedSequenceItem.getAttributeList());
            this.list.put(attribute);
        }
    }

    protected ContentItemWithValue(ContentItem contentItem, String string, String string2, CodedSequenceItem codedSequenceItem) throws DicomException {
        this(contentItem, string, string2, codedSequenceItem, null, null);
    }

    @Override
    public String getValueType() {
        return this.valueType;
    }

    @Override
    public String getConceptNameAndValue() {
        return this.getConceptNameCodeMeaning() + " " + this.getConceptValue();
    }

    @Override
    public abstract String getConceptValue();

    @Override
    public CodedSequenceItem getConceptName() {
        return this.conceptName;
    }

    @Override
    public String getConceptNameCodeMeaning() {
        return this.conceptName == null ? "" : this.conceptName.getCodeMeaning();
    }

    @Override
    public String getConceptNameCodeValue() {
        return this.conceptName == null ? "" : this.conceptName.getCodeValue();
    }

    @Override
    public String getConceptNameCodingSchemeDesignator() {
        return this.conceptName == null ? "" : this.conceptName.getCodingSchemeDesignator();
    }

    @Override
    public String toString() {
        return (this.relationshipType == null ? "" : this.relationshipType) + ": " + (this.valueType == null || this.valueType.length() == 0 ? "" : this.valueType + ": ") + (this.observationUID == null || this.observationUID.length() == 0 ? "" : "[" + this.observationUID + "] ") + (this.observationDateTime == null || this.observationDateTime.length() == 0 ? "" : "[" + this.observationDateTime + "] ") + (this.conceptName == null ? "" : this.conceptName.getCodeMeaning());
    }

    @Override
    public boolean contentItemNameMatchesCodeValueAndCodingSchemeDesignator(String string, String string2) {
        boolean bl = false;
        if (this.conceptName != null) {
            String string3 = this.conceptName.getCodingSchemeDesignator();
            String string4 = this.conceptName.getCodeValue();
            if (string3 != null && string3.trim().equals(string2.trim()) && string4 != null && string4.trim().equals(string.trim())) {
                bl = true;
            }
        }
        return bl;
    }
}

