/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeFactory;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomDirectoryRecord;
import com.pixelmed.dicom.DicomDirectoryRecordFactory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.NullOutputStream;
import com.pixelmed.dicom.OtherWordAttributeOnDisk;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DicomDirectory
implements TreeModel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DicomDirectory.java,v 1.51 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(OtherWordAttributeOnDisk.class);
    private DicomDirectoryRecord root;
    private Vector listeners;
    private TreeMap mapOffsetToSequenceItemAttributeList;
    private DicomDirectoryRecordFactory nodeFactory;
    protected HashMap mapOfDirectoryRecordsToSequenceItems;
    private Map<String, String> mapOfSOPInstanceUIDToReferencedFileName;

    @Override
    public Object getChild(Object object, int n) {
        return ((DicomDirectoryRecord)object).getChildAt(n);
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return ((DicomDirectoryRecord)object).getIndex((DicomDirectoryRecord)object2);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getChildCount(Object object) {
        return ((DicomDirectoryRecord)object).getChildCount();
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((DicomDirectoryRecord)object).getChildCount() == 0;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners == null) {
            this.listeners.removeElement(treeModelListener);
        }
    }

    private DicomDirectoryRecord findOrInsertNewConcatenationDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, String string, String string2) throws DicomException {
        Object object;
        Object object2;
        Object object3;
        Object object4 = null;
        int n = this.getChildCount(dicomDirectoryRecord);
        for (int i = 0; i < n; ++i) {
            object3 = (DicomDirectoryRecord)this.getChild(dicomDirectoryRecord, i);
            if (!(object3 instanceof DicomDirectoryRecordFactory.ConcatenationDirectoryRecord) || (object2 = Attribute.getSingleStringValueOrNull((AttributeList)(object = ((DicomDirectoryRecord)object3).getAttributeList()), TagFromName.ConcatenationUID)) == null || string == null || !((String)object2).equals(string)) continue;
            object4 = object3;
            break;
        }
        if (object4 == null) {
            AttributeList attributeList = new AttributeList();
            object3 = new CodeStringAttribute(TagFromName.DirectoryRecordType);
            ((Attribute)object3).addValue("CONCATENATION");
            attributeList.put(TagFromName.DirectoryRecordType, (Attribute)object3);
            object = new UniqueIdentifierAttribute(TagFromName.ConcatenationUID);
            ((Attribute)object).addValue(string);
            attributeList.put(TagFromName.ConcatenationUID, (Attribute)object);
            if (string2 != null) {
                object2 = new CodeStringAttribute(TagFromName.InstanceNumber);
                ((Attribute)object2).addValue(string2);
                attributeList.put(TagFromName.InstanceNumber, (Attribute)object2);
            }
            object4 = this.nodeFactory.getNewDicomDirectoryRecord(dicomDirectoryRecord, attributeList);
            dicomDirectoryRecord.addChild((DicomDirectoryRecord)object4);
        }
        return object4;
    }

    private void insertConcatenationNodes(DicomDirectoryRecord dicomDirectoryRecord) throws DicomException {
        int n = this.getChildCount(dicomDirectoryRecord);
        int n2 = 0;
        while (n2 < n) {
            DicomDirectoryRecord dicomDirectoryRecord2 = (DicomDirectoryRecord)this.getChild(dicomDirectoryRecord, n2);
            if (dicomDirectoryRecord instanceof DicomDirectoryRecordFactory.SeriesDirectoryRecord && dicomDirectoryRecord2 instanceof DicomDirectoryRecordFactory.ImageDirectoryRecord) {
                AttributeList attributeList = dicomDirectoryRecord2.getAttributeList();
                String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ConcatenationUID);
                if (string != null) {
                    String string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.InstanceNumber);
                    DicomDirectoryRecord dicomDirectoryRecord3 = this.findOrInsertNewConcatenationDirectoryRecord(dicomDirectoryRecord, string, string2);
                    dicomDirectoryRecord.removeChild(dicomDirectoryRecord2);
                    dicomDirectoryRecord3.addChild(dicomDirectoryRecord2);
                    n2 = 0;
                    n = this.getChildCount(dicomDirectoryRecord);
                    continue;
                }
                ++n2;
                continue;
            }
            this.insertConcatenationNodes(dicomDirectoryRecord2);
            ++n2;
        }
    }

    private DicomDirectoryRecord processSubTree(DicomDirectoryRecord dicomDirectoryRecord, long l) throws DicomException {
        AttributeList attributeList = (AttributeList)this.mapOffsetToSequenceItemAttributeList.get(new Long(l));
        DicomDirectoryRecord dicomDirectoryRecord2 = this.nodeFactory.getNewDicomDirectoryRecord(dicomDirectoryRecord, attributeList);
        long l2 = 0L;
        Attribute attribute = attributeList.get(TagFromName.OffsetOfReferencedLowerLevelDirectoryEntity);
        if (attribute != null && attribute.getVM() > 0) {
            l2 = attribute.getLongValues()[0];
        }
        if (l2 != 0L) {
            dicomDirectoryRecord2.addChild(this.processSubTree(dicomDirectoryRecord2, l2));
        }
        long l3 = 0L;
        Attribute attribute2 = attributeList.get(TagFromName.OffsetOfTheNextDirectoryRecord);
        if (attribute2 != null && attribute2.getVM() > 0) {
            l3 = attribute2.getLongValues()[0];
        }
        if (l3 != 0L) {
            dicomDirectoryRecord2.addSibling(this.processSubTree(dicomDirectoryRecord, l3));
        }
        return dicomDirectoryRecord2;
    }

    private void makeDicomDirectoryFromExistingAttributeList(AttributeList attributeList, boolean bl) throws DicomException {
        this.mapOffsetToSequenceItemAttributeList = new TreeMap();
        Attribute attribute = attributeList.get(TagFromName.DirectoryRecordSequence);
        if (attribute == null || !(attribute instanceof SequenceAttribute)) {
            throw new DicomException("Missing Directory Record Sequence in DICOMDIR or not SQ VR");
        }
        Iterator<SequenceItem> iterator = ((SequenceAttribute)attribute).iterator();
        while (iterator.hasNext()) {
            SequenceItem sequenceItem = iterator.next();
            this.mapOffsetToSequenceItemAttributeList.put(new Long(sequenceItem.getByteOffset()), sequenceItem.getAttributeList());
        }
        this.nodeFactory = new DicomDirectoryRecordFactory();
        long l = Attribute.getSingleLongValueOrDefault(attributeList, TagFromName.OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity, 0L);
        if (l == 0L) {
            throw new DicomException("Missing or invalid Root Directory First Record");
        }
        this.root = this.nodeFactory.getNewTopDirectoryRecord();
        this.root.addChild(this.processSubTree(this.root, l));
        if (bl) {
            this.insertConcatenationNodes(this.root);
        }
        this.mapOffsetToSequenceItemAttributeList = null;
        this.nodeFactory = null;
    }

    private DicomDirectoryRecord findExistingDirectoryRecordOrMakeNewOne(DicomDirectoryRecord dicomDirectoryRecord, DicomDirectoryRecord dicomDirectoryRecord2) {
        int n = dicomDirectoryRecord.getIndex(dicomDirectoryRecord2);
        if (n == -1) {
            dicomDirectoryRecord2.setParent(dicomDirectoryRecord);
            dicomDirectoryRecord.addChild(dicomDirectoryRecord2);
        } else {
            dicomDirectoryRecord2 = (DicomDirectoryRecord)dicomDirectoryRecord.getChildAt(n);
        }
        return dicomDirectoryRecord2;
    }

    private void findAttributeAndIfPresentAddToDifferentAttributeList(AttributeTag attributeTag, AttributeList attributeList, AttributeList attributeList2) {
        Attribute attribute = attributeList.get(attributeTag);
        if (attribute != null) {
            attributeList2.put(attribute);
        }
    }

    private void findAttributeAndIfPresentWithValueAddToDifferentAttributeList(AttributeTag attributeTag, AttributeList attributeList, AttributeList attributeList2) {
        Attribute attribute = attributeList.get(attributeTag);
        if (attribute != null && attribute.getVM() > 0) {
            attributeList2.put(attribute);
        }
    }

    private void findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(AttributeTag attributeTag, AttributeList attributeList, AttributeList attributeList2) throws DicomException {
        Attribute attribute = attributeList.get(attributeTag);
        if (attribute == null) {
            attribute = AttributeFactory.newAttribute(attributeTag);
        }
        attributeList2.put(attribute);
    }

    private void findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(AttributeTag attributeTag, AttributeList attributeList, AttributeList attributeList2, String string) throws DicomException {
        Attribute attribute = attributeList.get(attributeTag);
        if (attribute == null || attribute.getVM() == 0) {
            attribute = AttributeFactory.newAttribute(attributeTag);
            attribute.addValue(string);
        }
        attributeList2.put(attribute);
    }

    private void findAttributeInSharedFunctionalGroupAndIfPresentAddToDifferentAttributeList(AttributeTag attributeTag, AttributeTag attributeTag2, AttributeList attributeList, AttributeList attributeList2) {
        Attribute attribute;
        SequenceAttribute sequenceAttribute = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.SharedFunctionalGroupsSequence, attributeTag2);
        if (sequenceAttribute != null && (attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, attributeTag)) != null) {
            attributeList2.put(attribute);
        }
    }

    private void findAttributeInSharedFunctionalGroupAndIfPresentWithValueAddToDifferentAttributeList(AttributeTag attributeTag, AttributeTag attributeTag2, AttributeList attributeList, AttributeList attributeList2) {
        Attribute attribute;
        SequenceAttribute sequenceAttribute = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.SharedFunctionalGroupsSequence, attributeTag2);
        if (sequenceAttribute != null && (attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, attributeTag)) != null && attribute.getVM() > 0) {
            attributeList2.put(attribute);
        }
    }

    private void findAttributeNestedInSequenceAndIfPresentWithValueAddToDifferentAttributeList(AttributeTag attributeTag, AttributeTag attributeTag2, AttributeList attributeList, AttributeList attributeList2) {
        Attribute attribute;
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(attributeTag2);
        if (sequenceAttribute != null && (attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, attributeTag)) != null && attribute.getVM() > 0) {
            attributeList2.put(attribute);
        }
    }

    private void findAttributeNestedInSequenceAndIfPresentAddToDifferentAttributeList(AttributeTag attributeTag, AttributeTag attributeTag2, AttributeList attributeList, AttributeList attributeList2) {
        Attribute attribute;
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(attributeTag2);
        if (sequenceAttribute != null && (attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, attributeTag)) != null) {
            attributeList2.put(attribute);
        }
    }

    public void readDicomFileAndAddToDirectory(File file, String string) throws DicomException, IOException {
        AttributeList attributeList = new AttributeList();
        attributeList.setDecompressPixelData(false);
        attributeList.read(new File(file, string).getCanonicalPath(), TagFromName.PixelData);
        this.addAttributeListFromDicomFileToDirectory(attributeList, string);
    }

    public void readDicomFileAndAddToDirectory(String string) throws DicomException, IOException {
        AttributeList attributeList = new AttributeList();
        attributeList.setDecompressPixelData(false);
        attributeList.read(string, TagFromName.PixelData);
        this.addAttributeListFromDicomFileToDirectory(attributeList, string);
    }

    public void addAttributeListFromDicomFileToDirectory(AttributeList attributeList, String string) throws DicomException, IOException {
        Object object;
        Object object2 = new AttributeList();
        this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.PatientName, attributeList, (AttributeList)object2);
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.PatientID, attributeList, (AttributeList)object2, "000000");
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.PatientBirthDate, attributeList, (AttributeList)object2);
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.PatientSex, attributeList, (AttributeList)object2);
        Object object3 = TagFromName.DirectoryRecordType;
        Object object4 = new CodeStringAttribute((AttributeTag)object3);
        ((Attribute)object4).addValue("PATIENT");
        ((AttributeList)object2).put((AttributeTag)object3, (Attribute)object4);
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.SpecificCharacterSet, attributeList, (AttributeList)object2);
        object3 = TagFromName.OffsetOfTheNextDirectoryRecord;
        object4 = new UnsignedLongAttribute((AttributeTag)object3);
        ((Attribute)object4).addValue(0);
        ((AttributeList)object2).put((AttributeTag)object3, (Attribute)object4);
        object3 = TagFromName.OffsetOfReferencedLowerLevelDirectoryEntity;
        object4 = new UnsignedLongAttribute((AttributeTag)object3);
        ((Attribute)object4).addValue(0);
        ((AttributeList)object2).put((AttributeTag)object3, (Attribute)object4);
        object3 = TagFromName.RecordInUseFlag;
        object4 = new UnsignedShortAttribute((AttributeTag)object3);
        ((Attribute)object4).addValue(65535);
        ((AttributeList)object2).put((AttributeTag)object3, (Attribute)object4);
        DicomDirectoryRecordFactory.PatientDirectoryRecord patientDirectoryRecord = this.nodeFactory.getNewPatientDirectoryRecord(null, (AttributeList)object2);
        patientDirectoryRecord = (DicomDirectoryRecordFactory.PatientDirectoryRecord)this.findExistingDirectoryRecordOrMakeNewOne(this.root, patientDirectoryRecord);
        object3 = new AttributeList();
        this.findAttributeAndIfPresentAddToDifferentAttributeList(TagFromName.StudyInstanceUID, attributeList, (AttributeList)object3);
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.StudyID, attributeList, (AttributeList)object3, "000000");
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.StudyDate, attributeList, (AttributeList)object3, "19000101");
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.StudyTime, attributeList, (AttributeList)object3, "000000");
        this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.StudyDescription, attributeList, (AttributeList)object3);
        this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.AccessionNumber, attributeList, (AttributeList)object3);
        object4 = TagFromName.DirectoryRecordType;
        Object object5 = new CodeStringAttribute((AttributeTag)object4);
        ((Attribute)object5).addValue("STUDY");
        ((AttributeList)object3).put((AttributeTag)object4, (Attribute)object5);
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.SpecificCharacterSet, attributeList, (AttributeList)object3);
        object4 = TagFromName.OffsetOfTheNextDirectoryRecord;
        object5 = new UnsignedLongAttribute((AttributeTag)object4);
        ((Attribute)object5).addValue(0);
        ((AttributeList)object3).put((AttributeTag)object4, (Attribute)object5);
        object4 = TagFromName.OffsetOfReferencedLowerLevelDirectoryEntity;
        object5 = new UnsignedLongAttribute((AttributeTag)object4);
        ((Attribute)object5).addValue(0);
        ((AttributeList)object3).put((AttributeTag)object4, (Attribute)object5);
        object4 = TagFromName.RecordInUseFlag;
        object5 = new UnsignedShortAttribute((AttributeTag)object4);
        ((Attribute)object5).addValue(65535);
        ((AttributeList)object3).put((AttributeTag)object4, (Attribute)object5);
        object2 = this.nodeFactory.getNewStudyDirectoryRecord(null, (AttributeList)object3);
        object2 = (DicomDirectoryRecordFactory.StudyDirectoryRecord)this.findExistingDirectoryRecordOrMakeNewOne(patientDirectoryRecord, (DicomDirectoryRecord)object2);
        object4 = new AttributeList();
        this.findAttributeAndIfPresentAddToDifferentAttributeList(TagFromName.SeriesInstanceUID, attributeList, (AttributeList)object4);
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.Modality, attributeList, (AttributeList)object4, "OT");
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.SeriesNumber, attributeList, (AttributeList)object4, "0");
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.SeriesDate, attributeList, (AttributeList)object4);
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.SeriesTime, attributeList, (AttributeList)object4);
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.SeriesDescription, attributeList, (AttributeList)object4);
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.InstitutionName, attributeList, (AttributeList)object4);
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.InstitutionAddress, attributeList, (AttributeList)object4);
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.PerformingPhysicianName, attributeList, (AttributeList)object4);
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.BodyPartExamined, attributeList, (AttributeList)object4);
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.Laterality, attributeList, (AttributeList)object4);
        object5 = TagFromName.DirectoryRecordType;
        Object object6 = new CodeStringAttribute((AttributeTag)object5);
        ((Attribute)object6).addValue("SERIES");
        ((AttributeList)object4).put((AttributeTag)object5, (Attribute)object6);
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.SpecificCharacterSet, attributeList, (AttributeList)object4);
        object5 = TagFromName.OffsetOfTheNextDirectoryRecord;
        object6 = new UnsignedLongAttribute((AttributeTag)object5);
        ((Attribute)object6).addValue(0);
        ((AttributeList)object4).put((AttributeTag)object5, (Attribute)object6);
        object5 = TagFromName.OffsetOfReferencedLowerLevelDirectoryEntity;
        object6 = new UnsignedLongAttribute((AttributeTag)object5);
        ((Attribute)object6).addValue(0);
        ((AttributeList)object4).put((AttributeTag)object5, (Attribute)object6);
        object5 = TagFromName.RecordInUseFlag;
        object6 = new UnsignedShortAttribute((AttributeTag)object5);
        ((Attribute)object6).addValue(65535);
        ((AttributeList)object4).put((AttributeTag)object5, (Attribute)object6);
        object3 = this.nodeFactory.getNewSeriesDirectoryRecord(null, (AttributeList)object4);
        object3 = (DicomDirectoryRecordFactory.SeriesDirectoryRecord)this.findExistingDirectoryRecordOrMakeNewOne((DicomDirectoryRecord)object2, (DicomDirectoryRecord)object3);
        object4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        object5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
        object6 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
        AttributeList attributeList2 = new AttributeList();
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.InstanceNumber, attributeList, attributeList2, "0");
        String string2 = "";
        if (SOPClass.isImageStorage((String)object4)) {
            string2 = "IMAGE";
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.ContentDate, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.ContentTime, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.ImageComments, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.PhotometricInterpretation, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.AcquisitionDate, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.AcquisitionTime, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.VolumetricProperties, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.VolumeBasedCalculationTechnique, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.ComplexImageComponent, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.AcquisitionContrast, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.PixelPresentation, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.ConcatenationUID, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.ConcatenationFrameOffsetNumber, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.InConcatenationNumber, attributeList, attributeList2);
            this.findAttributeInSharedFunctionalGroupAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.PixelSpacing, TagFromName.PixelMeasuresSequence, attributeList, attributeList2);
            this.findAttributeInSharedFunctionalGroupAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.ImagePositionPatient, TagFromName.PlanePositionSequence, attributeList, attributeList2);
            this.findAttributeInSharedFunctionalGroupAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.ImageOrientationPatient, TagFromName.PlaneOrientationSequence, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.ImageType, attributeList, attributeList2, "UNKNOWN");
            this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.CalibrationImage, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.ReferencedImageSequence, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.ImagePositionPatient, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.ImageOrientationPatient, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.FrameOfReferenceUID, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.PixelSpacing, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.TableHeight, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.Rows, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.Columns, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.LossyImageCompressionRatio, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.SynchronizationFrameOfReferenceUID, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.NumberOfFrames, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.AcquisitionTimeSynchronized, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.AcquisitionDateTime, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.DimensionOrganizationType, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.TotalPixelMatrixRows, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.TotalPixelMatrixColumns, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.ImageOrientationSlide, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.ContainerIdentifier, attributeList, attributeList2);
            this.findAttributeNestedInSequenceAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.SpecimenIdentifier, TagFromName.SpecimenDescriptionSequence, attributeList, attributeList2);
            this.findAttributeNestedInSequenceAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.SpecimenShortDescription, TagFromName.SpecimenDescriptionSequence, attributeList, attributeList2);
            this.findAttributeNestedInSequenceAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.SpecimenDetailedDescription, TagFromName.SpecimenDescriptionSequence, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeList(TagFromName.AnatomicRegionSequence, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.ImageLaterality, attributeList, attributeList2);
            this.findAttributeInSharedFunctionalGroupAndIfPresentAddToDifferentAttributeList(TagFromName.AnatomicRegionSequence, TagFromName.FrameAnatomySequence, attributeList, attributeList2);
            this.findAttributeInSharedFunctionalGroupAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.FrameLaterality, TagFromName.FrameAnatomySequence, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeList(TagFromName.PrimaryAnatomicStructureSequence, attributeList, attributeList2);
            this.findAttributeNestedInSequenceAndIfPresentAddToDifferentAttributeList(TagFromName.PrimaryAnatomicStructureSequence, TagFromName.SpecimenDescriptionSequence, attributeList, attributeList2);
        } else if (SOPClass.isSpectroscopy((String)object4)) {
            string2 = "SPECTROSCOPY";
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.ImageType, attributeList, attributeList2, "UNKNOWN");
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.ContentDate, attributeList, attributeList2, "19000101");
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.ContentTime, attributeList, attributeList2, "000000");
            this.findAttributeAndIfPresentAddToDifferentAttributeList(TagFromName.ReferencedImageEvidenceSequence, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.NumberOfFrames, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.Rows, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.Columns, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.DataPointRows, attributeList, attributeList2);
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.DataPointColumns, attributeList, attributeList2);
        } else if (SOPClass.isRawData((String)object4)) {
            string2 = "RAW DATA";
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.ContentDate, attributeList, attributeList2, "19000101");
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.ContentTime, attributeList, attributeList2, "000000");
        } else if (SOPClass.isStructuredReport((String)object4)) {
            if (SOPClass.isKeyObjectSelectionDocument((String)object4)) {
                string2 = "KEY OBJECT DOC";
            } else {
                string2 = "SR DOCUMENT";
                this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.CompletionFlag, attributeList, attributeList2, "PARTIAL");
                this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.VerificationFlag, attributeList, attributeList2, "UNVERIFIED");
            }
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.ContentDate, attributeList, attributeList2, "19000101");
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.ContentTime, attributeList, attributeList2, "000000");
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.VerificationDateTime, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeList(TagFromName.ConceptNameCodeSequence, attributeList, attributeList2);
        } else if (SOPClass.isEncapsulatedDocument((String)object4)) {
            string2 = "ENCAP DOC";
            this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.ContentDate, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.ContentTime, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.DocumentTitle, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeList(TagFromName.HL7InstanceIdentifier, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeList(TagFromName.ConceptNameCodeSequence, attributeList, attributeList2);
            object = ((String)object4).equals("1.2.840.10008.5.1.4.1.1.104.1") ? "application/pdf" : (((String)object4).equals("1.2.840.10008.5.1.4.1.1.104.2") ? "text/XML" : "application/octet-stream");
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.MIMETypeOfEncapsulatedDocument, attributeList, attributeList2, (String)object);
        } else if (SOPClass.isPresentationState((String)object4)) {
            string2 = "PRESENTATION";
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.PresentationCreationDate, attributeList, attributeList2, "19000101");
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.PresentationCreationTime, attributeList, attributeList2, "000000");
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.ContentLabel, attributeList, attributeList2, "NONE");
            this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.ContentDescription, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.ContentCreatorName, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeList(TagFromName.ContentCreatorIdentificationCodeSequence, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeList(TagFromName.ReferencedSeriesSequence, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeList(TagFromName.BlendingSequence, attributeList, attributeList2);
        } else if (((String)object4).equals("1.2.840.10008.5.1.4.1.1.66.1") || ((String)object4).equals("1.2.840.10008.5.1.4.1.1.66.3") || ((String)object4).equals("1.2.840.10008.5.1.4.1.1.66.2") || ((String)object4).equals("1.2.840.10008.5.1.4.1.1.67")) {
            string2 = ((String)object4).equals("1.2.840.10008.5.1.4.1.1.66.2") ? "FIDUCIAL" : (((String)object4).equals("1.2.840.10008.5.1.4.1.1.67") ? "VALUE MAP" : "REGISTRATION");
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.ContentDate, attributeList, attributeList2, "19000101");
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.ContentTime, attributeList, attributeList2, "000000");
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.ContentLabel, attributeList, attributeList2, "NONE");
            this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.ContentDescription, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.ContentCreatorName, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeList(TagFromName.ContentCreatorIdentificationCodeSequence, attributeList, attributeList2);
        } else if (((String)object4).equals("1.2.840.10008.5.1.4.1.1.77.1.5.3")) {
            string2 = "STEREOMETRIC";
        } else if (((String)object4).equals("1.2.840.10008.5.1.4.1.1.481.2")) {
            string2 = "RT DOSE";
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.DoseSummationType, attributeList, attributeList2, "UNKNOWN");
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.DoseComment, attributeList, attributeList2);
        } else if (((String)object4).equals("1.2.840.10008.5.1.4.1.1.481.3")) {
            string2 = "RT STRUCTURE SET";
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.StructureSetLabel, attributeList, attributeList2, "NONE");
            this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.StructureSetDate, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.StructureSetTime, attributeList, attributeList2);
        } else if (((String)object4).equals("1.2.840.10008.5.1.4.1.1.481.5") || ((String)object4).equals("1.2.840.10008.5.1.4.1.1.481.8")) {
            string2 = "RT PLAN";
            this.findAttributeAndIfPresentWithValueAddToDifferentAttributeListElseAddDefault(TagFromName.RTPlanLabel, attributeList, attributeList2, "NONE");
            this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.RTPlanDate, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.RTPlanTime, attributeList, attributeList2);
        } else if (((String)object4).equals("1.2.840.10008.5.1.4.1.1.481.4") || ((String)object4).equals("1.2.840.10008.5.1.4.1.1.481.9") || ((String)object4).equals("1.2.840.10008.5.1.4.1.1.481.6") || ((String)object4).equals("1.2.840.10008.5.1.4.1.1.481.7")) {
            string2 = "RT TREAT RECORD";
            this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.TreatmentDate, attributeList, attributeList2);
            this.findAttributeAndIfPresentAddToDifferentAttributeListElseAddEmpty(TagFromName.TreatmentTime, attributeList, attributeList2);
        }
        object = TagFromName.DirectoryRecordType;
        Attribute attribute = new CodeStringAttribute((AttributeTag)object);
        attribute.addValue(string2);
        attributeList2.put((AttributeTag)object, attribute);
        object = TagFromName.ReferencedSOPClassUIDInFile;
        attribute = new UniqueIdentifierAttribute((AttributeTag)object);
        attribute.addValue((String)object4);
        attributeList2.put((AttributeTag)object, attribute);
        object = TagFromName.ReferencedSOPInstanceUIDInFile;
        attribute = new UniqueIdentifierAttribute((AttributeTag)object);
        attribute.addValue((String)object5);
        attributeList2.put((AttributeTag)object, attribute);
        object = TagFromName.ReferencedTransferSyntaxUIDInFile;
        attribute = new UniqueIdentifierAttribute((AttributeTag)object);
        attribute.addValue((String)object6);
        attributeList2.put((AttributeTag)object, attribute);
        object = TagFromName.ReferencedFileID;
        attribute = new CodeStringAttribute((AttributeTag)object);
        Object object7 = new StringTokenizer(new File(string).getPath().toUpperCase(Locale.US), File.separator);
        while (((StringTokenizer)object7).hasMoreTokens()) {
            attribute.addValue(((StringTokenizer)object7).nextToken());
        }
        attributeList2.put((AttributeTag)object, attribute);
        this.findAttributeAndIfPresentWithValueAddToDifferentAttributeList(TagFromName.SpecificCharacterSet, attributeList, attributeList2);
        object = TagFromName.OffsetOfTheNextDirectoryRecord;
        attribute = new UnsignedLongAttribute((AttributeTag)object);
        attribute.addValue(0);
        attributeList2.put((AttributeTag)object, attribute);
        object = TagFromName.OffsetOfReferencedLowerLevelDirectoryEntity;
        attribute = new UnsignedLongAttribute((AttributeTag)object);
        attribute.addValue(0);
        attributeList2.put((AttributeTag)object, attribute);
        object = TagFromName.RecordInUseFlag;
        attribute = new UnsignedShortAttribute((AttributeTag)object);
        attribute.addValue(65535);
        attributeList2.put((AttributeTag)object, attribute);
        object = null;
        if (string2.equals("IMAGE")) {
            object = this.nodeFactory.getNewImageDirectoryRecord(null, attributeList2);
        } else if (string2.equals("SPECTROSCOPY")) {
            object = this.nodeFactory.getNewSpectroscopyDirectoryRecord(null, attributeList2);
        } else if (string2.equals("RAW DATA")) {
            object = this.nodeFactory.getNewRawDataDirectoryRecord(null, attributeList2);
        } else if (string2.equals("WAVEFORM")) {
            object = this.nodeFactory.getNewWaveformDirectoryRecord(null, attributeList2);
        } else if (string2.equals("KEY OBJECT DOC")) {
            object = this.nodeFactory.getNewKODocumentDirectoryRecord(null, attributeList2);
        } else if (string2.equals("SR DOCUMENT")) {
            object = this.nodeFactory.getNewSRDocumentDirectoryRecord(null, attributeList2);
        } else if (string2.equals("PRESENTATION")) {
            object = this.nodeFactory.getNewPresentationStateDirectoryRecord(null, attributeList2);
        } else if (string2.equals("REGISTRATION")) {
            object = this.nodeFactory.getNewRegistrationDirectoryRecord(null, attributeList2);
        } else if (string2.equals("FIDUCIAL")) {
            object = this.nodeFactory.getNewFiducialDirectoryRecord(null, attributeList2);
        } else if (string2.equals("VALUE MAP")) {
            object = this.nodeFactory.getNewRealWorldValueMappingDirectoryRecord(null, attributeList2);
        } else if (string2.equals("STEREOMETRIC")) {
            object = this.nodeFactory.getNewStereometricRelationshipDirectoryRecord(null, attributeList2);
        } else if (string2.equals("ENCAP DOC")) {
            object = this.nodeFactory.getNewEncapsulatedDocumentDirectoryRecord(null, attributeList2);
        } else if (string2.equals("RT DOSE")) {
            object = this.nodeFactory.getNewRTDoseDirectoryRecord(null, attributeList2);
        } else if (string2.equals("RT STRUCTURE SET")) {
            object = this.nodeFactory.getNewRTStructureSetDirectoryRecord(null, attributeList2);
        } else if (string2.equals("RT PLAN")) {
            object = this.nodeFactory.getNewRTPlanDirectoryRecord(null, attributeList2);
        } else if (string2.equals("RT TREAT RECORD")) {
            object = this.nodeFactory.getNewRTTreatmentRecordDirectoryRecord(null, attributeList2);
        }
        if (object != null) {
            int n = ((DicomDirectoryRecord)object3).getIndex((TreeNode)object);
            if (n != -1) {
                object7 = (DicomDirectoryRecord)((DicomDirectoryRecord)object3).getChildAt(n);
                AttributeList attributeList3 = object7 == null ? null : ((DicomDirectoryRecord)object7).getAttributeList();
                String string3 = attributeList3 == null ? "-unknown-" : Attribute.getDelimitedStringValuesOrDefault(attributeList3, TagFromName.ReferencedFileID, "-unknown-");
                throw new DicomException("Instance already exists within series for UID " + (String)object5 + " from file " + string3 + " - not adding file " + string);
            }
        } else {
            throw new DicomException("Unrecognized SOP Class " + (String)object4 + " - cannot create directory record - not adding file " + string);
        }
        ((DicomDirectoryRecord)object).setParent((DicomDirectoryRecord)object3);
        ((DicomDirectoryRecord)object3).addChild((DicomDirectoryRecord)object);
    }

    public DicomDirectory(String[] stringArray) {
        this.mapOfDirectoryRecordsToSequenceItems = new HashMap();
        this.nodeFactory = new DicomDirectoryRecordFactory();
        this.root = this.nodeFactory.getNewTopDirectoryRecord();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                this.readDicomFileAndAddToDirectory(string);
                continue;
            }
            catch (Exception exception) {
                slf4jlogger.error("While reading file \"{}\"", string, exception);
            }
        }
    }

    public DicomDirectory(File file, String[] stringArray) {
        this.mapOfDirectoryRecordsToSequenceItems = new HashMap();
        this.nodeFactory = new DicomDirectoryRecordFactory();
        this.root = this.nodeFactory.getNewTopDirectoryRecord();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                this.readDicomFileAndAddToDirectory(file, string);
                continue;
            }
            catch (Exception exception) {
                slf4jlogger.error("While reading file \"{}\"", string, exception);
            }
        }
    }

    public DicomDirectory() {
        this.mapOfDirectoryRecordsToSequenceItems = new HashMap();
        this.nodeFactory = new DicomDirectoryRecordFactory();
        this.root = this.nodeFactory.getNewTopDirectoryRecord();
    }

    public DicomDirectory(AttributeList attributeList) throws DicomException {
        this.makeDicomDirectoryFromExistingAttributeList(attributeList, true);
    }

    public DicomDirectory(AttributeList attributeList, boolean bl) throws DicomException {
        this.makeDicomDirectoryFromExistingAttributeList(attributeList, bl);
    }

    private void walkTreeToBuildAttributeList(SequenceAttribute sequenceAttribute, DicomDirectoryRecord dicomDirectoryRecord) {
        AttributeList attributeList = dicomDirectoryRecord.getAttributeList();
        if (attributeList != null) {
            SequenceItem sequenceItem = new SequenceItem(attributeList);
            sequenceAttribute.addItem(sequenceItem);
            this.mapOfDirectoryRecordsToSequenceItems.put(dicomDirectoryRecord, sequenceItem);
        }
        int n = this.getChildCount(dicomDirectoryRecord);
        for (int i = 0; i < n; ++i) {
            this.walkTreeToBuildAttributeList(sequenceAttribute, (DicomDirectoryRecord)this.getChild(dicomDirectoryRecord, i));
        }
    }

    private AttributeList walkTreeToBuildAttributeList() throws DicomException {
        AttributeList attributeList = new AttributeList();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.3.10", new UIDGenerator().getAnotherNewUID(), "1.2.840.10008.1.2.1", null);
        Object object = TagFromName.OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity;
        Attribute attribute = new UnsignedLongAttribute((AttributeTag)object);
        attribute.addValue(0);
        attributeList.put((AttributeTag)object, attribute);
        object = TagFromName.OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity;
        attribute = new UnsignedLongAttribute((AttributeTag)object);
        attribute.addValue(0);
        attributeList.put((AttributeTag)object, attribute);
        object = TagFromName.FileSetConsistencyFlag;
        attribute = new UnsignedShortAttribute((AttributeTag)object);
        attribute.addValue(0);
        attributeList.put((AttributeTag)object, attribute);
        object = TagFromName.FileSetID;
        attribute = new CodeStringAttribute((AttributeTag)object);
        attributeList.put((AttributeTag)object, attribute);
        object = new SequenceAttribute(TagFromName.DirectoryRecordSequence);
        attributeList.put((Attribute)object);
        this.walkTreeToBuildAttributeList((SequenceAttribute)object, this.root);
        return attributeList;
    }

    private void walkTreeToFixUpOffsetsInAttributeList(SequenceAttribute sequenceAttribute, DicomDirectoryRecord dicomDirectoryRecord) throws DicomException {
        int n = this.getChildCount(dicomDirectoryRecord);
        DicomDirectoryRecord dicomDirectoryRecord2 = null;
        for (int i = 0; i < n; ++i) {
            DicomDirectoryRecord dicomDirectoryRecord3 = (DicomDirectoryRecord)this.getChild(dicomDirectoryRecord, i);
            if (dicomDirectoryRecord2 == null) {
                AttributeList attributeList = dicomDirectoryRecord.getAttributeList();
                if (attributeList != null) {
                    attributeList.get(TagFromName.OffsetOfReferencedLowerLevelDirectoryEntity).setValue(((SequenceItem)this.mapOfDirectoryRecordsToSequenceItems.get(dicomDirectoryRecord3)).getByteOffset());
                }
            } else {
                dicomDirectoryRecord2.getAttributeList().get(TagFromName.OffsetOfTheNextDirectoryRecord).setValue(((SequenceItem)this.mapOfDirectoryRecordsToSequenceItems.get(dicomDirectoryRecord3)).getByteOffset());
            }
            this.walkTreeToFixUpOffsetsInAttributeList(sequenceAttribute, dicomDirectoryRecord3);
            dicomDirectoryRecord2 = dicomDirectoryRecord3;
        }
    }

    private void walkTreeToFixUpOffsetsInAttributeList(AttributeList attributeList) throws DicomException {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.DirectoryRecordSequence);
        attributeList.get(TagFromName.OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity).setValue(sequenceAttribute.getItem(0).getByteOffset());
        attributeList.get(TagFromName.OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity).setValue(sequenceAttribute.getItem(sequenceAttribute.getNumberOfItems() - 1).getByteOffset());
        this.walkTreeToFixUpOffsetsInAttributeList(sequenceAttribute, this.root);
    }

    public void write(String string) throws IOException, DicomException {
        AttributeList attributeList = this.walkTreeToBuildAttributeList();
        attributeList.write(new NullOutputStream(), "1.2.840.10008.1.2.1", true, true, true);
        this.walkTreeToFixUpOffsetsInAttributeList(attributeList);
        attributeList.write(string, "1.2.840.10008.1.2.1", true, true);
    }

    private String walkTreeToString(DicomDirectoryRecord dicomDirectoryRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(dicomDirectoryRecord.toString());
        stringBuffer.append("\n");
        int n = this.getChildCount(dicomDirectoryRecord);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.walkTreeToString((DicomDirectoryRecord)this.getChild(dicomDirectoryRecord, i)));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.walkTreeToString(this.root);
    }

    private void addToMapOfSOPInstanceUIDToReferencedFileName(DicomDirectoryRecord dicomDirectoryRecord, String string) {
        Object object;
        String string2 = null;
        AttributeList attributeList = dicomDirectoryRecord.getAttributeList();
        if (attributeList != null) {
            try {
                String[] stringArray;
                object = attributeList.get(TagFromName.ReferencedFileID);
                if (object != null && (stringArray = ((Attribute)object).getStringValues()) != null && stringArray.length > 0) {
                    string2 = DicomDirectory.buildPathFromParentAndStringArray(string, stringArray);
                }
            }
            catch (DicomException dicomException) {
                // empty catch block
            }
        }
        object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ReferencedSOPInstanceUIDInFile);
        if (string2 != null && object != null) {
            this.mapOfSOPInstanceUIDToReferencedFileName.put((String)object, string2);
        }
        int n = this.getChildCount(dicomDirectoryRecord);
        for (int i = 0; i < n; ++i) {
            this.addToMapOfSOPInstanceUIDToReferencedFileName((DicomDirectoryRecord)this.getChild(dicomDirectoryRecord, i), string);
        }
    }

    public Map<String, String> getMapOfSOPInstanceUIDToReferencedFileName(String string) {
        if (this.mapOfSOPInstanceUIDToReferencedFileName == null) {
            this.mapOfSOPInstanceUIDToReferencedFileName = new HashMap<String, String>();
            this.addToMapOfSOPInstanceUIDToReferencedFileName(this.root, string);
        }
        return this.mapOfSOPInstanceUIDToReferencedFileName;
    }

    public String getReferencedFileNameForSOPInstanceUID(String string) throws DicomException {
        if (this.mapOfSOPInstanceUIDToReferencedFileName == null) {
            throw new DicomException("Map of SOPInstanceUID to ReferencedFileName has not been initialized");
        }
        return this.mapOfSOPInstanceUIDToReferencedFileName.get(string);
    }

    private static String buildPathFromParentAndStringArray(String string, String[] stringArray) throws DicomException {
        File file;
        File file2 = file = string == null ? null : new File(string);
        if (stringArray == null) {
            throw new DicomException("No components in Referenced File ID");
        }
        if (stringArray.length == 0) {
            throw new DicomException("No components in Referenced File ID");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null || string2.length() == 0) {
                throw new DicomException("Empty component in Referenced File ID");
            }
            file = file == null ? new File(string2) : new File(file, string2);
        }
        return file.getPath();
    }

    private static String getReferencedFileName(DicomDirectoryRecord dicomDirectoryRecord, String string) {
        String string2 = null;
        AttributeList attributeList = dicomDirectoryRecord.getAttributeList();
        if (attributeList != null) {
            try {
                Attribute attribute = attributeList.get(TagFromName.ReferencedFileID);
                if (attribute != null) {
                    String[] stringArray = attribute.getStringValues();
                    string2 = DicomDirectory.buildPathFromParentAndStringArray(string, stringArray);
                }
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
            }
        }
        return string2;
    }

    public static HashMap<String, DicomDirectoryRecord> findAllContainedReferencedFileNamesAndTheirRecords(DicomDirectoryRecord dicomDirectoryRecord, String string) {
        HashMap<String, DicomDirectoryRecord> hashMap = new HashMap<String, DicomDirectoryRecord>();
        String string2 = DicomDirectory.getReferencedFileName(dicomDirectoryRecord, string);
        if (string2 != null && string2.length() > 0) {
            hashMap.put(string2, dicomDirectoryRecord);
        }
        int n = dicomDirectoryRecord.getChildCount();
        for (int i = 0; i < n; ++i) {
            DicomDirectoryRecord dicomDirectoryRecord2 = (DicomDirectoryRecord)dicomDirectoryRecord.getChildAt(i);
            hashMap.putAll(DicomDirectory.findAllContainedReferencedFileNamesAndTheirRecords(dicomDirectoryRecord2, string));
        }
        return hashMap;
    }

    public HashMap<String, DicomDirectoryRecord> findAllContainedReferencedFileNamesAndTheirRecords(String string) {
        return DicomDirectory.findAllContainedReferencedFileNamesAndTheirRecords((DicomDirectoryRecord)this.getRoot(), string);
    }

    public static Vector<String> findAllContainedReferencedFileNames(DicomDirectoryRecord dicomDirectoryRecord, String string) {
        Vector<String> vector = new Vector<String>();
        HashMap<String, DicomDirectoryRecord> hashMap = DicomDirectory.findAllContainedReferencedFileNamesAndTheirRecords(dicomDirectoryRecord, string);
        vector.addAll(hashMap.keySet());
        return vector;
    }

    public Vector<String> findAllContainedReferencedFileNames(String string) {
        return DicomDirectory.findAllContainedReferencedFileNames((DicomDirectoryRecord)this.getRoot(), string);
    }

    private static void findAllImagesForFrameOfReference(DicomDirectoryRecord dicomDirectoryRecord, Vector<AttributeList> vector, String string) {
        if (dicomDirectoryRecord != null) {
            AttributeList attributeList = dicomDirectoryRecord.getAttributeList();
            if (attributeList != null && Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.DirectoryRecordType).equals("IMAGE") && Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.FrameOfReferenceUID).equals(string)) {
                vector.add(attributeList);
            }
            int n = dicomDirectoryRecord.getChildCount();
            for (int i = 0; i < n; ++i) {
                DicomDirectory.findAllImagesForFrameOfReference((DicomDirectoryRecord)dicomDirectoryRecord.getChildAt(i), vector, string);
            }
        }
    }

    public Vector<AttributeList> findAllImagesForFrameOfReference(String string) {
        Vector<AttributeList> vector = new Vector<AttributeList>();
        DicomDirectory.findAllImagesForFrameOfReference((DicomDirectoryRecord)this.getRoot(), vector, string);
        return vector;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 2) {
            try {
                String[] stringArray2;
                Object object;
                String string;
                int n;
                File file = new File(stringArray[0]);
                if (file.isDirectory()) {
                    n = 2;
                    string = new File(file, stringArray[1]).getCanonicalPath();
                } else {
                    file = null;
                    n = 1;
                    string = stringArray[0];
                }
                int n2 = stringArray.length - n;
                if (n2 == 0 && file != null && file.isDirectory()) {
                    object = FileUtilities.listFilesRecursively(file);
                    n2 = ((ArrayList)object).size();
                    stringArray2 = new String[n2];
                    String string2 = "^" + Pattern.quote(file.getCanonicalPath()) + File.separator;
                    int n3 = 0;
                    Iterator iterator = ((ArrayList)object).iterator();
                    while (iterator.hasNext()) {
                        File file2 = (File)iterator.next();
                        stringArray2[n3++] = file2.getCanonicalPath().replaceFirst(string2, "");
                    }
                } else {
                    stringArray2 = new String[n2];
                    System.arraycopy(stringArray, n, stringArray2, 0, n2);
                }
                object = file == null ? new DicomDirectory(stringArray2) : new DicomDirectory(file, stringArray2);
                ((DicomDirectory)object).write(string);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.exit(0);
            }
        } else {
            System.err.println("Usage:");
        }
    }
}

