/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.geom.Point2D;

public class DisplayShutter {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DisplayShutter.java,v 1.14 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DisplayShutter.class);
    protected boolean hasCircularShutter;
    protected int centerOfCircularShutterY;
    protected int centerOfCircularShutterX;
    protected int radiusOfCircularShutter;
    protected boolean hasRectangularShutter;
    protected int shutterLeftVerticalEdge;
    protected int shutterRightVerticalEdge;
    protected int shutterUpperHorizontalEdge;
    protected int shutterLowerHorizontalEdge;
    protected boolean hasPolygonalShutter;
    protected int[] verticesOfPolygonalShutter;
    protected Point2D[] verticesOfPolygonalShutterAsPoints;

    public DisplayShutter(AttributeList attributeList) {
        String[] stringArray = Attribute.getStringValues(attributeList, TagFromName.ShutterShape);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string == null) continue;
                if (string.equals("RECTANGULAR") || string.equals("RECTANGLE")) {
                    this.hasRectangularShutter = true;
                    this.shutterLeftVerticalEdge = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.ShutterLeftVerticalEdge, 0);
                    this.shutterRightVerticalEdge = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.ShutterRightVerticalEdge, 0);
                    this.shutterUpperHorizontalEdge = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.ShutterUpperHorizontalEdge, 0);
                    this.shutterLowerHorizontalEdge = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.ShutterLowerHorizontalEdge, 0);
                    continue;
                }
                if (string.equals("CIRCULAR")) {
                    this.hasCircularShutter = true;
                    int[] nArray = Attribute.getIntegerValues(attributeList, TagFromName.CenterOfCircularShutter);
                    if (nArray != null && nArray.length >= 2) {
                        this.centerOfCircularShutterY = nArray[0];
                        this.centerOfCircularShutterX = nArray[1];
                    }
                    this.radiusOfCircularShutter = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.RadiusOfCircularShutter, 0);
                    continue;
                }
                if (string.equals("POLYGONAL")) {
                    this.hasPolygonalShutter = true;
                    this.verticesOfPolygonalShutter = Attribute.getIntegerValues(attributeList, TagFromName.VerticesOfThePolygonalShutter);
                    continue;
                }
                slf4jlogger.warn("DisplayShutter(): unrecognized shutter shape - {} - ignored", string);
            }
        }
    }

    public void setRectangularDisplayShutter(int n, int n2, int n3, int n4) {
        this.hasRectangularShutter = true;
        this.shutterLeftVerticalEdge = n;
        this.shutterRightVerticalEdge = n2;
        this.shutterUpperHorizontalEdge = n3;
        this.shutterLowerHorizontalEdge = n4;
    }

    public boolean isRectangularShutter() {
        return this.hasRectangularShutter;
    }

    public int getShutterLeftVerticalEdge() {
        return this.shutterLeftVerticalEdge;
    }

    public int getShutterRightVerticalEdge() {
        return this.shutterRightVerticalEdge;
    }

    public int getShutterUpperHorizontalEdge() {
        return this.shutterUpperHorizontalEdge;
    }

    public int getShutterLowerHorizontalEdge() {
        return this.shutterLowerHorizontalEdge;
    }

    public Point2D getRectangularShutterTLHC() {
        return new Point2D.Double(this.shutterLeftVerticalEdge, this.shutterUpperHorizontalEdge);
    }

    public Point2D getRectangularShutterBRHC() {
        return new Point2D.Double(this.shutterRightVerticalEdge, this.shutterLowerHorizontalEdge);
    }

    public void setCircularDisplayShutter(int n, int n2, int n3) {
        this.hasCircularShutter = true;
        this.centerOfCircularShutterX = n;
        this.centerOfCircularShutterY = n2;
        this.radiusOfCircularShutter = n3;
    }

    public boolean isCircularShutter() {
        return this.hasCircularShutter;
    }

    public int getCenterOfCircularShutterX() {
        return this.centerOfCircularShutterX;
    }

    public int getCenterOfCircularShutterY() {
        return this.centerOfCircularShutterY;
    }

    public int getRadiusOfCircularShutter() {
        return this.radiusOfCircularShutter;
    }

    public Point2D getCircularShutterTLHC() {
        return new Point2D.Double(this.centerOfCircularShutterX - this.radiusOfCircularShutter, this.centerOfCircularShutterY - this.radiusOfCircularShutter);
    }

    public Point2D getCircularShutterBRHC() {
        return new Point2D.Double(this.centerOfCircularShutterX + this.radiusOfCircularShutter, this.centerOfCircularShutterY + this.radiusOfCircularShutter);
    }

    public boolean isPolygonalShutter() {
        return this.hasPolygonalShutter;
    }

    public int[] getVerticesOfPolygonalShutter() {
        return this.verticesOfPolygonalShutter;
    }

    public Point2D[] getVerticesOfPolygonalShutterAsPoint2D() {
        if (this.verticesOfPolygonalShutterAsPoints == null) {
            int n = this.verticesOfPolygonalShutter.length / 2;
            this.verticesOfPolygonalShutterAsPoints = new Point2D[n];
            for (int i = 0; i < n; ++i) {
                this.verticesOfPolygonalShutterAsPoints[i] = new Point2D.Double(this.verticesOfPolygonalShutter[i * 2 + 1], this.verticesOfPolygonalShutter[i * 2]);
            }
        }
        return this.verticesOfPolygonalShutterAsPoints;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Display Shutters...\n");
        if (this.hasRectangularShutter) {
            stringBuffer.append("\tRectangular: ");
            stringBuffer.append("left vertical edge = ");
            stringBuffer.append(this.shutterLeftVerticalEdge);
            stringBuffer.append(", ");
            stringBuffer.append("right vertical edge = ");
            stringBuffer.append(this.shutterRightVerticalEdge);
            stringBuffer.append(", ");
            stringBuffer.append("upper horizontal edge = ");
            stringBuffer.append(this.shutterUpperHorizontalEdge);
            stringBuffer.append(", ");
            stringBuffer.append("lower horizontal edge = ");
            stringBuffer.append(this.shutterLowerHorizontalEdge);
            stringBuffer.append("\n");
        }
        if (this.hasCircularShutter) {
            stringBuffer.append("\tCircular: ");
            stringBuffer.append("center X = ");
            stringBuffer.append(this.centerOfCircularShutterX);
            stringBuffer.append(", ");
            stringBuffer.append("center Y = ");
            stringBuffer.append(this.centerOfCircularShutterY);
            stringBuffer.append(", ");
            stringBuffer.append("radius = ");
            stringBuffer.append(this.radiusOfCircularShutter);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

