/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import java.util.Locale;

public class InformationEntity
implements Comparable {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/InformationEntity.java,v 1.23 2025/01/29 10:58:06 dclunie Exp $";
    private int value;
    public static InformationEntity PATIENT = new InformationEntity(2);
    public static InformationEntity STUDY = new InformationEntity(3);
    public static InformationEntity PROCEDURESTEP = new InformationEntity(4);
    public static InformationEntity SERIES = new InformationEntity(5);
    public static InformationEntity CONCATENATION = new InformationEntity(6);
    public static InformationEntity INSTANCE = new InformationEntity(7);
    public static InformationEntity FRAME = new InformationEntity(8);

    private InformationEntity(int n) {
        this.value = n;
    }

    public String toString() {
        if (this == PATIENT) {
            return "Patient";
        }
        if (this == STUDY) {
            return "Study";
        }
        if (this == PROCEDURESTEP) {
            return "ProcedureStep";
        }
        if (this == SERIES) {
            return "Series";
        }
        if (this == CONCATENATION) {
            return "Concatenation";
        }
        if (this == INSTANCE) {
            return "Instance";
        }
        if (this == FRAME) {
            return "Frame";
        }
        return null;
    }

    public static InformationEntity fromString(String string) {
        if (string != null) {
            if ((string = string.toUpperCase(Locale.US)).equals("PATIENT")) {
                return PATIENT;
            }
            if (string.equals("STUDY")) {
                return STUDY;
            }
            if (string.equals("PROCEDURESTEP")) {
                return PROCEDURESTEP;
            }
            if (string.equals("SERIES")) {
                return SERIES;
            }
            if (string.equals("CONCATENATION")) {
                return CONCATENATION;
            }
            if (string.equals("INSTANCE")) {
                return INSTANCE;
            }
            if (string.equals("FRAME")) {
                return FRAME;
            }
            return null;
        }
        return null;
    }

    public int compareTo(Object object) {
        return this.value - ((InformationEntity)object).value;
    }
}

