/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;
import java.text.NumberFormat;

public class IntegerStringAttribute
extends StringAttribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/IntegerStringAttribute.java,v 1.27 2025/01/29 10:58:06 dclunie Exp $";
    protected static final int MAX_LENGTH_SINGLE_VALUE = 12;
    private static double[] testValues = new double[]{0.0, 1.0, Double.MAX_VALUE, Double.MIN_VALUE, 3.4028234663852886E38, 1.4E-45f, 9.223372036854776E18, -9.223372036854776E18, 2.147483647E9, -2.147483648E9, 32767.0, -32768.0, 127.0, -128.0};
    private static String[] testStringSupplied = new String[]{"0", "1", "Double.MAX_VALUE", "Double.MIN_VALUE", "Float.MAX_VALUE", "Float.MIN_VALUE", "9223372036854775807", "-9223372036854775808", "2147483647", "-2147483648", "32767", "-32768", "127", "-128"};
    private static String[] testStringExpected = new String[]{"0", "1", "exception", "0", "exception", "0", "exception", "exception", "2147483647", "-2147483648", "32767", "-32768", "127", "-128"};

    @Override
    public final int getMaximumLengthOfSingleValue() {
        return 12;
    }

    public IntegerStringAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public IntegerStringAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream);
    }

    public IntegerStringAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, (long)l, dicomInputStream);
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.IS;
    }

    @Override
    public String[] getStringValues(NumberFormat numberFormat) throws DicomException {
        String[] stringArray = null;
        if (numberFormat == null) {
            stringArray = super.getStringValues(null);
        } else {
            long[] lArray = this.getLongValues();
            if (lArray != null) {
                stringArray = new String[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    stringArray[i] = numberFormat.format(lArray[i]);
                }
            }
        }
        return stringArray;
    }

    @Override
    public void addValue(long l) throws DicomException {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new DicomException("Value " + l + " out of range for Integer String");
        }
        this.addValue((int)l);
    }

    @Override
    public void addValue(float f) throws DicomException {
        if (f < -2.1474836E9f || f > 2.1474836E9f) {
            throw new DicomException("Value " + f + " out of range for Integer String");
        }
        this.addValue((int)f);
    }

    @Override
    public void addValue(double d) throws DicomException {
        if (d < -2.147483648E9 || d > 2.147483647E9) {
            throw new DicomException("Value " + d + " out of range for Integer String");
        }
        this.addValue((int)d);
    }

    @Override
    public final boolean isCharacterInValueValid(int n) throws DicomException {
        return n < 127 && (Character.isDigit(n) || n == 32 || n == 43 || n == 45);
    }

    @Override
    public boolean areValuesWellFormed() throws DicomException {
        boolean bl = true;
        long[] lArray = this.getLongValues();
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public boolean repairValues() throws DicomException {
        if (!this.isValid()) {
            this.flushCachedCopies();
            this.originalByteValues = null;
            if (this.originalValues != null && this.originalValues.length > 0) {
                for (int i = 0; i < this.originalValues.length; ++i) {
                    String string = this.originalValues[i];
                    if (string == null || string.length() <= 0) continue;
                    this.originalValues[i] = string.trim();
                }
            }
        }
        return this.isValid();
    }

    public static void main(String[] stringArray) {
        int n;
        String string;
        IntegerStringAttribute integerStringAttribute;
        int n2;
        System.err.println("Test IntegerString.addValue(double):");
        for (n2 = 0; n2 < testValues.length; ++n2) {
            integerStringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
            string = "";
            try {
                integerStringAttribute.addValue(testValues[n2]);
                string = Attribute.getSingleStringValueOrEmptyString(integerStringAttribute);
            }
            catch (DicomException dicomException) {
                string = "exception";
            }
            n = string.length();
            System.err.println("\t" + (string.equals(testStringExpected[n2]) && n <= 12 ? "PASS" : "FAIL") + ": Supplied <" + testStringSupplied[n2] + ">\t Got <" + string + "> (length=" + n + ")\t Expected <" + testStringExpected[n2] + ">\t Double.toString() <" + Double.toString(testValues[n2]) + ">");
        }
        System.err.println("Test IntegerString.addValue(float):");
        for (n2 = 0; n2 < testValues.length; ++n2) {
            integerStringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
            string = "";
            try {
                integerStringAttribute.addValue((float)testValues[n2]);
                string = Attribute.getSingleStringValueOrEmptyString(integerStringAttribute);
            }
            catch (DicomException dicomException) {
                string = "exception";
            }
            n = string.length();
            System.err.println("\t" + (string.equals(testStringExpected[n2]) && n <= 12 ? "PASS" : "FAIL") + ": Supplied <" + testStringSupplied[n2] + ">\t Got <" + string + "> (length=" + n + ")\t Expected <" + testStringExpected[n2] + ">\t Double.toString() <" + Double.toString(testValues[n2]) + ">");
        }
        System.err.println("Test IntegerString.addValue(long):");
        for (n2 = 0; n2 < testValues.length; ++n2) {
            integerStringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
            string = "";
            try {
                integerStringAttribute.addValue((long)testValues[n2]);
                string = Attribute.getSingleStringValueOrEmptyString(integerStringAttribute);
            }
            catch (DicomException dicomException) {
                string = "exception";
            }
            n = string.length();
            System.err.println("\t" + (string.equals(testStringExpected[n2]) && n <= 12 ? "PASS" : "FAIL") + ": Supplied <" + testStringSupplied[n2] + ">\t Got <" + string + "> (length=" + n + ")\t Expected <" + testStringExpected[n2] + ">\t Double.toString() <" + Double.toString(testValues[n2]) + ">");
        }
    }
}

