/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDirectory;
import com.pixelmed.dicom.DicomDirectoryRecord;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.DialogMessageLogger;
import com.pixelmed.display.SafeFileChooser;
import com.pixelmed.display.SafeProgressBarUpdaterThread;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.PrintStreamMessageLogger;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.JProgressBar;

public class MediaImporter {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/MediaImporter.java,v 1.28 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(MediaImporter.class);
    protected String mediaDirectoryPath;
    protected MessageLogger logger;
    protected JProgressBar progressBar;
    protected SafeProgressBarUpdaterThread progressBarUpdater;
    protected static final AttributeList.ReadTerminationStrategy terminateAfterIdentifyingGroup = new OurReadTerminationStrategy();

    protected void logLn(String string) {
        if (this.logger != null) {
            this.logger.sendLn(string);
        }
    }

    public MediaImporter(MessageLogger messageLogger) {
        this.mediaDirectoryPath = null;
        this.logger = messageLogger;
        this.progressBar = null;
    }

    public MediaImporter(MessageLogger messageLogger, JProgressBar jProgressBar) {
        this.mediaDirectoryPath = null;
        this.logger = messageLogger;
        this.progressBar = jProgressBar;
    }

    public MediaImporter(String string, MessageLogger messageLogger) {
        this.mediaDirectoryPath = string;
        this.logger = messageLogger;
        this.progressBar = null;
    }

    public MediaImporter(String string, MessageLogger messageLogger, JProgressBar jProgressBar) {
        this.mediaDirectoryPath = string;
        this.logger = messageLogger;
        this.progressBar = jProgressBar;
    }

    public void choosePathAndImportDicomFiles(Component component) throws IOException, DicomException {
        String string = null;
        boolean bl = true;
        if (bl) {
            slf4jlogger.info("choosePathAndImportDicomFiles(): using JFileChooser because not broken Java 7 on Mac OS X");
            slf4jlogger.debug("choosePathAndImportDicomFiles(): about to construct JFileChooser");
            SafeFileChooser safeFileChooser = new SafeFileChooser(this.mediaDirectoryPath);
            safeFileChooser.setFileSelectionMode(2);
            slf4jlogger.debug("choosePathAndImportDicomFiles(): about to chooser.showOpenDialog");
            if (safeFileChooser.showOpenDialog(component) == 0) {
                slf4jlogger.debug("choosePathAndImportDicomFiles(): back with APPROVE_OPTION");
                this.mediaDirectoryPath = safeFileChooser.getCurrentDirectory().getAbsolutePath();
                string = safeFileChooser.getSelectedFile().getAbsolutePath();
            }
        } else {
            slf4jlogger.info("choosePathAndImportDicomFiles(): using FileDialog instead of JFileChooser because broken on Java 7 on Mac OS X");
            FileDialog fileDialog = new FileDialog(component instanceof Frame ? (Frame)component : null, "Import", 0);
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            fileDialog.setDirectory(this.mediaDirectoryPath);
            fileDialog.setVisible(true);
            this.mediaDirectoryPath = fileDialog.getDirectory();
            string = new File(this.mediaDirectoryPath, fileDialog.getFile()).getAbsolutePath();
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
        }
        slf4jlogger.debug("choosePathAndImportDicomFiles(): mediaDirectoryPath = {}", this.mediaDirectoryPath);
        slf4jlogger.debug("choosePathAndImportDicomFiles(): pathName = {}", string);
        if (string != null) {
            slf4jlogger.debug("choosePathAndImportDicomFiles(): calling importDicomFiles()");
            this.importDicomFiles(string);
        }
    }

    public void choosePathAndImportDicomFiles() throws IOException, DicomException {
        this.choosePathAndImportDicomFiles(null);
    }

    protected boolean isOKToImport(String string, String string2) {
        slf4jlogger.debug("isOKToImport(): sopClassUID={}, transferSyntaxUID={}", string, string2);
        boolean bl = string != null && (SOPClass.isImageStorage(string) || SOPClass.isNonImageStorage(string) && !SOPClass.isDirectory(string)) && string2 != null && (string2.equals("1.2.840.10008.1.2") || string2.equals("1.2.840.10008.1.2.1") || string2.equals("1.2.840.10008.1.2.2"));
        slf4jlogger.debug("isOKToImport(): {}", bl);
        return bl;
    }

    public void importDicomFiles(String string) throws IOException, DicomException {
        slf4jlogger.debug("importDicomFiles(): pathName = {}", string);
        if (this.progressBar != null) {
            this.progressBarUpdater = new SafeProgressBarUpdaterThread(this.progressBar);
        }
        if (string != null) {
            Object object;
            File file = new File(string);
            Object object2 = null;
            if (file != null && file.exists()) {
                if (file.isFile() && file.getName().toUpperCase(Locale.US).equals("DICOMDIR")) {
                    object2 = file;
                } else if (file.isDirectory()) {
                    object = new File(file, "DICOMDIR");
                    if (object != null && ((File)object).exists()) {
                        object2 = object;
                    } else {
                        object = new File(file, "Dicomdir");
                        if (object != null && ((File)object).exists()) {
                            object2 = object;
                        } else {
                            object = new File(file, "dicomdir");
                            if (object != null && ((File)object).exists()) {
                                object2 = object;
                            }
                        }
                    }
                }
            }
            if (object2 != null) {
                slf4jlogger.debug("importDicomFiles(): Found DICOMDIR at = {}", object2);
                this.logLn("Found DICOMDIR at: " + object2);
                object = new DicomInputStream(new BufferedInputStream(new FileInputStream((File)object2)));
                AttributeList attributeList = new AttributeList();
                attributeList.read((DicomInputStream)object);
                ((FilterInputStream)object).close();
                DicomDirectory dicomDirectory = new DicomDirectory(attributeList);
                HashMap<String, DicomDirectoryRecord> hashMap = dicomDirectory.findAllContainedReferencedFileNamesAndTheirRecords(((File)object2).getParentFile().getPath());
                if (this.progressBarUpdater != null) {
                    this.progressBarUpdater.setValue(0);
                    this.progressBarUpdater.setMaximum(hashMap.size());
                    this.progressBarUpdater.setStringPainted(true);
                    EventQueue.invokeLater(this.progressBarUpdater);
                }
                int n = 0;
                for (String string2 : hashMap.keySet()) {
                    if (string2 != null) {
                        AttributeList attributeList2;
                        boolean bl = false;
                        String string3 = "";
                        String string4 = "";
                        DicomDirectoryRecord dicomDirectoryRecord = hashMap.get(string2);
                        if (dicomDirectoryRecord != null && (attributeList2 = dicomDirectoryRecord.getAttributeList()) != null) {
                            string3 = Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ReferencedSOPClassUIDInFile);
                            string4 = Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ReferencedTransferSyntaxUIDInFile);
                            if (string3 == null || string4 == null) {
                                try {
                                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string2)));
                                    if (dicomInputStream.haveMetaHeader()) {
                                        AttributeList attributeList3 = new AttributeList();
                                        attributeList3.readOnlyMetaInformationHeader(dicomInputStream);
                                        if (string3 == null) {
                                            string3 = Attribute.getSingleStringValueOrNull(attributeList3, TagFromName.MediaStorageSOPClassUID);
                                        }
                                        if (string4 == null) {
                                            string4 = Attribute.getSingleStringValueOrNull(attributeList3, TagFromName.TransferSyntaxUID);
                                        }
                                    }
                                    dicomInputStream.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (this.isOKToImport(string3, string4)) {
                                bl = true;
                            } else {
                                this.logLn("Is a DICOM file but bad meta-header, not a storage object, or is compressed: " + string2 + " SOP Class=" + string3 + ", Transfer Syntax=" + string4);
                            }
                        }
                        if (bl) {
                            this.doSomethingWithDicomFileOnMedia(string2, string4, string3);
                        } else {
                            this.doSomethingWithUnwantedFileOnMedia(string2, string4, string3);
                        }
                    }
                    ++n;
                    if (this.progressBarUpdater == null) continue;
                    this.progressBarUpdater.setValue(n);
                    this.progressBarUpdater.setStringPainted(true);
                    EventQueue.invokeLater(this.progressBarUpdater);
                }
            } else {
                slf4jlogger.debug("importDicomFiles(): Perform listFilesRecursively() on {}", file);
                object = FileUtilities.listFilesRecursively(file);
                if (this.progressBarUpdater != null) {
                    this.progressBarUpdater.setValue(0);
                    this.progressBarUpdater.setMaximum(((ArrayList)object).size());
                    this.progressBarUpdater.setStringPainted(true);
                    EventQueue.invokeLater(this.progressBarUpdater);
                }
                int n = 0;
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    File file2 = (File)iterator.next();
                    slf4jlogger.debug("importDicomFiles(): Have next mediaFile {}", file2);
                    if (file2 != null) {
                        try {
                            AttributeList attributeList;
                            String string5 = "";
                            String string6 = "";
                            DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(file2)));
                            boolean bl = false;
                            if (dicomInputStream.haveMetaHeader()) {
                                slf4jlogger.debug("importDicomFiles(): Have haveMetaHeader");
                                attributeList = new AttributeList();
                                attributeList.readOnlyMetaInformationHeader(dicomInputStream);
                                string5 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.MediaStorageSOPClassUID);
                                string6 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.TransferSyntaxUID);
                                if (string5 == null || string5.length() == 0) {
                                    this.logLn("Have meta information header, but missing SOP Class UID so reading from data set: " + file2);
                                    attributeList.read(dicomInputStream, terminateAfterIdentifyingGroup);
                                    string5 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID);
                                }
                                if (this.isOKToImport(string5, string6)) {
                                    slf4jlogger.debug("importDicomFiles(): isOKToImport");
                                    bl = true;
                                } else {
                                    slf4jlogger.debug("importDicomFiles(): Is a DICOM file but bad meta-header, not a storage object, or is compressed with a scheme that is not supported: {}  SOP Class={}, Transfer Syntax={}", file2, string5, string6);
                                    this.logLn("Is a DICOM file but bad meta-header, not a storage object, or is compressed with a scheme that is not supported: " + file2 + " SOP Class=" + string5 + ", Transfer Syntax=" + string6);
                                }
                            } else {
                                slf4jlogger.debug("importDicomFiles(): No meta information header, so guessing is a DICOM file in implicit VR and attempting to get SOP Class UID");
                                this.logLn("No meta information header, so guessing is a DICOM file in implicit VR and attempting to get SOP Class UID: " + file2);
                                attributeList = new AttributeList();
                                attributeList.read(dicomInputStream, terminateAfterIdentifyingGroup);
                                string5 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID);
                                string6 = "1.2.840.10008.1.2";
                                if (this.isOKToImport(string5, string6)) {
                                    bl = true;
                                } else {
                                    this.logLn("Is not a DICOM file, or not a storage object, or is compressed with a scheme that is not supported: " + file2 + " SOP Class=" + string5 + ", Transfer Syntax=" + string6);
                                }
                            }
                            dicomInputStream.close();
                            if (bl) {
                                this.doSomethingWithDicomFileOnMedia(file2.getPath(), string6, string5);
                            } else {
                                this.doSomethingWithUnwantedFileOnMedia(file2.getPath(), string6, string5);
                            }
                        }
                        catch (Exception exception) {
                            this.doSomethingWithUnwantedFileOnMedia(file2.getPath(), "", "");
                        }
                    }
                    ++n;
                    if (this.progressBarUpdater == null) continue;
                    this.progressBarUpdater.setValue(n);
                    this.progressBarUpdater.setStringPainted(true);
                    EventQueue.invokeLater(this.progressBarUpdater);
                }
            }
        }
        this.logLn("Media import complete");
    }

    protected void doSomethingWithUnwantedFileOnMedia(String string, String string2, String string3) {
        this.logLn("Not a DICOM file, not a DICOM PS 3.10 file or not one that is wanted: " + string);
    }

    protected void doSomethingWithDicomFileOnMedia(String string, String string2, String string3) {
        this.doSomethingWithDicomFileOnMedia(string);
    }

    protected void doSomethingWithDicomFileOnMedia(String string) {
        this.logLn("Is a DICOM PS3.10 file that is wanted: " + string);
    }

    public String getDirectory() {
        return this.mediaDirectoryPath;
    }

    public static void main(String[] stringArray) {
        block4: {
            try {
                if (stringArray.length == 0) {
                    EventQueue.invokeAndWait(new MediaImporterWithFileChooserDialogThread(MediaImporter.class, "/", "MediaImporter", 512, 384, true, null, null));
                    break block4;
                }
                if (stringArray.length == 1) {
                    String string = stringArray[0];
                    PrintStreamMessageLogger printStreamMessageLogger = new PrintStreamMessageLogger(System.err);
                    MediaImporter mediaImporter = new MediaImporter(printStreamMessageLogger);
                    mediaImporter.importDicomFiles(string);
                    break block4;
                }
                throw new Exception("Argument list must be zero or one value");
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.exit(0);
            }
        }
    }

    public static class MediaImporterWithFileChooserDialogThread
    implements Runnable {
        private Class mediaImporterClass;
        private String mediaDirectoryPath;
        private String loggerTitleMessage;
        private int loggerWidth;
        private int loggerHeight;
        private boolean exitApplicationOnLoggerClose;
        private Component parent;
        private JProgressBar progressBar;

        public MediaImporterWithFileChooserDialogThread(Class clazz, String string, String string2, int n, int n2, boolean bl, Component component, JProgressBar jProgressBar) {
            this.mediaImporterClass = clazz;
            this.mediaDirectoryPath = string;
            this.loggerTitleMessage = string2;
            this.loggerWidth = n;
            this.loggerHeight = n2;
            this.exitApplicationOnLoggerClose = bl;
            this.parent = component;
            this.progressBar = jProgressBar;
        }

        @Override
        public void run() {
            DialogMessageLogger dialogMessageLogger = new DialogMessageLogger(this.loggerTitleMessage, this.loggerWidth, this.loggerHeight, this.exitApplicationOnLoggerClose);
            try {
                Class[] classArray = new Class[]{String.class, MessageLogger.class, JProgressBar.class};
                Object[] objectArray = new Object[]{this.mediaDirectoryPath, dialogMessageLogger, this.progressBar};
                MediaImporter mediaImporter = (MediaImporter)this.mediaImporterClass.getConstructor(classArray).newInstance(objectArray);
                try {
                    mediaImporter.choosePathAndImportDicomFiles(this.parent);
                }
                catch (DicomException dicomException) {
                    slf4jlogger.error("", dicomException);
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                slf4jlogger.error("", noSuchMethodException);
            }
            catch (InstantiationException instantiationException) {
                slf4jlogger.error("", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                slf4jlogger.error("", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                slf4jlogger.error("", invocationTargetException);
            }
        }
    }

    protected static class OurReadTerminationStrategy
    implements AttributeList.ReadTerminationStrategy {
        protected OurReadTerminationStrategy() {
        }

        @Override
        public boolean terminate(AttributeList attributeList, AttributeTag attributeTag, long l) {
            return attributeTag.getGroup() > 8;
        }
    }
}

