/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import java.util.Iterator;

public class ModalityTransform {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ModalityTransform.java,v 1.15 2025/01/29 10:58:06 dclunie Exp $";
    private SingleModalityTransform[] arrayOfTransforms = null;
    private SingleModalityTransform commonTransforms = null;

    public ModalityTransform(AttributeList attributeList) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        if (sequenceAttribute != null) {
            int n = sequenceAttribute.getNumberOfItems();
            int n2 = 0;
            object6 = sequenceAttribute.iterator();
            while (object6.hasNext()) {
                object5 = object6.next();
                object4 = ((SequenceItem)object5).getAttributeList();
                if (object4 != null && (object3 = (SequenceAttribute)((AttributeList)object4).get(TagFromName.PixelValueTransformationSequence)) != null && ((SequenceAttribute)object3).getNumberOfItems() >= 1) {
                    if (this.arrayOfTransforms == null) {
                        this.arrayOfTransforms = new SingleModalityTransform[n];
                    }
                    if (this.arrayOfTransforms[n2] == null) {
                        this.arrayOfTransforms[n2] = null;
                    }
                    object2 = ((SequenceAttribute)object3).iterator();
                    while (object2.hasNext()) {
                        object = object2.next();
                        AttributeList attributeList2 = ((SequenceItem)object).getAttributeList();
                        this.arrayOfTransforms[n2] = new SingleModalityTransform(attributeList2);
                    }
                }
                ++n2;
            }
        }
        if (this.arrayOfTransforms == null) {
            Iterator<SequenceItem> iterator;
            SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
            if (sequenceAttribute2 != null && (iterator = sequenceAttribute2.iterator()).hasNext() && (object5 = ((SequenceItem)(object6 = iterator.next())).getAttributeList()) != null && (object4 = (SequenceAttribute)((AttributeList)object5).get(TagFromName.PixelValueTransformationSequence)) != null && ((SequenceAttribute)object4).getNumberOfItems() >= 1) {
                this.commonTransforms = null;
                object3 = ((SequenceAttribute)object4).iterator();
                while (object3.hasNext()) {
                    object2 = (SequenceItem)object3.next();
                    object = ((SequenceItem)object2).getAttributeList();
                    this.commonTransforms = new SingleModalityTransform((AttributeList)object);
                }
            }
            if (this.arrayOfTransforms == null && this.commonTransforms == null) {
                this.commonTransforms = new SingleModalityTransform(attributeList);
            }
        }
    }

    public double getRescaleSlope(int n) {
        SingleModalityTransform singleModalityTransform = this.arrayOfTransforms == null ? this.commonTransforms : this.arrayOfTransforms[n];
        return singleModalityTransform == null ? 1.0 : singleModalityTransform.slope;
    }

    public double getRescaleIntercept(int n) {
        SingleModalityTransform singleModalityTransform = this.arrayOfTransforms == null ? this.commonTransforms : this.arrayOfTransforms[n];
        return singleModalityTransform == null ? 0.0 : singleModalityTransform.intercept;
    }

    private class SingleModalityTransform {
        double slope = 1.0;
        double intercept = 0.0;
        String explanation;

        SingleModalityTransform(AttributeList attributeList) {
            if (attributeList != null) {
                this.slope = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RescaleSlope, 1.0);
                this.intercept = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RescaleIntercept, 0.0);
                this.explanation = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.RescaleType);
                if (this.slope == 0.0 && this.intercept == 0.0) {
                    this.slope = 1.0;
                    this.explanation = "override illegal zero slope with identity (com.pixelmed.dicom.ModalityTransform)" + (this.explanation == null || this.explanation.length() == 0 ? "" : "; " + this.explanation);
                }
            }
        }
    }
}

