/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;

public class OtherWordAttributeMultipleFrameArrays
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherWordAttributeMultipleFrameArrays.java,v 1.10 2025/01/29 10:58:07 dclunie Exp $";
    private short[][] values;

    public OtherWordAttributeMultipleFrameArrays(AttributeTag attributeTag) {
        super(attributeTag);
    }

    @Override
    public long getPaddedVL() {
        long l = this.getVL();
        if (l % 2L != 0L) {
            ++l;
        }
        return l;
    }

    @Override
    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        if (this.values != null && this.values.length > 0) {
            for (int i = 0; i < this.values.length; ++i) {
                dicomOutputStream.writeUnsigned16(this.values[i], this.values[i].length);
            }
        }
    }

    @Override
    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" []");
        return stringBuffer.toString();
    }

    public void setValuesPerFrame(short[][] sArray) throws DicomException {
        if (sArray == null) {
            this.values = null;
            this.valueMultiplicity = 0;
            this.valueLength = 0L;
        } else {
            int n = 0;
            this.values = new short[sArray.length][];
            for (int i = 0; i < sArray.length; ++i) {
                this.values[i] = sArray[i];
                if (n == 0) {
                    n = sArray[i].length;
                    continue;
                }
                if (n == sArray[i].length) continue;
                throw new DicomException("Frame short arrays are not same length - have " + sArray[i].length + " dec shorts for frame " + i + " does not match earlier frame " + n + " dec shorts");
            }
            this.values = sArray;
            this.valueMultiplicity = 1;
            this.valueLength = sArray.length * n * 2;
        }
    }

    public short[][] getShortValuesPerFrame() throws DicomException {
        short[][] sArrayArray = new short[this.values.length][];
        for (int i = 0; i < this.values.length; ++i) {
            sArrayArray[i] = this.values[i];
        }
        return sArrayArray;
    }

    @Override
    public void removeValues() {
        this.values = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.OW;
    }
}

