/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.utils.FloatFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class RealWorldValueTransform {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/RealWorldValueTransform.java,v 1.26 2025/01/29 10:58:07 dclunie Exp $";
    private SingleRealWorldValueTransforms[] arrayOfTransforms = null;
    private SingleRealWorldValueTransforms commonTransforms = null;
    private final int precisionToDisplayDouble = 4;
    private final int maximumIntegerDigits = 8;
    private final int maximumMaximumFractionDigits = 6;

    private static String getQuantityFromQuantityDefinitionSequence(AttributeList attributeList) {
        String string = null;
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.QuantityDefinitionSequence);
        if (sequenceAttribute != null) {
            Iterator<SequenceItem> iterator = sequenceAttribute.iterator();
            while (iterator.hasNext() && string == null) {
                SequenceItem sequenceItem = iterator.next();
                if (sequenceItem == null) continue;
                AttributeList attributeList2 = sequenceItem.getAttributeList();
                CodedSequenceItem codedSequenceItem = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList2, TagFromName.ConceptNameCodeSequence);
                CodedSequenceItem codedSequenceItem2 = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList2, TagFromName.ConceptCodeSequence);
                if (codedSequenceItem == null || !"G-C1C6".equals(codedSequenceItem.getCodeValue()) || !"SRT".equals(codedSequenceItem.getCodingSchemeDesignator()) || codedSequenceItem2 == null) continue;
                string = codedSequenceItem2.getCodeMeaning();
            }
        }
        return string;
    }

    public RealWorldValueTransform(AttributeList attributeList) {
        Object object;
        Object object2;
        Object object3;
        Iterator<SequenceItem> iterator;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        if (sequenceAttribute != null) {
            int n = sequenceAttribute.getNumberOfItems();
            int n2 = 0;
            object7 = sequenceAttribute.iterator();
            while (object7.hasNext()) {
                object6 = object7.next();
                object5 = ((SequenceItem)object6).getAttributeList();
                if (object5 != null) {
                    object4 = (SequenceAttribute)((AttributeList)object5).get(TagFromName.RealWorldValueMappingSequence);
                    if (object4 != null && ((SequenceAttribute)object4).getNumberOfItems() >= 1) {
                        if (this.arrayOfTransforms == null) {
                            this.arrayOfTransforms = new SingleRealWorldValueTransforms[n];
                        }
                        if (this.arrayOfTransforms[n2] == null) {
                            this.arrayOfTransforms[n2] = new SingleRealWorldValueTransforms();
                        }
                        iterator = ((SequenceAttribute)object4).iterator();
                        while (iterator.hasNext()) {
                            object3 = (SequenceItem)iterator.next();
                            object2 = ((SequenceItem)object3).getAttributeList();
                            this.arrayOfTransforms[n2].add(new SingleRealWorldValueTransform((AttributeList)object2));
                        }
                    }
                    if ((iterator = (SequenceAttribute)((AttributeList)object5).get(TagFromName.PixelValueTransformationSequence)) != null && ((SequenceAttribute)((Object)iterator)).getNumberOfItems() >= 1) {
                        if (this.arrayOfTransforms == null) {
                            this.arrayOfTransforms = new SingleRealWorldValueTransforms[n];
                        }
                        if (this.arrayOfTransforms[n2] == null) {
                            this.arrayOfTransforms[n2] = new SingleRealWorldValueTransforms();
                        }
                        object3 = ((SequenceAttribute)((Object)iterator)).iterator();
                        while (object3.hasNext()) {
                            object2 = (SequenceItem)object3.next();
                            object = ((SequenceItem)object2).getAttributeList();
                            this.arrayOfTransforms[n2].add(new SingleRealWorldValueTransform((AttributeList)object, string));
                        }
                    }
                }
                ++n2;
            }
        }
        if (this.arrayOfTransforms == null) {
            SequenceAttribute sequenceAttribute2;
            Iterator<SequenceItem> iterator2;
            SequenceAttribute sequenceAttribute3 = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
            if (sequenceAttribute3 != null && (iterator2 = sequenceAttribute3.iterator()).hasNext() && (object6 = ((SequenceItem)(object7 = iterator2.next())).getAttributeList()) != null) {
                object5 = (SequenceAttribute)((AttributeList)object6).get(TagFromName.RealWorldValueMappingSequence);
                if (object5 != null && ((SequenceAttribute)object5).getNumberOfItems() >= 1) {
                    if (this.commonTransforms == null) {
                        this.commonTransforms = new SingleRealWorldValueTransforms();
                    }
                    object4 = ((SequenceAttribute)object5).iterator();
                    while (object4.hasNext()) {
                        iterator = (SequenceItem)object4.next();
                        object3 = ((SequenceItem)((Object)iterator)).getAttributeList();
                        this.commonTransforms.add(new SingleRealWorldValueTransform((AttributeList)object3));
                    }
                }
                if ((object4 = (SequenceAttribute)((AttributeList)object6).get(TagFromName.PixelValueTransformationSequence)) != null && ((SequenceAttribute)object4).getNumberOfItems() >= 1) {
                    if (this.commonTransforms == null) {
                        this.commonTransforms = new SingleRealWorldValueTransforms();
                    }
                    iterator = ((SequenceAttribute)object4).iterator();
                    while (iterator.hasNext()) {
                        object3 = iterator.next();
                        object2 = ((SequenceItem)object3).getAttributeList();
                        object = new SingleRealWorldValueTransform((AttributeList)object2, string);
                        if (((SingleRealWorldValueTransform)object).isIdentityAndUnitsUnspecified()) continue;
                        this.commonTransforms.add(object);
                    }
                }
            }
            if (this.arrayOfTransforms == null && this.commonTransforms == null && (sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.RealWorldValueMappingSequence)) != null && sequenceAttribute2.getNumberOfItems() >= 1) {
                object7 = new SingleRealWorldValueTransform(attributeList);
                this.commonTransforms = new SingleRealWorldValueTransforms();
                object6 = sequenceAttribute2.iterator();
                while (object6.hasNext()) {
                    object5 = object6.next();
                    object4 = ((SequenceItem)object5).getAttributeList();
                    this.commonTransforms.add(new SingleRealWorldValueTransform((AttributeList)object4));
                }
            }
            Attribute attribute = attributeList.get(TagFromName.RescaleSlope);
            object7 = attributeList.get(TagFromName.RescaleIntercept);
            if (attribute != null && object7 != null) {
                if (this.commonTransforms == null) {
                    this.commonTransforms = new SingleRealWorldValueTransforms();
                }
                if (!((SingleRealWorldValueTransform)(object6 = new SingleRealWorldValueTransform(attributeList, string))).isIdentityAndUnitsUnspecified()) {
                    this.commonTransforms.add(object6);
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RealWorldValueTransforms:\n");
        if (this.commonTransforms != null) {
            stringBuffer.append("\tCommon:\n");
            for (Object object : this.commonTransforms) {
                stringBuffer.append(object);
            }
        }
        if (this.arrayOfTransforms != null) {
            for (int i = 0; i < this.arrayOfTransforms.length; ++i) {
                stringBuffer.append("\tPer-Frame for Frame[");
                stringBuffer.append(i + 1);
                stringBuffer.append("]:\n");
                for (SingleRealWorldValueTransform singleRealWorldValueTransform : this.arrayOfTransforms[i]) {
                    stringBuffer.append(singleRealWorldValueTransform);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String toString(int n, int n2) {
        return this.toString(n, (double)n2);
    }

    public String toString(int n, double d) {
        SingleRealWorldValueTransforms singleRealWorldValueTransforms;
        StringBuffer stringBuffer = new StringBuffer();
        SingleRealWorldValueTransforms singleRealWorldValueTransforms2 = singleRealWorldValueTransforms = this.arrayOfTransforms == null ? this.commonTransforms : this.arrayOfTransforms[n];
        if (singleRealWorldValueTransforms != null) {
            for (SingleRealWorldValueTransform singleRealWorldValueTransform : singleRealWorldValueTransforms) {
                if (singleRealWorldValueTransform.rangeOfValues != null && (!((double)singleRealWorldValueTransform.rangeOfValues[0] <= d) || !(d <= (double)singleRealWorldValueTransform.rangeOfValues[1]))) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                double d2 = d * singleRealWorldValueTransform.slope + singleRealWorldValueTransform.intercept;
                stringBuffer.append(FloatFormatter.toString(d2, Locale.US));
                stringBuffer.append(" ");
                stringBuffer.append(singleRealWorldValueTransform.units);
                if (singleRealWorldValueTransform.quantity == null || singleRealWorldValueTransform.quantity.length() <= 0) continue;
                stringBuffer.append(" (");
                stringBuffer.append(singleRealWorldValueTransform.quantity);
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    private class SingleRealWorldValueTransforms
    extends ArrayList<SingleRealWorldValueTransform> {
        private SingleRealWorldValueTransforms() {
        }
    }

    private class SingleRealWorldValueTransform {
        int[] rangeOfValues;
        double slope;
        double intercept;
        String units;
        String quantity;

        SingleRealWorldValueTransform(AttributeList attributeList) {
            if (attributeList != null) {
                Attribute attribute = attributeList.get(TagFromName.RealWorldValueFirstValueMapped);
                Attribute attribute2 = attributeList.get(TagFromName.RealWorldValueLastValueMapped);
                if (attribute != null && attribute2 != null) {
                    this.rangeOfValues = new int[2];
                    this.rangeOfValues[0] = attribute.getSingleIntegerValueOrDefault(0);
                    this.rangeOfValues[1] = attribute2.getSingleIntegerValueOrDefault(0);
                } else {
                    this.rangeOfValues = null;
                }
                this.slope = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RealWorldValueSlope, 0.0);
                this.intercept = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RealWorldValueIntercept, 0.0);
                this.units = SequenceAttribute.getMeaningOfCodedSequenceAttributeOrDefault(attributeList, TagFromName.MeasurementUnitsCodeSequence, "");
                this.quantity = RealWorldValueTransform.getQuantityFromQuantityDefinitionSequence(attributeList);
            }
        }

        SingleRealWorldValueTransform(AttributeList attributeList, String string) {
            if (attributeList != null) {
                this.rangeOfValues = null;
                this.slope = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RescaleSlope, 1.0);
                this.intercept = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RescaleIntercept, 0.0);
                String string2 = "??";
                String string3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.RescaleType);
                String string4 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.Units);
                if (string.equals("1.2.840.10008.5.1.4.1.1.128") && string4 != null && string4.length() > 0) {
                    string2 = string4;
                } else if (string3 != null && string3.length() > 0) {
                    string2 = string3;
                } else if (string.equals("1.2.840.10008.5.1.4.1.1.2")) {
                    string2 = "HU";
                }
                this.units = string2;
            }
        }

        boolean isIdentityAndUnitsUnspecified() {
            return this.slope == 1.0 && this.intercept == 0.0 && (this.units == null || this.units.equals("US") || this.units.equals("??"));
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\t\t");
            stringBuffer.append("slope=");
            stringBuffer.append(this.slope);
            stringBuffer.append(", intercept=");
            stringBuffer.append(this.intercept);
            stringBuffer.append(", units=");
            stringBuffer.append(this.units);
            stringBuffer.append(", quantity=");
            stringBuffer.append(this.quantity);
            stringBuffer.append(", range=");
            if (this.rangeOfValues != null) {
                stringBuffer.append("[");
                stringBuffer.append(this.rangeOfValues[0]);
                stringBuffer.append("..");
                stringBuffer.append(this.rangeOfValues[1]);
                stringBuffer.append("]");
            } else {
                stringBuffer.append("ALL");
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

