/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedList;

public class SequenceAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SequenceAttribute.java,v 1.38 2025/01/29 10:58:07 dclunie Exp $";
    private LinkedList<SequenceItem> itemList = new LinkedList();

    public SequenceAttribute(AttributeTag attributeTag) {
        super(attributeTag);
        this.valueLength = 0xFFFFFFFFL;
    }

    @Override
    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        Iterator<SequenceItem> iterator = this.iterator();
        while (iterator.hasNext()) {
            SequenceItem sequenceItem = iterator.next();
            sequenceItem.write(dicomOutputStream);
        }
        dicomOutputStream.writeUnsigned16(65534);
        dicomOutputStream.writeUnsigned16(57565);
        dicomOutputStream.writeUnsigned32(0L);
    }

    @Override
    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append("\n%seq\n");
        Iterator<SequenceItem> iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString(dicomDictionary));
            stringBuffer.append("\n");
        }
        stringBuffer.append("%endseq");
        return stringBuffer.toString();
    }

    @Override
    public void removeValues() {
        this.itemList = new LinkedList();
        this.valueMultiplicity = 0;
        this.valueLength = 0xFFFFFFFFL;
    }

    public void addItem(SequenceItem sequenceItem) {
        this.itemList.addLast(sequenceItem);
    }

    public void addItem(AttributeList attributeList) {
        this.itemList.addLast(new SequenceItem(attributeList));
    }

    public void addItem(AttributeList attributeList, long l) {
        this.itemList.addLast(new SequenceItem(attributeList, l));
    }

    public Iterator<SequenceItem> iterator() {
        return this.itemList.listIterator(0);
    }

    public int getNumberOfItems() {
        return this.itemList.size();
    }

    public SequenceItem getItem(int n) {
        return this.itemList == null || n >= this.itemList.size() ? null : this.itemList.get(n);
    }

    public void remove(SequenceItem sequenceItem) {
        this.itemList.remove(sequenceItem);
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.SQ;
    }

    @Override
    public long getLengthOfEntireEncodedAttribute(boolean bl, boolean bl2) throws DicomException {
        long l = this.getLengthOfBaseOfEncodedAttribute(bl, bl2);
        Iterator<SequenceItem> iterator = this.iterator();
        while (iterator.hasNext()) {
            l += 8L;
            SequenceItem sequenceItem = iterator.next();
            AttributeList attributeList = sequenceItem.getAttributeList();
            if (attributeList != null) {
                for (Attribute attribute : attributeList.values()) {
                    l += attribute.getLengthOfEntireEncodedAttribute(bl, bl2);
                }
            }
            l += 8L;
        }
        return l += 8L;
    }

    public static AttributeList getAttributeListFromWithinSequenceWithSingleItem(SequenceAttribute sequenceAttribute) {
        SequenceItem sequenceItem;
        Iterator<SequenceItem> iterator;
        AttributeList attributeList = null;
        if (sequenceAttribute != null && (iterator = sequenceAttribute.iterator()).hasNext() && (sequenceItem = iterator.next()) != null) {
            attributeList = sequenceItem.getAttributeList();
        }
        return attributeList;
    }

    public static AttributeList getAttributeListFromSelectedItemWithinSequence(SequenceAttribute sequenceAttribute, int n) {
        SequenceItem sequenceItem;
        AttributeList attributeList = null;
        if (sequenceAttribute != null && (sequenceItem = sequenceAttribute.getItem(n)) != null) {
            attributeList = sequenceItem.getAttributeList();
        }
        return attributeList;
    }

    public static Attribute getNamedAttributeFromWithinSelectedItemWithinSequence(SequenceAttribute sequenceAttribute, int n, AttributeTag attributeTag) {
        AttributeList attributeList;
        SequenceItem sequenceItem;
        Attribute attribute = null;
        if (sequenceAttribute != null && (sequenceItem = sequenceAttribute.getItem(n)) != null && (attributeList = sequenceItem.getAttributeList()) != null) {
            attribute = attributeList.get(attributeTag);
        }
        return attribute;
    }

    public static Attribute getNamedAttributeFromWithinSelectedItemWithinSequence(AttributeList attributeList, AttributeTag attributeTag, int n, AttributeTag attributeTag2) {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(attributeTag);
        return SequenceAttribute.getNamedAttributeFromWithinSelectedItemWithinSequence(sequenceAttribute, n, attributeTag2);
    }

    public static AttributeList getAttributeListFromWithinSequenceWithSingleItem(AttributeList attributeList, AttributeTag attributeTag) {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(attributeTag);
        return SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(sequenceAttribute);
    }

    public static Attribute getNamedAttributeFromWithinSequenceWithSingleItem(SequenceAttribute sequenceAttribute, AttributeTag attributeTag) {
        AttributeList attributeList;
        Attribute attribute = null;
        if (sequenceAttribute != null && (attributeList = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(sequenceAttribute)) != null) {
            attribute = attributeList.get(attributeTag);
        }
        return attribute;
    }

    public static Attribute getNamedAttributeFromWithinSequenceWithSingleItem(AttributeList attributeList, AttributeTag attributeTag, AttributeTag attributeTag2) {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(attributeTag);
        return SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, attributeTag2);
    }

    public static String getSingleStringValueOfNamedAttributeFromWithinSequenceWithSingleItemOrDefault(AttributeList attributeList, AttributeTag attributeTag, AttributeTag attributeTag2, String string) {
        String string2 = string;
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(attributeTag);
        Attribute attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, attributeTag2);
        if (attribute != null) {
            string2 = attribute.getSingleStringValueOrDefault(string);
        }
        return string2;
    }

    public static String getSingleStringValueOfNamedAttributeFromWithinSequenceWithSingleItemOrEmptyString(AttributeList attributeList, AttributeTag attributeTag, AttributeTag attributeTag2) {
        return SequenceAttribute.getSingleStringValueOfNamedAttributeFromWithinSequenceWithSingleItemOrDefault(attributeList, attributeTag, attributeTag2, "");
    }

    public static double getSingleIntegerValueOfNamedAttributeFromWithinSequenceWithSingleItemOrDefault(AttributeList attributeList, AttributeTag attributeTag, AttributeTag attributeTag2, int n) {
        int n2 = n;
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(attributeTag);
        Attribute attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, attributeTag2);
        if (attribute != null) {
            n2 = attribute.getSingleIntegerValueOrDefault(n);
        }
        return n2;
    }

    public static double getSingleDoubleValueOfNamedAttributeFromWithinSequenceWithSingleItemOrDefault(AttributeList attributeList, AttributeTag attributeTag, AttributeTag attributeTag2, double d) {
        double d2 = d;
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(attributeTag);
        Attribute attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, attributeTag2);
        if (attribute != null) {
            d2 = attribute.getSingleDoubleValueOrDefault(d);
        }
        return d2;
    }

    public static String getMeaningOfCodedSequenceAttributeOrDefault(AttributeList attributeList, AttributeTag attributeTag, String string) {
        return SequenceAttribute.getSingleStringValueOfNamedAttributeFromWithinSequenceWithSingleItemOrDefault(attributeList, attributeTag, TagFromName.CodeMeaning, string);
    }

    public static String getMeaningOfCodedSequenceAttributeOrEmptyString(AttributeList attributeList, AttributeTag attributeTag) {
        return SequenceAttribute.getMeaningOfCodedSequenceAttributeOrDefault(attributeList, attributeTag, "");
    }

    @Override
    public String getDelimitedStringValuesOrDefault(String string, NumberFormat numberFormat) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        String string2 = "";
        Iterator<SequenceItem> iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(string2);
            stringBuffer.append(iterator.next().getDelimitedStringValuesOrDefault(string, numberFormat, ","));
            string2 = ",";
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public static String[] getArrayOfSingleStringValueOrDefaultOfNamedAttributeWithinSequenceItems(AttributeList attributeList, AttributeTag attributeTag, AttributeTag attributeTag2, String string, NumberFormat numberFormat) {
        String[] stringArray = null;
        Attribute attribute = attributeList.get(attributeTag);
        if (attribute != null && attribute instanceof SequenceAttribute) {
            SequenceAttribute sequenceAttribute = (SequenceAttribute)attribute;
            int n = sequenceAttribute.getNumberOfItems();
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = Attribute.getSingleStringValueOrDefault(sequenceAttribute.getItem(i).getAttributeList(), attributeTag2, string, numberFormat);
            }
        }
        return stringArray == null ? new String[]{} : stringArray;
    }

    public static String[] getArrayOfSingleStringValueOrDefaultOfNamedAttributeWithinSequenceItems(AttributeList attributeList, AttributeTag attributeTag, AttributeTag attributeTag2, String string) {
        return SequenceAttribute.getArrayOfSingleStringValueOrDefaultOfNamedAttributeWithinSequenceItems(attributeList, attributeTag, attributeTag2, string, null);
    }

    public static String[] getArrayOfSingleStringValueOrEmptyStringOfNamedAttributeWithinSequenceItems(AttributeList attributeList, AttributeTag attributeTag, AttributeTag attributeTag2) {
        return SequenceAttribute.getArrayOfSingleStringValueOrDefaultOfNamedAttributeWithinSequenceItems(attributeList, attributeTag, attributeTag2, "");
    }
}

