/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomFileUtilities;
import com.pixelmed.dicom.FrameSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class SetOfFrameSets
extends HashSet<FrameSet> {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SetOfFrameSets.java,v 1.22 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SetOfFrameSets.class);

    public void insertIntoFrameSets(AttributeList attributeList) throws DicomException {
        boolean bl = false;
        for (FrameSet frameSet : this) {
            if (!frameSet.eligible(attributeList)) continue;
            frameSet.insert(attributeList);
            bl = true;
            break;
        }
        if (!bl) {
            this.add(new FrameSet(attributeList));
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (FrameSet frameSet : this) {
            stringBuffer.append("Frame set [");
            stringBuffer.append(Integer.toString(n));
            stringBuffer.append("]:\n");
            stringBuffer.append(frameSet.toString());
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    private void doCommonConstructorStuff(Set<File> set) {
        for (File file : set) {
            try {
                if (!DicomFileUtilities.isDicomOrAcrNemaFile(file)) continue;
                AttributeList attributeList = new AttributeList();
                attributeList.read(file, TagFromName.PixelData);
                this.insertIntoFrameSets(attributeList);
            }
            catch (Exception exception) {
                slf4jlogger.error("While reading \"{}\"", file, exception);
            }
        }
    }

    public SetOfFrameSets() {
    }

    public SetOfFrameSets(Set<File> set) {
        this.doCommonConstructorStuff(set);
    }

    public SetOfFrameSets(String[] stringArray) {
        HashSet<File> hashSet = new HashSet<File>();
        for (String string : stringArray) {
            ArrayList<File> arrayList = FileUtilities.listFilesRecursively(new File(string));
            hashSet.addAll(arrayList);
        }
        this.doCommonConstructorStuff(hashSet);
    }

    public static void main(String[] stringArray) {
        SetOfFrameSets setOfFrameSets = new SetOfFrameSets(stringArray);
        System.err.println("SetOfFrameSets.main(): Result");
        System.err.println(setOfFrameSets.toString());
    }
}

