/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.FloatDoubleAttribute;
import com.pixelmed.dicom.FloatSingleAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.NumberFormat;

public class UnknownAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/UnknownAttribute.java,v 1.31 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(UnknownAttribute.class);
    protected byte[] originalLittleEndianByteValues;

    public UnknownAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public UnknownAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    public UnknownAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.valueLength = l;
        this.valueMultiplicity = 1;
        try {
            this.originalLittleEndianByteValues = new byte[(int)l];
            dicomInputStream.readInsistently(this.originalLittleEndianByteValues, 0, (int)l);
        }
        catch (IOException iOException) {
            throw new DicomException("Failed to read value (length " + l + " dec) in UN attribute " + this.getTag());
        }
    }

    @Override
    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        dicomOutputStream.write(this.originalLittleEndianByteValues);
    }

    @Override
    public String toString(DicomDictionary dicomDictionary) {
        return super.toString(dicomDictionary) + " " + this.getVR() + " ";
    }

    @Override
    public void removeValues() {
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.UN;
    }

    @Override
    public void setValues(byte[] byArray) throws DicomException {
        this.originalLittleEndianByteValues = byArray;
        this.valueMultiplicity = 1;
        this.valueLength = byArray.length;
    }

    @Override
    public void setValues(byte[] byArray, boolean bl) throws DicomException {
        if (bl) {
            throw new DicomException("Setting UN VR bytes from big endian not supported");
        }
        this.setValues(byArray);
    }

    @Override
    public byte[] getByteValues() {
        return this.originalLittleEndianByteValues;
    }

    @Override
    public byte[] getByteValues(boolean bl) throws DicomException {
        if (bl) {
            throw new DicomException("Returning UN VR bytes in big endian not supported");
        }
        return this.originalLittleEndianByteValues;
    }

    @Override
    public String[] getStringValues(NumberFormat numberFormat) throws DicomException {
        String[] stringArray = null;
        try {
            String[] stringArray2 = new String[]{new String(this.originalLittleEndianByteValues)};
            stringArray = ArrayCopyUtilities.copyStringArrayRemovingLeadingAndTrailingPadding(stringArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    @Override
    public double[] getDoubleValues() throws DicomException {
        double[] dArray = null;
        if (this.valueLength % (long)FloatDoubleAttribute.bytesPerValue != 0L) {
            throw new DicomException("incorrect value length (" + this.valueLength + " dec) for UN as FD");
        }
        try {
            BinaryInputStream binaryInputStream = new BinaryInputStream(new ByteArrayInputStream(this.originalLittleEndianByteValues), false);
            int n = (int)(this.valueLength / (long)FloatDoubleAttribute.bytesPerValue);
            dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = binaryInputStream.readDouble();
            }
        }
        catch (IOException iOException) {
            slf4jlogger.error("", iOException);
            throw new DicomException(iOException.toString());
        }
        return dArray;
    }

    @Override
    public float[] getFloatValues() throws DicomException {
        float[] fArray = null;
        if (this.valueLength % (long)FloatSingleAttribute.bytesPerValue != 0L) {
            throw new DicomException("incorrect value length (" + this.valueLength + " dec) for UN as FD");
        }
        try {
            BinaryInputStream binaryInputStream = new BinaryInputStream(new ByteArrayInputStream(this.originalLittleEndianByteValues), false);
            int n = (int)(this.valueLength / (long)FloatSingleAttribute.bytesPerValue);
            fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = binaryInputStream.readFloat();
            }
        }
        catch (IOException iOException) {
            slf4jlogger.error("", iOException);
            throw new DicomException(iOException.toString());
        }
        return fArray;
    }
}

