/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.display.StatusBarManager;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class ApplicationFrame
extends JFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/ApplicationFrame.java,v 1.47 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ApplicationFrame.class);
    protected static String resourceBundleName = "com.pixelmed.display.ApplicationFrame";
    protected static ResourceBundle resourceBundle;
    protected StatusBarManager statusBarManager;
    private Properties applicationProperties;
    private String applicationPropertyFileName;

    protected static void localizeJOptionPane() {
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(resourceBundleName);
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    if (!string.startsWith("OptionPane.")) continue;
                    String string2 = resourceBundle.getString(string);
                    slf4jlogger.debug("localizeJOptionPane(): UIManager.put(\"{}\" , \"{}\")", string, string2);
                    UIManager.put(string, string2);
                }
            }
            catch (Exception exception) {
                slf4jlogger.warn("Missing resource bundle for localization {}", exception.toString());
            }
        }
    }

    protected static String getReleaseString() {
        return "General Release";
    }

    protected static String getBuildDate() {
        return VersionAndConstants.getBuildDate();
    }

    protected JLabel getStatusBar() {
        this.statusBarManager = new StatusBarManager(ApplicationFrame.getBuildDate() + " " + ApplicationFrame.getReleaseString());
        return this.statusBarManager.getStatusBar();
    }

    protected static String makePathToFileInUsersHomeDirectory(String string) {
        return FileUtilities.makePathToFileInUsersHomeDirectory(string);
    }

    protected void loadProperties() {
        this.applicationProperties = new Properties(){

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }
        };
        if (this.applicationPropertyFileName != null) {
            String string = ApplicationFrame.makePathToFileInUsersHomeDirectory(this.applicationPropertyFileName);
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                this.applicationProperties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
    }

    protected void storeProperties(String string) throws IOException {
        if (this.applicationPropertyFileName == null) {
            throw new IOException("asked to store properties but no applicationPropertyFileName was ever set");
        }
        String string2 = ApplicationFrame.makePathToFileInUsersHomeDirectory(this.applicationPropertyFileName);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        this.applicationProperties.store(fileOutputStream, string);
        fileOutputStream.close();
    }

    protected Properties getProperties() {
        return this.applicationProperties;
    }

    protected String getApplicationPropertyFileName() {
        return this.applicationPropertyFileName;
    }

    protected void setApplicationPropertyFileName(String string) {
        this.applicationPropertyFileName = string;
    }

    public static String getPropertyInsistently(Properties properties, String string) throws Exception {
        String string2 = properties.getProperty(string);
        if (string2 == null || string2.length() == 0) {
            throw new Exception("Properties do not contain value for " + string);
        }
        return string2;
    }

    public String getPropertyInsistently(String string) throws Exception {
        return ApplicationFrame.getPropertyInsistently(this.applicationProperties, string);
    }

    public static String getPropertyOrDefaultAndAddIt(Properties properties, String string, String string2) {
        String string3 = string2;
        String string4 = properties.getProperty(string);
        if (string4 == null) {
            properties.setProperty(string, string3);
        } else {
            string3 = string4;
        }
        return string3;
    }

    public String getPropertyOrDefaultAndAddIt(String string, String string2) {
        return ApplicationFrame.getPropertyOrDefaultAndAddIt(this.applicationProperties, string, string2);
    }

    public static boolean getBooleanPropertyOrDefaultAndAddIt(Properties properties, String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            properties.setProperty(string, Boolean.toString(bl2));
        } else {
            bl2 = Boolean.parseBoolean(string2);
        }
        return bl2;
    }

    public boolean getBooleanPropertyOrDefaultAndAddIt(String string, boolean bl) {
        return ApplicationFrame.getBooleanPropertyOrDefaultAndAddIt(this.applicationProperties, string, bl);
    }

    public static int getIntegerPropertyOrDefaultAndAddIt(Properties properties, String string, int n) {
        int n2 = n;
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            properties.setProperty(string, Integer.toString(n2));
        } else {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                slf4jlogger.error("", numberFormatException);
            }
        }
        return n2;
    }

    public int getIntegerPropertyOrDefaultAndAddIt(String string, int n) {
        return ApplicationFrame.getIntegerPropertyOrDefaultAndAddIt(this.applicationProperties, string, n);
    }

    protected File takeSnapShot(Rectangle rectangle) {
        File file = null;
        try {
            file = File.createTempFile("snap", ".jpg", new File(System.getProperty("user.home")));
            BufferedImage bufferedImage = new Robot().createScreenCapture(rectangle);
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file;
    }

    public ApplicationFrame() {
        this("Application Frame", (String)null);
    }

    public ApplicationFrame(int n) {
        this("Application Frame", null, n);
    }

    public ApplicationFrame(String string) {
        this(string, (String)null);
    }

    public ApplicationFrame(String string, int n) {
        this(string, null, n);
    }

    public ApplicationFrame(String string, String string2) {
        this(string, string2, 3);
    }

    public ApplicationFrame(String string, String string2, int n) {
        this.setApplicationPropertyFileName(string2);
        this.loadProperties();
        if (string != null) {
            this.setTitle(string);
        }
        this.createGUI();
        this.setDefaultCloseOperation(n);
    }

    public ApplicationFrame(String string, String string2, int n, int n2) {
        this(string, string2, n, n2, 3);
    }

    public ApplicationFrame(String string, String string2, int n, int n2, int n3) {
        this.setApplicationPropertyFileName(string2);
        this.loadProperties();
        if (string != null) {
            this.setTitle(string);
        }
        this.createGUI();
        this.setSize(n, n2);
        this.setDefaultCloseOperation(n3);
    }

    public static void setInternationalizedFontsForGUI() {
        slf4jlogger.debug("ApplicationFrame.setInternationalizedFontsForGUI()");
        Font font = new Font("Arial Unicode MS", 0, 12);
        if (!(font != null && font.getFamily().equals("Arial Unicode MS") || (font = new Font("Bitstream Cyberbit", 0, 13)) != null && font.getFamily().equals("Bitstream Cyberbit"))) {
            font = null;
        }
        if (font == null) {
            System.err.println("Warning: couldn't set internationalized font: non-Latin values may not display properly");
        } else {
            slf4jlogger.debug("Using internationalized font {}", font);
            UIManager.put("Tree.font", font);
            UIManager.put("Table.font", font);
        }
    }

    public static void setBackgroundForGUI() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        slf4jlogger.debug("setBackgroundForGUI(): L&F is {}", string);
        if (UIManager.getLookAndFeel().getClass().getName().equals("com.apple.laf.AquaLookAndFeel")) {
            UIManager.put("Panel.background", Color.lightGray);
            UIManager.put("CheckBox.background", Color.lightGray);
            UIManager.put("SplitPane.background", Color.lightGray);
        }
    }

    public static void setPreferredLookAndFeelForPlatform() {
        try {
            String string = System.getProperty("os.name");
            if (string != null && string.toLowerCase(Locale.US).startsWith("windows")) {
                slf4jlogger.debug("ApplicationFrame.setPreferredLookAndFeelForPlatform(): detected Windows - using Windows LAF");
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    protected void createGUI() {
        slf4jlogger.debug("ApplicationFrame.createGUI()");
        ApplicationFrame.setPreferredLookAndFeelForPlatform();
        ApplicationFrame.localizeJOptionPane();
        ApplicationFrame.setBackgroundForGUI();
        ApplicationFrame.setInternationalizedFontsForGUI();
    }

    public static void main(String[] stringArray) {
        ApplicationFrame applicationFrame = new ApplicationFrame();
        applicationFrame.setVisible(true);
    }
}

