/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CompressedFrameDecoder;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.display.ImageEditUtilities;
import com.pixelmed.display.SafeCursorChanger;
import com.pixelmed.display.SafeFileChooser;
import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SingleImagePanelWithRegionDrawing;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.event.FrameSelectionChangeEvent;
import com.pixelmed.display.event.GraphicDisplayChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.Event;
import com.pixelmed.event.EventContext;
import com.pixelmed.event.SelfRegisteringListener;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CapabilitiesAvailable;
import com.pixelmed.utils.FileUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DicomImageBlackout
extends JFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/DicomImageBlackout.java,v 1.68 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DicomImageBlackout.class);
    protected static String resourceBundleName = "com.pixelmed.display.DicomImageBlackout";
    protected ResourceBundle resourceBundle = ResourceBundle.getBundle(resourceBundleName);
    protected String ourAETitle = "OURAETITLE";
    private static final Dimension maximumMultiPanelDimension = new Dimension(800, 600);
    private static final double splitPaneResizeWeight = 0.9;
    protected String[] dicomFileNames;
    protected String currentFileName;
    protected int currentFileNumber;
    protected Box mainPanel;
    protected JPanel multiPanel;
    protected SingleImagePanel imagePanel;
    protected AttributeList list;
    protected SourceImage sImg;
    protected boolean changesWereMade;
    protected boolean usedjpegblockredaction;
    protected boolean deferredDecompression;
    protected File redactedJPEGFile;
    protected int previousRows;
    protected int previousColumns;
    protected Vector previousPersistentDrawingShapes;
    protected JPanel cineSliderControlsPanel;
    protected CineSliderChangeListener cineSliderChangeListener;
    protected JSlider cineSlider;
    protected JLabel imagesRemainingLabel;
    protected EventContext ourEventContext;
    protected boolean burnInOverlays;
    protected boolean useZeroBlackoutValue;
    protected boolean usePixelPaddingBlackoutValue;
    protected JCheckBox useZeroBlackoutValueCheckBox;
    protected JCheckBox usePixelPaddingBlackoutValueCheckBox;
    protected OurFrameSelectionChangeListener ourFrameSelectionChangeListener;
    protected int burnedinflag;
    protected StatusNotificationHandler statusNotificationHandler;
    protected ApplyActionListener applyActionListener;
    protected SaveActionListener saveActionListener;
    protected NextActionListener nextActionListener;
    protected PreviousActionListener previousActionListener;
    protected JButton blackoutApplyButton;
    protected JButton blackoutSaveButton;
    protected JButton blackoutNextButton;
    protected JButton blackoutPreviousButton;

    protected void recordStateOfDrawingShapesForFileChange() {
        this.previousRows = this.sImg.getHeight();
        this.previousColumns = this.sImg.getWidth();
        this.previousPersistentDrawingShapes = this.imagePanel.getPersistentDrawingShapes();
    }

    protected void createCineSliderIfNecessary(int n, int n2, int n3) {
        if (this.cineSlider == null || n != this.cineSlider.getMinimum() || n2 != this.cineSlider.getMaximum()) {
            this.cineSliderControlsPanel.removeAll();
            if (n2 > n) {
                this.cineSlider = new JSlider(n, n2, n3);
                this.cineSlider.setLabelTable(this.cineSlider.createStandardLabels(n2 - 1, n));
                this.cineSlider.setPaintLabels(true);
                this.cineSliderControlsPanel.add(this.cineSlider);
                this.cineSlider.addChangeListener(this.cineSliderChangeListener);
            } else {
                this.cineSlider = null;
            }
        }
        if (this.cineSlider != null && this.cineSlider.getValue() != n3) {
            this.cineSlider.setValue(n3);
        }
    }

    protected void updateDisplayedFileNumber(int n, int n2) {
        if (this.imagesRemainingLabel != null) {
            this.imagesRemainingLabel.setText(Integer.toString(n + 1) + " of " + Integer.toString(n2));
        }
    }

    protected void loadDicomFileOrDirectory(String string) {
        try {
            File file = FileUtilities.getFileFromNameInsensitiveToCaseIfNecessary(string);
            this.loadDicomFileOrDirectory(file);
        }
        catch (Exception exception) {
            slf4jlogger.error("Read failed", exception);
            if (this.statusNotificationHandler != null) {
                this.statusNotificationHandler.notify(7, "Read failed", exception);
            }
            this.dispose();
        }
    }

    protected void loadDicomFileOrDirectory(File file) {
        block7: {
            this.changesWereMade = false;
            SingleImagePanel.deconstructAllSingleImagePanelsInContainer(this.multiPanel);
            this.multiPanel.removeAll();
            this.multiPanel.revalidate();
            this.multiPanel.repaint();
            SafeCursorChanger safeCursorChanger = new SafeCursorChanger(this);
            safeCursorChanger.setWaitCursor();
            try {
                slf4jlogger.info("loadDicomFileOrDirectory(): Open {}", file);
                this.currentFileName = file.getAbsolutePath();
                this.deferredDecompression = CompressedFrameDecoder.canDecompress(file);
                slf4jlogger.info("loadDicomFileOrDirectory(): deferredDecompression {}", this.deferredDecompression);
                DicomInputStream dicomInputStream = new DicomInputStream(file);
                this.list = new AttributeList();
                this.list.setDecompressPixelData(!this.deferredDecompression);
                this.list.read(dicomInputStream);
                dicomInputStream.close();
                String string = Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.SOPClassUID);
                if (SOPClass.isImageStorage(string)) {
                    this.sImg = new SourceImage(this.list);
                    this.imagePanel = new SingleImagePanelWithRegionDrawing(this.sImg, this.ourEventContext);
                    this.imagePanel.setShowOverlays(this.burnInOverlays);
                    this.imagePanel.setApplyShutter(false);
                    this.addSingleImagePanelToMultiPanelAndEstablishLayout();
                    this.createCineSliderIfNecessary(1, Attribute.getSingleIntegerValueOrDefault(this.list, TagFromName.NumberOfFrames, 1), 1);
                    safeCursorChanger.restoreCursor();
                    this.showUIComponents();
                    if (this.previousPersistentDrawingShapes != null) {
                        if (this.previousRows == this.sImg.getHeight() && this.previousColumns == this.sImg.getWidth()) {
                            this.imagePanel.setPersistentDrawingShapes(this.previousPersistentDrawingShapes);
                        } else {
                            this.previousRows = 0;
                            this.previousColumns = 0;
                            this.previousPersistentDrawingShapes = null;
                        }
                    }
                    break block7;
                }
                throw new DicomException("unsupported SOP Class " + string);
            }
            catch (Exception exception) {
                slf4jlogger.error("Read failed", exception);
                if (this.statusNotificationHandler != null) {
                    this.statusNotificationHandler.notify(7, "Read failed", exception);
                }
                safeCursorChanger.restoreCursor();
                this.dispose();
            }
        }
    }

    protected double getScaleFactorToFitInMaximumAvailable(double d, double d2, double d3, double d4) {
        double d5 = d3 / d;
        double d6 = d4 / d2;
        double d7 = d5 < d6 ? d5 : d6;
        return d7;
    }

    protected Dimension changeDimensionToFitInMaximumAvailable(Dimension dimension, Dimension dimension2, boolean bl) {
        double d;
        double d2;
        double d3;
        double d4 = dimension.getWidth();
        double d5 = this.getScaleFactorToFitInMaximumAvailable(d4, d3 = dimension.getHeight(), d2 = dimension2.getWidth(), d = dimension2.getHeight());
        if (d5 < 1.0 || !bl) {
            d4 *= d5;
            d3 *= d5;
        }
        dimension = new Dimension((int)d4, (int)d3);
        return dimension;
    }

    protected Dimension reduceDimensionToFitInMaximumAvailable(Dimension dimension) {
        return this.changeDimensionToFitInMaximumAvailable(dimension, maximumMultiPanelDimension, true);
    }

    protected void addSingleImagePanelToMultiPanelAndEstablishLayout() {
        this.addSingleImagePanelToMultiPanelAndEstablishLayoutWithCenterMaximumAfterInitialSizeLayout();
    }

    protected void addSingleImagePanelToMultiPanelAndEstablishLayoutWithCenterMaximumAfterInitialSizeLayout() {
        Dimension dimension = this.reduceDimensionToFitInMaximumAvailable(this.sImg.getDimension());
        this.imagePanel.setPreferredSize(dimension);
        this.imagePanel.setMinimumSize(dimension);
        this.multiPanel.setPreferredSize(dimension);
        this.multiPanel.setMinimumSize(dimension);
        CenterMaximumAfterInitialSizeLayout centerMaximumAfterInitialSizeLayout = new CenterMaximumAfterInitialSizeLayout();
        this.multiPanel.setLayout(centerMaximumAfterInitialSizeLayout);
        this.multiPanel.setBackground(Color.black);
        this.multiPanel.add(this.imagePanel);
    }

    protected void showUIComponents() {
        this.remove(this.mainPanel);
        this.add(this.mainPanel);
        this.pack();
        this.validate();
        this.setVisible(true);
        this.imagePanel.setMinimumSize(null);
        this.multiPanel.setMinimumSize(null);
    }

    protected void buildUIComponents() {
        this.ourEventContext = new EventContext("Blackout Panel");
        this.multiPanel = new JPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        this.burnInOverlays = false;
        this.useZeroBlackoutValue = false;
        this.usePixelPaddingBlackoutValue = true;
        JCheckBox jCheckBox = new JCheckBox(this.resourceBundle.getString("keepOverlaysCheckBoxLabelText"), this.burnInOverlays);
        jCheckBox.setToolTipText(this.resourceBundle.getString("keepOverlaysCheckBoxToolTipText"));
        jCheckBox.setMnemonic(79);
        jPanel.add(jCheckBox);
        jCheckBox.addChangeListener(new OverlaysChangeListener(this, this.ourEventContext));
        this.usePixelPaddingBlackoutValueCheckBox = new JCheckBox(this.resourceBundle.getString("usePixelPaddingBlackoutValueCheckBoxLabelText"), this.usePixelPaddingBlackoutValue);
        this.usePixelPaddingBlackoutValueCheckBox.setToolTipText(this.resourceBundle.getString("usePixelPaddingBlackoutValueCheckBoxToolTipText"));
        this.usePixelPaddingBlackoutValueCheckBox.setMnemonic(80);
        jPanel.add(this.usePixelPaddingBlackoutValueCheckBox);
        this.usePixelPaddingBlackoutValueCheckBox.addChangeListener(new PixelPaddingBlackoutValueChangeListener(this, this.ourEventContext));
        this.useZeroBlackoutValueCheckBox = new JCheckBox(this.resourceBundle.getString("useZeroBlackoutValueCheckBoxLabelText"), this.useZeroBlackoutValue);
        this.useZeroBlackoutValueCheckBox.setToolTipText(this.resourceBundle.getString("useZeroBlackoutValueCheckBoxToolTipText"));
        this.useZeroBlackoutValueCheckBox.setMnemonic(90);
        jPanel.add(this.useZeroBlackoutValueCheckBox);
        this.useZeroBlackoutValueCheckBox.addChangeListener(new ZeroBlackoutValueChangeListener(this, this.ourEventContext));
        this.blackoutPreviousButton = new JButton(this.resourceBundle.getString("blackoutPreviousButtonLabelText"));
        this.blackoutPreviousButton.setToolTipText(this.resourceBundle.getString("blackoutPreviousButtonToolTipText"));
        jPanel.add(this.blackoutPreviousButton);
        this.previousActionListener = new PreviousActionListener(this);
        this.blackoutPreviousButton.addActionListener(this.previousActionListener);
        this.blackoutApplyButton = new JButton(this.resourceBundle.getString("blackoutApplyButtonLabelText"));
        this.blackoutApplyButton.setToolTipText(this.resourceBundle.getString("blackoutApplyButtonToolTipText"));
        jPanel.add(this.blackoutApplyButton);
        this.applyActionListener = new ApplyActionListener(this);
        this.blackoutApplyButton.addActionListener(this.applyActionListener);
        this.blackoutSaveButton = new JButton(this.resourceBundle.getString("blackoutSaveButtonLabelText"));
        this.blackoutSaveButton.setToolTipText(this.resourceBundle.getString("blackoutSaveButtonToolTipText"));
        jPanel.add(this.blackoutSaveButton);
        this.saveActionListener = new SaveActionListener(this);
        this.blackoutSaveButton.addActionListener(this.saveActionListener);
        this.blackoutNextButton = new JButton(this.resourceBundle.getString("blackoutNextButtonLabelText"));
        this.blackoutNextButton.setToolTipText(this.resourceBundle.getString("blackoutNextButtonToolTipText"));
        jPanel.add(this.blackoutNextButton);
        this.nextActionListener = new NextActionListener(this);
        this.blackoutNextButton.addActionListener(this.nextActionListener);
        JButton jButton = new JButton(this.resourceBundle.getString("blackoutApplySaveAllButtonLabelText"));
        jButton.setToolTipText(this.resourceBundle.getString("blackoutApplySaveAllButtonToolTipText"));
        jPanel.add(jButton);
        jButton.addActionListener(new ApplySaveAllActionListener(this));
        this.imagesRemainingLabel = new JLabel("0 of 0");
        jPanel.add(this.imagesRemainingLabel);
        JButton jButton2 = new JButton(this.resourceBundle.getString("blackoutCancelButtonLabelText"));
        jButton2.setToolTipText(this.resourceBundle.getString("blackoutCancelButtonToolTipText"));
        jPanel.add(jButton2);
        jButton2.addActionListener(new CancelActionListener(this));
        this.cineSliderControlsPanel = new JPanel();
        jPanel.add(this.cineSliderControlsPanel);
        this.cineSliderChangeListener = new CineSliderChangeListener();
        this.ourFrameSelectionChangeListener = new OurFrameSelectionChangeListener(this.ourEventContext);
        JSplitPane jSplitPane = new JSplitPane(0, this.multiPanel, jPanel);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setResizeWeight(0.9);
        JLabel jLabel = new JLabel(this.resourceBundle.getString("statusBarHelpText"));
        this.mainPanel = new Box(1);
        this.mainPanel.add(jSplitPane);
        this.mainPanel.add(jLabel);
    }

    public DicomImageBlackout(String[] stringArray, StatusNotificationHandler statusNotificationHandler, int n) {
        this(null, stringArray, statusNotificationHandler, n);
    }

    public DicomImageBlackout(String string, String[] stringArray, StatusNotificationHandler statusNotificationHandler, int n) {
        super(string);
        String string2;
        if (string == null) {
            this.setTitle(this.resourceBundle.getString("applicationTitle"));
        }
        if ((string2 = System.getProperty("os.name")) != null && string2.toLowerCase().startsWith("windows")) {
            slf4jlogger.info("disabling memory mapping for SourceImage on Windows platform");
            SourceImage.setAllowMemoryMapping(false);
        }
        this.statusNotificationHandler = statusNotificationHandler == null ? new DefaultStatusNotificationHandler() : statusNotificationHandler;
        this.burnedinflag = n;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (DicomImageBlackout.this.statusNotificationHandler != null) {
                    DicomImageBlackout.this.statusNotificationHandler.notify(1, "Window closed", null);
                }
                DicomImageBlackout.this.dispose();
            }
        });
        this.buildUIComponents();
        if (stringArray == null || stringArray.length == 0) {
            string2 = null;
            SafeFileChooser.SafeFileChooserThread safeFileChooserThread = new SafeFileChooser.SafeFileChooserThread();
            try {
                EventQueue.invokeAndWait(safeFileChooserThread);
                string2 = safeFileChooserThread.getSelectedFileName();
            }
            catch (InterruptedException interruptedException) {
                slf4jlogger.error("", interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                slf4jlogger.error("", invocationTargetException);
            }
            if (string2 != null) {
                String[] stringArray2 = new String[]{string2};
                stringArray = stringArray2;
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            this.dicomFileNames = stringArray;
            this.currentFileNumber = 0;
            this.updateDisplayedFileNumber(this.currentFileNumber, stringArray.length);
            this.loadDicomFileOrDirectory(stringArray[this.currentFileNumber]);
        }
    }

    public void deconstruct() {
        if (this.ourFrameSelectionChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourFrameSelectionChangeListener);
            this.ourFrameSelectionChangeListener = null;
        }
        if (this.multiPanel != null) {
            SingleImagePanel.deconstructAllSingleImagePanelsInContainer(this.multiPanel);
        }
    }

    @Override
    public void dispose() {
        this.deconstruct();
        super.dispose();
    }

    protected void finalize() throws Throwable {
        this.deconstruct();
        super.finalize();
    }

    public static void main(String[] stringArray) {
        ApplicationFrame.setInternationalizedFontsForGUI();
        ApplicationFrame.setBackgroundForGUI();
        new DicomImageBlackout(stringArray, null, 4);
    }

    protected class CenterMaximumAfterInitialSizeLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n;
                Insets insets = container.getInsets();
                int n2 = container.getComponentCount();
                Dimension dimension = container.getSize();
                int n3 = 0;
                int n4 = 0;
                for (n = 0; n < n2; ++n) {
                    Component component = container.getComponent(n);
                    Dimension dimension2 = component.getPreferredSize();
                    n3 = (int)((double)n3 + dimension2.getWidth());
                    n4 = (int)((double)n4 + dimension2.getHeight());
                }
                n = dimension.width - (insets.left + insets.right);
                int n5 = dimension.height - (insets.top + insets.bottom);
                int n6 = 0;
                int n7 = 0;
                boolean bl = false;
                double d = 1.0;
                if (n3 == n && n4 <= n5 || n3 <= n && n4 == n5) {
                    n6 = (n - n3) / 2;
                    n7 = (n5 - n4) / 2;
                } else {
                    bl = true;
                    d = DicomImageBlackout.this.getScaleFactorToFitInMaximumAvailable(n3, n4, n, n5);
                    n6 = (int)(((double)n - (double)n3 * d) / 2.0);
                    n7 = (int)(((double)n5 - (double)n4 * d) / 2.0);
                }
                for (int i = 0; i < n2; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension3 = component.getPreferredSize();
                    int n8 = dimension3.width;
                    int n9 = dimension3.height;
                    if (bl) {
                        n8 = (int)((double)n8 * d);
                        n9 = (int)((double)n9 * d);
                    }
                    component.setBounds(n6, n7, n8, n9);
                    n6 += n8;
                    n7 += n9;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Insets insets = container.getInsets();
                int n = container.getComponentCount();
                int n2 = insets.left + insets.right;
                int n3 = insets.top + insets.bottom;
                for (int i = 0; i < n; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension = component.getMinimumSize();
                    n2 = (int)((double)n2 + dimension.getWidth());
                    n3 = (int)((double)n3 + dimension.getHeight());
                }
                return new Dimension(n2, n3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Insets insets = container.getInsets();
                int n = container.getComponentCount();
                int n2 = insets.left + insets.right;
                int n3 = insets.top + insets.bottom;
                for (int i = 0; i < n; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension = component.getPreferredSize();
                    n2 = (int)((double)n2 + dimension.getWidth());
                    n3 = (int)((double)n3 + dimension.getHeight());
                }
                return new Dimension(n2, n3);
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }
    }

    protected class PixelPaddingBlackoutValueChangeListener
    implements ChangeListener {
        DicomImageBlackout application;
        EventContext eventContext;

        public PixelPaddingBlackoutValueChangeListener(DicomImageBlackout dicomImageBlackout2, EventContext eventContext) {
            this.application = dicomImageBlackout2;
            this.eventContext = eventContext;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent != null && changeEvent.getSource() instanceof JCheckBox) {
                this.application.usePixelPaddingBlackoutValue = ((JCheckBox)changeEvent.getSource()).isSelected();
                if (this.application.usePixelPaddingBlackoutValue) {
                    this.application.useZeroBlackoutValue = false;
                    this.application.useZeroBlackoutValueCheckBox.setSelected(this.application.useZeroBlackoutValue);
                }
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new GraphicDisplayChangeEvent(this.eventContext, this.application.usePixelPaddingBlackoutValue));
            }
        }
    }

    protected class ZeroBlackoutValueChangeListener
    implements ChangeListener {
        DicomImageBlackout application;
        EventContext eventContext;

        public ZeroBlackoutValueChangeListener(DicomImageBlackout dicomImageBlackout2, EventContext eventContext) {
            this.application = dicomImageBlackout2;
            this.eventContext = eventContext;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent != null && changeEvent.getSource() instanceof JCheckBox) {
                this.application.useZeroBlackoutValue = ((JCheckBox)changeEvent.getSource()).isSelected();
                if (this.application.useZeroBlackoutValue) {
                    this.application.usePixelPaddingBlackoutValue = false;
                    this.application.usePixelPaddingBlackoutValueCheckBox.setSelected(this.application.usePixelPaddingBlackoutValue);
                }
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new GraphicDisplayChangeEvent(this.eventContext, this.application.useZeroBlackoutValue));
            }
        }
    }

    protected class OverlaysChangeListener
    implements ChangeListener {
        DicomImageBlackout application;
        EventContext eventContext;

        public OverlaysChangeListener(DicomImageBlackout dicomImageBlackout2, EventContext eventContext) {
            this.application = dicomImageBlackout2;
            this.eventContext = eventContext;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent != null && changeEvent.getSource() instanceof JCheckBox) {
                this.application.burnInOverlays = ((JCheckBox)changeEvent.getSource()).isSelected();
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new GraphicDisplayChangeEvent(this.eventContext, this.application.burnInOverlays));
            }
        }
    }

    protected class CancelActionListener
    implements ActionListener {
        DicomImageBlackout application;

        public CancelActionListener(DicomImageBlackout dicomImageBlackout2) {
            this.application = dicomImageBlackout2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.application.statusNotificationHandler != null) {
                this.application.statusNotificationHandler.notify(2, "Cancelled", null);
            }
            this.application.dispose();
        }
    }

    protected class ApplySaveAllActionListener
    implements ActionListener {
        DicomImageBlackout application;

        public ApplySaveAllActionListener(DicomImageBlackout dicomImageBlackout2) {
            this.application = dicomImageBlackout2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            do {
                DicomImageBlackout.this.applyActionListener.actionPerformed(null);
                DicomImageBlackout.this.saveActionListener.actionPerformed(null);
                DicomImageBlackout.this.nextActionListener.actionPerformed(null);
            } while (DicomImageBlackout.this.dicomFileNames != null && DicomImageBlackout.this.currentFileNumber < DicomImageBlackout.this.dicomFileNames.length);
        }
    }

    protected class PreviousActionListener
    implements ActionListener {
        DicomImageBlackout application;

        public PreviousActionListener(DicomImageBlackout dicomImageBlackout2) {
            this.application = dicomImageBlackout2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DicomImageBlackout.this.recordStateOfDrawingShapesForFileChange();
            if (DicomImageBlackout.this.changesWereMade && this.application.statusNotificationHandler != null) {
                this.application.statusNotificationHandler.notify(5, "Changes were applied to " + DicomImageBlackout.this.dicomFileNames[DicomImageBlackout.this.currentFileNumber] + " but were discarded and not saved", null);
            }
            --DicomImageBlackout.this.currentFileNumber;
            if (DicomImageBlackout.this.dicomFileNames != null && DicomImageBlackout.this.currentFileNumber >= 0) {
                DicomImageBlackout.this.updateDisplayedFileNumber(DicomImageBlackout.this.currentFileNumber, DicomImageBlackout.this.dicomFileNames.length);
                DicomImageBlackout.this.loadDicomFileOrDirectory(DicomImageBlackout.this.dicomFileNames[DicomImageBlackout.this.currentFileNumber]);
            } else {
                if (this.application.statusNotificationHandler != null) {
                    this.application.statusNotificationHandler.notify(3, "Normal completion", null);
                }
                this.application.dispose();
            }
        }
    }

    protected class NextActionListener
    implements ActionListener {
        DicomImageBlackout application;

        public NextActionListener(DicomImageBlackout dicomImageBlackout2) {
            this.application = dicomImageBlackout2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DicomImageBlackout.this.recordStateOfDrawingShapesForFileChange();
            if (DicomImageBlackout.this.changesWereMade && this.application.statusNotificationHandler != null) {
                this.application.statusNotificationHandler.notify(5, "Changes were applied to " + DicomImageBlackout.this.dicomFileNames[DicomImageBlackout.this.currentFileNumber] + " but were discarded and not saved", null);
            }
            ++DicomImageBlackout.this.currentFileNumber;
            if (DicomImageBlackout.this.dicomFileNames != null && DicomImageBlackout.this.currentFileNumber < DicomImageBlackout.this.dicomFileNames.length) {
                DicomImageBlackout.this.updateDisplayedFileNumber(DicomImageBlackout.this.currentFileNumber, DicomImageBlackout.this.dicomFileNames.length);
                DicomImageBlackout.this.loadDicomFileOrDirectory(DicomImageBlackout.this.dicomFileNames[DicomImageBlackout.this.currentFileNumber]);
            } else {
                if (this.application.statusNotificationHandler != null) {
                    this.application.statusNotificationHandler.notify(3, "Normal completion", null);
                }
                this.application.dispose();
            }
        }
    }

    protected class SaveActionListener
    implements ActionListener {
        DicomImageBlackout application;
        SafeCursorChanger cursorChanger;

        public SaveActionListener(DicomImageBlackout dicomImageBlackout2) {
            this.application = dicomImageBlackout2;
            this.cursorChanger = new SafeCursorChanger(dicomImageBlackout2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            long l = System.currentTimeMillis();
            DicomImageBlackout.this.recordStateOfDrawingShapesForFileChange();
            this.cursorChanger.setWaitCursor();
            boolean bl = true;
            try {
                this.application.sImg.close();
                this.application.sImg = null;
                System.gc();
                System.runFinalization();
                System.gc();
            }
            catch (Throwable throwable) {
                if (this.application.statusNotificationHandler != null) {
                    this.application.statusNotificationHandler.notify(4, "Save failed - unable to close image - not saving modifications", throwable);
                }
                bl = false;
            }
            File file = new File(DicomImageBlackout.this.currentFileName);
            File file2 = new File(DicomImageBlackout.this.currentFileName + ".new");
            if (bl) {
                block21: {
                    String string = Attribute.getSingleStringValueOrEmptyString(DicomImageBlackout.this.list, TagFromName.TransferSyntaxUID);
                    try {
                        Object object;
                        String string2 = null;
                        if (DicomImageBlackout.this.usedjpegblockredaction && DicomImageBlackout.this.redactedJPEGFile != null) {
                            object = new DicomInputStream(DicomImageBlackout.this.redactedJPEGFile);
                            DicomImageBlackout.this.list = new AttributeList();
                            DicomImageBlackout.this.list.setDecompressPixelData(false);
                            DicomImageBlackout.this.list.read((DicomInputStream)object);
                            ((FilterInputStream)object).close();
                            string2 = "1.2.840.10008.1.2.4.50";
                        } else {
                            string2 = "1.2.840.10008.1.2.1";
                            DicomImageBlackout.this.list.correctDecompressedImagePixelModule(DicomImageBlackout.this.deferredDecompression);
                            DicomImageBlackout.this.list.insertLossyImageCompressionHistoryIfDecompressed(DicomImageBlackout.this.deferredDecompression);
                        }
                        if (DicomImageBlackout.this.burnedinflag != 1) {
                            DicomImageBlackout.this.list.remove(TagFromName.BurnedInAnnotation);
                            if (DicomImageBlackout.this.burnedinflag == 4 || DicomImageBlackout.this.burnedinflag == 3 && DicomImageBlackout.this.changesWereMade) {
                                object = new CodeStringAttribute(TagFromName.BurnedInAnnotation);
                                ((Attribute)object).addValue("NO");
                                DicomImageBlackout.this.list.put((Attribute)object);
                            }
                        }
                        if (DicomImageBlackout.this.changesWereMade) {
                            object = DicomImageBlackout.this.list.get(TagFromName.DeidentificationMethod);
                            if (object == null) {
                                object = new LongStringAttribute(TagFromName.DeidentificationMethod);
                                DicomImageBlackout.this.list.put((Attribute)object);
                            }
                            if (this.application.burnInOverlays) {
                                ((Attribute)object).addValue("Overlays burned in then blacked out");
                            }
                            ((Attribute)object).addValue("Burned in text blacked out");
                            object = (SequenceAttribute)DicomImageBlackout.this.list.get(TagFromName.DeidentificationMethodCodeSequence);
                            if (object == null) {
                                object = new SequenceAttribute(TagFromName.DeidentificationMethodCodeSequence);
                                DicomImageBlackout.this.list.put((Attribute)object);
                            }
                            ((SequenceAttribute)object).addItem(new CodedSequenceItem("113101", "DCM", "Clean Pixel Data Option").getAttributeList());
                        }
                        DicomImageBlackout.this.list.removeGroupLengthAttributes();
                        DicomImageBlackout.this.list.removeMetaInformationHeaderAttributes();
                        DicomImageBlackout.this.list.remove(TagFromName.DataSetTrailingPadding);
                        FileMetaInformation.addFileMetaInformation(DicomImageBlackout.this.list, string2, DicomImageBlackout.this.ourAETitle);
                        DicomImageBlackout.this.list.write(file2, string2, true, true);
                        DicomImageBlackout.this.list = null;
                        try {
                            file.delete();
                            FileUtilities.renameElseCopyTo(file2, file);
                        }
                        catch (IOException iOException) {
                            if (this.application.statusNotificationHandler != null) {
                                this.application.statusNotificationHandler.notify(4, "Save failed - unable to rename or copy " + file2 + " to " + file + " - not saving modifications", iOException);
                            }
                            bl = false;
                        }
                        if (DicomImageBlackout.this.redactedJPEGFile != null) {
                            DicomImageBlackout.this.redactedJPEGFile.delete();
                            DicomImageBlackout.this.redactedJPEGFile = null;
                        }
                        DicomImageBlackout.this.usedjpegblockredaction = false;
                        DicomImageBlackout.this.changesWereMade = false;
                        if (this.application.statusNotificationHandler != null) {
                            this.application.statusNotificationHandler.notify(6, "Save of " + DicomImageBlackout.this.currentFileName + " succeeded", null);
                        }
                    }
                    catch (DicomException dicomException) {
                        slf4jlogger.error("Save failed", dicomException);
                        if (this.application.statusNotificationHandler != null) {
                            this.application.statusNotificationHandler.notify(4, "Save failed", dicomException);
                        }
                    }
                    catch (IOException iOException) {
                        slf4jlogger.error("Save failed", iOException);
                        if (this.application.statusNotificationHandler == null) break block21;
                        this.application.statusNotificationHandler.notify(4, "Save failed", iOException);
                    }
                }
                slf4jlogger.info("SaveActionListener.actionPerformed(): time to save = {}", System.currentTimeMillis() - l);
            }
            DicomImageBlackout.this.loadDicomFileOrDirectory(file);
            slf4jlogger.info("SaveActionListener.actionPerformed(): total time including reload for display = {}", System.currentTimeMillis() - l);
            this.cursorChanger.restoreCursor();
        }
    }

    protected class ApplyActionListener
    implements ActionListener {
        DicomImageBlackout application;
        SafeCursorChanger cursorChanger;

        public ApplyActionListener(DicomImageBlackout dicomImageBlackout2) {
            this.application = dicomImageBlackout2;
            this.cursorChanger = new SafeCursorChanger(dicomImageBlackout2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Vector vector;
            long l = System.currentTimeMillis();
            DicomImageBlackout.this.recordStateOfDrawingShapesForFileChange();
            this.cursorChanger.setWaitCursor();
            if (this.application.imagePanel != null && this.application.sImg != null && this.application.list != null && this.application.imagePanel != null && ((vector = this.application.imagePanel.getPersistentDrawingShapes()) != null && vector.size() > 0 || this.application.burnInOverlays)) {
                DicomImageBlackout.this.changesWereMade = true;
                String string = Attribute.getSingleStringValueOrEmptyString(DicomImageBlackout.this.list, TagFromName.TransferSyntaxUID);
                try {
                    if (string.equals("1.2.840.10008.1.2.4.50") && !this.application.burnInOverlays && CapabilitiesAvailable.haveJPEGBaselineSelectiveBlockRedaction()) {
                        slf4jlogger.info("ApplyActionListener.actionPerformed(): Blackout JPEG blocks");
                        DicomImageBlackout.this.usedjpegblockredaction = true;
                        if (DicomImageBlackout.this.redactedJPEGFile != null) {
                            DicomImageBlackout.this.redactedJPEGFile.delete();
                        }
                        DicomImageBlackout.this.redactedJPEGFile = File.createTempFile("DicomImageBlackout", ".dcm");
                        ImageEditUtilities.blackoutJPEGBlocks(new File(this.application.currentFileName), DicomImageBlackout.this.redactedJPEGFile, vector);
                        DicomInputStream dicomInputStream = new DicomInputStream(DicomImageBlackout.this.redactedJPEGFile);
                        DicomImageBlackout.this.list = new AttributeList();
                        DicomImageBlackout.this.list.setDecompressPixelData(!CompressedFrameDecoder.canDecompress(DicomImageBlackout.this.redactedJPEGFile));
                        DicomImageBlackout.this.list.read(dicomInputStream);
                        dicomInputStream.close();
                        slf4jlogger.info("ApplyActionListener.actionPerformed(): Create new source image after blackout of JPEG blocks");
                        this.application.sImg = new SourceImage(this.application.list);
                    } else {
                        slf4jlogger.info("ApplyActionListener.actionPerformed(): Blackout decompressed image");
                        DicomImageBlackout.this.usedjpegblockredaction = false;
                        ImageEditUtilities.blackout(this.application.sImg, this.application.list, vector, this.application.burnInOverlays, this.application.usePixelPaddingBlackoutValue, this.application.useZeroBlackoutValue, 0);
                    }
                    this.application.imagePanel.dirty(this.application.sImg);
                    this.application.imagePanel.repaint();
                }
                catch (Exception exception) {
                    slf4jlogger.error("Blackout failed", exception);
                    if (this.application.statusNotificationHandler != null) {
                        this.application.statusNotificationHandler.notify(8, "Blackout failed", exception);
                    }
                    this.application.dispose();
                }
            }
            slf4jlogger.info("ApplyActionListener.actionPerformed(): total time = {}", System.currentTimeMillis() - l);
            this.cursorChanger.restoreCursor();
        }
    }

    public class DefaultStatusNotificationHandler
    extends StatusNotificationHandler {
        @Override
        public void notify(int n, String string, Throwable throwable) {
            System.err.println("DicomImageBlackout.DefaultStatusNotificationHandler.notify(): status = " + n);
            System.err.println("DicomImageBlackout.DefaultStatusNotificationHandler.notify(): message = " + string);
            if (throwable != null) {
                throwable.printStackTrace(System.err);
            }
        }
    }

    public abstract class StatusNotificationHandler {
        public static final int WINDOW_CLOSED = 1;
        public static final int CANCELLED = 2;
        public static final int COMPLETED = 3;
        public static final int SAVE_FAILED = 4;
        public static final int UNSAVED_CHANGES = 5;
        public static final int SAVE_SUCCEEDED = 6;
        public static final int READ_FAILED = 7;
        public static final int BLACKOUT_FAILED = 8;

        protected StatusNotificationHandler() {
        }

        public abstract void notify(int var1, String var2, Throwable var3);
    }

    public abstract class BurnedInAnnotationFlagAction {
        public static final int LEAVE_ALONE = 1;
        public static final int ALWAYS_REMOVE = 2;
        public static final int ADD_AS_NO_IF_CHANGED = 3;
        public static final int ADD_AS_NO_IF_SAVED = 4;

        private BurnedInAnnotationFlagAction() {
        }
    }

    protected class CineSliderChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new FrameSelectionChangeEvent(DicomImageBlackout.this.ourEventContext, DicomImageBlackout.this.cineSlider.getValue() - 1));
        }
    }

    class OurFrameSelectionChangeListener
    extends SelfRegisteringListener {
        public OurFrameSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSelectionChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            FrameSelectionChangeEvent frameSelectionChangeEvent = (FrameSelectionChangeEvent)event;
            DicomImageBlackout.this.cineSlider.setValue(frameSelectionChangeEvent.getIndex() + 1);
        }
    }
}

