/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.Vector;

public class DrawingUtilities {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/DrawingUtilities.java,v 1.13 2025/01/29 10:58:07 dclunie Exp $";

    public static void drawShadowedString(String string, int n, int n2, Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, n + 1, n2 + 1);
        graphics2D.setColor(color);
        graphics2D.drawString(string, n, n2);
    }

    public static void drawShadowedShape(Shape shape, Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.black);
        AffineTransform affineTransform = graphics2D.getTransform();
        float f = graphics2D.getStroke() instanceof BasicStroke ? ((BasicStroke)graphics2D.getStroke()).getLineWidth() : 1.0f;
        graphics2D.translate(f, f);
        graphics2D.draw(shape);
        graphics2D.setColor(color);
        graphics2D.setTransform(affineTransform);
        graphics2D.draw(shape);
    }

    public static void addDiagonalCross(Vector vector, int n, int n2, int n3, int n4) {
        vector.add(new Line2D.Float(new Point(n - n3, n2 - n3), new Point(n - n4, n2 - n4)));
        vector.add(new Line2D.Float(new Point(n + n4, n2 + n4), new Point(n + n3, n2 + n3)));
        vector.add(new Line2D.Float(new Point(n + n3, n2 - n3), new Point(n + n4, n2 - n4)));
        vector.add(new Line2D.Float(new Point(n - n4, n2 + n4), new Point(n - n3, n2 + n3)));
    }

    public static void addVerticalCross(Vector vector, int n, int n2, int n3, int n4) {
        vector.add(new Line2D.Float(new Point(n - n3, n2), new Point(n - n4, n2)));
        vector.add(new Line2D.Float(new Point(n + n4, n2), new Point(n + n3, n2)));
        vector.add(new Line2D.Float(new Point(n, n2 - n3), new Point(n, n2 - n4)));
        vector.add(new Line2D.Float(new Point(n, n2 + n4), new Point(n, n2 + n3)));
    }
}

