/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.display.ApplicationFrame;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import javax.swing.JComponent;

public class PlotGraph
extends JComponent {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/PlotGraph.java,v 1.32 2025/01/29 10:58:07 dclunie Exp $";
    protected float[] samples;
    protected FloatArrayStatistics statistics;
    protected int nTilesPerColumn;
    protected int nTilesPerRow;
    protected int samplesPerRow;
    protected int samplesPerTile;
    protected float widthOfTile;
    protected float heightOfTile;
    protected BufferedImage imageOfRenderedPlot;

    protected PlotGraph(int n, int n2, float f, float f2) {
        this.statistics = new FloatArrayStatistics(f, f2);
        this.nTilesPerColumn = n;
        this.nTilesPerRow = n2;
    }

    public PlotGraph(float[] fArray, int n, int n2) {
        this.samples = fArray;
        this.statistics = new FloatArrayStatistics(fArray);
        this.nTilesPerColumn = n;
        this.nTilesPerRow = n2;
        this.samplesPerRow = fArray.length / n;
        this.samplesPerTile = this.samplesPerRow / n2;
    }

    private void renderPlotToGraphics2D(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        int n;
        Color color = Color.black;
        Color color2 = Color.white;
        float f = 1.0f;
        graphics2D.setBackground(color);
        graphics2D.setColor(color);
        if (bl) {
            graphics2D.fill(new Rectangle2D.Float(0.0f, 0.0f, rectangle.width, rectangle.height));
        }
        graphics2D.setColor(color2);
        graphics2D.setStroke(new BasicStroke(f));
        this.widthOfTile = (float)rectangle.width / (float)this.nTilesPerRow;
        this.heightOfTile = (float)rectangle.height / (float)this.nTilesPerColumn;
        float f2 = 0.0f;
        float f3 = (this.widthOfTile - 1.0f) / (float)(this.samplesPerTile - 1);
        float f4 = -this.statistics.getMinimum();
        float f5 = (this.heightOfTile - 1.0f) / this.statistics.getRange();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f6 = 0.0f;
        for (int i = 0; i < this.nTilesPerColumn; ++i) {
            float f7 = 0.0f;
            for (n = 0; n < this.nTilesPerRow; ++n) {
                if (i == 0) {
                    graphics2D.draw(new Line2D.Float(f7, f6, f7 + this.widthOfTile, f6));
                }
                if (n == 0) {
                    graphics2D.draw(new Line2D.Float(f7, f6, f7, f6 + this.heightOfTile));
                }
                graphics2D.draw(new Line2D.Float(f7, f6 + this.heightOfTile, f7 + this.widthOfTile, f6 + this.heightOfTile));
                graphics2D.draw(new Line2D.Float(f7 + this.widthOfTile, f6, f7 + this.widthOfTile, f6 + this.heightOfTile));
                f7 += this.widthOfTile;
            }
            f6 += this.heightOfTile;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        f6 = 0.0f;
        Line2D.Float float_ = new Line2D.Float();
        for (int i = 0; i < this.nTilesPerColumn; ++i) {
            n = i * this.samplesPerRow;
            float f8 = 0.0f;
            for (int j = 0; j < this.nTilesPerRow; ++j) {
                int n2 = n + j * this.samplesPerTile;
                int n3 = n2 + 1;
                float f9 = f2 * f3 + f8;
                float f10 = this.heightOfTile - f4 * f5 + f6;
                float f11 = f9;
                float f12 = f10 - this.samples[n2] * f5;
                for (int k = 1; k < this.samplesPerTile; ++k) {
                    float f13 = (int)((float)k * f3 + f9);
                    float f14 = (int)(f10 - this.samples[n3++] * f5);
                    if (f11 != f13 || f12 != f14) {
                        float_.setLine(f11, f12, f13, f14);
                        graphics2D.draw(float_);
                    }
                    f11 = f13;
                    f12 = f14;
                }
                f8 += this.widthOfTile;
            }
            f6 += this.heightOfTile;
        }
    }

    private BufferedImage createAppropriateBufferedImageToDrawInto(Rectangle rectangle) {
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel();
        return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(rectangle.width, rectangle.height), colorModel.isAlphaPremultiplied(), null);
    }

    protected void actuallyPaintComponent(Graphics graphics, BufferedImage bufferedImage, Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = this.getBounds();
        this.imageOfRenderedPlot = this.createAppropriateBufferedImageToDrawInto(rectangle3);
        if (bufferedImage != null && rectangle != null && rectangle2 != null) {
            this.imageOfRenderedPlot.getGraphics().drawImage(bufferedImage, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, this);
            this.renderPlotToGraphics2D((Graphics2D)this.imageOfRenderedPlot.getGraphics(), rectangle3, false);
        } else {
            this.renderPlotToGraphics2D((Graphics2D)this.imageOfRenderedPlot.getGraphics(), rectangle3, true);
        }
        graphics.drawImage(this.imageOfRenderedPlot, 0, 0, this);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.actuallyPaintComponent(graphics, null, null, null);
    }

    public static void main(String[] stringArray) {
        try {
            BinaryInputStream binaryInputStream = new BinaryInputStream(new BufferedInputStream(new FileInputStream(stringArray[0])), true);
            int n = Integer.parseInt(stringArray[1]);
            int n2 = Integer.parseInt(stringArray[2]);
            int n3 = Integer.parseInt(stringArray[3]);
            int n4 = Integer.parseInt(stringArray[4]);
            float[] fArray = new float[n * n3 * n2];
            binaryInputStream.skipInsistently(n4 * fArray.length * 8);
            binaryInputStream.readComplexFloat(fArray, null, fArray.length);
            PlotGraph plotGraph = new PlotGraph(fArray, n2, n3);
            plotGraph.setPreferredSize(new Dimension(512, 256));
            ApplicationFrame applicationFrame = new ApplicationFrame();
            applicationFrame.getContentPane().add(plotGraph);
            applicationFrame.pack();
            applicationFrame.setVisible(true);
            applicationFrame.takeSnapShot(applicationFrame.getBounds());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected class FloatArrayStatistics {
        private int n;
        private float minimum;
        private float maximum;

        public FloatArrayStatistics(float f, float f2) {
            this.minimum = f;
            this.maximum = f2;
        }

        public FloatArrayStatistics(float[] fArray) {
            this.minimum = Float.MAX_VALUE;
            this.maximum = Float.MIN_VALUE;
            for (float f : fArray) {
                if (f < this.minimum) {
                    this.minimum = f;
                }
                if (!(f > this.maximum)) continue;
                this.maximum = f;
            }
        }

        public float getMinimum() {
            return this.minimum;
        }

        public float getMaximum() {
            return this.maximum;
        }

        public float getRange() {
            return this.maximum - this.minimum;
        }
    }
}

