/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;

public class SafeCursorChanger {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SafeCursorChanger.java,v 1.12 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SafeCursorChanger.class);
    protected Cursor was;
    protected Component component;

    public SafeCursorChanger(Component component) {
        this.component = component;
    }

    public void saveCursor() {
        if (EventQueue.isDispatchThread()) {
            this.was = this.component.getCursor();
        } else {
            SafeCursorGetterThread safeCursorGetterThread = new SafeCursorGetterThread();
            try {
                EventQueue.invokeAndWait(safeCursorGetterThread);
                this.was = safeCursorGetterThread.getCursor();
            }
            catch (InterruptedException interruptedException) {
                slf4jlogger.error("", interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                slf4jlogger.error("", invocationTargetException);
            }
        }
    }

    public void setWaitCursor() {
        if (EventQueue.isDispatchThread()) {
            this.component.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            EventQueue.invokeLater(new SafeCursorSetterThread(Cursor.getPredefinedCursor(3)));
        }
    }

    public void restoreCursor() {
        if (EventQueue.isDispatchThread()) {
            this.component.setCursor(this.was);
        } else {
            EventQueue.invokeLater(new SafeCursorSetterThread(this.was));
        }
    }

    public class SafeCursorSetterThread
    implements Runnable {
        protected Cursor cursor;

        public SafeCursorSetterThread(Cursor cursor) {
            this.cursor = cursor;
        }

        @Override
        public void run() {
            SafeCursorChanger.this.component.setCursor(this.cursor);
        }
    }

    public class SafeCursorGetterThread
    implements Runnable {
        protected Cursor cursor;

        @Override
        public void run() {
            this.cursor = SafeCursorChanger.this.component.getCursor();
        }

        public Cursor getCursor() {
            return this.cursor;
        }
    }
}

