/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ThreadUtilities;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.UIManager;

public class SafeFileChooser {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SafeFileChooser.java,v 1.15 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SafeFileChooser.class);
    protected static String resourceBundleName = "com.pixelmed.display.SafeFileChooser";
    protected static ResourceBundle resourceBundle;
    protected JFileChooser chooser;

    protected static void localizeJFileChooser() {
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(resourceBundleName);
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    if (!string.startsWith("FileChooser.")) continue;
                    String string2 = resourceBundle.getString(string);
                    slf4jlogger.debug("localizeJFileChooser(): UIManager.put(\"{}\" , \"{}\")", string, string2);
                    UIManager.put(string, string2);
                }
            }
            catch (Exception exception) {
                slf4jlogger.warn("Missing resource bundle for localization {}", exception.toString());
            }
        }
    }

    public SafeFileChooser() {
        ThreadUtilities.checkIsEventDispatchThreadElseException();
        SafeFileChooser.localizeJFileChooser();
        this.chooser = new JFileChooser();
    }

    public SafeFileChooser(String string) {
        ThreadUtilities.checkIsEventDispatchThreadElseException();
        SafeFileChooser.localizeJFileChooser();
        this.chooser = new JFileChooser(string);
    }

    public void setFileSelectionMode(int n) throws IllegalArgumentException {
        ThreadUtilities.checkIsEventDispatchThreadElseException();
        this.chooser.setFileSelectionMode(n);
    }

    public int showOpenDialog(Component component) throws HeadlessException {
        ThreadUtilities.checkIsEventDispatchThreadElseException();
        return this.chooser.showOpenDialog(component);
    }

    public File getCurrentDirectory() {
        ThreadUtilities.checkIsEventDispatchThreadElseException();
        return this.chooser.getCurrentDirectory();
    }

    public File getSelectedFile() {
        ThreadUtilities.checkIsEventDispatchThreadElseException();
        return this.chooser.getSelectedFile();
    }

    public int showSaveDialog(Component component) throws HeadlessException {
        ThreadUtilities.checkIsEventDispatchThreadElseException();
        return this.chooser.showSaveDialog(component);
    }

    public void setDialogTitle(String string) throws HeadlessException {
        ThreadUtilities.checkIsEventDispatchThreadElseException();
        this.chooser.setDialogTitle(string);
    }

    public static class SafeFileChooserThread
    implements Runnable {
        private int fileSelectionMode;
        private String initialDirectoryPath;
        private String dialogTitle;
        private String selectedFileName;
        private String currentDirectoryPath;

        public SafeFileChooserThread() {
            this.fileSelectionMode = 0;
        }

        public SafeFileChooserThread(int n) {
            this.fileSelectionMode = n;
        }

        public SafeFileChooserThread(String string) {
            this.fileSelectionMode = 0;
            this.initialDirectoryPath = string;
        }

        public SafeFileChooserThread(int n, String string) {
            this.fileSelectionMode = n;
            this.initialDirectoryPath = string;
        }

        public SafeFileChooserThread(String string, String string2) {
            this.fileSelectionMode = 0;
            this.initialDirectoryPath = string;
            this.dialogTitle = string2;
        }

        public SafeFileChooserThread(int n, String string, String string2) {
            this.fileSelectionMode = n;
            this.initialDirectoryPath = string;
            this.dialogTitle = string2;
        }

        @Override
        public void run() {
            SafeFileChooser safeFileChooser;
            SafeFileChooser safeFileChooser2 = safeFileChooser = this.initialDirectoryPath == null ? new SafeFileChooser() : new SafeFileChooser(this.initialDirectoryPath);
            if (this.dialogTitle != null) {
                safeFileChooser.setDialogTitle(this.dialogTitle);
            }
            safeFileChooser.setFileSelectionMode(this.fileSelectionMode);
            this.selectedFileName = null;
            if (safeFileChooser.showOpenDialog(null) == 0) {
                this.selectedFileName = safeFileChooser.getSelectedFile().getAbsolutePath();
                this.currentDirectoryPath = safeFileChooser.getCurrentDirectory().getAbsolutePath();
            }
        }

        public String getSelectedFileName() {
            return this.selectedFileName;
        }

        public String getCurrentDirectoryPath() {
            return this.currentDirectoryPath;
        }
    }
}

