/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.SpectroscopyVolumeLocalization;
import com.pixelmed.display.LocalizerManager;
import com.pixelmed.display.event.FrameSelectionChangeEvent;
import com.pixelmed.display.event.FrameSortOrderChangeEvent;
import com.pixelmed.display.event.SourceSpectrumSelectionChangeEvent;
import com.pixelmed.display.event.StatusChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.Event;
import com.pixelmed.event.EventContext;
import com.pixelmed.event.SelfRegisteringListener;
import com.pixelmed.geometry.GeometryOfVolume;
import java.util.Vector;

class SpectroscopyLocalizerManager
extends LocalizerManager {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SpectroscopyLocalizerManager.java,v 1.16 2025/01/29 10:58:08 dclunie Exp $";
    protected GeometryOfVolume spectroscopyGeometry;
    protected SpectroscopyVolumeLocalization spectroscopyVolumeLocalization;
    protected int spectroscopyIndex;
    protected int[] spectroscopySortOrder;
    private OurSourceSpectrumSelectionChangeListener sourceSpectrumSelectionChangeListener;
    private OurSpectrumFrameSelectionChangeListener spectrumFrameSelectionChangeListener;
    private OurSpectrumFrameSortOrderChangeListener spectrumFrameSortOrderChangeListener;

    SpectroscopyLocalizerManager() {
    }

    @Override
    protected void drawOutlineOnLocalizerReferenceImagePanel() {
        if (this.referencedImagePanel != null) {
            Vector vector;
            this.localizerPoster.setLocalizerGeometry(this.referenceImageGeometry.getGeometryOfSlices()[this.referenceIndex]);
            boolean bl = false;
            if (this.spectroscopyGeometry != null) {
                vector = this.localizerPoster.getOutlineOnLocalizerForThisGeometry(this.spectroscopyGeometry.getGeometryOfSlices()[this.spectroscopyIndex]);
                this.referencedImagePanel.setLocalizerShapes(vector);
                bl = true;
            }
            if (this.spectroscopyVolumeLocalization != null) {
                vector = this.localizerPoster.getOutlineOnLocalizerForThisVolumeLocalization(this.spectroscopyVolumeLocalization);
                this.referencedImagePanel.setVolumeLocalizationShapes(vector);
                bl = true;
            }
            if (bl) {
                this.referencedImagePanel.getParent().validate();
                this.referencedImagePanel.repaint();
            }
        }
    }

    public void setSourceSpectrumSelectionContext(EventContext eventContext) {
        if (this.sourceSpectrumSelectionChangeListener == null) {
            this.sourceSpectrumSelectionChangeListener = new OurSourceSpectrumSelectionChangeListener(eventContext);
        } else {
            this.sourceSpectrumSelectionChangeListener.setEventContext(eventContext);
        }
    }

    public void setSpectrumFrameSelectionContext(EventContext eventContext) {
        if (this.spectrumFrameSelectionChangeListener == null) {
            this.spectrumFrameSelectionChangeListener = new OurSpectrumFrameSelectionChangeListener(eventContext);
        } else {
            this.spectrumFrameSelectionChangeListener.setEventContext(eventContext);
        }
    }

    public void setSpectrumFrameSortOrderContext(EventContext eventContext) {
        if (this.spectrumFrameSortOrderChangeListener == null) {
            this.spectrumFrameSortOrderChangeListener = new OurSpectrumFrameSortOrderChangeListener(eventContext);
        } else {
            this.spectrumFrameSortOrderChangeListener.setEventContext(eventContext);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.spectroscopyIndex = 0;
        this.spectroscopySortOrder = null;
        this.spectroscopyGeometry = null;
        this.spectroscopyVolumeLocalization = null;
    }

    class OurSpectrumFrameSortOrderChangeListener
    extends SelfRegisteringListener {
        public OurSpectrumFrameSortOrderChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSortOrderChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            FrameSortOrderChangeEvent frameSortOrderChangeEvent = (FrameSortOrderChangeEvent)event;
            SpectroscopyLocalizerManager.this.spectroscopySortOrder = frameSortOrderChangeEvent.getSortOrder();
            SpectroscopyLocalizerManager.this.spectroscopyIndex = frameSortOrderChangeEvent.getIndex();
            if (SpectroscopyLocalizerManager.this.spectroscopySortOrder != null) {
                SpectroscopyLocalizerManager.this.spectroscopyIndex = SpectroscopyLocalizerManager.this.spectroscopySortOrder[SpectroscopyLocalizerManager.this.spectroscopyIndex];
            }
            if (SpectroscopyLocalizerManager.this.referenceImageGeometry != null && SpectroscopyLocalizerManager.this.spectroscopyGeometry != null) {
                SpectroscopyLocalizerManager.this.drawOutlineOnLocalizerReferenceImagePanel();
            }
        }
    }

    class OurSpectrumFrameSelectionChangeListener
    extends SelfRegisteringListener {
        public OurSpectrumFrameSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSelectionChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            FrameSelectionChangeEvent frameSelectionChangeEvent = (FrameSelectionChangeEvent)event;
            SpectroscopyLocalizerManager.this.spectroscopyIndex = frameSelectionChangeEvent.getIndex();
            if (SpectroscopyLocalizerManager.this.spectroscopySortOrder != null) {
                SpectroscopyLocalizerManager.this.spectroscopyIndex = SpectroscopyLocalizerManager.this.spectroscopySortOrder[SpectroscopyLocalizerManager.this.spectroscopyIndex];
            }
            if (SpectroscopyLocalizerManager.this.referenceImageGeometry != null && SpectroscopyLocalizerManager.this.spectroscopyGeometry != null) {
                SpectroscopyLocalizerManager.this.drawOutlineOnLocalizerReferenceImagePanel();
            }
        }
    }

    class OurSourceSpectrumSelectionChangeListener
    extends SelfRegisteringListener {
        public OurSourceSpectrumSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.SourceSpectrumSelectionChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            SourceSpectrumSelectionChangeEvent sourceSpectrumSelectionChangeEvent = (SourceSpectrumSelectionChangeEvent)event;
            SpectroscopyLocalizerManager.this.spectroscopySortOrder = sourceSpectrumSelectionChangeEvent.getSortOrder();
            SpectroscopyLocalizerManager.this.spectroscopyIndex = sourceSpectrumSelectionChangeEvent.getIndex();
            if (SpectroscopyLocalizerManager.this.spectroscopySortOrder != null) {
                SpectroscopyLocalizerManager.this.spectroscopyIndex = SpectroscopyLocalizerManager.this.spectroscopySortOrder[SpectroscopyLocalizerManager.this.spectroscopyIndex];
            }
            SpectroscopyLocalizerManager.this.spectroscopyGeometry = sourceSpectrumSelectionChangeEvent.getGeometryOfVolume();
            SpectroscopyLocalizerManager.this.spectroscopyVolumeLocalization = sourceSpectrumSelectionChangeEvent.getSpectroscopyVolumeLocalization();
            if (SpectroscopyLocalizerManager.this.spectroscopyGeometry != null && SpectroscopyLocalizerManager.this.spectroscopyGeometry.getGeometryOfSlices() == null) {
                SpectroscopyLocalizerManager.this.spectroscopyGeometry = null;
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Selected image does not contain necessary geometry for localization."));
            }
        }
    }
}

