/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.displaywave;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTreeBrowser;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.display.SafeFileChooser;
import com.pixelmed.displaywave.DicomSourceECG;
import com.pixelmed.displaywave.ECGPanel;
import com.pixelmed.displaywave.SCPSourceECG;
import com.pixelmed.displaywave.SourceECG;
import com.pixelmed.scpecg.SCPECG;
import com.pixelmed.scpecg.SCPTreeBrowser;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ECGViewer
extends ApplicationFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/displaywave/ECGViewer.java,v 1.18 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ECGViewer.class);
    private final float milliMetresPerPixel = 0.35277778f;
    private final int defaultHeightOfTileInMicroVolts = 2000;
    private final int minimumHeightOfTileInMicroVolts = 1000;
    private final int maximumHeightOfTileInMicroVolts = 5000;
    private final int minorIntervalHeightOfTileInMicroVolts = 500;
    private final int majorIntervalHeightOfTileInMicroVolts = 1000;
    private final String heightOfTileSliderLabel = "Height of tile in uV";
    private final int defaultHorizontalScalingInMilliMetresPerSecond = 25;
    private final int minimumHorizontalScalingInMilliMetresPerSecond = 10;
    private final int maximumHorizontalScalingInMilliMetresPerSecond = 50;
    private final int minorIntervalHorizontalScalingInMilliMetresPerSecond = 5;
    private final int majorIntervalHorizontalScalingInMilliMetresPerSecond = 10;
    private final String horizontalScalingSliderLabel = "mm/S";
    private final int defaultVerticalScalingInMilliMetresPerMilliVolt = 10;
    private final int minimumVerticalScalingInMilliMetresPerMilliVolt = 5;
    private final int maximumVerticalScalingInMilliMetresPerMilliVolt = 25;
    private final int minorIntervalVerticalScalingInMilliMetresPerMilliVolt = 5;
    private final int majorIntervalVerticalScalingInMilliMetresPerMilliVolt = 10;
    private final String verticalScalingSliderLabel = "mm/mV";
    private final int maximumSliderWidth = 320;
    private final int maximumSliderHeight = 100;
    private final int minimumAttributeTreePaneWidth = 200;
    private int applicationWidth;
    private int applicationHeight;
    private String lastDirectoryPath;

    private void loadSourceECGIntoScrollPane(JFrame jFrame, SourceECG sourceECG, JScrollPane jScrollPane, JScrollPane jScrollPane2, int n, int n2, int n3) {
        Cursor cursor = jFrame.getCursor();
        jFrame.setCursor(Cursor.getPredefinedCursor(3));
        int n4 = sourceECG.getNumberOfChannels();
        int n5 = sourceECG.getNumberOfSamplesPerChannel();
        float f = sourceECG.getSamplingIntervalInMilliSeconds();
        int n6 = n4;
        int n7 = 1;
        boolean bl = false;
        float f2 = (float)n / 1000.0f;
        float f3 = (float)n2 / 352.77777f;
        float f4 = (float)n3 / 0.35277778f;
        float f5 = 1.0f / f3;
        float f6 = f / f5;
        int n8 = n5 * n7;
        int n9 = (int)((float)n8 * f6);
        int n10 = this.applicationWidth - 200;
        int n11 = n9 > n10 ? n10 : n9;
        int n12 = this.applicationWidth - n11;
        float f7 = 1.0f / f4;
        int n13 = (int)((float)n6 * f2 / f7);
        ECGPanel eCGPanel = new ECGPanel(sourceECG.getSamples(), n4, n5, sourceECG.getChannelNames(), n6, n7, f, sourceECG.getAmplitudeScalingFactorInMilliVolts(), f3, f4, (float)bl, sourceECG.getDisplaySequence(), n9, n13);
        eCGPanel.setPreferredSize(new Dimension(n9, n13));
        jScrollPane.setViewportView(eCGPanel);
        jScrollPane2.setPreferredSize(new Dimension(n12, 0));
        jFrame.setCursor(cursor);
    }

    private SourceECG loadDicomFile(String string, JFrame jFrame, JScrollPane jScrollPane, JScrollPane jScrollPane2) {
        DicomSourceECG dicomSourceECG = null;
        if (string != null) {
            try {
                String string2;
                DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                new AttributeTreeBrowser(attributeList, jScrollPane2);
                Attribute attribute = attributeList.get(TagFromName.MediaStorageSOPClassUID);
                String string3 = string2 = attribute != null && attribute.getVM() == 1 ? attribute.getStringValues()[0] : null;
                if (string2 == null) {
                    attribute = attributeList.get(TagFromName.SOPClassUID);
                    String string4 = string2 = attribute != null && attribute.getVM() == 1 ? attribute.getStringValues()[0] : null;
                }
                if (!SOPClass.isWaveform(string2)) {
                    throw new Exception("unsupported SOP Class " + string2);
                }
                dicomSourceECG = new DicomSourceECG(attributeList);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dicomSourceECG;
    }

    private SourceECG loadSCPECGFile(String string, JFrame jFrame, JScrollPane jScrollPane, JScrollPane jScrollPane2) {
        SCPSourceECG sCPSourceECG = null;
        if (string != null) {
            try {
                BinaryInputStream binaryInputStream = new BinaryInputStream(new BufferedInputStream(new FileInputStream(string)), false);
                SCPECG sCPECG = new SCPECG(binaryInputStream, false);
                new SCPTreeBrowser(sCPECG, jScrollPane2);
                sCPSourceECG = new SCPSourceECG(sCPECG, true);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return sCPSourceECG;
    }

    private SourceECG loadECGFile(String string, JFrame jFrame, JScrollPane jScrollPane, JScrollPane jScrollPane2) {
        Cursor cursor = jFrame.getCursor();
        jFrame.setCursor(Cursor.getPredefinedCursor(3));
        SourceECG sourceECG = null;
        if (string == null) {
            SafeFileChooser.SafeFileChooserThread safeFileChooserThread = new SafeFileChooser.SafeFileChooserThread();
            try {
                EventQueue.invokeAndWait(safeFileChooserThread);
                string = safeFileChooserThread.getSelectedFileName();
                this.lastDirectoryPath = safeFileChooserThread.getCurrentDirectoryPath();
            }
            catch (InterruptedException interruptedException) {
                slf4jlogger.error("", interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                slf4jlogger.error("", invocationTargetException);
            }
        }
        slf4jlogger.info("Loading: {}", string);
        jScrollPane.setViewportView(null);
        jScrollPane.repaint();
        jScrollPane2.setViewportView(null);
        jScrollPane2.repaint();
        sourceECG = this.loadDicomFile(string, jFrame, jScrollPane, jScrollPane2);
        if (sourceECG == null) {
            sourceECG = this.loadSCPECGFile(string, jFrame, jScrollPane, jScrollPane2);
        }
        jFrame.setCursor(cursor);
        return sourceECG;
    }

    private final JSlider addCommonSlider(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, String string) {
        JSlider jSlider = new JSlider(n2, n3, n);
        jSlider.setPaintLabels(true);
        jSlider.setPaintTicks(true);
        jSlider.setPaintTrack(true);
        jSlider.setMajorTickSpacing(n4);
        jSlider.setMinorTickSpacing(n5);
        jSlider.setSnapToTicks(true);
        JLabel jLabel = new JLabel(string);
        jPanel.add(jLabel);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jSlider);
        gridBagLayout.setConstraints(jSlider, gridBagConstraints);
        jSlider.setMaximumSize(new Dimension(320, 100));
        return jSlider;
    }

    private void doCommonConstructorStuff(String string, String string2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.applicationWidth = 1024;
        this.applicationHeight = 700;
        JScrollPane jScrollPane = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        SourceECG sourceECG = this.loadECGFile(string2, this, jScrollPane, jScrollPane2);
        if (sourceECG != null) {
            this.loadSourceECGIntoScrollPane(this, sourceECG, jScrollPane, jScrollPane2, 2000, 25, 10);
        }
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(200, 50));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        JSlider jSlider = this.addCommonSlider(jPanel, gridBagLayout, gridBagConstraints, 2000, 1000, 5000, 1000, 500, "Height of tile in uV");
        JSlider jSlider2 = this.addCommonSlider(jPanel, gridBagLayout, gridBagConstraints, 25, 10, 50, 10, 5, "mm/S");
        JSlider jSlider3 = this.addCommonSlider(jPanel, gridBagLayout, gridBagConstraints, 10, 5, 25, 10, 5, "mm/mV");
        CommonScalingSliderChangeListener commonScalingSliderChangeListener = new CommonScalingSliderChangeListener(this, sourceECG, jScrollPane, jScrollPane2, jSlider, jSlider2, jSlider3, 2000, 25, 10);
        jSlider.addChangeListener(commonScalingSliderChangeListener);
        jSlider2.addChangeListener(commonScalingSliderChangeListener);
        jSlider3.addChangeListener(commonScalingSliderChangeListener);
        JButton jButton = new JButton("Default");
        jButton.setToolTipText("Reset scaling to defaults");
        jPanel.add(jButton);
        jButton.addActionListener(new ResetScalingToDefaultsActionListener(commonScalingSliderChangeListener, 2000, 25, 10));
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        Container container = this.getContentPane();
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, jScrollPane2);
        JSplitPane jSplitPane2 = new JSplitPane(1, jSplitPane, jScrollPane);
        container.add(jSplitPane2);
        this.pack();
        this.setVisible(true);
    }

    private ECGViewer(String string, int n, int n2) {
    }

    private ECGViewer(String string) {
    }

    private ECGViewer(String string, String string2) {
        super(string, (String)null);
        this.doCommonConstructorStuff(string, string2);
    }

    private ECGViewer(String string, String string2, String string3) {
        super(string, string2);
        this.doCommonConstructorStuff(string, string3);
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        ECGViewer eCGViewer = new ECGViewer("ECG Viewer", string);
    }

    private class CommonScalingSliderChangeListener
    implements ChangeListener {
        JSlider heightOfTileSlider;
        JSlider horizontalScalingSlider;
        JSlider verticalScalingSlider;
        JFrame application;
        SourceECG sourceECG;
        JScrollPane scrollPaneOfDisplayedECG;
        JScrollPane scrollPaneOfAttributeTree;
        int requestedHeightOfTileInMicroVolts;
        int requestedHorizontalScalingInMilliMetresPerSecond;
        int requestedVerticalScalingInMilliMetresPerMilliVolt;

        public CommonScalingSliderChangeListener(JFrame jFrame, SourceECG sourceECG, JScrollPane jScrollPane, JScrollPane jScrollPane2, JSlider jSlider, JSlider jSlider2, JSlider jSlider3, int n, int n2, int n3) {
            this.heightOfTileSlider = jSlider;
            this.horizontalScalingSlider = jSlider2;
            this.verticalScalingSlider = jSlider3;
            this.requestedHeightOfTileInMicroVolts = n;
            this.requestedHorizontalScalingInMilliMetresPerSecond = n2;
            this.requestedVerticalScalingInMilliMetresPerMilliVolt = n3;
            this.application = jFrame;
            this.sourceECG = sourceECG;
            this.scrollPaneOfDisplayedECG = jScrollPane;
            this.scrollPaneOfAttributeTree = jScrollPane2;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (!jSlider.getValueIsAdjusting()) {
                boolean bl = false;
                int n = jSlider.getValue();
                if (jSlider == this.heightOfTileSlider) {
                    if (n != this.requestedHeightOfTileInMicroVolts) {
                        this.requestedHeightOfTileInMicroVolts = n;
                        bl = true;
                    }
                } else if (jSlider == this.horizontalScalingSlider) {
                    if (n != this.requestedHorizontalScalingInMilliMetresPerSecond) {
                        this.requestedHorizontalScalingInMilliMetresPerSecond = n;
                        bl = true;
                    }
                } else if (jSlider == this.verticalScalingSlider && n != this.requestedVerticalScalingInMilliMetresPerMilliVolt) {
                    this.requestedVerticalScalingInMilliMetresPerMilliVolt = n;
                    bl = true;
                }
                if (bl) {
                    ECGViewer.this.loadSourceECGIntoScrollPane(this.application, this.sourceECG, this.scrollPaneOfDisplayedECG, this.scrollPaneOfAttributeTree, this.requestedHeightOfTileInMicroVolts, this.requestedHorizontalScalingInMilliMetresPerSecond, this.requestedVerticalScalingInMilliMetresPerMilliVolt);
                }
            }
        }

        public void setValuesAndRedraw(int n, int n2, int n3) {
            this.heightOfTileSlider.setValue(n);
            this.horizontalScalingSlider.setValue(n2);
            this.verticalScalingSlider.setValue(n3);
            boolean bl = false;
            if (this.requestedHeightOfTileInMicroVolts != n) {
                this.requestedHeightOfTileInMicroVolts = n;
                bl = true;
            }
            if (this.requestedHorizontalScalingInMilliMetresPerSecond != n2) {
                this.requestedHorizontalScalingInMilliMetresPerSecond = n2;
                bl = true;
            }
            if (this.requestedVerticalScalingInMilliMetresPerMilliVolt != n3) {
                this.requestedVerticalScalingInMilliMetresPerMilliVolt = n3;
                bl = true;
            }
            if (bl) {
                ECGViewer.this.loadSourceECGIntoScrollPane(this.application, this.sourceECG, this.scrollPaneOfDisplayedECG, this.scrollPaneOfAttributeTree, n, n2, n3);
            }
        }
    }

    private class ResetScalingToDefaultsActionListener
    implements ActionListener {
        CommonScalingSliderChangeListener scalingChangeListener;
        int defaultHeightOfTileInMicroVolts;
        int defaultHorizontalScalingInMilliMetresPerSecond;
        int defaultVerticalScalingInMilliMetresPerMilliVolt;

        public ResetScalingToDefaultsActionListener(CommonScalingSliderChangeListener commonScalingSliderChangeListener, int n, int n2, int n3) {
            this.scalingChangeListener = commonScalingSliderChangeListener;
            this.defaultHeightOfTileInMicroVolts = n;
            this.defaultHorizontalScalingInMilliMetresPerSecond = n2;
            this.defaultVerticalScalingInMilliMetresPerMilliVolt = n3;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.scalingChangeListener.setValuesAndRedraw(this.defaultHeightOfTileInMicroVolts, this.defaultHorizontalScalingInMilliMetresPerSecond, this.defaultVerticalScalingInMilliMetresPerMilliVolt);
        }
    }
}

