/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dose.RoleInOrganization;
import com.pixelmed.dose.RoleInProcedure;

public class PersonParticipant {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dose/PersonParticipant.java,v 1.14 2025/01/29 10:58:08 dclunie Exp $";
    protected String name;
    protected RoleInProcedure roleInProcedure;
    protected String id;
    protected String idIssuer;
    protected String organization;
    protected RoleInOrganization roleInOrganization;

    public PersonParticipant(String string, RoleInProcedure roleInProcedure, String string2, String string3, String string4, RoleInOrganization roleInOrganization) {
        this.name = string;
        this.roleInProcedure = roleInProcedure;
        this.id = string2;
        this.idIssuer = string3;
        this.organization = string4;
        this.roleInOrganization = roleInOrganization;
    }

    public PersonParticipant(ContentItem contentItem) {
        ContentItem contentItem2 = contentItem.getNamedChild("DCM", "113870");
        if (contentItem2 != null) {
            this.name = contentItem2.getSingleStringValueOrNull();
            this.roleInProcedure = RoleInProcedure.getRoleInProcedure(contentItem2);
            this.id = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem2, "DCM", "113871");
            this.idIssuer = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem2, "DCM", "113872");
            this.organization = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem2, "DCM", "113873");
            this.roleInOrganization = RoleInOrganization.getRoleInOrganization(contentItem2);
        }
    }

    public String getName() {
        return this.name;
    }

    public RoleInProcedure getRoleInProcedure() {
        return this.roleInProcedure;
    }

    public String getId() {
        return this.id;
    }

    public String getIdIssuer() {
        return this.idIssuer;
    }

    public String getOrganization() {
        return this.organization;
    }

    public RoleInOrganization getRoleInOrganization() {
        return this.roleInOrganization;
    }

    public ContentItem getStructuredReportFragment() throws DicomException {
        ContentItemFactory contentItemFactory;
        ContentItemFactory contentItemFactory2 = contentItemFactory = new ContentItemFactory();
        contentItemFactory2.getClass();
        ContentItemFactory.PersonNameContentItem personNameContentItem = contentItemFactory2.new ContentItemFactory.PersonNameContentItem(null, "CONTAINS", new CodedSequenceItem("113870", "DCM", "Person Name"), this.name == null || this.name.trim().length() == 0 ? "Nobody" : this.name);
        if (this.roleInProcedure != null) {
            ContentItemFactory contentItemFactory3 = contentItemFactory;
            contentItemFactory3.getClass();
            contentItemFactory3.new ContentItemFactory.CodeContentItem(personNameContentItem, "HAS PROPERTIES", new CodedSequenceItem("113875", "DCM", "Person Role in Procedure"), this.roleInProcedure.getCodedSequenceItem());
        }
        if (this.id != null && this.id.trim().length() > 0) {
            ContentItemFactory contentItemFactory4 = contentItemFactory;
            contentItemFactory4.getClass();
            contentItemFactory4.new ContentItemFactory.TextContentItem(personNameContentItem, "HAS PROPERTIES", new CodedSequenceItem("113871", "DCM", "Person ID"), this.id);
        }
        if (this.idIssuer != null && this.idIssuer.trim().length() > 0) {
            ContentItemFactory contentItemFactory5 = contentItemFactory;
            contentItemFactory5.getClass();
            contentItemFactory5.new ContentItemFactory.TextContentItem(personNameContentItem, "HAS PROPERTIES", new CodedSequenceItem("113872", "DCM", "Person ID Issuer"), this.idIssuer);
        }
        if (this.organization != null && this.organization.trim().length() > 0) {
            ContentItemFactory contentItemFactory6 = contentItemFactory;
            contentItemFactory6.getClass();
            contentItemFactory6.new ContentItemFactory.TextContentItem(personNameContentItem, "HAS PROPERTIES", new CodedSequenceItem("113873", "DCM", "Organization Name"), this.organization);
        }
        if (this.roleInOrganization != null) {
            ContentItemFactory contentItemFactory7 = contentItemFactory;
            contentItemFactory7.getClass();
            contentItemFactory7.new ContentItemFactory.CodeContentItem(personNameContentItem, "HAS PROPERTIES", new CodedSequenceItem("113874", "DCM", "Person Role in Organization"), this.roleInOrganization.getCodedSequenceItem());
        }
        return personNameContentItem;
    }
}

