/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class ScanRange {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dose/ScanRange.java,v 1.16 2025/01/29 10:58:08 dclunie Exp $";
    protected String startDirection;
    protected String startLocation;
    protected String endDirection;
    protected String endLocation;
    protected String absoluteRange;
    protected double absoluteRangeAsDouble;

    public ScanRange(String string, String string2, String string3, String string4) {
        this.startDirection = string;
        this.startLocation = string2;
        this.endDirection = string3;
        this.endLocation = string4;
        this.absoluteRange = null;
    }

    public ScanRange(String string, String string2) {
        this.startDirection = string.startsWith("-") ? "I" : "S";
        this.startLocation = string.replaceFirst("[+-]", "");
        this.endDirection = string2.startsWith("-") ? "I" : "S";
        this.endLocation = string2.replaceFirst("[+-]", "");
        this.absoluteRange = null;
    }

    public String getStartDirection() {
        return this.startDirection;
    }

    public String getStartLocation() {
        return this.startLocation;
    }

    public String getEndDirection() {
        return this.endDirection;
    }

    public String getEndLocation() {
        return this.endLocation;
    }

    public double getAbsoluteRangeAsDouble() {
        if (this.absoluteRange == null) {
            double d = Double.parseDouble(this.startLocation);
            if (this.startDirection.equals("I")) {
                d = -d;
            }
            double d2 = Double.parseDouble(this.endLocation);
            if (this.endDirection.equals("I")) {
                d2 = -d2;
            }
            this.absoluteRangeAsDouble = d - d2;
            if (this.absoluteRangeAsDouble < 0.0) {
                this.absoluteRangeAsDouble = -this.absoluteRangeAsDouble;
            }
        }
        return this.absoluteRangeAsDouble;
    }

    public String getAbsoluteRange() {
        if (this.absoluteRange == null) {
            this.getAbsoluteRangeAsDouble();
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
            decimalFormat.setMaximumFractionDigits(3);
            decimalFormat.setMinimumFractionDigits(3);
            decimalFormat.setDecimalSeparatorAlwaysShown(true);
            decimalFormat.setGroupingUsed(false);
            this.absoluteRange = decimalFormat.format(this.absoluteRangeAsDouble);
        }
        return this.absoluteRange;
    }

    public boolean isStationary() {
        return this.getAbsoluteRangeAsDouble() < 1.0E-4;
    }

    public String toString() {
        return this.startDirection + this.startLocation + "-" + this.endDirection + this.endLocation;
    }

    public boolean equals(Object object) {
        ScanRange scanRange;
        boolean bl = false;
        bl = object instanceof ScanRange ? (scanRange = (ScanRange)object).getStartDirection().equals(this.getStartDirection()) && scanRange.getStartLocation().equals(this.getStartLocation()) && scanRange.getEndDirection().equals(this.getEndDirection()) && scanRange.getEndLocation().equals(this.getEndLocation()) : false;
        return bl;
    }

    public int hashCode() {
        return this.getStartDirection().hashCode() + this.getStartLocation().hashCode() + this.getEndDirection().hashCode() + this.getEndLocation().hashCode();
    }
}

