/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.doseocr;

import com.pixelmed.anatproc.CTAnatomy;
import com.pixelmed.anatproc.CodedConcept;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnknownAttribute;
import com.pixelmed.dose.CTAcquisitionParameters;
import com.pixelmed.dose.CTDose;
import com.pixelmed.dose.CTDoseAcquisition;
import com.pixelmed.dose.CTIrradiationEventDataFromImages;
import com.pixelmed.dose.CTPhantomType;
import com.pixelmed.dose.CTScanType;
import com.pixelmed.dose.ScopeOfDoseAccummulation;
import com.pixelmed.dose.SourceOfDoseInformation;
import com.pixelmed.doseocr.GenerateRadiationDoseStructuredReport;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FloatFormatter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExposureDoseSequence {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/doseocr/ExposureDoseSequence.java,v 1.43 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ExposureDoseSequence.class);
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;
    private static AttributeTag privateDLPTag = new AttributeTag(225, 4129);

    public static String getValuesFromCommentsOnRadiationDose(AttributeList attributeList, Map<String, String> map, Map<String, String> map2, int n) throws IOException {
        slf4jlogger.warn("getValuesFromCommentsOnRadiationDose(): Debug level supplied as argument ignored");
        return ExposureDoseSequence.getValuesFromCommentsOnRadiationDose(attributeList, map, map2);
    }

    public static String getValuesFromCommentsOnRadiationDose(AttributeList attributeList, Map<String, String> map, Map<String, String> map2) throws IOException {
        slf4jlogger.debug("ExposureDoseSequence.getValuesFromCommentsOnRadiationDose():");
        String string = "";
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("CommentsOnRadiationDose")).toUpperCase(Locale.US).trim();
        if (string2.length() > 0) {
            Pattern pattern = Pattern.compile("[ \t]*SERIES #[ \t]*([0-9]+)[ \t]*.*CTDIVOL[ \t]*=[ \t]*([0-9]*[.][0-9]*)[ \t]+DLP[ \t]*=[ \t]*([0-9]*[.][0-9]*).*");
            Pattern pattern2 = Pattern.compile("[ \t]*EVENT=[ \t]*([0-9]+)[ \t]*DLP[ \t]*=[ \t]*([0-9]*[.][0-9]*).*");
            Pattern pattern3 = Pattern.compile("[ \t]*TOTAL[ \t]*DLP=[ \t]*([0-9]*[.][0-9]*).*");
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string2.toString()));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                String string4;
                String string5;
                int n;
                Matcher matcher;
                string3 = string3.toUpperCase(Locale.US);
                slf4jlogger.debug(string3);
                if (string3.contains("SERIES") && (matcher = pattern.matcher(string3)).matches()) {
                    slf4jlogger.debug("matches");
                    n = matcher.groupCount();
                    slf4jlogger.debug("groupCount = {}", n);
                    if (n >= 3) {
                        string5 = matcher.group(1);
                        string4 = matcher.group(2);
                        String string6 = matcher.group(3);
                        slf4jlogger.debug("series = {}, CTDIVol = {}, DLP = {}", string5, string4, string6);
                        if (string5.length() > 0) {
                            map2.put(string5, string4);
                            map.put(string5, string6);
                        }
                    }
                }
                if (string3.contains("EVENT")) {
                    matcher = pattern2.matcher(string3);
                    if (!matcher.matches()) continue;
                    slf4jlogger.debug("matches");
                    n = matcher.groupCount();
                    slf4jlogger.debug("groupCount = {}", n);
                    if (n < 2) continue;
                    string5 = matcher.group(1);
                    string4 = matcher.group(2);
                    slf4jlogger.debug("series = {}, DLP = {}", string5, string4);
                    if (string5.length() <= 0) continue;
                    map.put(string5, string4);
                    continue;
                }
                if (!string3.contains("TOTAL") || !(matcher = pattern3.matcher(string3)).matches()) continue;
                slf4jlogger.debug("matches");
                n = matcher.groupCount();
                slf4jlogger.debug("groupCount = {}", n);
                if (n < 1) continue;
                string = matcher.group(1);
                slf4jlogger.debug("totalDLPFromCommentsOnRadiationDose = {}", string);
            }
        }
        return string;
    }

    public static String getPhilipsPrivateDLPValue(AttributeList attributeList) throws DicomException {
        String string = "";
        Attribute attribute = attributeList.get(privateDLPTag);
        if (attribute instanceof UnknownAttribute) {
            byte[] byArray = attribute.getByteValues();
            string = new String(byArray);
            string = FloatFormatter.toString(new Double(string), Locale.US);
        } else {
            string = Attribute.getSingleStringValueOrEmptyString(attributeList, privateDLPTag);
        }
        return string;
    }

    public static boolean isPossiblyPhilipsDoseScreenSeries(String string, String string2, String string3, String string4) {
        return (string == null || string.length() == 0 || string.toUpperCase(Locale.US).contains("PHILIPS")) && string2 != null && string2.equals("CT") && string4 != null && string4.toLowerCase(Locale.US).trim().equals("dose info");
    }

    public static boolean isPossiblyPhilipsDoseScreenSeries(AttributeList attributeList) {
        return ExposureDoseSequence.isPossiblyPhilipsDoseScreenSeries(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Manufacturer), Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality), null, Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesDescription));
    }

    public static boolean isPossiblyPhilipsDoseScreenInstance(String string, String string2, String string3) {
        return !(string != null && string.length() != 0 && !string.toUpperCase(Locale.US).contains("PHILIPS") || string3 == null || !string3.contains("DOSE_INFO") && !string3.contains("DOSE-INFO") && !string3.contains("LOCALIZER"));
    }

    public static boolean isPossiblyPhilipsDoseScreenInstance(AttributeList attributeList) {
        return ExposureDoseSequence.isPossiblyPhilipsDoseScreenInstance(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Manufacturer), null, Attribute.getDelimitedStringValuesOrDefault(attributeList, TagFromName.ImageType, ""));
    }

    public static boolean isPhilipsDoseScreenInstance(AttributeList attributeList) {
        String string = Attribute.getDelimitedStringValuesOrDefault(attributeList, TagFromName.ImageType, "").trim();
        return Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesDescription).toLowerCase(Locale.US).trim().equals("dose info") && ExposureDoseSequence.isPossiblyPhilipsDoseScreenInstance(attributeList) && attributeList.get(dictionary.getTagFromName("ExposureDoseSequence")) != null;
    }

    public static CTDose getCTDoseFromExposureDoseSequence(AttributeList attributeList, int n, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages, boolean bl) throws IOException, DicomException {
        slf4jlogger.warn("getCTDoseFromExposureDoseSequence(): Debug level supplied as argument ignored");
        return ExposureDoseSequence.getCTDoseFromExposureDoseSequence(attributeList, cTIrradiationEventDataFromImages, bl);
    }

    public static CTDose getCTDoseFromExposureDoseSequence(AttributeList attributeList, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages, boolean bl) throws IOException, DicomException {
        slf4jlogger.debug("ExposureDoseSequence.getCTDoseFromExposureDoseSequence():");
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDescription);
        String string3 = null;
        String string4 = null;
        if (cTIrradiationEventDataFromImages != null) {
            string3 = cTIrradiationEventDataFromImages.getOverallEarliestAcquisitionDateTimeForStudy(string);
            string4 = cTIrradiationEventDataFromImages.getOverallLatestAcquisitionDateTimeForStudy(string);
        }
        if ((string3 == null || string3.trim().length() == 0 && attributeList != null) && (string3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyDate)) != null && string3.length() == 8) {
            string3 = string3 + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyTime);
        }
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string, string3, string4, string2);
        cTDose.setSourceOfDoseInformation(SourceOfDoseInformation.COPIED_FROM_IMAGE_ATTRIBUTES);
        CodedSequenceItem codedSequenceItem = null;
        Object object = CTAnatomy.findAnatomicConcept(attributeList);
        if (object != null) {
            codedSequenceItem = ((CodedConcept)object).getCodedSequenceItem();
        }
        object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ProtocolName);
        String string5 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        String string6 = ExposureDoseSequence.getValuesFromCommentsOnRadiationDose(attributeList, hashMap, hashMap2);
        Object object2 = ExposureDoseSequence.getPhilipsPrivateDLPValue(attributeList);
        if (object2 == null || ((String)object2).length() == 0) {
            slf4jlogger.debug("Cannot get total DLP from private attribute - using value parsed from CommentsOnRadiationDose if present");
            object2 = string6;
        }
        cTDose.setDLPTotal((String)object2);
        object2 = attributeList.get(dictionary.getTagFromName("ExposureDoseSequence"));
        if (object2 != null && object2 instanceof SequenceAttribute) {
            int n = 1;
            Iterator<SequenceItem> iterator = ((SequenceAttribute)object2).iterator();
            while (iterator.hasNext()) {
                SequenceItem sequenceItem = iterator.next();
                if (sequenceItem != null) {
                    AttributeList attributeList2 = sequenceItem.getAttributeList();
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace(attributeList2.toString());
                    }
                    String string7 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.AcquisitionDateTime);
                    String string8 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SeriesDescription);
                    String string9 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ProtocolName);
                    String string10 = Attribute.getSingleStringValueOrEmptyString(attributeList2, dictionary.getTagFromName("KVP"));
                    double d = Attribute.getSingleDoubleValueOrDefault(attributeList2, dictionary.getTagFromName("ExposureTime"), 0.0);
                    String string11 = Attribute.getSingleStringValueOrEmptyString(attributeList2, dictionary.getTagFromName("RadiationMode"));
                    String string12 = Attribute.getSingleStringValueOrEmptyString(attributeList2, dictionary.getTagFromName("FilterType"));
                    String string13 = Attribute.getSingleStringValueOrEmptyString(attributeList2, dictionary.getTagFromName("ScanLength"));
                    double d2 = Attribute.getSingleDoubleValueOrDefault(attributeList2, dictionary.getTagFromName("XRayTubeCurrentInuA"), 0.0);
                    String string14 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.AcquisitionType);
                    String string15 = Attribute.getSingleStringValueOrEmptyString(attributeList2, dictionary.getTagFromName("SingleCollimationWidth"));
                    String string16 = Attribute.getSingleStringValueOrEmptyString(attributeList2, dictionary.getTagFromName("TotalCollimationWidth"));
                    String string17 = Attribute.getSingleStringValueOrEmptyString(attributeList2, dictionary.getTagFromName("SpiralPitchFactor"));
                    String string18 = Attribute.getSingleStringValueOrEmptyString(attributeList2, dictionary.getTagFromName("EstimatedDoseSaving"));
                    String string19 = Attribute.getSingleStringValueOrEmptyString(attributeList2, dictionary.getTagFromName("CTDIvol"));
                    String string20 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SeriesNumber);
                    String string21 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SliceLocation);
                    String string22 = ExposureDoseSequence.getPhilipsPrivateDLPValue(attributeList2);
                    String string23 = d > 0.0 ? FloatFormatter.toString(new Double(d) / 1000.0, Locale.US) : null;
                    String string24 = d2 > 0.0 ? FloatFormatter.toString(new Double(d2) / 1000.0, Locale.US) : null;
                    String string25 = string20;
                    if (string25.length() == 0) {
                        string25 = Integer.toString(n);
                    }
                    if (string25.length() > 0) {
                        if (string19.length() == 0) {
                            slf4jlogger.debug("Cannot get per series CTDIvol from private attribute - using value parsed from CommentsOnRadiationDose if present");
                            string19 = (String)hashMap2.get(string25);
                            if (string19 == null) {
                                string19 = "";
                            }
                        }
                        if (string22.length() == 0) {
                            slf4jlogger.debug("Cannot get per series DLP from private attribute - using value parsed from CommentsOnRadiationDose if present");
                            string22 = (String)hashMap.get(string25);
                            if (string22 == null) {
                                string22 = "";
                            }
                        }
                    }
                    if (string19.equals("0")) {
                        string19 = "";
                    }
                    if (string22.equals("0")) {
                        string22 = "";
                    }
                    CodedSequenceItem codedSequenceItem2 = codedSequenceItem;
                    Object object3 = CTAnatomy.findAnatomicConcept(attributeList2);
                    slf4jlogger.debug("anatomyConcept = {}", object3);
                    if (object3 != null) {
                        codedSequenceItem2 = ((CodedConcept)object3).getCodedSequenceItem();
                    }
                    object3 = null;
                    Object object4 = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList2, dictionary.getTagFromName("CTDIPhantomTypeCodeSequence"));
                    if (object4 != null) {
                        object3 = CTPhantomType.selectFromCode((CodedSequenceItem)object4);
                        slf4jlogger.debug("usePhantom = {}", object3);
                    }
                    object4 = object;
                    if (string9.length() > 0) {
                        object4 = string9;
                    }
                    String string26 = string5;
                    if (string8.length() > 0) {
                        string26 = string8;
                    }
                    slf4jlogger.debug("acquisitionType = {}", string14);
                    CTScanType cTScanType = CTScanType.selectFromDescription(string14);
                    slf4jlogger.debug("useScanType = {}", cTScanType);
                    CTDoseAcquisition cTDoseAcquisition = new CTDoseAcquisition(string, true, string20, cTScanType, null, string19, string22, (CTPhantomType)object3);
                    String string27 = null;
                    String string28 = null;
                    if (cTScanType.equals(CTScanType.LOCALIZER)) {
                        string27 = string13;
                    } else {
                        string27 = string13;
                        string28 = string13;
                    }
                    CTAcquisitionParameters cTAcquisitionParameters = new CTAcquisitionParameters(null, cTScanType, codedSequenceItem2, (String)object4, string26, string23, string27, string28, null, null, null, null, null, null, string15, string16, string17, string10, string24, null, null);
                    slf4jlogger.debug("CTDIvol = {}", string19);
                    slf4jlogger.debug("DLP = {}", string22);
                    if (string19.length() > 0 && string22.length() > 0) {
                        cTAcquisitionParameters.deriveScanningLengthFromDLPAndCTDIVolIfGreater(string22, string19);
                    }
                    cTDoseAcquisition.setAcquisitionParameters(cTAcquisitionParameters);
                    cTDose.addAcquisition(cTDoseAcquisition);
                }
                ++n;
            }
        }
        if (bl) {
            GenerateRadiationDoseStructuredReport.createContextForNewRadiationDoseStructuredReportFromExistingInstance(attributeList, cTDose, cTIrradiationEventDataFromImages);
        }
        return cTDose;
    }

    public static final void main(String[] stringArray) {
        try {
            String string = stringArray.length > 0 && !stringArray[0].equals("-") ? stringArray[0] : null;
            String string2 = stringArray.length > 1 && !stringArray[1].equals("-") ? stringArray[1] : null;
            String string3 = stringArray.length > 2 && !stringArray[2].equals("-") ? stringArray[2] : null;
            CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages = null;
            if (string2 != null) {
                cTIrradiationEventDataFromImages = new CTIrradiationEventDataFromImages(string2);
                slf4jlogger.info(cTIrradiationEventDataFromImages.toString());
                if (string == null) {
                    string = cTIrradiationEventDataFromImages.getDoseScreenOrStructuredReportFilenames(true, false).get(0);
                }
            }
            AttributeList attributeList = new AttributeList();
            attributeList.read(string);
            CTDose cTDose = ExposureDoseSequence.getCTDoseFromExposureDoseSequence(attributeList, cTIrradiationEventDataFromImages, string3 != null);
            slf4jlogger.info(cTDose.toString(true, true));
            if (!cTDose.specifiedDLPTotalMatchesDLPTotalFromAcquisitions()) {
                slf4jlogger.warn("############ specified DLP total ({}) does not match DLP total from acquisitions ({})", cTDose.getDLPTotal(), cTDose.getDLPTotalFromAcquisitions());
            }
            if (string3 != null) {
                cTDose.write(string3, null, ExposureDoseSequence.class.getCanonicalName());
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

