/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.ftp;

import com.pixelmed.display.SafeProgressBarUpdaterThread;
import com.pixelmed.display.event.StatusChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.ftp.FTPException;
import com.pixelmed.ftp.FTPRemoteHost;
import com.pixelmed.ftp.FTPSecurityType;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.MessageLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.UUID;
import javax.swing.JProgressBar;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;

public class FTPFileSender {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/ftp/FTPFileSender.java,v 1.19 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(FTPFileSender.class);
    protected static int socketConnectTimeoutInMilliSeconds = 30000;

    public FTPFileSender(FTPRemoteHost fTPRemoteHost, String[] stringArray, boolean bl, int n, MessageLogger messageLogger, JProgressBar jProgressBar) throws NoSuchAlgorithmException, IOException, Exception {
        this(fTPRemoteHost, stringArray, bl, messageLogger, jProgressBar);
        slf4jlogger.warn("gDebug level supplied as constructor argument ignored");
    }

    public FTPFileSender(FTPRemoteHost fTPRemoteHost, String[] stringArray, boolean bl, MessageLogger messageLogger, JProgressBar jProgressBar) throws NoSuchAlgorithmException, IOException, Exception {
        this(fTPRemoteHost.getHost(), fTPRemoteHost.getUser(), fTPRemoteHost.getPassword(), fTPRemoteHost.getDirectory(), stringArray, fTPRemoteHost.getSecurity().equals(FTPSecurityType.TLS), bl, messageLogger, jProgressBar);
    }

    public FTPFileSender(String string, String string2, String string3, String string4, String[] stringArray, boolean bl, boolean bl2, int n) throws NoSuchAlgorithmException, IOException, FTPException {
        this(string, string2, string3, string4, stringArray, bl, bl2);
        slf4jlogger.warn("gDebug level supplied as constructor argument ignored");
    }

    public FTPFileSender(String string, String string2, String string3, String string4, String[] stringArray, boolean bl, boolean bl2) throws NoSuchAlgorithmException, IOException, FTPException {
        this(string, string2, string3, string4, stringArray, bl, bl2, null, null);
    }

    public FTPFileSender(String string, String string2, String string3, String string4, String[] stringArray, boolean bl, boolean bl2, int n, MessageLogger messageLogger, JProgressBar jProgressBar) throws NoSuchAlgorithmException, IOException, FTPException {
        this(string, string2, string3, string4, stringArray, bl, bl2, messageLogger, jProgressBar);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPFileSender(String string, String string2, String string3, String string4, String[] stringArray, boolean bl, boolean bl2, MessageLogger messageLogger, JProgressBar jProgressBar) throws NoSuchAlgorithmException, IOException, FTPException {
        SafeProgressBarUpdaterThread safeProgressBarUpdaterThread = null;
        if (jProgressBar != null) {
            safeProgressBarUpdaterThread = new SafeProgressBarUpdaterThread(jProgressBar);
        }
        FTPSClient fTPSClient = bl ? new FTPSClient("TLS", false) : new FTPClient();
        slf4jlogger.debug("FTPClient original connect timeout = {} ms", fTPSClient.getConnectTimeout());
        fTPSClient.setConnectTimeout(socketConnectTimeoutInMilliSeconds);
        slf4jlogger.debug("FTPClient replaced connect timeout = {} ms", fTPSClient.getConnectTimeout());
        if (slf4jlogger.isDebugEnabled()) {
            fTPSClient.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.err)));
        }
        try {
            if (bl) {
                try {
                    slf4jlogger.debug("Trying to connect in explicit mode to {}", string);
                    fTPSClient.connect(string);
                }
                catch (Exception exception) {
                    slf4jlogger.debug("Failed to connect in explicit mode to {}", string, exception);
                    slf4jlogger.debug("Trying again in implicit mode on port 990");
                    fTPSClient = new FTPSClient("TLS", true);
                    slf4jlogger.debug("FTPClient original connect timeout = {} ms", fTPSClient.getConnectTimeout());
                    fTPSClient.setConnectTimeout(socketConnectTimeoutInMilliSeconds);
                    slf4jlogger.debug("FTPClient replaced connect timeout = {} ms", fTPSClient.getConnectTimeout());
                    fTPSClient.setDefaultPort(990);
                    if (slf4jlogger.isDebugEnabled()) {
                        fTPSClient.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.err)));
                    }
                    slf4jlogger.debug("About to connect");
                    fTPSClient.connect(string);
                    slf4jlogger.debug("Back from connect");
                }
            } else {
                fTPSClient.connect(string);
            }
            slf4jlogger.debug("Connected to {}", string);
            slf4jlogger.debug(fTPSClient.getReplyString());
            int n = fTPSClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)n)) {
                fTPSClient.disconnect();
                throw new FTPException("FTP server " + string + " refused connection");
            }
            if (bl) {
                fTPSClient.execPBSZ(0L);
                fTPSClient.execPROT("P");
            }
            if (!fTPSClient.login(string2, string3)) {
                fTPSClient.disconnect();
                throw new FTPException("FTP server " + string + " login failed");
            }
            fTPSClient.enterLocalPassiveMode();
            if (string4 != null && string4.length() > 0) {
                if (!fTPSClient.changeWorkingDirectory(string4)) {
                    fTPSClient.disconnect();
                    throw new FTPException("FTP server " + string + " cwd to " + string4 + " failed");
                }
                slf4jlogger.debug("Working directory is now {}", fTPSClient.printWorkingDirectory());
            }
            if (!fTPSClient.setFileType(2)) {
                fTPSClient.disconnect();
                throw new FTPException("FTP server " + string + " set file type to Binary failed");
            }
            ApplicationEventDispatcher applicationEventDispatcher = ApplicationEventDispatcher.getApplicationEventDispatcher();
            int n2 = stringArray.length;
            SafeProgressBarUpdaterThread.startProgressBar(safeProgressBarUpdaterThread, n2);
            int n3 = 0;
            for (String string5 : stringArray) {
                SafeProgressBarUpdaterThread.updateProgressBar(safeProgressBarUpdaterThread, n3);
                File file = new File(string5);
                FileInputStream fileInputStream = new FileInputStream(file);
                String string6 = bl2 ? UUID.randomUUID().toString() : file.getName();
                slf4jlogger.debug("Attempting to store local {} to remote {}", string5, string6);
                if (!fTPSClient.storeFile(string6, (InputStream)fileInputStream)) {
                    fTPSClient.disconnect();
                    throw new FTPException("FTP server " + string + " file store of local " + string5 + " to remote " + string6 + " failed");
                }
                ((InputStream)fileInputStream).close();
                slf4jlogger.debug("Successfully stored local {} to remote {}", string5, string6);
                if (messageLogger != null) {
                    messageLogger.sendLn("Successfully stored local " + string5 + " to remote " + string6);
                }
                SafeProgressBarUpdaterThread.endProgressBar(safeProgressBarUpdaterThread);
                if (applicationEventDispatcher != null) {
                    applicationEventDispatcher.processEvent(new StatusChangeEvent("Sent " + string5 + " to Registry"));
                }
                ++n3;
            }
            fTPSClient.logout();
        }
        finally {
            if (fTPSClient.isConnected()) {
                slf4jlogger.debug("FTPFileSender(): finally so disconnect");
                fTPSClient.disconnect();
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            if (string4.equals("-") || string4.equals(".")) {
                string4 = null;
            }
            boolean bl = stringArray[4].toUpperCase(Locale.US).trim().equals("SECURE");
            boolean bl2 = stringArray[5].toUpperCase(Locale.US).trim().equals("RANDOM");
            int n = stringArray.length - 6;
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 6, stringArray2, 0, n);
            new FTPFileSender(string, string2, string3, string4, stringArray2, bl, bl2);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(1);
        }
    }
}

