/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.AAbortPDU;
import com.pixelmed.network.AssociateAcceptPDU;
import com.pixelmed.network.AssociateRejectPDU;
import com.pixelmed.network.AssociateRequestAcceptPDU;
import com.pixelmed.network.AssociateRequestPDU;
import com.pixelmed.network.Association;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ByteArray;
import java.io.IOException;
import java.net.Socket;
import java.util.LinkedList;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class AssociationInitiator
extends Association {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/AssociationInitiator.java,v 1.43 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(AssociationInitiator.class);
    private String hostname;
    private int port;

    protected AssociationInitiator(String string, int n, String string2, String string3, String string4, String string5, int n2, int n3, int n4, LinkedList linkedList, LinkedList linkedList2, boolean bl, String string6, String string7, int n5) throws DicomNetworkException, IOException {
        this(string, n, string2, string3, string4, string5, n2, n3, n4, linkedList, linkedList2, bl, string6, string7);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    protected AssociationInitiator(String string, int n, String string2, String string3, String string4, String string5, int n2, int n3, int n4, LinkedList linkedList, LinkedList linkedList2, boolean bl, String string6, String string7) throws DicomNetworkException, IOException {
        long l;
        block25: {
            this.hostname = string;
            this.port = n;
            this.calledAETitle = string2;
            this.callingAETitle = string3;
            this.presentationContexts = linkedList;
            this.scuSCPRoleSelections = linkedList2;
            slf4jlogger.debug("establishing Association");
            l = System.currentTimeMillis();
            int n5 = 0;
            String string8 = null;
            String string9 = null;
            if (string6 != null) {
                string8 = string6;
                if (string7 != null) {
                    string9 = string7;
                    n5 = 2;
                } else {
                    n5 = 1;
                }
            }
            slf4jlogger.trace("Association[{}]: userIdentityType={}", this.associationNumber, n5);
            slf4jlogger.trace("Association[{}]: OurMaximumLengthReceived={}", this.associationNumber, n2);
            AssociateRequestPDU associateRequestPDU = new AssociateRequestPDU(string2, string3, string4, string5, n2, linkedList, linkedList2, n5, string8, string9);
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("Association[{}]: Us:\n{}", this.associationNumber, associateRequestPDU.toString());
            }
            long l2 = System.currentTimeMillis();
            try {
                Object object;
                Object object2;
                if (bl) {
                    object2 = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    SSLSocket sSLSocket = (SSLSocket)((SocketFactory)object2).createSocket(string, n);
                    String[] stringArray = AssociationInitiator.getCipherSuitesToEnable(sSLSocket.getSupportedCipherSuites());
                    if (stringArray != null) {
                        sSLSocket.setEnabledCipherSuites(stringArray);
                    }
                    if ((object = AssociationInitiator.getProtocolsToEnable(sSLSocket.getEnabledProtocols())) != null) {
                        sSLSocket.setEnabledProtocols((String[])object);
                    }
                    this.socket = sSLSocket;
                } else {
                    this.socket = new Socket(string, n);
                }
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("took {} mS for new Socket to return", System.currentTimeMillis() - l2);
                }
                this.setSocketOptions(this.socket, n2, n3, n4);
                this.in = this.socket.getInputStream();
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("took {} mS from requesting new Socket to get input stream", System.currentTimeMillis() - l2);
                }
                this.out = this.socket.getOutputStream();
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("took {} mS from requesting new Socket to get output stream", System.currentTimeMillis() - l2);
                }
                this.out.write(associateRequestPDU.getBytes());
                this.out.flush();
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("took {} mS from requesting new Socket to back from writing A-ASSOCIATE-RQ PDU", System.currentTimeMillis() - l2);
                }
                object2 = new byte[6];
                AssociationInitiator.readInsistently(this.in, (byte[])object2, 0, 6, "type and length of PDU");
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("took {} mS from requesting new Socket to back from reading A-ASSOCIATE-AC or -RJ PDU", System.currentTimeMillis() - l2);
                }
                int n6 = object2[0] & 0xFF;
                int n7 = ByteArray.bigEndianToUnsignedInt((byte[])object2, 2, 4);
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("Association[{}]: Them: PDU Type: 0x{} (length 0x{})", this.associationNumber, Integer.toHexString(n6), Integer.toHexString(n7));
                }
                if (n6 == 2) {
                    object = new AssociateAcceptPDU(AssociationInitiator.getRestOfPDU(this.in, (byte[])object2, n7));
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("Association[{}]: Them:\n{}", this.associationNumber, ((AssociateRequestAcceptPDU)object).toString());
                    }
                    this.presentationContexts = ((AssociateRequestAcceptPDU)object).getAcceptedPresentationContextsWithAbstractSyntaxIncludedFromRequest(this.presentationContexts);
                    if (this.maximumLengthReceived == 0 || ((AssociateRequestAcceptPDU)object).getMaximumLengthReceived() < this.maximumLengthReceived) {
                        this.maximumLengthReceived = ((AssociateRequestAcceptPDU)object).getMaximumLengthReceived();
                    }
                    slf4jlogger.debug("Association[{}]: We will send them PDUs of: {}", this.associationNumber, this.maximumLengthReceived);
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("Association[{}]: Accepted presentation contexts:\n{}", this.associationNumber, this.presentationContexts.toString());
                    }
                    break block25;
                }
                if (n6 == 3) {
                    object = new AssociateRejectPDU(AssociationInitiator.getRestOfPDU(this.in, (byte[])object2, n7));
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("Association[{}]: Them:\n{}", this.associationNumber, ((AssociateRejectPDU)object).toString());
                    }
                    this.socket.close();
                    throw new DicomNetworkException("A-ASSOCIATE-RJ indication - " + ((AssociateRejectPDU)object).getInfo());
                }
                if (n6 == 7) {
                    object = new AAbortPDU(AssociationInitiator.getRestOfPDU(this.in, (byte[])object2, n7));
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("Association[{}]: Them:\n{}", this.associationNumber, ((AAbortPDU)object).toString());
                    }
                    this.socket.close();
                    throw new DicomNetworkException("A-ABORT indication - " + ((AAbortPDU)object).getInfo());
                }
                slf4jlogger.trace("Association[{}]: Aborting", this.associationNumber);
                object = new AAbortPDU(2, 2);
                this.out.write(((AAbortPDU)object).getBytes());
                this.out.flush();
                this.socket.close();
                throw new DicomNetworkException("A-P-ABORT indication - " + ((AAbortPDU)object).getInfo());
            }
            catch (IOException iOException) {
                throw new DicomNetworkException("A-P-ABORT indication - (" + string + ":" + Integer.toString(n) + ") - " + iOException);
            }
        }
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("took {} mS to establish Association", System.currentTimeMillis() - l);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Association[" + this.associationNumber + "]: Hostname: ");
        stringBuffer.append(this.hostname);
        stringBuffer.append("\n");
        stringBuffer.append("Association[" + this.associationNumber + "]: Port: ");
        stringBuffer.append(this.port);
        stringBuffer.append("\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    @Override
    public String getCallingAEHostName() {
        return this.getLocalHostName();
    }

    @Override
    public String getCalledAEHostName() {
        return this.getRemoteHostName();
    }

    @Override
    public int getCallingAEPort() {
        return this.getLocalPort();
    }

    @Override
    public int getCalledAEPort() {
        return this.getRemotePort();
    }
}

