/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.NetworkConfigurationSource;
import com.pixelmed.network.NetworkDefaultValues;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;

public class NetworkApplicationProperties {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/NetworkApplicationProperties.java,v 1.30 2025/01/29 10:58:08 dclunie Exp $";
    public static final String propertyName_DicomListeningPort = "Dicom.ListeningPort";
    public static final String propertyName_DicomCalledAETitle = "Dicom.CalledAETitle";
    public static final String propertyName_DicomCallingAETitle = "Dicom.CallingAETitle";
    public static final String propertyName_PrimaryDeviceType = "Dicom.PrimaryDeviceType";
    public static final String propertyName_DicomAcceptorMaximumLengthReceived = "Dicom.AcceptorMaximumLengthReceived";
    public static final String propertyName_DicomAcceptorSocketReceiveBufferSize = "Dicom.AcceptorSocketReceiveBufferSize";
    public static final String propertyName_DicomAcceptorSocketSendBufferSize = "Dicom.AcceptorSocketSendBufferSize";
    public static final String propertyName_DicomInitiatorMaximumLengthReceived = "Dicom.InitiatorMaximumLengthReceived";
    public static final String propertyName_DicomInitiatorSocketReceiveBufferSize = "Dicom.InitiatorSocketReceiveBufferSize";
    public static final String propertyName_DicomInitiatorSocketSendBufferSize = "Dicom.InitiatorSocketSendBufferSize";
    public static final String StudyRootQueryModel = "STUDYROOT";
    public static final String PatientRootQueryModel = "PATIENTROOT";
    public static final String PatientStudyOnlyQueryModel = "PATIENTSTUDYONLY";
    public static final String propertyName_StorageSCUCompressionLevel = "Dicom.StorageSCUCompressionLevel";
    private int port;
    private String calledAETitle;
    private String callingAETitle;
    private String primaryDeviceType;
    private int storageSCUCompressionLevel;
    private int acceptorMaximumLengthReceived;
    private int acceptorSocketReceiveBufferSize;
    private int acceptorSocketSendBufferSize;
    private int initiatorMaximumLengthReceived;
    private int initiatorSocketReceiveBufferSize;
    private int initiatorSocketSendBufferSize;
    private NetworkApplicationInformation networkApplicationInformation;
    protected NetworkConfigurationSource networkConfigurationSource = null;

    public static final boolean isStudyRootQueryModel(String string) {
        return string != null && string.equals(StudyRootQueryModel);
    }

    public static final boolean isPatientRootQueryModel(String string) {
        return string != null && string.equals(PatientRootQueryModel);
    }

    public static final boolean isPatientStudyOnlyQueryModel(String string) {
        return string != null && string.equals(PatientStudyOnlyQueryModel);
    }

    public NetworkApplicationProperties() throws DicomNetworkException {
        this.port = 11112;
        this.callingAETitle = this.calledAETitle = NetworkDefaultValues.getDefaultApplicationEntityTitle(this.port);
        this.primaryDeviceType = NetworkDefaultValues.getDefaultPrimaryDeviceType();
        this.storageSCUCompressionLevel = 0;
        this.acceptorMaximumLengthReceived = AssociationFactory.getDefaultMaximumLengthReceived();
        this.acceptorSocketReceiveBufferSize = AssociationFactory.getDefaultReceiveBufferSize();
        this.acceptorSocketSendBufferSize = AssociationFactory.getDefaultSendBufferSize();
        this.initiatorMaximumLengthReceived = AssociationFactory.getDefaultMaximumLengthReceived();
        this.initiatorSocketReceiveBufferSize = AssociationFactory.getDefaultReceiveBufferSize();
        this.initiatorSocketSendBufferSize = AssociationFactory.getDefaultSendBufferSize();
        this.networkApplicationInformation = new NetworkApplicationInformation();
    }

    public NetworkApplicationProperties(Properties properties) throws DicomNetworkException, IOException {
        this(properties, false);
    }

    public NetworkApplicationProperties(Properties properties, boolean bl) throws DicomNetworkException, IOException {
        Set set;
        String string = properties.getProperty(propertyName_DicomListeningPort);
        this.port = string == null || string.length() == 0 ? 11112 : Integer.parseInt(string);
        this.calledAETitle = properties.getProperty(propertyName_DicomCalledAETitle);
        if (this.calledAETitle == null || this.calledAETitle.length() == 0) {
            this.calledAETitle = NetworkDefaultValues.getDefaultApplicationEntityTitle(this.port);
        }
        this.callingAETitle = properties.getProperty(propertyName_DicomCallingAETitle);
        if (this.callingAETitle == null || this.callingAETitle.length() == 0) {
            this.callingAETitle = this.calledAETitle;
        }
        this.primaryDeviceType = properties.getProperty(propertyName_PrimaryDeviceType);
        this.storageSCUCompressionLevel = Integer.valueOf(properties.getProperty(propertyName_StorageSCUCompressionLevel, "0"));
        this.acceptorMaximumLengthReceived = Integer.valueOf(properties.getProperty(propertyName_DicomAcceptorMaximumLengthReceived, Integer.toString(AssociationFactory.getDefaultMaximumLengthReceived())));
        this.acceptorSocketReceiveBufferSize = Integer.valueOf(properties.getProperty(propertyName_DicomAcceptorSocketReceiveBufferSize, Integer.toString(AssociationFactory.getDefaultReceiveBufferSize())));
        this.acceptorSocketSendBufferSize = Integer.valueOf(properties.getProperty(propertyName_DicomAcceptorSocketSendBufferSize, Integer.toString(AssociationFactory.getDefaultSendBufferSize())));
        this.initiatorMaximumLengthReceived = Integer.valueOf(properties.getProperty(propertyName_DicomInitiatorMaximumLengthReceived, Integer.toString(AssociationFactory.getDefaultMaximumLengthReceived())));
        this.initiatorSocketReceiveBufferSize = Integer.valueOf(properties.getProperty(propertyName_DicomInitiatorSocketReceiveBufferSize, Integer.toString(AssociationFactory.getDefaultReceiveBufferSize())));
        this.initiatorSocketSendBufferSize = Integer.valueOf(properties.getProperty(propertyName_DicomInitiatorSocketSendBufferSize, Integer.toString(AssociationFactory.getDefaultSendBufferSize())));
        this.networkApplicationInformation = new NetworkApplicationInformation(properties);
        if (bl && ((set = this.networkApplicationInformation.getListOfApplicationEntityTitlesOfApplicationEntities()) == null || set.size() == 0 || set.size() == 1 && set.contains(this.calledAETitle))) {
            this.networkApplicationInformation.addPublicStorageSCPs();
        }
    }

    public Properties getProperties(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        properties.setProperty(propertyName_DicomListeningPort, Integer.toString(this.port));
        properties.setProperty(propertyName_DicomCalledAETitle, this.calledAETitle);
        properties.setProperty(propertyName_DicomCallingAETitle, this.callingAETitle);
        properties.setProperty(propertyName_StorageSCUCompressionLevel, Integer.toString(this.storageSCUCompressionLevel));
        properties.setProperty(propertyName_DicomAcceptorMaximumLengthReceived, Integer.toString(this.acceptorMaximumLengthReceived));
        properties.setProperty(propertyName_DicomAcceptorSocketReceiveBufferSize, Integer.toString(this.acceptorSocketReceiveBufferSize));
        properties.setProperty(propertyName_DicomAcceptorSocketSendBufferSize, Integer.toString(this.acceptorSocketSendBufferSize));
        properties.setProperty(propertyName_DicomInitiatorMaximumLengthReceived, Integer.toString(this.initiatorMaximumLengthReceived));
        properties.setProperty(propertyName_DicomInitiatorSocketReceiveBufferSize, Integer.toString(this.initiatorSocketReceiveBufferSize));
        properties.setProperty(propertyName_DicomInitiatorSocketSendBufferSize, Integer.toString(this.initiatorSocketSendBufferSize));
        this.networkApplicationInformation.getProperties(properties);
        return properties;
    }

    public int getListeningPort() {
        return this.port;
    }

    public void setListeningPort(int n) {
        this.port = n;
    }

    public String getCalledAETitle() {
        return this.calledAETitle;
    }

    public void setCalledAETitle(String string) {
        this.calledAETitle = string;
    }

    public String getCallingAETitle() {
        return this.callingAETitle;
    }

    public void setCallingAETitle(String string) {
        this.callingAETitle = string;
    }

    public String getPrimaryDeviceType() {
        return this.primaryDeviceType;
    }

    public void setPrimaryDeviceType(String string) {
        this.primaryDeviceType = string;
    }

    public int getStorageSCUCompressionLevel() {
        return this.storageSCUCompressionLevel;
    }

    public int getAcceptorMaximumLengthReceived() {
        return this.acceptorMaximumLengthReceived;
    }

    public void setAcceptorMaximumLengthReceived(int n) {
        this.acceptorMaximumLengthReceived = n;
    }

    public int getAcceptorSocketReceiveBufferSize() {
        return this.acceptorSocketReceiveBufferSize;
    }

    public void setAcceptorSocketReceiveBufferSize(int n) {
        this.acceptorSocketReceiveBufferSize = n;
    }

    public int getAcceptorSocketSendBufferSize() {
        return this.acceptorSocketSendBufferSize;
    }

    public void setAcceptorSocketSendBufferSize(int n) {
        this.acceptorSocketSendBufferSize = n;
    }

    public int getInitiatorMaximumLengthReceived() {
        return this.initiatorMaximumLengthReceived;
    }

    public void setInitiatorMaximumLengthReceived(int n) {
        this.initiatorMaximumLengthReceived = n;
    }

    public int getInitiatorSocketReceiveBufferSize() {
        return this.initiatorSocketReceiveBufferSize;
    }

    public void setInitiatorSocketReceiveBufferSize(int n) {
        this.initiatorSocketReceiveBufferSize = n;
    }

    public int getInitiatorSocketSendBufferSize() {
        return this.initiatorSocketSendBufferSize;
    }

    public void setInitiatorSocketSendBufferSize(int n) {
        this.initiatorSocketSendBufferSize = n;
    }

    public NetworkApplicationInformation getNetworkApplicationInformation() {
        return this.networkApplicationInformation;
    }

    public NetworkConfigurationSource getNetworkConfigurationSource() {
        if (this.networkConfigurationSource == null) {
            this.networkConfigurationSource = new OurNetworkConfigurationSource(this.networkApplicationInformation);
        }
        return this.networkConfigurationSource;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Our port: " + this.port + "\n");
        stringBuffer.append("Our calledAETitle: " + this.calledAETitle + "\n");
        stringBuffer.append("Our callingAETitle: " + this.callingAETitle + "\n");
        stringBuffer.append("Our primaryDeviceType: " + this.primaryDeviceType + "\n");
        stringBuffer.append("storageSCUCompressionLevel: " + this.storageSCUCompressionLevel + "\n");
        stringBuffer.append("acceptorMaximumLengthReceived: " + this.acceptorMaximumLengthReceived + "\n");
        stringBuffer.append("acceptorSocketReceiveBufferSize: " + this.acceptorSocketReceiveBufferSize + "\n");
        stringBuffer.append("acceptorSocketSendBufferSize: " + this.acceptorSocketSendBufferSize + "\n");
        stringBuffer.append("initiatorMaximumLengthReceived: " + this.initiatorMaximumLengthReceived + "\n");
        stringBuffer.append("initiatorSocketReceiveBufferSize: " + this.initiatorSocketReceiveBufferSize + "\n");
        stringBuffer.append("initiatorSocketSendBufferSize: " + this.initiatorSocketSendBufferSize + "\n");
        stringBuffer.append("Remote applications:\n" + this.networkApplicationInformation + "\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            System.out.print(new NetworkApplicationProperties(properties).getNetworkApplicationInformation().getLDIFRepresentation(stringArray[1]));
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    protected class OurNetworkConfigurationSource
    extends NetworkConfigurationSource {
        private NetworkApplicationInformation ourNetworkApplicationInformation;

        OurNetworkConfigurationSource(NetworkApplicationInformation networkApplicationInformation) {
            this.ourNetworkApplicationInformation = networkApplicationInformation;
        }

        @Override
        public synchronized NetworkApplicationInformation getNetworkApplicationInformation() {
            return this.ourNetworkApplicationInformation;
        }

        @Override
        public void activateDiscovery(int n) {
        }

        @Override
        public void deActivateDiscovery() {
        }
    }
}

