/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.ApplicationEntity;
import com.pixelmed.network.NetworkConfigurationSource;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TimerTask;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class NetworkConfigurationFromLDAP
extends NetworkConfigurationSource {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/NetworkConfigurationFromLDAP.java,v 1.17 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(NetworkConfigurationFromLDAP.class);
    private static final String defaultInitialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String defaultProviderURL = "ldap:";
    private static final String defaultdevicesDN = "cn=Devices,cn=DICOM Configuration,o=pixelmed,c=us";
    private static final String devicesRDN = "cn=Devices";
    protected GetNetworkApplicationInformation getter;

    private String getDicomDevicesRootDistinguishedName(DirContext dirContext) {
        Object object;
        String string = null;
        try {
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("getDicomDevicesRootDistinguishedName: name of context = {}", dirContext.getNameInNamespace());
            }
            object = new SearchControls();
            ((SearchControls)object).setSearchScope(2);
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search("", "(cn=DICOM Configuration)", (SearchControls)object);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                string = searchResult.getName();
                slf4jlogger.trace("getDicomDevicesRootDistinguishedName: found {}", string);
            }
        }
        catch (NamingException namingException) {
            slf4jlogger.error("Ignoring exception", namingException);
        }
        object = null;
        if (string == null) {
            object = defaultdevicesDN;
            slf4jlogger.trace("getDicomDevicesRootDistinguishedName: not found  - using default name = {}", object);
        } else {
            object = "cn=Devices," + string;
        }
        return object;
    }

    @Override
    public void activateDiscovery(int n) {
        if (n == 0) {
            this.getNetworkConfiguration();
        } else {
            if (this.getter == null) {
                this.getter = new GetNetworkApplicationInformation(n);
            }
            this.getter.start();
        }
    }

    @Override
    public void deActivateDiscovery() {
        if (this.getter != null) {
            this.getter.cancel();
        }
    }

    protected void getNetworkConfiguration() {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", defaultInitialContextFactory);
            hashtable.put("java.naming.provider.url", defaultProviderURL);
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            String string = this.getDicomDevicesRootDistinguishedName(initialDirContext);
            NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(string, null);
            while (namingEnumeration.hasMore()) {
                String string2;
                Attributes attributes = namingEnumeration.next().getAttributes();
                BasicAttribute basicAttribute = (BasicAttribute)attributes.get("dicomDeviceName");
                String string3 = basicAttribute == null ? "" : basicAttribute.get(0).toString();
                slf4jlogger.trace("dicomDeviceName: {}", string3);
                if (basicAttribute == null) continue;
                HashMap<String, PresentationAddress> hashMap = new HashMap<String, PresentationAddress>();
                ArrayList<ApplicationEntityWithDicomNetworkConnectionName> arrayList = new ArrayList<ApplicationEntityWithDicomNetworkConnectionName>();
                NamingEnumeration<SearchResult> namingEnumeration2 = initialDirContext.search("dicomDeviceName=" + string3 + "," + string, null);
                while (namingEnumeration2.hasMore()) {
                    Object object;
                    String string4;
                    BasicAttribute basicAttribute2;
                    String string5;
                    BasicAttribute basicAttribute3;
                    Attributes attributes2 = namingEnumeration2.next().getAttributes();
                    BasicAttribute basicAttribute4 = (BasicAttribute)attributes2.get("objectClass");
                    string2 = basicAttribute4 == null ? "" : basicAttribute4.get(0).toString();
                    slf4jlogger.trace("\tvObjectClass: {}", string2);
                    if (string2 == null) continue;
                    if (string2.equals("dicomNetworkAE")) {
                        basicAttribute3 = (BasicAttribute)attributes2.get("dicomAETitle");
                        string5 = basicAttribute3 == null ? "" : basicAttribute3.get(0).toString();
                        slf4jlogger.trace("\t\tdicomAETitle: {}", string5);
                        basicAttribute2 = (BasicAttribute)attributes2.get("dicomNetworkConnectionReference");
                        string4 = basicAttribute2 == null ? "" : basicAttribute2.get(0).toString();
                        slf4jlogger.trace("\t\tdicomNetworkConnectionReference: {}", string4);
                        object = null;
                        if (string4 != null) {
                            int n = string4.indexOf(",");
                            if (n >= 0) {
                                string4 = string4.substring(0, n);
                                slf4jlogger.trace("\t\tdicomNetworkConnectionReference first part: {}", string4);
                            }
                            object = string4.replaceFirst("[cC][nN]=", "");
                            slf4jlogger.trace("\t\tdicomNetworkConnectionCommonNameValue: {}", object);
                        }
                        if (string5 == null || string5.length() <= 0 || object == null || ((String)object).length() <= 0) continue;
                        arrayList.add(new ApplicationEntityWithDicomNetworkConnectionName(string5, (String)object));
                        continue;
                    }
                    if (!string2.equals("dicomNetworkConnection")) continue;
                    basicAttribute3 = (BasicAttribute)attributes2.get("cn");
                    string5 = basicAttribute3 == null ? "" : basicAttribute3.get(0).toString();
                    slf4jlogger.trace("\t\tcn: {}", string5);
                    basicAttribute2 = (BasicAttribute)attributes2.get("dicomHostname");
                    string4 = basicAttribute2 == null ? "" : basicAttribute2.get(0).toString();
                    slf4jlogger.trace("\t\tdicomHostname: {}", string4);
                    object = (BasicAttribute)attributes2.get("dicomPort");
                    String string6 = object == null ? "" : ((BasicAttribute)object).get(0).toString();
                    slf4jlogger.trace("\t\tdicomPort: {}", string6);
                    if (string5 == null || string5.length() <= 0 || string4 == null || string4.length() <= 0 || string6 == null || string6.length() <= 0) continue;
                    hashMap.put(string5, new PresentationAddress(string4, Integer.parseInt(string6)));
                }
                for (ApplicationEntityWithDicomNetworkConnectionName applicationEntityWithDicomNetworkConnectionName : arrayList) {
                    string2 = applicationEntityWithDicomNetworkConnectionName.getDicomNetworkConnectionName();
                    applicationEntityWithDicomNetworkConnectionName.setPresentationAddress((PresentationAddress)hashMap.get(string2));
                    this.getNetworkApplicationInformation().add(string2, applicationEntityWithDicomNetworkConnectionName);
                }
                for (ApplicationEntity applicationEntity : arrayList) {
                    slf4jlogger.trace("\tApplicationEntity: {}", applicationEntity);
                }
            }
        }
        catch (CommunicationException communicationException) {
            slf4jlogger.debug("getNetworkConfiguration(): LDAP service not available (Could not contact server)", communicationException);
        }
        catch (Exception exception) {
            slf4jlogger.error("Ignoring exception", exception);
        }
    }

    public NetworkConfigurationFromLDAP(int n) {
        this();
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public NetworkConfigurationFromLDAP() {
    }

    public static void main(String[] stringArray) {
        NetworkConfigurationFromLDAP networkConfigurationFromLDAP = new NetworkConfigurationFromLDAP();
        networkConfigurationFromLDAP.activateDiscovery(5000);
        networkConfigurationFromLDAP.activateDumper(1000);
        Thread thread = Thread.currentThread();
        try {
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            networkConfigurationFromLDAP.close();
            return;
        }
    }

    protected class GetNetworkApplicationInformation
    extends TimerTask {
        private int interval;

        GetNetworkApplicationInformation(int n) {
            this.interval = n;
        }

        @Override
        public void run() {
            NetworkConfigurationFromLDAP.this.getNetworkApplicationInformation().removeAll();
            NetworkConfigurationFromLDAP.this.getNetworkConfiguration();
        }

        void start() {
            NetworkConfigurationFromLDAP.this.timer.schedule((TimerTask)this, 0L, (long)this.interval);
        }
    }

    private class ApplicationEntityWithDicomNetworkConnectionName
    extends ApplicationEntity {
        private String dicomNetworkConnectionName;

        ApplicationEntityWithDicomNetworkConnectionName(String string, String string2) {
            super(string);
            this.dicomNetworkConnectionName = string2;
        }

        public final String getDicomNetworkConnectionName() {
            return this.dicomNetworkConnectionName;
        }
    }
}

