/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.util.Timer;
import java.util.TimerTask;

public abstract class NetworkConfigurationSource {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/NetworkConfigurationSource.java,v 1.12 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(NetworkConfigurationSource.class);
    protected static final int DefaultDumpInfoInterval = 10000;
    protected static final int DefaultSourceRefreshInterval = 3600000;
    private final NetworkApplicationInformation networkApplicationInformation = new NetworkApplicationInformation();
    protected final Timer timer = new Timer();
    protected DumpNetworkApplicationInformation dumper;

    public synchronized NetworkApplicationInformation getNetworkApplicationInformation() {
        return this.networkApplicationInformation;
    }

    public final void activateDumper() {
        this.activateDumper(10000);
    }

    public void activateDumper(int n) {
        if (this.dumper == null) {
            this.dumper = new DumpNetworkApplicationInformation(n);
        }
        this.dumper.start();
    }

    public void deActivateDumper() {
        if (this.dumper != null) {
            this.dumper.cancel();
        }
    }

    protected NetworkConfigurationSource(int n) {
        this();
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    protected NetworkConfigurationSource() {
    }

    public final void close() {
        this.deActivateDiscovery();
        this.deActivateDumper();
    }

    public final void activateDiscovery() {
        this.activateDiscovery(3600000);
    }

    public abstract void activateDiscovery(int var1);

    public abstract void deActivateDiscovery();

    protected class DumpNetworkApplicationInformation
    extends TimerTask {
        private int dumpInfoInterval;

        DumpNetworkApplicationInformation(int n) {
            this.dumpInfoInterval = n;
        }

        @Override
        public void run() {
            System.err.println(NetworkConfigurationSource.this.getNetworkApplicationInformation().toString());
        }

        void start() {
            NetworkConfigurationSource.this.timer.schedule((TimerTask)this, this.dumpInfoInterval, (long)this.dumpInfoInterval);
        }
    }
}

