/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.SOPClass;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.AssociationInitiator;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkDefaultValues;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.network.PresentationContext;
import com.pixelmed.network.VerificationSOPClassSCU;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ByteArray;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class ProbeCapability
implements Runnable {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/ProbeCapability.java,v 1.24 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ProbeCapability.class);
    private boolean knowHostIsReachable = true;
    private boolean knowCalledAET;
    private boolean knowPort;
    private String callingAETitle;
    private boolean done = false;
    private String hostname;
    private int port;
    private String calledAETitle;
    private List supportedStorageSOPClasses;
    private List supportedQuerySOPClasses;
    private List supportedRetrieveWithMoveSOPClasses;
    private List supportedRetrieveWithGetSOPClasses;
    private String queryModel;
    protected static final char[] upperCase = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    protected static final char[] upperCaseNumericUnderscore = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '_', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};

    public String getCalledAETitle() {
        return this.calledAETitle;
    }

    public PresentationAddress getPresentationAddress() {
        return this.hostname != null && this.hostname.length() > 0 && this.port != 0 ? new PresentationAddress(this.hostname, this.port) : null;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public List getSupportedStorageSOPClasses() {
        return this.supportedStorageSOPClasses;
    }

    public boolean isStorageSupported() {
        return this.supportedStorageSOPClasses != null && this.supportedStorageSOPClasses.size() > 0;
    }

    public List getSupportedQuerySOPClasses() {
        return this.supportedQuerySOPClasses;
    }

    public boolean isQuerySupported() {
        return this.supportedQuerySOPClasses != null && this.supportedQuerySOPClasses.size() > 0;
    }

    public List getSupportedRetrieveWithMoveSOPClasses() {
        return this.supportedRetrieveWithMoveSOPClasses;
    }

    public boolean isRetrieveWithMoveSupported() {
        return this.supportedRetrieveWithMoveSOPClasses != null && this.supportedRetrieveWithMoveSOPClasses.size() > 0;
    }

    public List getSupportedRetrieveWithGetSOPClasses() {
        return this.supportedRetrieveWithGetSOPClasses;
    }

    public boolean isRetrieveWithGetSupported() {
        return this.supportedRetrieveWithGetSOPClasses != null && this.supportedRetrieveWithGetSOPClasses.size() > 0;
    }

    public String getQueryModel() {
        return this.queryModel;
    }

    public boolean isDone() {
        return this.done;
    }

    public static List probeSupportedSOPClasses(String[] stringArray, String string, int n, String string2, String string3, int n2) throws DicomNetworkException, IOException {
        slf4jlogger.warn("Debug level supplied as argument ignored");
        return ProbeCapability.probeSupportedSOPClasses(stringArray, string, n, string2, string3);
    }

    public static List probeSupportedSOPClasses(String[] stringArray, String string, int n, String string2, String string3) throws DicomNetworkException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedList<PresentationContext> linkedList = new LinkedList<PresentationContext>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        linkedList2.add("1.2.840.10008.1.2");
        int n2 = 0;
        int n3 = 1;
        while (n2 < stringArray.length) {
            linkedList.add(new PresentationContext((byte)n3, stringArray[n2], linkedList2));
            ++n2;
            n3 += 2;
        }
        AssociationInitiator associationInitiator = AssociationFactory.createNewAssociation(string, n, string2, string3, linkedList, null, false);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("Storage test association\n{}", ((Association)associationInitiator).toString());
        }
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            try {
                byte by = associationInitiator.getSuitablePresentationContextID(stringArray[n3]);
                arrayList.add(stringArray[n3]);
                continue;
            }
            catch (DicomNetworkException dicomNetworkException) {
                // empty catch block
            }
        }
        associationInitiator.release();
        return arrayList;
    }

    private void probeSupportedSOPClasses(String string, int n, String string2, String string3) {
        try {
            this.supportedStorageSOPClasses = ProbeCapability.probeSupportedSOPClasses(SOPClass.arrayOfStorageSOPClasses, string, n, string2, string3);
            slf4jlogger.trace("Supported Storage SOP Classes {}", this.supportedStorageSOPClasses);
        }
        catch (Exception exception) {
            slf4jlogger.trace("", exception);
        }
        try {
            this.supportedQuerySOPClasses = ProbeCapability.probeSupportedSOPClasses(SOPClass.arrayOfQuerySOPClasses, string, n, string2, string3);
            slf4jlogger.trace("Supported Query SOP Classes {}", this.supportedQuerySOPClasses);
            if (this.supportedQuerySOPClasses != null) {
                if (this.supportedQuerySOPClasses.contains("1.2.840.10008.5.1.4.1.2.2.1")) {
                    this.queryModel = "STUDYROOT";
                } else if (this.supportedQuerySOPClasses.contains("1.2.840.10008.5.1.4.1.2.1.1")) {
                    this.queryModel = "PATIENTROOT";
                } else if (this.supportedQuerySOPClasses.contains("1.2.840.10008.5.1.4.1.2.3.1")) {
                    this.queryModel = "PATIENTSTUDYONLY";
                }
            }
        }
        catch (Exception exception) {
            slf4jlogger.trace("", exception);
        }
        try {
            this.supportedRetrieveWithMoveSOPClasses = ProbeCapability.probeSupportedSOPClasses(SOPClass.arrayOfRetrieveWithMoveSOPClasses, string, n, string2, string3);
            slf4jlogger.trace("Supported Retrieve with Move SOP Classes {}", this.supportedRetrieveWithMoveSOPClasses);
            if (this.supportedRetrieveWithMoveSOPClasses != null && this.queryModel == null) {
                if (this.supportedQuerySOPClasses.contains("1.2.840.10008.5.1.4.1.2.2.2")) {
                    this.queryModel = "STUDYROOT";
                } else if (this.supportedQuerySOPClasses.contains("1.2.840.10008.5.1.4.1.2.1.2")) {
                    this.queryModel = "PATIENTROOT";
                } else if (this.supportedQuerySOPClasses.contains("1.2.840.10008.5.1.4.1.2.3.2")) {
                    this.queryModel = "PATIENTSTUDYONLY";
                }
            }
        }
        catch (Exception exception) {
            slf4jlogger.trace("", exception);
        }
        try {
            this.supportedRetrieveWithGetSOPClasses = ProbeCapability.probeSupportedSOPClasses(SOPClass.arrayOfRetrieveWithGetSOPClasses, string, n, string2, string3);
            slf4jlogger.trace("Supported Retrieve with Get SOP Classes {}{}", this.supportedRetrieveWithGetSOPClasses);
            if (this.supportedRetrieveWithGetSOPClasses != null && this.queryModel == null) {
                if (this.supportedQuerySOPClasses.contains("1.2.840.10008.5.1.4.1.2.2.3")) {
                    this.queryModel = "STUDYROOT";
                } else if (this.supportedQuerySOPClasses.contains("1.2.840.10008.5.1.4.1.2.1.3")) {
                    this.queryModel = "PATIENTROOT";
                } else if (this.supportedQuerySOPClasses.contains("1.2.840.10008.5.1.4.1.2.3.3")) {
                    this.queryModel = "PATIENTSTUDYONLY";
                }
            }
        }
        catch (Exception exception) {
            slf4jlogger.trace("", exception);
        }
    }

    public ProbeCapability(String string, String string2, int n) throws DicomNetworkException {
        this(string, string2);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public ProbeCapability(String string, String string2) throws DicomNetworkException {
        this.knowCalledAET = false;
        this.knowPort = false;
        this.calledAETitle = null;
        this.callingAETitle = string2;
        this.hostname = string;
        this.port = 0;
    }

    public ProbeCapability(String string, String string2, String string3, int n) throws DicomNetworkException {
        this(string, string2, string3);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public ProbeCapability(String string, String string2, String string3) throws DicomNetworkException {
        this.knowCalledAET = true;
        this.knowPort = false;
        this.calledAETitle = string2;
        this.callingAETitle = string3;
        this.hostname = string;
        this.port = 0;
    }

    public ProbeCapability(String string, int n, String string2, String string3, int n2) {
        this(string, n, string2, string3);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public ProbeCapability(String string, int n, String string2, String string3) {
        this.knowCalledAET = true;
        this.knowPort = true;
        this.calledAETitle = string2;
        this.callingAETitle = string3;
        this.hostname = string;
        this.port = n;
    }

    @Override
    public void run() {
        slf4jlogger.info("ProbeCapability.run()");
        try {
            if (!this.knowPort) {
                this.port = 0;
                for (int i = 0; this.port == 0 && i < NetworkDefaultValues.commonPortNumbers.length; ++i) {
                    int n = NetworkDefaultValues.commonPortNumbers[i];
                    slf4jlogger.trace("Trying port {}", n);
                    try {
                        if (!ProbeCapability.canConnectToPort(this.hostname, n)) continue;
                        if (!this.knowCalledAET) {
                            this.calledAETitle = null;
                            AETGenerator aETGenerator = new AETGenerator(this.hostname, n);
                            String string = aETGenerator.next();
                            while (string != null && this.calledAETitle == null) {
                                try {
                                    slf4jlogger.info("Trying Called AET {}", string);
                                    new VerificationSOPClassSCU(this.hostname, n, string, this.callingAETitle, false);
                                    this.port = n;
                                    this.calledAETitle = string;
                                }
                                catch (Exception exception) {
                                    slf4jlogger.trace("", exception);
                                }
                                string = aETGenerator.next();
                            }
                            continue;
                        }
                        new VerificationSOPClassSCU(this.hostname, n, this.calledAETitle, this.callingAETitle, false);
                        this.port = n;
                        continue;
                    }
                    catch (Exception exception) {
                        slf4jlogger.trace("", exception);
                    }
                }
                if (this.port != 0) {
                    slf4jlogger.trace("ProbeCapability: successful verification on port {}", this.port);
                }
            }
            if (this.hostname != null && this.port != 0) {
                this.probeSupportedSOPClasses(this.hostname, this.port, this.calledAETitle, this.callingAETitle);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
        this.done = true;
    }

    public void runUntilDone() throws InterruptedException {
        new Thread(this).start();
        while (!this.done) {
            Thread.sleep(10L);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AE [");
        stringBuffer.append(this.calledAETitle);
        stringBuffer.append("], host [");
        stringBuffer.append(this.hostname);
        stringBuffer.append("], port [");
        stringBuffer.append(this.port);
        stringBuffer.append("], query model [");
        stringBuffer.append(this.queryModel);
        stringBuffer.append("]\n");
        stringBuffer.append("\tSupported Storage SOP Classes = ");
        stringBuffer.append(this.supportedStorageSOPClasses);
        stringBuffer.append("\n");
        stringBuffer.append("\tSupported Query SOP Classes = ");
        stringBuffer.append(this.supportedQuerySOPClasses);
        stringBuffer.append("\n");
        stringBuffer.append("\tSupported Retrieve with Move SOP Classes = ");
        stringBuffer.append(this.supportedRetrieveWithMoveSOPClasses);
        stringBuffer.append("\n");
        stringBuffer.append("\tSupported Retrieve with Get SOP Classes = ");
        stringBuffer.append(this.supportedRetrieveWithGetSOPClasses);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static boolean canConnectToPort(String string, int n) {
        return ProbeCapability.canConnectToPort(string, n, 0);
    }

    public static boolean canConnectToPort(String string, int n, int n2) {
        boolean bl = false;
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            Socket socket = new Socket();
            socket.connect(inetSocketAddress, n2);
            socket.close();
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    static boolean isReachable(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress();
        int n = 0;
        for (int i = 0; n == 0 && i < NetworkDefaultValues.commonPortNumbers.length; ++i) {
            int n2 = NetworkDefaultValues.commonPortNumbers[i];
            if (!ProbeCapability.canConnectToPort(string, n2)) continue;
            n = n2;
        }
        return n > 0;
    }

    static void probeHostOfUnknownDICOMIdentity(InetAddress inetAddress, String string) {
    }

    static void probeRangeOfHostsInLocalSubnet(int n, int n2, String string) {
        int n3 = n & n2;
        int n4 = n3 + 1;
        int n5 = ((n3 | ~n2) & 0xFFFFFFFF) - 1;
        int n6 = n;
        try {
            InetAddress inetAddress = InetAddress.getByAddress(ByteArray.intToBigEndianArray(n6, 4));
            if (ProbeCapability.isReachable(inetAddress)) {
                slf4jlogger.info("Can reach address {}", inetAddress);
            } else {
                slf4jlogger.info("Cannot reach address {}", inetAddress);
            }
        }
        catch (UnknownHostException unknownHostException) {
            slf4jlogger.error("", unknownHostException);
        }
    }

    static InetAddress[] getAllLocalHosts() {
        InetAddress[] inetAddressArray = null;
        try {
            String string;
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (inetAddress != null && (string = inetAddress.getHostName()) != null) {
                inetAddressArray = InetAddress.getAllByName(string);
            }
        }
        catch (UnknownHostException unknownHostException) {
            slf4jlogger.error("", unknownHostException);
        }
        return inetAddressArray;
    }

    public static void probeRangeAllHostsOnLocalSubnet(String string) {
        InetAddress[] inetAddressArray = ProbeCapability.getAllLocalHosts();
        if (inetAddressArray != null) {
            for (int i = 0; i < inetAddressArray.length; ++i) {
                InetAddress inetAddress = inetAddressArray[i];
                slf4jlogger.info("Got address {}", ProbeCapability.describeIPAddress(inetAddress));
                if (inetAddress == null || !(inetAddress instanceof Inet4Address)) continue;
                Inet4Address inet4Address = (Inet4Address)inetAddress;
                int n = ByteArray.bigEndianToUnsignedInt(inet4Address.getAddress());
                int n2 = -256;
                ProbeCapability.probeRangeOfHostsInLocalSubnet(n, n2, string);
            }
        }
    }

    public static String describeIPAddress(InetAddress inetAddress) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("InetAddress " + inetAddress + "\n");
        if (inetAddress != null) {
            stringBuffer.append("\tis Inet4Address = " + (inetAddress instanceof Inet4Address) + "\n");
            stringBuffer.append("\tis Inet6Address = " + (inetAddress instanceof Inet6Address) + "\n");
            stringBuffer.append("\tgetCanonicalHostName() = " + inetAddress.getCanonicalHostName() + "\n");
            stringBuffer.append("\tgetHostAddress() = " + inetAddress.getHostAddress() + "\n");
            stringBuffer.append("\tgetHostName() = " + inetAddress.getHostName() + "\n");
            stringBuffer.append("\tisMulticastAddress() = " + inetAddress.isMulticastAddress() + "\n");
            stringBuffer.append("\tisAnyLocalAddress() = " + inetAddress.isAnyLocalAddress() + "\n");
            stringBuffer.append("\tisLoopbackAddress() = " + inetAddress.isLoopbackAddress() + "\n");
            stringBuffer.append("\tisLinkLocalAddress() = " + inetAddress.isLinkLocalAddress() + "\n");
            stringBuffer.append("\tisSiteLocalAddress() = " + inetAddress.isSiteLocalAddress() + "\n");
            stringBuffer.append("\tisMCGlobal() = " + inetAddress.isMCGlobal() + "\n");
            stringBuffer.append("\tisMCNodeLocal() = " + inetAddress.isMCNodeLocal() + "\n");
            stringBuffer.append("\tisMCLinkLocal() = " + inetAddress.isMCLinkLocal() + "\n");
            stringBuffer.append("\tisMCSiteLocal() = " + inetAddress.isMCSiteLocal() + "\n");
            stringBuffer.append("\tisMCOrgLocal() = " + inetAddress.isMCOrgLocal() + "\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        block12: {
            try {
                ProbeCapability probeCapability = null;
                if (stringArray.length == 1) {
                    ProbeCapability.probeRangeAllHostsOnLocalSubnet(stringArray[0]);
                } else if (stringArray.length == 2) {
                    probeCapability = new ProbeCapability(stringArray[0], stringArray[1]);
                } else if (stringArray.length == 3) {
                    probeCapability = new ProbeCapability(stringArray[0], stringArray[1], stringArray[2]);
                } else if (stringArray.length == 4) {
                    probeCapability = new ProbeCapability(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2], stringArray[3]);
                } else {
                    System.err.println("Usage: hostname [[port] calledAET] callingAET");
                }
                if (probeCapability == null) break block12;
                try {
                    probeCapability.runUntilDone();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
                System.out.print(probeCapability);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.exit(0);
            }
        }
    }

    protected class AETGenerator {
        protected boolean usedHostnameAsSupplied;
        protected boolean usedHostnameAsAllUpperCase;
        protected boolean usedAllUpperCaseNumericUnderscore;
        protected StringPermutationGenerator upperCaseNumericUnderscorePermutationGenerator;
        protected final String hostname;
        protected final int port;

        public AETGenerator(String string, int n) {
            this.port = n;
            if (string != null && string.length() > 0) {
                this.usedHostnameAsSupplied = false;
                this.usedHostnameAsAllUpperCase = false;
                this.hostname = string;
            } else {
                this.usedHostnameAsSupplied = false;
                this.usedHostnameAsAllUpperCase = false;
                this.hostname = null;
            }
            this.usedAllUpperCaseNumericUnderscore = false;
            this.upperCaseNumericUnderscorePermutationGenerator = null;
        }

        public String next() {
            if (!this.usedHostnameAsSupplied) {
                this.usedHostnameAsSupplied = true;
                return this.hostname;
            }
            if (!this.usedHostnameAsAllUpperCase) {
                this.usedHostnameAsAllUpperCase = true;
                return this.hostname.toUpperCase(Locale.US);
            }
            if (!this.usedAllUpperCaseNumericUnderscore) {
                String string;
                if (this.upperCaseNumericUnderscorePermutationGenerator == null) {
                    this.upperCaseNumericUnderscorePermutationGenerator = new StringPermutationGenerator(upperCase, upperCaseNumericUnderscore, 16);
                }
                if ((string = this.upperCaseNumericUnderscorePermutationGenerator.next()) != null) {
                    return string;
                }
                this.usedAllUpperCaseNumericUnderscore = true;
            }
            return null;
        }
    }

    protected class StringPermutationGenerator {
        protected final char[] firstCharacterPossibilities;
        protected final char[] subsequentCharacterPossibilities;
        protected final int maximumLength;
        protected final int[] indicesIntoCharacterPossibilities;
        protected final int maximumFirstCharacterIndex;
        protected final int maximumSubsequentCharacterIndex;
        protected boolean done;

        public StringPermutationGenerator(char[] cArray, char[] cArray2, int n) {
            this.firstCharacterPossibilities = cArray;
            this.subsequentCharacterPossibilities = cArray2;
            this.maximumLength = n;
            this.indicesIntoCharacterPossibilities = new int[n];
            for (int i = 0; i < n; ++i) {
                this.indicesIntoCharacterPossibilities[i] = -1;
            }
            this.maximumFirstCharacterIndex = cArray.length - 1;
            this.maximumSubsequentCharacterIndex = cArray2.length - 1;
            this.done = false;
        }

        public String next() {
            if (!this.done) {
                int n;
                boolean bl = false;
                int n2 = this.maximumFirstCharacterIndex;
                for (n = 0; n < this.maximumLength; ++n) {
                    int n3 = this.indicesIntoCharacterPossibilities[n];
                    if (n3 < n2) {
                        int n4 = n;
                        this.indicesIntoCharacterPossibilities[n4] = this.indicesIntoCharacterPossibilities[n4] + 1;
                        bl = true;
                        break;
                    }
                    this.indicesIntoCharacterPossibilities[n] = 0;
                    n2 = this.maximumSubsequentCharacterIndex;
                }
                if (bl) {
                    int n5;
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cArray = this.firstCharacterPossibilities;
                    n = 0;
                    while (n < this.maximumLength && (n5 = this.indicesIntoCharacterPossibilities[n]) != -1) {
                        char c = cArray[n5];
                        stringBuffer.append(c);
                        n5 = this.indicesIntoCharacterPossibilities[++n];
                        cArray = this.subsequentCharacterPossibilities;
                    }
                    return stringBuffer.toString();
                }
                this.done = true;
                return null;
            }
            return null;
        }
    }
}

