/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.DicomException;
import com.pixelmed.network.Association;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PDataPDU;
import com.pixelmed.network.PresentationDataValue;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;

public abstract class ReceivedDataHandler {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/ReceivedDataHandler.java,v 1.27 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ReceivedDataHandler.class);
    protected boolean done = false;
    protected boolean release = false;

    ReceivedDataHandler(int n) {
        this();
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    ReceivedDataHandler() {
    }

    protected void dumpPDVList(LinkedList linkedList) {
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            PresentationDataValue presentationDataValue = (PresentationDataValue)listIterator.next();
            System.err.println("Received PDV:");
            System.err.println(presentationDataValue);
        }
    }

    protected String dumpPDVListToString(LinkedList linkedList) {
        StringBuffer stringBuffer = new StringBuffer();
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            PresentationDataValue presentationDataValue = (PresentationDataValue)listIterator.next();
            stringBuffer.append("Received PDV:\n");
            stringBuffer.append(presentationDataValue);
        }
        return stringBuffer.toString();
    }

    public abstract void sendPDataIndication(PDataPDU var1, Association var2) throws DicomNetworkException, DicomException, IOException;

    public boolean isDone() {
        return this.done;
    }

    public boolean isToBeReleased() {
        return this.release;
    }

    public void setDone(boolean bl) {
        this.done = bl;
    }

    public void setRelease(boolean bl) {
        this.release = bl;
    }
}

