/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.query;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.query.QueryInformationModel;
import com.pixelmed.query.QueryTreeRecord;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class QueryTreeModel
implements TreeModel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/query/QueryTreeModel.java,v 1.20 2025/01/29 10:58:09 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(QueryTreeModel.class);
    private QueryTreeRecord root;
    private Vector listeners;

    @Override
    public Object getChild(Object object, int n) {
        return ((QueryTreeRecord)object).getChildAt(n);
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return ((QueryTreeRecord)object).getIndex((QueryTreeRecord)object2);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getChildCount(Object object) {
        return ((QueryTreeRecord)object).getChildCount();
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((QueryTreeRecord)object).getChildCount() == 0;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners == null) {
            this.listeners.removeElement(treeModelListener);
        }
    }

    public QueryTreeModel(QueryInformationModel queryInformationModel, AttributeList attributeList, int n) throws DicomException {
        this(queryInformationModel, attributeList);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public QueryTreeModel(QueryInformationModel queryInformationModel, AttributeList attributeList) throws DicomException {
        if (queryInformationModel != null) {
            String string = queryInformationModel.getCalledAETitle();
            this.root = new QueryTreeRecord(queryInformationModel, attributeList, null, string == null ? "Remote database" : string, null, null, null);
        }
    }

    private String walkTree(QueryTreeRecord queryTreeRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(queryTreeRecord.toString());
        stringBuffer.append("\n");
        int n = this.getChildCount(queryTreeRecord);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.walkTree((QueryTreeRecord)this.getChild(queryTreeRecord, i)));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.walkTree(this.root);
    }
}

