/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.scpecg;

import com.pixelmed.scpecg.DefaultHuffmanTable;
import com.pixelmed.scpecg.HuffmanTable;
import com.pixelmed.scpecg.Section2;
import java.util.ArrayList;

public class HuffmanDecoder {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/scpecg/HuffmanDecoder.java,v 1.20 2025/01/29 10:58:09 dclunie Exp $";
    private int[] extractBitMask = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    private long[] signDetectMask = new long[]{0L, 1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L};
    private long[] signExtendMask = new long[]{-4096L, -1L, -2L, -4L, -8L, -16L, -32L, -64L, -128L, -256L, -512L, -1024L, -2048L, -4096L, -8192L, -16384L, -32768L};
    private byte[] bytesToDecompress;
    private int availableBytes;
    private int byteIndex;
    private int bitIndex;
    private int currentByte;
    private long currentBits;
    private int haveBits;
    private int decompressedValueCount;
    private short lastValue;
    private short secondLastValue;
    private int huffmanTableLength;
    private int[] bitsPerPrefix;
    private int[] bitsPerEntireCode;
    private int[] tableModeSwitch;
    private long[] huffmanPrefixCodes;
    private int[] valuesRepresentedByCodes;
    private int differenceDataUsed;
    private int multiplier;
    private ArrayList huffmanTablesList;

    private String dump(long[] lArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("0x");
            stringBuffer.append(Long.toHexString(lArray[i]));
        }
        return stringBuffer.toString();
    }

    private final long reverseBits(long l, int n) {
        long l2 = 0L;
        while (n-- > 0) {
            l2 = l2 << 1 | l & 1L;
            l >>= 1;
        }
        return l2;
    }

    private final long[] swapSuppliedHuffmanTableBaseCodes(long[] lArray, int[] nArray) {
        int n = lArray.length;
        long[] lArray2 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray2[i] = this.reverseBits(lArray[i], nArray[i]);
        }
        return lArray2;
    }

    private final void getEnoughBits(int n) throws Exception {
        while (this.haveBits < n) {
            if (this.bitIndex > 7) {
                if (this.byteIndex < this.availableBytes) {
                    this.currentByte = this.bytesToDecompress[this.byteIndex++];
                    this.bitIndex = 0;
                } else {
                    throw new Exception("No more bits (having decompressed " + this.byteIndex + " dec bytes)");
                }
            }
            long l = (this.currentByte & this.extractBitMask[this.bitIndex++]) == 0 ? 0L : 1L;
            this.currentBits = (this.currentBits << 1) + l;
            ++this.haveBits;
        }
    }

    private void loadHuffmanTableInUse(int n) {
        HuffmanTable huffmanTable = null;
        if (Section2.useDefaultTable(n)) {
            huffmanTable = new DefaultHuffmanTable();
        } else if (this.huffmanTablesList != null) {
            huffmanTable = (HuffmanTable)this.huffmanTablesList.get(n);
        }
        this.huffmanTableLength = huffmanTable.getNumberOfCodeStructuresInTable();
        this.bitsPerPrefix = huffmanTable.getNumberOfBitsInPrefix();
        this.bitsPerEntireCode = huffmanTable.getNumberOfBitsInEntireCode();
        this.tableModeSwitch = huffmanTable.getTableModeSwitch();
        this.valuesRepresentedByCodes = huffmanTable.getBaseValueRepresentedByBaseCode();
        this.huffmanPrefixCodes = this.swapSuppliedHuffmanTableBaseCodes(huffmanTable.getBaseCode(), this.bitsPerPrefix);
    }

    public HuffmanDecoder(byte[] byArray, int n, int n2, int n3, ArrayList arrayList) {
        this.differenceDataUsed = n;
        this.multiplier = n2;
        this.bytesToDecompress = byArray;
        this.availableBytes = byArray.length;
        this.decompressedValueCount = 0;
        this.byteIndex = 0;
        this.bitIndex = 8;
        this.haveBits = 0;
        this.huffmanTablesList = arrayList;
        this.loadHuffmanTableInUse(Section2.useDefaultTable(n3) ? n3 : 0);
    }

    public final short decode() throws Exception {
        short s = 0;
        boolean bl = false;
        do {
            int n;
            int n2;
            for (n2 = 0; n2 < this.huffmanTableLength; ++n2) {
                n = this.bitsPerPrefix[n2];
                this.getEnoughBits(n);
                if (this.currentBits == this.huffmanPrefixCodes[n2]) break;
            }
            if (n2 >= this.huffmanTableLength) {
                throw new Exception("Code prefix not in table");
            }
            if (this.tableModeSwitch[n2] == 0) {
                n = this.valuesRepresentedByCodes[n2];
                this.loadHuffmanTableInUse(n);
                continue;
            }
            if (this.bitsPerPrefix[n2] == this.bitsPerEntireCode[n2]) {
                s = (short)this.valuesRepresentedByCodes[n2];
            } else {
                n = this.bitsPerEntireCode[n2] - this.bitsPerPrefix[n2];
                this.currentBits = 0L;
                this.haveBits = 0;
                this.getEnoughBits(n);
                if ((this.currentBits & this.signDetectMask[n]) != 0L) {
                    this.currentBits |= this.signExtendMask[n];
                }
                s = (short)this.currentBits;
            }
            if (this.differenceDataUsed == 1) {
                if (this.decompressedValueCount > 0) {
                    s = (short)(s + this.lastValue);
                }
            } else if (this.differenceDataUsed == 2) {
                if (this.decompressedValueCount > 1) {
                    s = (short)(s + 2 * this.lastValue - this.secondLastValue);
                }
            } else if (this.differenceDataUsed != 0) {
                throw new Exception("Unrecognized difference encoding method " + this.differenceDataUsed);
            }
            this.secondLastValue = this.lastValue;
            this.lastValue = s;
            this.currentBits = 0L;
            this.haveBits = 0;
            ++this.decompressedValueCount;
            bl = true;
        } while (!bl);
        s = (short)(s * this.multiplier);
        return s;
    }

    public final short[] decode(int n) throws Exception {
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = this.decode();
        }
        return sArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("availableBytes=");
        stringBuffer.append(this.availableBytes);
        stringBuffer.append(" dec, byteIndex=");
        stringBuffer.append(this.byteIndex);
        stringBuffer.append(" dec, bitIndex=");
        stringBuffer.append(this.bitIndex);
        stringBuffer.append(" dec, decompressedValueCount=");
        stringBuffer.append(this.decompressedValueCount);
        stringBuffer.append(" dec");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        int n;
        short[] sArray;
        int n2 = 28;
        byte[] byArray = new byte[]{-1, -125, 127, -32, -26, -15, 83, 101, 89, -74, 91, -106, 75, -106, 0};
        short[] sArray2 = new short[]{13, 14, 15, 14, 16, 18, 19, 20, 22, 22, 23, 23, 23, 22, 22, 20, 17, 15, 12, 8, 6, 3, 1, 0, -2, -2, -3, -3};
        short[] sArray3 = new short[]{63, 70, 74, 71, 79, 89, 96, 102, 108, 112, 114, 116, 116, 112, 110, 100, 87, 74, 59, 42, 28, 13, 5, -1, -8, -11, -13, -17};
        System.out.println("Decoded (should be exact):");
        HuffmanDecoder huffmanDecoder = new HuffmanDecoder(byArray, 2, 1, 19999, null);
        try {
            sArray = huffmanDecoder.decode(n2);
            for (n = 0; n < n2; ++n) {
                System.out.println("\t[" + n + "] \tgot " + sArray[n] + " \texpected " + sArray2[n] + " \tdifference " + (sArray[n] - sArray2[n]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.out.println("Multiplied (expect to see quantization error):");
        huffmanDecoder = new HuffmanDecoder(byArray, 2, 5, 19999, null);
        try {
            sArray = huffmanDecoder.decode(n2);
            for (n = 0; n < n2; ++n) {
                System.out.println("\t[" + n + "] \tgot " + sArray[n] + " \texpected " + sArray3[n] + " \tdifference " + (sArray[n] - sArray3[n]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

