/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.scpecg;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.scpecg.SCPTreeRecord;
import com.pixelmed.scpecg.Section;
import com.pixelmed.scpecg.SectionHeader;
import java.io.IOException;

public class Section3
extends Section {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/scpecg/Section3.java,v 1.22 2025/01/29 10:58:09 dclunie Exp $";
    private static String[] leadNameDictionary = new String[]{"Unspecified", "I", "II", "V1", "V2", "V3", "V4", "V5", "V6", "V7", "V2R", "V3R", "V4R", "V5R", "V6R", "V7R", "X", "Y", "Z", "CC5", "CM5", "Left Arm", "Right Arm", "Left Leg", "I (Frank)", "E", "C", "A", "M", "F", "H", "I -cal", "II-cal", "V1-cal", "V2-cal", "V3-cal", "V4-cal", "V5-cal", "V6-cal", "V7-cal", "V2R-cal", "V3R-cal", "V4R-cal", "V5R-cal", "V6R-cal", "V7R-cal", "X-cal", "Y-cal", "Z-cal", "CC5-cal", "CM5-cal", "Left Arm-cal", "Right Arm-cal", "Left Leg-cal", "I-cal (Frank)", "E-cal", "C-cal", "A-cal", "M-cal", "F-cal", "H-cal", "III", "aVR", "aVL", "aVF", "-aVR", "V8", "V9", "V8R", "V9R", "D (Nehb \u2013 Dorsal)", "A (Nehb \u2013 Anterior)", "J (Nehb \u2013 Inferior)", "Defibrillator lead: anterior-lateral", "External pacing lead: anteriorposterior", "A1 (Auxiliary unipolar lead 1)", "A2 (Auxiliary unipolar lead 2)", "A3 (Auxiliary unipolar lead 3)", "A4 (Auxiliary unipolar lead 4)", "V8-cal", "V9-cal", "V8R-cal", "V9R-cal", "D-cal (cal for Nehb \u2013 Dorsal)", "A-cal (cal for Nehb \u2013 Anterior)", "J-cal (cal for Nehb \u2013 Inferior)"};
    private int numberOfLeads;
    private int flagByte;
    private boolean referenceBeatUsedForCompression;
    private boolean reservedBit1;
    private boolean leadsAllSimultaneouslyRecorded;
    private int numberOfSimultaneouslyRecordedLeads;
    private long[] startingSampleNumbers;
    private long[] endingSampleNumbers;
    private long[] numbersOfSamples;
    private int[] leadNumbers;
    private String[] leadNames;

    @Override
    public String getSectionName() {
        return "Lead Definition";
    }

    public static String getLeadName(int n) {
        return n > 0 && n < leadNameDictionary.length ? leadNameDictionary[n] : "";
    }

    public static int getLeadNumber(String string) {
        for (int i = 0; i < leadNameDictionary.length; ++i) {
            if (!leadNameDictionary[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getNumberOfLeads() {
        return this.numberOfLeads;
    }

    public int getFlagByte() {
        return this.flagByte;
    }

    public boolean getReferenceBeatUsedForCompression() {
        return this.referenceBeatUsedForCompression;
    }

    public boolean getReservedBit1() {
        return this.reservedBit1;
    }

    public boolean getLeadsAllSimultaneouslyRecorded() {
        return this.leadsAllSimultaneouslyRecorded;
    }

    public int getNumberOfSimultaneouslyRecordedLeads() {
        return this.numberOfSimultaneouslyRecordedLeads;
    }

    public long[] getStartingSampleNumbers() {
        return this.startingSampleNumbers;
    }

    public long[] getEndingSampleNumbers() {
        return this.endingSampleNumbers;
    }

    public long[] getNumbersOfSamples() {
        return this.numbersOfSamples;
    }

    public int[] getLeadNumbers() {
        return this.leadNumbers;
    }

    public String[] getLeadNames() {
        if (this.leadNames == null) {
            this.leadNames = new String[this.numberOfLeads];
            for (int i = 0; i < this.numberOfLeads; ++i) {
                this.leadNames[i] = Section3.getLeadName(this.leadNumbers[i]);
            }
        }
        return this.leadNames;
    }

    public Section3(SectionHeader sectionHeader) {
        super(sectionHeader);
    }

    @Override
    public long read(BinaryInputStream binaryInputStream) throws IOException {
        this.numberOfLeads = binaryInputStream.readUnsigned8();
        ++this.bytesRead;
        --this.sectionBytesRemaining;
        this.flagByte = binaryInputStream.readUnsigned8();
        ++this.bytesRead;
        --this.sectionBytesRemaining;
        this.referenceBeatUsedForCompression = (this.flagByte & 1) != 0;
        this.reservedBit1 = (this.flagByte & 2) != 0;
        this.leadsAllSimultaneouslyRecorded = (this.flagByte & 4) != 0;
        this.numberOfSimultaneouslyRecordedLeads = (this.flagByte & 0xF8) >> 3;
        this.startingSampleNumbers = new long[this.numberOfLeads];
        this.endingSampleNumbers = new long[this.numberOfLeads];
        this.numbersOfSamples = new long[this.numberOfLeads];
        this.leadNumbers = new int[this.numberOfLeads];
        int n = 0;
        while (this.sectionBytesRemaining > 0L) {
            this.startingSampleNumbers[n] = binaryInputStream.readUnsigned32();
            this.bytesRead += 4L;
            this.sectionBytesRemaining -= 4L;
            this.endingSampleNumbers[n] = binaryInputStream.readUnsigned32();
            this.bytesRead += 4L;
            this.sectionBytesRemaining -= 4L;
            this.leadNumbers[n] = binaryInputStream.readUnsigned8();
            ++this.bytesRead;
            --this.sectionBytesRemaining;
            this.numbersOfSamples[n] = this.endingSampleNumbers[n] - this.startingSampleNumbers[n] + 1L;
            ++n;
        }
        if (n != this.numberOfLeads) {
            System.err.println("Section 3 Number Of Leads specified as " + this.numberOfLeads + " but encountered " + n);
        }
        this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        return this.bytesRead;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Number of Leads = " + this.numberOfLeads + " dec (0x" + Integer.toHexString(this.numberOfLeads) + ")\n");
        stringBuffer.append("Flag byte = " + this.flagByte + " dec (0x" + Integer.toHexString(this.flagByte) + ")\n");
        stringBuffer.append("\t" + (this.referenceBeatUsedForCompression ? "Reference Beat Used For Compression" : "Reference Beat Not Used For Compression") + "\n");
        stringBuffer.append("\t" + (this.reservedBit1 ? "Reserved Bit 1 Set" : "Reserved Bit 1 Reset") + "\n");
        stringBuffer.append("\t" + (this.leadsAllSimultaneouslyRecorded ? "Leads All Simultaneously Recorded" : "Leads Not All Simultaneously Recorded") + "\n");
        stringBuffer.append("\tNumber of Simultaneously Recorded Leads = " + this.numberOfSimultaneouslyRecordedLeads + " dec (0x" + Integer.toHexString(this.numberOfSimultaneouslyRecordedLeads) + ")\n");
        stringBuffer.append("Lead details:\n");
        for (int i = 0; i < this.numberOfLeads; ++i) {
            stringBuffer.append("\tLead " + i + ":\n");
            stringBuffer.append("\t\tStartingSampleNumbers = " + this.startingSampleNumbers[i] + " dec (0x" + Long.toHexString(this.startingSampleNumbers[i]) + ")\n");
            stringBuffer.append("\t\tEndingSampleNumbers = " + this.endingSampleNumbers[i] + " dec (0x" + Long.toHexString(this.endingSampleNumbers[i]) + ")\n");
            stringBuffer.append("\t\tNumber of Samples (computed) = " + this.numbersOfSamples[i] + " dec (0x" + Long.toHexString(this.numbersOfSamples[i]) + ")\n");
            stringBuffer.append("\t\tLead Number = " + this.leadNumbers[i] + " dec (0x" + Long.toHexString(this.leadNumbers[i]) + ") ");
            stringBuffer.append(Section3.getLeadName(this.leadNumbers[i]) + "\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public String validate() {
        return "";
    }

    @Override
    public SCPTreeRecord getTree(SCPTreeRecord sCPTreeRecord) {
        if (this.tree == null) {
            SCPTreeRecord sCPTreeRecord2 = new SCPTreeRecord(sCPTreeRecord, "Section", this.getValueForSectionNodeInTree());
            this.addSectionHeaderToTree(sCPTreeRecord2);
            new SCPTreeRecord(sCPTreeRecord2, "Number of Leads", Long.toString(this.numberOfLeads) + " dec (0x" + Long.toHexString(this.numberOfLeads) + ")");
            SCPTreeRecord sCPTreeRecord3 = new SCPTreeRecord(sCPTreeRecord2, "Flag byte", "0x" + Integer.toHexString(this.numberOfLeads));
            new SCPTreeRecord(sCPTreeRecord2, "Reference Beat Used For Compression", this.referenceBeatUsedForCompression ? "yes" : "no");
            new SCPTreeRecord(sCPTreeRecord2, "Reserved Bit 1", this.reservedBit1 ? "set" : "reset");
            new SCPTreeRecord(sCPTreeRecord2, "Leads All Simultaneously Recorded", this.leadsAllSimultaneouslyRecorded ? "yes" : "no");
            new SCPTreeRecord(sCPTreeRecord2, "Number of Simultaneously Recorded Leads", Integer.toString(this.numberOfSimultaneouslyRecordedLeads) + " dec (0x" + Integer.toHexString(this.numberOfSimultaneouslyRecordedLeads) + ")");
            sCPTreeRecord3 = new SCPTreeRecord(sCPTreeRecord2, "Lead Details");
            for (int i = 0; i < this.numberOfLeads; ++i) {
                SCPTreeRecord sCPTreeRecord4 = new SCPTreeRecord(sCPTreeRecord3, "Lead", Long.toString(i + 1));
                new SCPTreeRecord(sCPTreeRecord4, "StartingSampleNumbers", Long.toString(this.startingSampleNumbers[i]) + " dec (0x" + Long.toHexString(this.startingSampleNumbers[i]) + ")");
                new SCPTreeRecord(sCPTreeRecord4, "EndingSampleNumbers", Long.toString(this.endingSampleNumbers[i]) + " dec (0x" + Long.toHexString(this.endingSampleNumbers[i]) + ")");
                new SCPTreeRecord(sCPTreeRecord4, "Number of Samples (computed)", Long.toString(this.numbersOfSamples[i]) + " dec (0x" + Long.toHexString(this.numbersOfSamples[i]) + ")");
                new SCPTreeRecord(sCPTreeRecord4, "Lead Number", Long.toString(this.leadNumbers[i]) + " dec (0x" + Long.toHexString(this.leadNumbers[i]) + ")");
                new SCPTreeRecord(sCPTreeRecord4, "Lead Name", Section3.getLeadName(this.leadNumbers[i]));
            }
        }
        return this.tree;
    }
}

