/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.slf4j;

import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/slf4j/Logger.java,v 1.10 2025/01/29 10:58:09 dclunie Exp $";
    protected org.slf4j.Logger slf4jlogger;
    protected String className;
    protected boolean errorEnabled = true;
    protected boolean warnEnabled = true;
    protected boolean infoEnabled = true;
    protected boolean debugEnabled = false;
    protected boolean traceEnabled = false;
    protected boolean showDateTime = false;
    protected SimpleDateFormat dateFormatter;
    protected static boolean millisecondsSinceEpochAtStartIsSet;
    protected static long millisecondsSinceEpochAtStart;

    public boolean isErrorEnabled() {
        return this.errorEnabled;
    }

    public boolean isWarnEnabled() {
        return this.warnEnabled;
    }

    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    protected void setLoggingDetailLevel(String string) {
        switch (string) {
            case "trace": {
                this.traceEnabled = true;
                this.debugEnabled = true;
                this.infoEnabled = true;
                this.warnEnabled = true;
                this.errorEnabled = true;
                break;
            }
            case "debug": {
                this.traceEnabled = false;
                this.debugEnabled = true;
                this.infoEnabled = true;
                this.warnEnabled = true;
                this.errorEnabled = true;
                break;
            }
            case "info": {
                this.traceEnabled = false;
                this.debugEnabled = false;
                this.infoEnabled = true;
                this.warnEnabled = true;
                this.errorEnabled = true;
                break;
            }
            case "warn": {
                this.traceEnabled = false;
                this.debugEnabled = false;
                this.infoEnabled = false;
                this.warnEnabled = true;
                this.errorEnabled = true;
                break;
            }
            case "error": {
                this.traceEnabled = false;
                this.debugEnabled = false;
                this.infoEnabled = false;
                this.warnEnabled = false;
                this.errorEnabled = true;
            }
        }
    }

    protected Logger(org.slf4j.Logger logger) {
        this.slf4jlogger = logger;
    }

    protected Logger(String string) {
        String string2;
        this.className = string;
        String string3 = System.getProperty("org.slf4j.simpleLogger.log." + string);
        if (string3 != null) {
            this.setLoggingDetailLevel(string3);
        } else {
            string2 = System.getProperty("org.slf4j.simpleLogger.defaultLogLevel");
            if (string2 != null) {
                this.setLoggingDetailLevel(string2);
            }
        }
        string2 = System.getProperty("org.slf4j.simpleLogger.showDateTime");
        if ("true".equals(string2)) {
            this.showDateTime = true;
            String string4 = System.getProperty("org.slf4j.simpleLogger.dateTimeFormat");
            if (string4 == null && !millisecondsSinceEpochAtStartIsSet) {
                millisecondsSinceEpochAtStart = new Date().getTime();
            } else {
                try {
                    this.dateFormatter = new SimpleDateFormat(string4);
                }
                catch (Throwable throwable) {
                    System.err.println("Logger(): exception while creating SimpleDateFormat from \"" + string4 + "\"");
                    throwable.printStackTrace(System.err);
                }
            }
        }
    }

    public void error(String string) {
        if (this.slf4jlogger != null) {
            if (this.slf4jlogger.isErrorEnabled()) {
                this.slf4jlogger.error(string);
            }
        } else if (this.errorEnabled) {
            System.err.println(this.getPreamable("ERROR") + string);
        }
    }

    public void error(String string, Object ... objectArray) {
        if (this.slf4jlogger != null) {
            if (this.slf4jlogger.isErrorEnabled()) {
                this.slf4jlogger.error(string, objectArray);
            }
        } else if (this.errorEnabled) {
            System.err.println(this.getPreamable("ERROR") + Logger.getFormattedStringFromArguments(string, objectArray));
        }
    }

    public void error(String string, Throwable throwable) {
        if (this.slf4jlogger != null) {
            if (this.slf4jlogger.isErrorEnabled()) {
                this.slf4jlogger.error(string, throwable);
            }
        } else if (this.errorEnabled) {
            System.err.println(this.getPreamable("ERROR") + string + throwable);
            throwable.printStackTrace(System.err);
        }
    }

    public void warn(String string) {
        if (this.slf4jlogger != null) {
            if (this.slf4jlogger.isWarnEnabled()) {
                this.slf4jlogger.warn(string);
            }
        } else if (this.warnEnabled) {
            System.err.println(this.getPreamable("WARN") + string);
        }
    }

    public void warn(String string, Object ... objectArray) {
        if (this.slf4jlogger != null) {
            if (this.slf4jlogger.isWarnEnabled()) {
                this.slf4jlogger.warn(string, objectArray);
            }
        } else if (this.warnEnabled) {
            System.err.println(this.getPreamable("WARN") + Logger.getFormattedStringFromArguments(string, objectArray));
        }
    }

    public void warn(String string, Throwable throwable) {
        if (this.slf4jlogger != null) {
            if (this.slf4jlogger.isWarnEnabled()) {
                this.slf4jlogger.warn(string, throwable);
            }
        } else if (this.warnEnabled) {
            System.err.println(this.getPreamable("WARN") + string + throwable);
            throwable.printStackTrace(System.err);
        }
    }

    public void info(String string) {
        if (this.slf4jlogger != null) {
            if (this.slf4jlogger.isInfoEnabled()) {
                this.slf4jlogger.info(string);
            }
        } else if (this.infoEnabled) {
            System.err.println(this.getPreamable("INFO") + string);
        }
    }

    public void info(String string, Object ... objectArray) {
        if (this.slf4jlogger != null) {
            if (this.slf4jlogger.isInfoEnabled()) {
                this.slf4jlogger.info(string, objectArray);
            }
        } else if (this.infoEnabled) {
            System.err.println(this.getPreamable("INFO") + Logger.getFormattedStringFromArguments(string, objectArray));
        }
    }

    public void info(String string, Throwable throwable) {
        if (this.slf4jlogger != null) {
            if (this.slf4jlogger.isInfoEnabled()) {
                this.slf4jlogger.info(string, throwable);
            }
        } else if (this.infoEnabled) {
            System.err.println(this.getPreamable("INFO") + string + throwable);
            throwable.printStackTrace(System.err);
        }
    }

    public void debug(String string) {
        if (this.slf4jlogger != null) {
            if (this.slf4jlogger.isDebugEnabled()) {
                this.slf4jlogger.debug(string);
            }
        } else if (this.debugEnabled) {
            System.err.println(this.getPreamable("DEBUG") + string);
        }
    }

    public void debug(String string, Object ... objectArray) {
        if (this.slf4jlogger != null) {
            if (this.slf4jlogger.isDebugEnabled()) {
                this.slf4jlogger.debug(string, objectArray);
            }
        } else if (this.debugEnabled) {
            System.err.println(this.getPreamable("DEBUG") + Logger.getFormattedStringFromArguments(string, objectArray));
        }
    }

    public void debug(String string, Throwable throwable) {
        if (this.slf4jlogger != null) {
            if (this.slf4jlogger.isDebugEnabled()) {
                this.slf4jlogger.debug(string, throwable);
            }
        } else if (this.debugEnabled) {
            System.err.println(this.getPreamable("DEBUG") + string + throwable);
            throwable.printStackTrace(System.err);
        }
    }

    public void trace(String string) {
        if (this.slf4jlogger != null) {
            if (this.slf4jlogger.isTraceEnabled()) {
                this.slf4jlogger.trace(string);
            }
        } else if (this.traceEnabled) {
            System.err.println(this.getPreamable("TRACE") + string);
        }
    }

    public void trace(String string, Object ... objectArray) {
        if (this.slf4jlogger != null) {
            if (this.slf4jlogger.isTraceEnabled()) {
                this.slf4jlogger.trace(string, objectArray);
            }
        } else if (this.traceEnabled) {
            System.err.println(this.getPreamable("TRACE") + Logger.getFormattedStringFromArguments(string, objectArray));
        }
    }

    public void trace(String string, Throwable throwable) {
        if (this.slf4jlogger != null) {
            if (this.slf4jlogger.isTraceEnabled()) {
                this.slf4jlogger.trace(string, throwable);
            }
        } else if (this.traceEnabled) {
            System.err.println(this.getPreamable("TRACE") + string + throwable);
            throwable.printStackTrace(System.err);
        }
    }

    protected String getPreamable(String string) {
        String string2 = "";
        if (this.showDateTime) {
            if (this.dateFormatter != null) {
                try {
                    string2 = this.dateFormatter.format(new Date()) + " ";
                }
                catch (Throwable throwable) {
                    System.err.println("Logger.getPreamble(): exception while formatting current date and time");
                }
            } else {
                string2 = Long.toString(new Date().getTime() - millisecondsSinceEpochAtStart) + " ";
            }
        }
        String string3 = "";
        try {
            string3 = "[" + Thread.currentThread().getName() + "] ";
        }
        catch (Throwable throwable) {
            System.err.println("Logger.getPreamble(): exception while getting current thread name");
        }
        return string2 + string3 + string + " " + this.className + " ";
    }

    protected static String getFormattedStringFromArguments(String string, Object ... objectArray) {
        String string2 = string;
        try {
            String[] stringArray = string.split("[{][}]");
            if (stringArray.length > 0) {
                if (stringArray.length >= objectArray.length) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(stringArray[0]);
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringBuffer.append(objectArray[i]);
                        if (i + 1 >= stringArray.length) continue;
                        stringBuffer.append(stringArray[i + 1]);
                    }
                    string2 = stringBuffer.toString();
                } else {
                    System.err.println("Logger.getFormattedStringFromArguments(): too few arguments in format string \"" + string + "\" when given " + objectArray.length + " arguments");
                }
            }
        }
        catch (Throwable throwable) {
            System.err.println("Logger.getFormattedStringFromArguments(): exception while replacing arguments in format string \"" + string + "\"");
            throwable.printStackTrace(System.err);
        }
        return string2;
    }
}

