/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.anatproc.CTAnatomy;
import com.pixelmed.anatproc.Concept;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.TagFromName;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestAnatomyFind
extends TestCase {
    private static final Concept chest = new Concept("C0817096");
    private static final Concept pelvis = new Concept("C0030797");

    public TestAnatomyFind(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestAnatomyFind");
        testSuite.addTest((Test)new TestAnatomyFind("TestAnatomyFind_SeriesDescription"));
        testSuite.addTest((Test)new TestAnatomyFind("TestAnatomyFind_BodyPartExaminedOverridesSeriesDescription"));
        testSuite.addTest((Test)new TestAnatomyFind("TestAnatomyFind_SeriesDescriptionOverridesStudyDescription"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestAnatomyFind_SeriesDescription() throws Exception {
        AttributeList attributeList = new AttributeList();
        Object object = new LongStringAttribute(TagFromName.SeriesDescription);
        ((Attribute)object).addValue("Chest");
        attributeList.put((Attribute)object);
        object = CTAnatomy.findAnatomicConcept(attributeList);
        TestAnatomyFind.assertEquals((String)"Checking found chest in series description", (Object)chest, (Object)object);
        TestAnatomyFind.assertTrue((String)"Checking found is not pelvis", (!pelvis.equals(object) ? 1 : 0) != 0);
    }

    public void TestAnatomyFind_BodyPartExaminedOverridesSeriesDescription() throws Exception {
        AttributeList attributeList = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.BodyPartExamined);
        ((Attribute)object).addValue("Chest");
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.SeriesDescription);
        ((Attribute)object).addValue("Pelvis");
        attributeList.put((Attribute)object);
        object = CTAnatomy.findAnatomicConcept(attributeList);
        TestAnatomyFind.assertEquals((String)"Checking found chest in BodyPartExamined overrides pelvis in SeriesDescription", (Object)chest, (Object)object);
        TestAnatomyFind.assertTrue((String)"Checking found is not pelvis", (!pelvis.equals(object) ? 1 : 0) != 0);
    }

    public void TestAnatomyFind_SeriesDescriptionOverridesStudyDescription() throws Exception {
        AttributeList attributeList = new AttributeList();
        Object object = new LongStringAttribute(TagFromName.StudyDescription);
        ((Attribute)object).addValue("Pelvis");
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.SeriesDescription);
        ((Attribute)object).addValue("Chest");
        attributeList.put((Attribute)object);
        object = CTAnatomy.findAnatomicConcept(attributeList);
        TestAnatomyFind.assertEquals((String)"Checking found chest in SeriesDescription overrides pelvis in StudyDescription", (Object)chest, (Object)object);
        TestAnatomyFind.assertTrue((String)"Checking found is not pelvis", (!pelvis.equals(object) ? 1 : 0) != 0);
    }
}

