/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SignedShortAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestAttributeListReadUnspecifiedShortAttribute
extends TestCase {
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;
    private String studyID = "612386812";
    private String seriesNumber = "12";
    private String instanceNumber = "38";

    public TestAttributeListReadUnspecifiedShortAttribute(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestAttributeListReadUnspecifiedShortAttribute");
        testSuite.addTest((Test)new TestAttributeListReadUnspecifiedShortAttribute("TestAttributeListReadUnspecifiedShortAttribute_SignedPixelRepresentation_ImplicitVR"));
        testSuite.addTest((Test)new TestAttributeListReadUnspecifiedShortAttribute("TestAttributeListReadUnspecifiedShortAttribute_UnsignedPixelRepresentation_ImplicitVR"));
        testSuite.addTest((Test)new TestAttributeListReadUnspecifiedShortAttribute("TestAttributeListReadUnspecifiedShortAttribute_SignedPixelRepresentation_ExplicitVR"));
        testSuite.addTest((Test)new TestAttributeListReadUnspecifiedShortAttribute("TestAttributeListReadUnspecifiedShortAttribute_UnsignedPixelRepresentation_ExplicitVR"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private AttributeList makeAttributeList() {
        AttributeList attributeList = new AttributeList();
        try {
            UIDGenerator uIDGenerator = new UIDGenerator("9999");
            String string = uIDGenerator.getNewSOPInstanceUID(this.studyID, this.seriesNumber, this.instanceNumber);
            String string2 = uIDGenerator.getNewSeriesInstanceUID(this.studyID, this.seriesNumber);
            String string3 = uIDGenerator.getNewStudyInstanceUID(this.studyID);
            UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
            ((Attribute)uniqueIdentifierAttribute).addValue("1.2.840.10008.5.1.4.1.1.2");
            attributeList.put(uniqueIdentifierAttribute);
            uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
            ((Attribute)uniqueIdentifierAttribute).addValue(string);
            attributeList.put(uniqueIdentifierAttribute);
            uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
            ((Attribute)uniqueIdentifierAttribute).addValue(string2);
            attributeList.put(uniqueIdentifierAttribute);
            uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
            ((Attribute)uniqueIdentifierAttribute).addValue(string3);
            attributeList.put(uniqueIdentifierAttribute);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        return attributeList;
    }

    public void TestAttributeListReadUnspecifiedShortAttribute_SignedPixelRepresentation_ImplicitVR() throws Exception {
        File file = File.createTempFile("TestAttributeListReadUnspecifiedShortAttribute_SpecificAttribute", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        Attribute attribute = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
        attribute.addValue(1);
        attributeList.put(attribute);
        attribute = new SignedShortAttribute(TagFromName.PixelPaddingValue);
        attribute.addValue(65535);
        attributeList.put(attribute);
        attribute = new SequenceAttribute(TagFromName.RealWorldValueMappingSequence);
        attributeList.put(attribute);
        Object object = new AttributeList();
        ((SequenceAttribute)attribute).addItem((AttributeList)object);
        SignedShortAttribute signedShortAttribute = new SignedShortAttribute(TagFromName.RealWorldValueLastValueMapped);
        ((Attribute)signedShortAttribute).addValue(65535);
        ((AttributeList)object).put(signedShortAttribute);
        attribute = new SequenceAttribute(dictionary.getTagFromName("HistogramSequence"));
        attributeList.put(attribute);
        object = new AttributeList();
        ((SequenceAttribute)attribute).addItem((AttributeList)object);
        signedShortAttribute = new SignedShortAttribute(dictionary.getTagFromName("HistogramLastBinValue"));
        ((Attribute)signedShortAttribute).addValue(65535);
        ((AttributeList)object).put(signedShortAttribute);
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2", true, true);
        attributeList = new AttributeList();
        attributeList.read(file);
        attribute = attributeList.get(TagFromName.PixelPaddingValue);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking PixelPaddingValue is SS", (boolean)(attribute instanceof SignedShortAttribute));
        object = attribute.getIntegerValues();
        TestAttributeListReadUnspecifiedShortAttribute.assertEquals((String)"Checking PixelPaddingValue value is -1", (int)-1, (int)object[0]);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking PixelPaddingValue value is not 0xffff", (object[0] != 65535 ? 1 : 0) != 0);
        attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.RealWorldValueMappingSequence, TagFromName.RealWorldValueLastValueMapped);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking RealWorldValueLastValueMapped is SS", (boolean)(attribute instanceof SignedShortAttribute));
        object = attribute.getIntegerValues();
        TestAttributeListReadUnspecifiedShortAttribute.assertEquals((String)"Checking RealWorldValueLastValueMapped value is -1", (int)-1, (int)object[0]);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking RealWorldValueLastValueMapped value is not 0xffff", (object[0] != 65535 ? 1 : 0) != 0);
        attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, dictionary.getTagFromName("HistogramSequence"), dictionary.getTagFromName("HistogramLastBinValue"));
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking HistogramLastBinValue is SS", (boolean)(attribute instanceof SignedShortAttribute));
        object = attribute.getIntegerValues();
        TestAttributeListReadUnspecifiedShortAttribute.assertEquals((String)"Checking HistogramLastBinValue value is -1", (int)-1, (int)object[0]);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking HistogramLastBinValue value is not 0xffff", (object[0] != 65535 ? 1 : 0) != 0);
    }

    public void TestAttributeListReadUnspecifiedShortAttribute_UnsignedPixelRepresentation_ImplicitVR() throws Exception {
        File file = File.createTempFile("TestAttributeListReadUnspecifiedShortAttribute_SpecificAttribute", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        Attribute attribute = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
        attribute.addValue(0);
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.PixelPaddingValue);
        attribute.addValue(65535);
        attributeList.put(attribute);
        attribute = new SequenceAttribute(TagFromName.RealWorldValueMappingSequence);
        attributeList.put(attribute);
        Object object = new AttributeList();
        ((SequenceAttribute)attribute).addItem((AttributeList)object);
        UnsignedShortAttribute unsignedShortAttribute = new UnsignedShortAttribute(TagFromName.RealWorldValueLastValueMapped);
        ((Attribute)unsignedShortAttribute).addValue(65535);
        ((AttributeList)object).put(unsignedShortAttribute);
        attribute = new SequenceAttribute(dictionary.getTagFromName("HistogramSequence"));
        attributeList.put(attribute);
        object = new AttributeList();
        ((SequenceAttribute)attribute).addItem((AttributeList)object);
        unsignedShortAttribute = new UnsignedShortAttribute(dictionary.getTagFromName("HistogramLastBinValue"));
        ((Attribute)unsignedShortAttribute).addValue(65535);
        ((AttributeList)object).put(unsignedShortAttribute);
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2", true, true);
        attributeList = new AttributeList();
        attributeList.read(file);
        attribute = attributeList.get(TagFromName.PixelPaddingValue);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking PixelPaddingValue is US", (boolean)(attribute instanceof UnsignedShortAttribute));
        object = attribute.getIntegerValues();
        TestAttributeListReadUnspecifiedShortAttribute.assertEquals((String)"Checking PixelPaddingValue value is 0xffff", (int)65535, (int)object[0]);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking PixelPaddingValue value is not -1", (object[0] != -1 ? 1 : 0) != 0);
        attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.RealWorldValueMappingSequence, TagFromName.RealWorldValueLastValueMapped);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking RealWorldValueLastValueMapped is US", (boolean)(attribute instanceof UnsignedShortAttribute));
        object = attribute.getIntegerValues();
        TestAttributeListReadUnspecifiedShortAttribute.assertEquals((String)"Checking RealWorldValueLastValueMapped value is 0xffff", (int)65535, (int)object[0]);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking RealWorldValueLastValueMapped value is not -1", (object[0] != -1 ? 1 : 0) != 0);
        attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, dictionary.getTagFromName("HistogramSequence"), dictionary.getTagFromName("HistogramLastBinValue"));
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking HistogramLastBinValue is US", (boolean)(attribute instanceof UnsignedShortAttribute));
        object = attribute.getIntegerValues();
        TestAttributeListReadUnspecifiedShortAttribute.assertEquals((String)"Checking HistogramLastBinValue value is 0xffff", (int)65535, (int)object[0]);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking HistogramLastBinValue value is not -1", (object[0] != -1 ? 1 : 0) != 0);
    }

    public void TestAttributeListReadUnspecifiedShortAttribute_SignedPixelRepresentation_ExplicitVR() throws Exception {
        File file = File.createTempFile("TestAttributeListReadUnspecifiedShortAttribute_SpecificAttribute", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        Attribute attribute = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
        attribute.addValue(1);
        attributeList.put(attribute);
        attribute = new SignedShortAttribute(TagFromName.PixelPaddingValue);
        attribute.addValue(65535);
        attributeList.put(attribute);
        attribute = new SequenceAttribute(TagFromName.RealWorldValueMappingSequence);
        attributeList.put(attribute);
        Object object = new AttributeList();
        ((SequenceAttribute)attribute).addItem((AttributeList)object);
        SignedShortAttribute signedShortAttribute = new SignedShortAttribute(TagFromName.RealWorldValueLastValueMapped);
        ((Attribute)signedShortAttribute).addValue(65535);
        ((AttributeList)object).put(signedShortAttribute);
        attribute = new SequenceAttribute(dictionary.getTagFromName("HistogramSequence"));
        attributeList.put(attribute);
        object = new AttributeList();
        ((SequenceAttribute)attribute).addItem((AttributeList)object);
        signedShortAttribute = new SignedShortAttribute(dictionary.getTagFromName("HistogramLastBinValue"));
        ((Attribute)signedShortAttribute).addValue(65535);
        ((AttributeList)object).put(signedShortAttribute);
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        attributeList = new AttributeList();
        attributeList.read(file);
        attribute = attributeList.get(TagFromName.PixelPaddingValue);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking PixelPaddingValue is SS", (boolean)(attribute instanceof SignedShortAttribute));
        object = attribute.getIntegerValues();
        TestAttributeListReadUnspecifiedShortAttribute.assertEquals((String)"Checking PixelPaddingValue value is -1", (int)-1, (int)object[0]);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking PixelPaddingValue value is not 0xffff", (object[0] != 65535 ? 1 : 0) != 0);
        attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.RealWorldValueMappingSequence, TagFromName.RealWorldValueLastValueMapped);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking RealWorldValueLastValueMapped is SS", (boolean)(attribute instanceof SignedShortAttribute));
        object = attribute.getIntegerValues();
        TestAttributeListReadUnspecifiedShortAttribute.assertEquals((String)"Checking RealWorldValueLastValueMapped value is -1", (int)-1, (int)object[0]);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking RealWorldValueLastValueMapped value is not 0xffff", (object[0] != 65535 ? 1 : 0) != 0);
        attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, dictionary.getTagFromName("HistogramSequence"), dictionary.getTagFromName("HistogramLastBinValue"));
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking HistogramLastBinValue is SS", (boolean)(attribute instanceof SignedShortAttribute));
        object = attribute.getIntegerValues();
        TestAttributeListReadUnspecifiedShortAttribute.assertEquals((String)"Checking HistogramLastBinValue value is -1", (int)-1, (int)object[0]);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking HistogramLastBinValue value is not 0xffff", (object[0] != 65535 ? 1 : 0) != 0);
    }

    public void TestAttributeListReadUnspecifiedShortAttribute_UnsignedPixelRepresentation_ExplicitVR() throws Exception {
        File file = File.createTempFile("TestAttributeListReadUnspecifiedShortAttribute_SpecificAttribute", ".dcm");
        file.deleteOnExit();
        AttributeList attributeList = this.makeAttributeList();
        Attribute attribute = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
        attribute.addValue(0);
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.PixelPaddingValue);
        attribute.addValue(65535);
        attributeList.put(attribute);
        attribute = new SequenceAttribute(TagFromName.RealWorldValueMappingSequence);
        attributeList.put(attribute);
        Object object = new AttributeList();
        ((SequenceAttribute)attribute).addItem((AttributeList)object);
        UnsignedShortAttribute unsignedShortAttribute = new UnsignedShortAttribute(TagFromName.RealWorldValueLastValueMapped);
        ((Attribute)unsignedShortAttribute).addValue(65535);
        ((AttributeList)object).put(unsignedShortAttribute);
        attribute = new SequenceAttribute(dictionary.getTagFromName("HistogramSequence"));
        attributeList.put(attribute);
        object = new AttributeList();
        ((SequenceAttribute)attribute).addItem((AttributeList)object);
        unsignedShortAttribute = new UnsignedShortAttribute(dictionary.getTagFromName("HistogramLastBinValue"));
        ((Attribute)unsignedShortAttribute).addValue(65535);
        ((AttributeList)object).put(unsignedShortAttribute);
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
        attributeList = new AttributeList();
        attributeList.read(file);
        attribute = attributeList.get(TagFromName.PixelPaddingValue);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking PixelPaddingValue is US", (boolean)(attribute instanceof UnsignedShortAttribute));
        object = attribute.getIntegerValues();
        TestAttributeListReadUnspecifiedShortAttribute.assertEquals((String)"Checking PixelPaddingValue value is 0xffff", (int)65535, (int)object[0]);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking PixelPaddingValue value is not -1", (object[0] != -1 ? 1 : 0) != 0);
        attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.RealWorldValueMappingSequence, TagFromName.RealWorldValueLastValueMapped);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking RealWorldValueLastValueMapped is US", (boolean)(attribute instanceof UnsignedShortAttribute));
        object = attribute.getIntegerValues();
        TestAttributeListReadUnspecifiedShortAttribute.assertEquals((String)"Checking RealWorldValueLastValueMapped value is 0xffff", (int)65535, (int)object[0]);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking RealWorldValueLastValueMapped value is not -1", (object[0] != -1 ? 1 : 0) != 0);
        attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, dictionary.getTagFromName("HistogramSequence"), dictionary.getTagFromName("HistogramLastBinValue"));
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking HistogramLastBinValue is US", (boolean)(attribute instanceof UnsignedShortAttribute));
        object = attribute.getIntegerValues();
        TestAttributeListReadUnspecifiedShortAttribute.assertEquals((String)"Checking HistogramLastBinValue value is 0xffff", (int)65535, (int)object[0]);
        TestAttributeListReadUnspecifiedShortAttribute.assertTrue((String)"Checking HistogramLastBinValue value is not -1", (object[0] != -1 ? 1 : 0) != 0);
    }
}

