/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.OtherLongAttribute;
import com.pixelmed.dicom.OtherVeryLongAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBinaryAttributeBinaryInputOutput
extends TestCase {
    public TestBinaryAttributeBinaryInputOutput(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestBinaryAttributeBinaryInputOutput");
        testSuite.addTest((Test)new TestBinaryAttributeBinaryInputOutput("TestBinaryAttributeBinaryInputOutput_ReadAndWriteOtherLongValuesLittleEndian"));
        testSuite.addTest((Test)new TestBinaryAttributeBinaryInputOutput("TestBinaryAttributeBinaryInputOutput_ReadAndWriteOtherLongValuesBigEndian"));
        testSuite.addTest((Test)new TestBinaryAttributeBinaryInputOutput("TestBinaryAttributeBinaryInputOutput_ReadAndWriteOtherVeryLongValuesLittleEndian"));
        testSuite.addTest((Test)new TestBinaryAttributeBinaryInputOutput("TestBinaryAttributeBinaryInputOutput_ReadAndWriteOtherVeryLongValuesBigEndian"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestBinaryAttributeBinaryInputOutput_ReadAndWriteOtherLongValuesLittleEndian() throws Exception {
        int[] nArray = new int[]{16909060, 287454020, 67305985, 1144201745, 0, Integer.MAX_VALUE, Integer.MIN_VALUE, -1879048193};
        AttributeTag attributeTag = new AttributeTag(17, 4112);
        OtherLongAttribute otherLongAttribute = new OtherLongAttribute(attributeTag);
        otherLongAttribute.setValues(nArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream(byteArrayOutputStream, null, "1.2.840.10008.1.2.1");
        otherLongAttribute.write(dicomOutputStream);
        dicomOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AttributeList attributeList = new AttributeList();
        attributeList.read(new DicomInputStream(byteArrayInputStream, "1.2.840.10008.1.2.1", false));
        Attribute attribute = attributeList.get(attributeTag);
        TestBinaryAttributeBinaryInputOutput.assertEquals((String)"VR", (Object)ValueRepresentation.OL, (Object)attribute.getVR());
        int[] nArray2 = attribute.getIntegerValues();
        TestBinaryAttributeBinaryInputOutput.assertEquals((String)"Same number of values", (int)nArray.length, (int)nArray2.length);
        for (int i = 0; i < nArray.length; ++i) {
            TestBinaryAttributeBinaryInputOutput.assertEquals((String)("Checking hex value[" + i + "]"), (String)Integer.toHexString(nArray[i]), (String)Integer.toHexString(nArray2[i]));
        }
    }

    public void TestBinaryAttributeBinaryInputOutput_ReadAndWriteOtherLongValuesBigEndian() throws Exception {
        int[] nArray = new int[]{16909060, 287454020, 67305985, 1144201745, 0, Integer.MAX_VALUE, Integer.MIN_VALUE, -1879048193};
        AttributeTag attributeTag = new AttributeTag(17, 4112);
        OtherLongAttribute otherLongAttribute = new OtherLongAttribute(attributeTag);
        otherLongAttribute.setValues(nArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream(byteArrayOutputStream, null, "1.2.840.10008.1.2.2");
        otherLongAttribute.write(dicomOutputStream);
        dicomOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AttributeList attributeList = new AttributeList();
        attributeList.read(new DicomInputStream(byteArrayInputStream, "1.2.840.10008.1.2.2", false));
        Attribute attribute = attributeList.get(attributeTag);
        TestBinaryAttributeBinaryInputOutput.assertEquals((String)"VR", (Object)ValueRepresentation.OL, (Object)attribute.getVR());
        int[] nArray2 = attribute.getIntegerValues();
        TestBinaryAttributeBinaryInputOutput.assertEquals((String)"Same number of values", (int)nArray.length, (int)nArray2.length);
        for (int i = 0; i < nArray.length; ++i) {
            TestBinaryAttributeBinaryInputOutput.assertEquals((String)("Checking hex value[" + i + "]"), (String)Integer.toHexString(nArray[i]), (String)Integer.toHexString(nArray2[i]));
        }
    }

    public void TestBinaryAttributeBinaryInputOutput_ReadAndWriteOtherVeryLongValuesLittleEndian() throws Exception {
        long[] lArray = new long[]{72623859790382856L, 1234605616436508552L, 578719170729017857L, -8613303245920329199L, 0L, Long.MAX_VALUE, Long.MIN_VALUE, -8070450532247928833L};
        AttributeTag attributeTag = new AttributeTag(17, 4112);
        OtherVeryLongAttribute otherVeryLongAttribute = new OtherVeryLongAttribute(attributeTag);
        otherVeryLongAttribute.setValues(lArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream(byteArrayOutputStream, null, "1.2.840.10008.1.2.1");
        otherVeryLongAttribute.write(dicomOutputStream);
        dicomOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AttributeList attributeList = new AttributeList();
        attributeList.read(new DicomInputStream(byteArrayInputStream, "1.2.840.10008.1.2.1", false));
        Attribute attribute = attributeList.get(attributeTag);
        TestBinaryAttributeBinaryInputOutput.assertEquals((String)"VR", (Object)ValueRepresentation.OV, (Object)attribute.getVR());
        long[] lArray2 = attribute.getLongValues();
        TestBinaryAttributeBinaryInputOutput.assertEquals((String)"Same number of values", (int)lArray.length, (int)lArray2.length);
        for (int i = 0; i < lArray.length; ++i) {
            TestBinaryAttributeBinaryInputOutput.assertEquals((String)("Checking hex value[" + i + "]"), (String)Long.toHexString(lArray[i]), (String)Long.toHexString(lArray2[i]));
        }
    }

    public void TestBinaryAttributeBinaryInputOutput_ReadAndWriteOtherVeryLongValuesBigEndian() throws Exception {
        long[] lArray = new long[]{72623859790382856L, 1234605616436508552L, 578719170729017857L, -8613303245920329199L, 0L, Long.MAX_VALUE, Long.MIN_VALUE, -8070450532247928833L};
        AttributeTag attributeTag = new AttributeTag(17, 4112);
        OtherVeryLongAttribute otherVeryLongAttribute = new OtherVeryLongAttribute(attributeTag);
        otherVeryLongAttribute.setValues(lArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream(byteArrayOutputStream, null, "1.2.840.10008.1.2.2");
        otherVeryLongAttribute.write(dicomOutputStream);
        dicomOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AttributeList attributeList = new AttributeList();
        attributeList.read(new DicomInputStream(byteArrayInputStream, "1.2.840.10008.1.2.2", false));
        Attribute attribute = attributeList.get(attributeTag);
        TestBinaryAttributeBinaryInputOutput.assertEquals((String)"VR", (Object)ValueRepresentation.OV, (Object)attribute.getVR());
        long[] lArray2 = attribute.getLongValues();
        TestBinaryAttributeBinaryInputOutput.assertEquals((String)"Same number of values", (int)lArray.length, (int)lArray2.length);
        for (int i = 0; i < lArray.length; ++i) {
            TestBinaryAttributeBinaryInputOutput.assertEquals((String)("Checking hex value[" + i + "]"), (String)Long.toHexString(lArray[i]), (String)Long.toHexString(lArray2[i]));
        }
    }
}

