/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CompositeInstanceContext;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.XMLRepresentationOfStructuredReportObjectFactory;
import com.pixelmed.dose.CTAcquisitionParameters;
import com.pixelmed.dose.CTDose;
import com.pixelmed.dose.CTDoseAcquisition;
import com.pixelmed.dose.CTDoseCheckDetails;
import com.pixelmed.dose.CTPhantomType;
import com.pixelmed.dose.CTScanType;
import com.pixelmed.dose.CommonDoseObserverContext;
import com.pixelmed.dose.ScanRange;
import com.pixelmed.dose.ScopeOfDoseAccummulation;
import com.pixelmed.dose.SourceOfDoseInformation;
import com.pixelmed.validate.DicomSRValidator;
import java.util.Locale;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestCTDose
extends TestCase {
    private CommonDoseObserverContext observerContext;
    private CompositeInstanceContext compositeInstanceContext;
    private String deviceUID = "1.2.3.4";
    private String deviceName = "station1";
    private String manufacturer = "Acme";
    private String modelName = "Scanner";
    private String serialNumber = "72349236741";
    private String location = "Suite1";
    private String operatorName = "Smith^John";
    private String operatorID = "26354781234";
    private String physicianName = "Jones^Mary";
    private String physicianID = "23491234234";
    private String idIssuer = "99BLA";
    private String organization = "St. Elsewhere's";
    private String patientName = "Smith^Mary";
    private String patientID = "3764913624";
    private String patientBirthDate = "19600101";
    private String patientAge = "041Y";
    private String patientWeight = "68";
    private String patientSize = "1.55";
    private String patientSex = "F";
    private String studyID = "612386812";
    private String seriesNumber = "12";
    private String instanceNumber = "38";
    private String referringPhysicianName = "Jones^Harriet";
    private String studyDate = "20010203";
    private String studyTime = "043000";
    private UIDGenerator u = new UIDGenerator("9999");
    private String sopInstanceUID;
    private String seriesInstanceUID;
    private String studyInstanceUID;

    public TestCTDose(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCTDose");
        testSuite.addTest((Test)new TestCTDose("testCTDoseConstructor_WithAllParameters"));
        testSuite.addTest((Test)new TestCTDose("testCTDoseConstructor_WithAllParametersAndThreeAcquisitionsInTwoSeries"));
        testSuite.addTest((Test)new TestCTDose("testCTDoseConstructor_WithOneAcquisitionsAndNoTotalDLP"));
        testSuite.addTest((Test)new TestCTDose("testCTDoseConstructor_PropagationOfDescriptionToAttributeList_IfNoStudyDescriptionInCompositeInstanceContext"));
        testSuite.addTest((Test)new TestCTDose("testCTDoseConstructor_PropagationOfDescriptionToAttributeList_DoesNotOverwriteIfStudyDescriptionAlreadyInCompositeInstanceContext"));
        testSuite.addTest((Test)new TestCTDose("testCTDoseConstructor_WithSeparateHeadAndBodyTotalDLPConstructor"));
        testSuite.addTest((Test)new TestCTDose("testCTDoseConstructor_WithSeparateHeadAndBodyTotalDLPSet"));
        testSuite.addTest((Test)new TestCTDose("testCTDoseConstructor_WithSeparateHeadAndBodyAcquisitions"));
        return testSuite;
    }

    protected void setUp() {
        Locale.setDefault(Locale.FRENCH);
        this.observerContext = new CommonDoseObserverContext(this.deviceUID, this.deviceName, this.manufacturer, this.modelName, this.serialNumber, this.location, this.operatorName, this.operatorID, this.physicianName, this.physicianID, this.idIssuer, this.organization);
        try {
            UIDGenerator uIDGenerator = new UIDGenerator("9999");
            this.sopInstanceUID = uIDGenerator.getNewSOPInstanceUID(this.studyID, this.seriesNumber, this.instanceNumber);
            this.seriesInstanceUID = uIDGenerator.getNewSeriesInstanceUID(this.studyID, this.seriesNumber);
            this.studyInstanceUID = uIDGenerator.getNewStudyInstanceUID(this.studyID);
            AttributeList attributeList = new AttributeList();
            StringAttribute stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
            ((Attribute)stringAttribute).addValue(this.sopInstanceUID);
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
            ((Attribute)stringAttribute).addValue(this.seriesInstanceUID);
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
            ((Attribute)stringAttribute).addValue(this.studyInstanceUID);
            attributeList.put(stringAttribute);
            stringAttribute = new PersonNameAttribute(TagFromName.PatientName);
            ((Attribute)stringAttribute).addValue(this.patientName);
            attributeList.put(stringAttribute);
            stringAttribute = new LongStringAttribute(TagFromName.PatientID);
            ((Attribute)stringAttribute).addValue(this.patientID);
            attributeList.put(stringAttribute);
            stringAttribute = new DateAttribute(TagFromName.PatientBirthDate);
            ((Attribute)stringAttribute).addValue(this.patientBirthDate);
            attributeList.put(stringAttribute);
            stringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
            ((Attribute)stringAttribute).addValue(this.patientAge);
            attributeList.put(stringAttribute);
            stringAttribute = new CodeStringAttribute(TagFromName.PatientSex);
            ((Attribute)stringAttribute).addValue(this.patientSex);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.PatientWeight);
            ((Attribute)stringAttribute).addValue(this.patientWeight);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.PatientSize);
            ((Attribute)stringAttribute).addValue(this.patientSize);
            attributeList.put(stringAttribute);
            stringAttribute = new ShortStringAttribute(TagFromName.StudyID);
            ((Attribute)stringAttribute).addValue(this.studyID);
            attributeList.put(stringAttribute);
            stringAttribute = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
            ((Attribute)stringAttribute).addValue(this.referringPhysicianName);
            attributeList.put(stringAttribute);
            stringAttribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
            ((Attribute)stringAttribute).addValue(this.seriesNumber);
            attributeList.put(stringAttribute);
            stringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
            ((Attribute)stringAttribute).addValue(this.instanceNumber);
            attributeList.put(stringAttribute);
            stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
            attributeList.put(stringAttribute);
            stringAttribute = new DateAttribute(TagFromName.StudyDate);
            ((Attribute)stringAttribute).addValue(this.studyDate);
            attributeList.put(stringAttribute);
            stringAttribute = new TimeAttribute(TagFromName.StudyTime);
            ((Attribute)stringAttribute).addValue(this.studyTime);
            attributeList.put(stringAttribute);
            this.compositeInstanceContext = new CompositeInstanceContext(attributeList, true);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
    }

    protected void tearDown() {
    }

    public void testCTDoseConstructor_WithAllParameters() throws Exception {
        String string = "1299.58";
        int n = 4;
        String string2 = "1.2.124.113532.172.16.11.4.20090807.144612.3424396";
        String string3 = "20010203043000+0000";
        String string4 = "20010203043500+0000";
        String string5 = "CAP";
        String string6 = "Dose\tPatient ID=3764913624\tName=Smith^Mary\tSex=F\tDOB=19600101\tAge=041Y\tWeight=68 kg\tHeight=1.55 m\tAccession=\tStart=" + string3 + "\tEnd=" + string4 + "\tModality=CT\tDescription=" + string5 + "\tScope=Study\tUID=" + string2 + "\tEvents=" + Integer.toString(n) + "\tDLP Total=" + string + " mGy.cm\n";
        String string7 = "Dose\tPatient ID=3764913624\tName=Smith^Mary\tSex=F\tDOB=19600101\tAge=041Y\tWeight=68 kg\tHeight=1.55 m\tAccession=\tStart=" + string3 + "\tModality=CT\tDescription=" + string5 + "\tDLP Total=" + string + " mGy.cm\n";
        CTDose cTDose = new CTDose(string, n, ScopeOfDoseAccummulation.STUDY, string2, string3, string4, string5);
        cTDose.setCompositeInstanceContext(this.compositeInstanceContext);
        TestCTDose.assertEquals((String)"Checking DLP Total", (String)string, (String)cTDose.getDLPTotal());
        TestCTDose.assertEquals((String)"Checking totalNumberOfIrradiationEvents", (int)n, (int)cTDose.getTotalNumberOfIrradiationEvents());
        TestCTDose.assertEquals((String)"Checking ScopeOfDoseAccummulation equality", (Object)ScopeOfDoseAccummulation.STUDY, (Object)cTDose.getScopeOfDoseAccummulation());
        TestCTDose.assertEquals((String)"Checking ScopeOfDoseAccummulation string equality", (String)"Study", (String)cTDose.getScopeOfDoseAccummulation().toString());
        TestCTDose.assertEquals((String)"Checking scopeUID string equality", (String)string2, (String)cTDose.getScopeUID());
        TestCTDose.assertEquals((String)"Checking startDateTime string equality", (String)string3, (String)cTDose.getStartDateTime());
        TestCTDose.assertEquals((String)"Checking endDateTime string equality", (String)string4, (String)cTDose.getEndDateTime());
        TestCTDose.assertEquals((String)"Checking description string equality", (String)string5, (String)cTDose.getDescription());
        TestCTDose.assertEquals((String)"Checking toString default", (String)string6, (String)cTDose.toString());
        TestCTDose.assertEquals((String)"Checking toString detail", (String)string6, (String)cTDose.toString(true, false));
        TestCTDose.assertEquals((String)"Checking toString no detail", (String)string7, (String)cTDose.toString(false, false));
        TestCTDose.assertFalse((String)"Checking SR is not null", (cTDose.getStructuredReport() == null ? 1 : 0) != 0);
    }

    public void testCTDoseConstructor_WithAllParametersAndThreeAcquisitionsInTwoSeries() throws Exception {
        String[] stringArray = new String[]{"20.23", "20.23", "20.23"};
        String[] stringArray2 = new String[]{"1362.24", "107.73", "172.99"};
        String[] stringArray3 = new String[]{"673.38", "53.25", "85.51"};
        String string = "BODY32";
        ScanRange[] scanRangeArray = new ScanRange[]{new ScanRange("S", "14.250", "I", "635.750"), new ScanRange("I", "635.250", "I", "665.250"), new ScanRange("S", "14.250", "S", "84.250")};
        String string2 = "1.2.124.113532.172.16.11.4.20090807.144612.3424396";
        CTDoseAcquisition cTDoseAcquisition = new CTDoseAcquisition(string2, true, "2", CTScanType.HELICAL, scanRangeArray[0], stringArray[0], stringArray2[0], CTPhantomType.selectFromDescription(string));
        CTDoseAcquisition cTDoseAcquisition2 = new CTDoseAcquisition(string2, true, "2", CTScanType.HELICAL, scanRangeArray[1], stringArray[1], stringArray2[1], CTPhantomType.selectFromDescription(string));
        CTDoseAcquisition cTDoseAcquisition3 = new CTDoseAcquisition(string2, true, "3", CTScanType.HELICAL, scanRangeArray[2], stringArray[2], stringArray2[2], CTPhantomType.selectFromDescription(string));
        String string3 = "1642.96";
        int n = 3;
        String string4 = "20010203043000+0000";
        String string5 = "2001/02/03 04:30:00";
        String string6 = "20010203043500+0000";
        String string7 = "2001/02/03 04:35:00";
        String string8 = "CAP";
        String string9 = "Dose\tPatient ID=\tName=\tSex=\tDOB=\tAge=\tWeight= kg\tHeight= m\tAccession=\tStart=" + string4 + "\tEnd=" + string6 + "\tModality=CT\tDescription=" + string8 + "\tScope=Study\tUID=" + string2 + "\tEvents=" + Integer.toString(n) + "\tDLP Total=" + string3 + " (BODY32) mGy.cm\n\tSeries=2\tHelical\tRange=S14.250-I635.750 mm\tCTDIvol=" + stringArray[0] + " mGy\tDLP=" + stringArray2[0] + " mGy.cm\tPhantom=BODY32\n\tSeries=2\tHelical\tRange=I635.250-I665.250 mm\tCTDIvol=" + stringArray[1] + " mGy\tDLP=" + stringArray2[1] + " mGy.cm\tPhantom=BODY32\n\tSeries=3\tHelical\tRange=S14.250-S84.250 mm\tCTDIvol=" + stringArray[2] + " mGy\tDLP=" + stringArray2[2] + " mGy.cm\tPhantom=BODY32\n";
        String string10 = "Dose\tPatient ID=\tName=\tSex=\tDOB=\tAge=\tWeight= kg\tHeight= m\tAccession=\tStart=" + string4 + "\tModality=CT\tDescription=" + string8 + "\tDLP Total=" + string3 + " (BODY32) mGy.cm\n";
        String string11 = "Dose\tPatient ID=\tName=\tSex=\tDOB=\tAge=\tWeight= kg\tHeight= m\tAccession=\t" + string5 + "\tCT\t" + string8 + "\tDLP Total=" + string3 + " (BODY32) mGy.cm\n";
        String string12 = "<tr><td></td><td></td><td></td><td></td><td align=right></td><td align=right></td><td align=right></td><td></td><td>2001/02/03 04:30:00</td><td>CT</td><td>CAP</td><td align=right>1642.96 (BODY32)</td><td align=right></td><td align=right></td><td></td><td></td><td></td><td>MOD</td></tr>\n";
        String string13 = "<tr><th>ID</th><th>Name</th><th>Sex</th><th>DOB</th><th>Age</th><th>Weight kg</th><th>Height m</th><th>Accession</th><th>Date</th><th>Modality</th><th>Description</th><th>DLP Total mGy.cm</th><th>DLP HEAD16 mGy.cm</th><th>DLP BODY32 mGy.cm</th><th>Manufacturer</th><th>Model</th><th>Station</th><th>From</th></tr>\n<tr><td></td><td></td><td></td><td></td><td align=right></td><td align=right></td><td align=right></td><td></td><td>2001/02/03 04:30:00</td><td>CT</td><td>CAP</td><td align=right>1642.96 (BODY32)</td><td align=right></td><td align=right></td><td></td><td></td><td></td><td>MOD</td></tr>\n<tr><td colspan=2></td><td colspan=15><table><tr><th>Number</th><th>Type</th><th>Range mm</th><th>CTDIvol mGy</th><th>DLP mGy.cm</th><th>Phantom</th></tr>\n<tr><td>Series=2</td><td>Helical</td><td>S14.250-I635.750</td><td>" + stringArray[0] + "</td><td>" + stringArray2[0] + "</td><td>BODY32</td></tr>\n<tr><td>Series=2</td><td>Helical</td><td>I635.250-I665.250</td><td>" + stringArray[1] + "</td><td>" + stringArray2[1] + "</td><td>BODY32</td></tr>\n<tr><td>Series=3</td><td>Helical</td><td>S14.250-S84.250</td><td>" + stringArray[2] + "</td><td>" + stringArray2[2] + "</td><td>BODY32</td></tr>\n</table></td></tr>\n";
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string2, string4, string6, string8);
        cTDose.addAcquisition(cTDoseAcquisition);
        cTDose.addAcquisition(cTDoseAcquisition2);
        cTDose.addAcquisition(cTDoseAcquisition3);
        cTDose.setDLPTotal(string3);
        TestCTDose.assertEquals((String)"Checking DLP Total", (String)string3, (String)cTDose.getDLPTotal());
        TestCTDose.assertTrue((String)"Checking DLP Total as double", (Double.parseDouble(string3) == Double.parseDouble(cTDose.getDLPTotal()) ? 1 : 0) != 0);
        TestCTDose.assertEquals((String)"Checking totalNumberOfIrradiationEvents", (int)n, (int)cTDose.getTotalNumberOfIrradiationEvents());
        TestCTDose.assertTrue((String)"Checking ScopeOfDoseAccummulation equality", (boolean)ScopeOfDoseAccummulation.STUDY.equals(cTDose.getScopeOfDoseAccummulation()));
        TestCTDose.assertEquals((String)"Checking ScopeOfDoseAccummulation string equality", (String)"Study", (String)cTDose.getScopeOfDoseAccummulation().toString());
        TestCTDose.assertEquals((String)"Checking scopeUID string equality", (String)string2, (String)cTDose.getScopeUID());
        TestCTDose.assertEquals((String)"Checking startDateTime string equality", (String)string4, (String)cTDose.getStartDateTime());
        TestCTDose.assertEquals((String)"Checking endDateTime string equality", (String)string6, (String)cTDose.getEndDateTime());
        TestCTDose.assertEquals((String)"Checking description string equality", (String)string8, (String)cTDose.getDescription());
        TestCTDose.assertEquals((String)"Checking number of acquisitions", (int)n, (int)cTDose.getNumberOfAcquisitions());
        TestCTDose.assertTrue((String)"Checking CTDoseAcquisition 1 equality", (boolean)cTDoseAcquisition.equals(cTDose.getAcquisition(0)));
        TestCTDose.assertTrue((String)"Checking CTDoseAcquisition 2 equality", (boolean)cTDoseAcquisition2.equals(cTDose.getAcquisition(1)));
        TestCTDose.assertTrue((String)"Checking CTDoseAcquisition 3 equality", (boolean)cTDoseAcquisition3.equals(cTDose.getAcquisition(2)));
        TestCTDose.assertTrue((String)"Checking DLP Total as double with total from acquisitions", (boolean)cTDose.specifiedDLPTotalMatchesDLPTotalFromAcquisitions());
        TestCTDose.assertEquals((String)"Checking toString default", (String)string9, (String)cTDose.toString());
        TestCTDose.assertEquals((String)"Checking toString detail", (String)string9, (String)cTDose.toString(true, false));
        TestCTDose.assertEquals((String)"Checking toString no detail", (String)string10, (String)cTDose.toString(false, false));
        TestCTDose.assertEquals((String)"Checking toString no detail pretty", (String)string11, (String)cTDose.toString(false, true));
        TestCTDose.assertEquals((String)"Checking getHTML no detail", (String)string12, (String)cTDose.getHTMLTableRow(false));
        TestCTDose.assertEquals((String)"Checking getHTML detail", (String)string13, (String)cTDose.getHTMLTableRow(true));
        StructuredReport structuredReport = cTDose.getStructuredReport();
        TestCTDose.assertFalse((String)"Checking SR is not null", (structuredReport == null ? 1 : 0) != 0);
        AttributeList attributeList = cTDose.getAttributeList();
        TestCTDose.assertFalse((String)"Checking SR AttributeList is not null", (attributeList == null ? 1 : 0) != 0);
        Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
        TestCTDose.assertFalse((String)"Checking SR document is not null", (document == null ? 1 : 0) != 0);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestCTDose.assertEquals((String)"Checking document title", (String)"X-Ray Radiation Dose Report", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/concept/@cm", document));
        TestCTDose.assertEquals((String)"Checking procedure reported", (String)"Computed Tomography X-Ray", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='121058']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking diagnostic intent", (String)"Diagnostic Intent", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='121058']/code[concept/@cv='363703001']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking Start of X-Ray Irradiation", (String)string4, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/datetime[concept/@cv='113809']/value", document));
        TestCTDose.assertEquals((String)"Checking End of X-Ray Irradiation", (String)string6, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/datetime[concept/@cv='113810']/value", document));
        TestCTDose.assertEquals((String)"Checking scope of accumulation", (String)"Study", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='113705']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking scope of accumulation UIDREF", (String)string2, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='113705']/uidref/value", document));
        TestCTDose.assertEquals((String)"Checking Total Number of Irradiation Events", (String)Integer.toString(n), (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113812']/value", document));
        TestCTDose.assertEquals((String)"Checking Total Number of Irradiation Events units", (String)"events", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113812']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Total", (String)string3, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113813']/value", document));
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Total units", (String)"mGy.cm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113813']/units/@cm", document));
        NodeList nodeList = (NodeList)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']", document, XPathConstants.NODESET);
        TestCTDose.assertTrue((String)"CT Acquisitions not null", (nodeList != null ? 1 : 0) != 0);
        TestCTDose.assertTrue((String)"CT Acquisitions count", (nodeList.getLength() == n ? 1 : 0) != 0);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            TestCTDose.assertEquals((String)"Checking Target Region", (String)"Entire body", (String)xPathFactory.newXPath().evaluate("./code[concept/@cv='123014']/value/@cm", node));
            TestCTDose.assertEquals((String)"Checking CT Acquisition Type", (String)"Spiral Acquisition", (String)xPathFactory.newXPath().evaluate("./code[concept/@cv='113820']/value/@cm", node));
            TestCTDose.assertEquals((String)"Checking Scanning Length", (String)stringArray3[i], (String)xPathFactory.newXPath().evaluate("./container[concept/@cv='113822']/num[concept/@cv='113825']/value", node));
            TestCTDose.assertEquals((String)"Checking Scanning Length units", (String)"mm", (String)xPathFactory.newXPath().evaluate("./container[concept/@cv='113822']/num[concept/@cv='113825']/units/@cm", node));
            TestCTDose.assertEquals((String)"Checking Mean CTDIvol", (String)stringArray[i], (String)xPathFactory.newXPath().evaluate("./container[concept/@cv='113829']/num[concept/@cv='113830']/value", node));
            TestCTDose.assertEquals((String)"Checking Mean CTDIvol units", (String)"mGy", (String)xPathFactory.newXPath().evaluate("./container[concept/@cv='113829']/num[concept/@cv='113830']/units/@cm", node));
            TestCTDose.assertEquals((String)"Checking CTDIw Phantom Type", (String)"IEC Body Dosimetry Phantom", (String)xPathFactory.newXPath().evaluate("./container[concept/@cv='113829']/code[concept/@cv='113835']/value/@cm", node));
            TestCTDose.assertEquals((String)"Checking DLP", (String)stringArray2[i], (String)xPathFactory.newXPath().evaluate("./container[concept/@cv='113829']/num[concept/@cv='113838']/value", node));
            TestCTDose.assertEquals((String)"Checking DLP units", (String)"mGy.cm", (String)xPathFactory.newXPath().evaluate("./container[concept/@cv='113829']/num[concept/@cv='113838']/units/@cm", node));
        }
    }

    public void testCTDoseConstructor_WithOneAcquisitionsAndNoTotalDLP() throws Exception {
        SourceOfDoseInformation sourceOfDoseInformation = SourceOfDoseInformation.DERIVED_FROM_HUMAN_READABLE_REPORTS;
        String string = "1362.24";
        String string2 = "20.23";
        String string3 = "1.2.124.113532.172.16.11.4.20090807.144612.3424396";
        CTDoseAcquisition cTDoseAcquisition = new CTDoseAcquisition(string3, true, "2", CTScanType.HELICAL, new ScanRange("S", "14.250", "I", "635.750"), string2, string, CTPhantomType.selectFromDescription("BODY32"));
        String string4 = "1.2.3.4";
        CTScanType cTScanType = CTScanType.HELICAL;
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("416775004", "SCT", "Chest, Abdomen and Pelvis");
        String string5 = "5.90 CHEST+ABDOMEN+PELVIS";
        String string6 = "Non-contrast thin";
        String string7 = "1";
        String string8 = "120";
        String string9 = "397";
        String string10 = "433";
        String string11 = "0.6";
        String string12 = "0.625";
        String string13 = "40";
        String string14 = "0.984";
        String string15 = "14.5625";
        String string16 = "S14.5625";
        String string17 = "-636.0625";
        String string18 = "I636.0625";
        String string19 = "650.625";
        String string20 = "1.2.124.113532.172.16.11.4.3651756012387523857235";
        CTAcquisitionParameters cTAcquisitionParameters = new CTAcquisitionParameters(string4, cTScanType, codedSequenceItem, string5, string6, string7, null, string19, null, string15, string17, null, null, string20, string12, string13, string14, string8, string9, string10, string11);
        cTAcquisitionParameters.deriveScanningLengthFromDLPAndCTDIVolIfGreater(string, string2);
        String string21 = "673.38";
        CTDoseCheckDetails cTDoseCheckDetails = new CTDoseCheckDetails(true, "1000", true, "150", "1200", null, "very naughty", this.observerContext.getPersonParticipantAdministering(), true, "500", true, "120", null, "125", "slightly naughty", this.observerContext.getPersonParticipantAdministering());
        String string22 = string;
        String string23 = null;
        boolean bl = true;
        String string24 = "20010203043000+0000";
        String string25 = "20010203043500+0000";
        String string26 = "CAP";
        String string27 = "<tr><td>3764913624</td><td>Smith^Mary</td><td>F</td><td>19600101</td><td align=right>041Y</td><td align=right>68</td><td align=right>1.55</td><td></td><td>2001/02/03 04:30:00</td><td>CT</td><td>CAP</td><td align=right>1362.24 (BODY32)</td><td align=right></td><td align=right></td><td>" + this.manufacturer + "</td><td>" + this.modelName + "</td><td>" + this.deviceName + "</td><td>OCR</td></tr>\n";
        String string28 = "<tr><th>ID</th><th>Name</th><th>Sex</th><th>DOB</th><th>Age</th><th>Weight kg</th><th>Height m</th><th>Accession</th><th>Date</th><th>Modality</th><th>Description</th><th>DLP Total mGy.cm</th><th>DLP HEAD16 mGy.cm</th><th>DLP BODY32 mGy.cm</th><th>Manufacturer</th><th>Model</th><th>Station</th><th>From</th></tr>\n<tr><td>3764913624</td><td>Smith^Mary</td><td>F</td><td>19600101</td><td align=right>041Y</td><td align=right>68</td><td align=right>1.55</td><td></td><td>2001/02/03 04:30:00</td><td>CT</td><td>CAP</td><td align=right>1362.24 (BODY32)</td><td align=right></td><td align=right></td><td>" + this.manufacturer + "</td><td>" + this.modelName + "</td><td>" + this.deviceName + "</td><td>OCR</td></tr>\n<tr><td colspan=2></td><td colspan=15><table><tr><th>Number</th><th>Type</th><th>Range mm</th><th>CTDIvol mGy</th><th>DLP mGy.cm</th><th>Phantom</th><th>Type</th><th>Anatomy</th><th>Protocol</th><th>Scanning Length mm</th><th>Reconstructable Volume mm</th><th>Exposed Range mm</th><th>Collimation Single/Total mm</th><th>Pitch Factor</th><th>kVP</th><th>Tube Current Mean/Max mA</th><th>Exposure Time/Per Rotation s</th><th>Comment</th></tr>\n<tr><td>Series=2</td><td>Helical</td><td>S14.250-I635.750</td><td>20.23</td><td>1362.24</td><td>BODY32</td><td>Helical</td><td>Chest, Abdomen and Pelvis</td><td>" + string5 + "</td><td>673.38</td><td>650.625 [I636.0625-S14.5625]</td><td></td><td>0.625/40</td><td>0.984:1</td><td>120</td><td>397/433</td><td>1/0.6</td><td>" + string6 + "</td></tr>\n</table></td></tr>\n";
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string3, string24, string25, string26);
        cTDoseAcquisition.setAcquisitionParameters(cTAcquisitionParameters);
        cTDoseAcquisition.setDoseCheckDetails(cTDoseCheckDetails);
        cTDose.addAcquisition(cTDoseAcquisition);
        cTDose.setDLPTotal(string23);
        cTDose.setObserverContext(this.observerContext);
        cTDose.setCompositeInstanceContext(this.compositeInstanceContext);
        TestCTDose.assertEquals((String)"Checking SourceOfDoseInformation default", (Object)SourceOfDoseInformation.AUTOMATED_DATA_COLLECTION, (Object)cTDose.getSourceOfDoseInformation());
        cTDose.setSourceOfDoseInformation(sourceOfDoseInformation);
        TestCTDose.assertEquals((String)"Checking SourceOfDoseInformation is set", (Object)sourceOfDoseInformation, (Object)cTDose.getSourceOfDoseInformation());
        TestCTDose.assertEquals((String)"Checking null DLP Total", string23, (String)cTDose.getDLPTotal());
        TestCTDose.assertFalse((String)"Checking null DLP Total does not match total from acquisitions", (boolean)cTDose.specifiedDLPTotalMatchesDLPTotalFromAcquisitions());
        TestCTDose.assertEquals((String)"Checking DLP total from acquisitions", (String)string22, (String)cTDose.getDLPTotalFromAcquisitions());
        TestCTDose.assertEquals((String)"Checking getHTML no detail", (String)string27, (String)cTDose.getHTMLTableRow(false));
        TestCTDose.assertEquals((String)"Checking getHTML detail", (String)string28, (String)cTDose.getHTMLTableRow(true));
        StructuredReport structuredReport = cTDose.getStructuredReport();
        TestCTDose.assertFalse((String)"Checking SR is not null", (structuredReport == null ? 1 : 0) != 0);
        AttributeList attributeList = cTDose.getAttributeList();
        TestCTDose.assertFalse((String)"Checking SR AttributeList is not null", (attributeList == null ? 1 : 0) != 0);
        Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
        TestCTDose.assertFalse((String)"Checking SR document is not null", (document == null ? 1 : 0) != 0);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestCTDose.assertEquals((String)"Checking document title", (String)"X-Ray Radiation Dose Report", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/concept/@cm", document));
        TestCTDose.assertEquals((String)"Checking procedure reported", (String)"Computed Tomography X-Ray", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='121058']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking diagnostic intent", (String)"Diagnostic Intent", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='121058']/code[concept/@cv='363703001']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking observer type", (String)"Device", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='121005']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking Device Observer UID", (String)this.deviceUID, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/uidref[concept/@cv='121012']/value", document));
        TestCTDose.assertEquals((String)"Checking Device Observer Name", (String)this.deviceName, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/text[concept/@cv='121013']/value", document));
        TestCTDose.assertEquals((String)"Checking Device Observer Manufacturer", (String)this.manufacturer, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/text[concept/@cv='121014']/value", document));
        TestCTDose.assertEquals((String)"Checking Device Observer Model Name", (String)this.modelName, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/text[concept/@cv='121015']/value", document));
        TestCTDose.assertEquals((String)"Checking Device Observer Serial Number", (String)this.serialNumber, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/text[concept/@cv='121016']/value", document));
        TestCTDose.assertEquals((String)"Checking Device Observer Physical Location During Observation", (String)this.location, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/text[concept/@cv='121017']/value", document));
        TestCTDose.assertEquals((String)"Checking Start of X-Ray Irradiation", (String)string24, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/datetime[concept/@cv='113809']/value", document));
        TestCTDose.assertEquals((String)"Checking End of X-Ray Irradiation", (String)string25, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/datetime[concept/@cv='113810']/value", document));
        TestCTDose.assertEquals((String)"Checking scope of accumulation", (String)"Study", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='113705']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking scope of accumulation UIDREF", (String)string3, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='113705']/uidref/value", document));
        TestCTDose.assertEquals((String)"Checking Total Number of Irradiation Events", (String)"1", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113812']/value", document));
        TestCTDose.assertEquals((String)"Checking Total Number of Irradiation Events units", (String)"events", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113812']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Total", (String)string22, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113813']/value", document));
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Total units", (String)"mGy.cm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113813']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Acquisition Protocol", (String)string5, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/text[concept/@cv='125203']/value", document));
        TestCTDose.assertEquals((String)"Checking Target Region", (String)"Chest, Abdomen and Pelvis", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/code[concept/@cv='123014']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking CT Acquisition Type", (String)"Spiral Acquisition", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/code[concept/@cv='113820']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking Irradiation Event UID", (String)string4, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/uidref[concept/@cv='113769']/value", document));
        TestCTDose.assertEquals((String)"Checking ExposureTime", (String)string7, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113824']/value", document));
        TestCTDose.assertEquals((String)"Checking ExposureTime units", (String)"s", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113824']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Scanning Length", (String)string21, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113825']/value", document));
        TestCTDose.assertEquals((String)"Checking Scanning Length units", (String)"mm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113825']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Length of Reconstructable Volume", (String)string19, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113893']/value", document));
        TestCTDose.assertEquals((String)"Checking Length of Reconstructable Volume units", (String)"mm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113893']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Top Z Location of Reconstructable Volume", (String)string15, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113895']/value", document));
        TestCTDose.assertEquals((String)"Checking Top Z Location of Reconstructable Volume units", (String)"mm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113895']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Bottom Z Location of Reconstructable Volume", (String)string17, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113896']/value", document));
        TestCTDose.assertEquals((String)"Checking Bottom Z Location of Reconstructable Volume units", (String)"mm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113896']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Frame of Reference UID", (String)string20, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/uidref[concept/@cv='112227']/value", document));
        TestCTDose.assertEquals((String)"Checking Nominal Single Collimation Width", (String)string12, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113826']/value", document));
        TestCTDose.assertEquals((String)"Checking Nominal Single Collimation Width units", (String)"mm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113826']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Nominal Total Collimation Width", (String)string13, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113827']/value", document));
        TestCTDose.assertEquals((String)"Checking Nominal Total Collimation Width units", (String)"mm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113827']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Pitch Factor", (String)string14, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113828']/value", document));
        TestCTDose.assertEquals((String)"Checking Pitch Factor units", (String)"ratio", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113828']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Number of X-Ray Sources", (String)"1", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113823']/value", document));
        TestCTDose.assertEquals((String)"Checking Number of X-Ray Sources units", (String)"X-Ray sources", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113823']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Identification Number of the X-Ray Source", (String)"1", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/text[concept/@cv='113832']/value", document));
        TestCTDose.assertEquals((String)"Checking KVP", (String)string8, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113733']/value", document));
        TestCTDose.assertEquals((String)"Checking KVP units", (String)"kV", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113733']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Maximum X-Ray Tube Current", (String)string10, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113833']/value", document));
        TestCTDose.assertEquals((String)"Checking Maximum X-Ray Tube Current units", (String)"mA", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113833']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking X-Ray Tube Current", (String)string9, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113734']/value", document));
        TestCTDose.assertEquals((String)"Checking X-Ray Tube Current units", (String)"mA", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113734']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Exposure Time per Rotation", (String)string11, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113834']/value", document));
        TestCTDose.assertEquals((String)"Checking Exposure Time per Rotation", (String)"s", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113834']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Comment", (String)string6, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/text[concept/@cv='121106']/value", document));
        TestCTDose.assertEquals((String)"Checking Mean CTDIvol", (String)string2, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113829']/num[concept/@cv='113830']/value", document));
        TestCTDose.assertEquals((String)"Checking Mean CTDIvol units", (String)"mGy", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113829']/num[concept/@cv='113830']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking CTDIw Phantom Type", (String)"IEC Body Dosimetry Phantom", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113829']/code[concept/@cv='113835']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking DLP", (String)string, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113829']/num[concept/@cv='113838']/value", document));
        TestCTDose.assertEquals((String)"Checking DLP units", (String)"mGy.cm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113829']/num[concept/@cv='113838']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Source of Dose Information", (String)"Derived From Human-Readable Reports", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='113854']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking Device Role in Procedure", (String)"Irradiating Device", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/code[concept/@cv='113876']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking Device Manufacturer", (String)this.manufacturer, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/code[concept/@cv='113876']/text[concept/@cv='113878']/value", document));
        TestCTDose.assertEquals((String)"Checking Device Model Name", (String)this.modelName, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/code[concept/@cv='113876']/text[concept/@cv='113879']/value", document));
        TestCTDose.assertEquals((String)"Checking Device Serial Number", (String)this.serialNumber, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/code[concept/@cv='113876']/text[concept/@cv='113880']/value", document));
        TestCTDose.assertEquals((String)"Checking Device Observer UID", (String)this.deviceUID, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/code[concept/@cv='113876']/uidref[concept/@cv='121012']/value", document));
        String string29 = "Root Content Item has Template Identifier DCMR:10011 (Manufacturer \"Acme\", Model \"Scanner\")\nFound XRayRadiationDoseSR IOD\nFound Root Template TID_10011 (CTRadiationDose)\nRoot Template Validation Complete\nWarning: 1.12.2.1: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113811,DCM,\"CT Accumulated Dose Data\")/NUM (113813,DCM,\"CT Dose Length Product Total\")/CODE (113835,DCM,\"CTDIw Phantom Type\"): Content Item not in template\nIOD validation complete\n";
        DicomSRValidator dicomSRValidator = new DicomSRValidator();
        System.err.println("validate =\n" + dicomSRValidator.validate(attributeList));
        TestCTDose.assertEquals((String)"Checking validation from StructuredReport Document", (String)string29, (String)dicomSRValidator.validate(attributeList));
        TestCTDose.assertEquals((String)"Checking PatientName", (String)this.patientName, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientName));
        TestCTDose.assertEquals((String)"Checking PatientID", (String)this.patientID, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID));
        TestCTDose.assertEquals((String)"Checking PatientBirthDate", (String)this.patientBirthDate, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientBirthDate));
        TestCTDose.assertEquals((String)"Checking PatientSex", (String)this.patientSex, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientSex));
        TestCTDose.assertEquals((String)"Checking PatientAge", (String)this.patientAge, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientAge));
        TestCTDose.assertEquals((String)"Checking PatientWeight", (String)this.patientWeight, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientWeight));
        TestCTDose.assertEquals((String)"Checking PatientSize", (String)this.patientSize, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientSize));
        TestCTDose.assertEquals((String)"Checking StudyInstanceUID", (String)this.studyInstanceUID, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID));
        TestCTDose.assertEquals((String)"Checking StudyID", (String)this.studyID, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyID));
        TestCTDose.assertEquals((String)"Checking ReferringPhysicianName", (String)this.referringPhysicianName, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ReferringPhysicianName));
        TestCTDose.assertEquals((String)"Checking AccessionNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AccessionNumber));
        TestCTDose.assertEquals((String)"Checking StudyDate", (String)this.studyDate, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDate));
        TestCTDose.assertEquals((String)"Checking StudyTime", (String)this.studyTime, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyTime));
        TestCTDose.assertEquals((String)"Checking SeriesInstanceUID", (String)this.seriesInstanceUID, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID));
        TestCTDose.assertEquals((String)"Checking SeriesNumber", (String)this.seriesNumber, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber));
        TestCTDose.assertEquals((String)"Checking SOPInstanceUID", (String)this.sopInstanceUID, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID));
        TestCTDose.assertEquals((String)"Checking InstanceNumber", (String)this.instanceNumber, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InstanceNumber));
        String string30 = structuredReport.toString();
        CTDose cTDose2 = new CTDose(structuredReport);
        StructuredReport structuredReport2 = cTDose2.getStructuredReport(true);
        String string31 = structuredReport2.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR (from SR alone) as string", (String)string30, (String)string31);
        String string32 = attributeList.toString();
        AttributeList attributeList2 = cTDose2.getAttributeList();
        String string33 = attributeList.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR AttributeList (from SR alone) as string", (String)string32, (String)string33);
        string30 = structuredReport.toString();
        cTDose2 = new CTDose(structuredReport, attributeList);
        structuredReport2 = cTDose2.getStructuredReport(true);
        string31 = structuredReport2.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR (from SR and AttributeList) as string", (String)string30, (String)string31);
        string32 = attributeList.toString();
        attributeList2 = cTDose2.getAttributeList();
        string33 = attributeList.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR AttributeList (from SR and AttributeList) as as string", (String)string32, (String)string33);
        string30 = structuredReport.toString();
        cTDose2 = new CTDose(attributeList);
        structuredReport2 = cTDose2.getStructuredReport(true);
        string31 = structuredReport2.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR (from AttributeList alone) as string", (String)string30, (String)string31);
        string32 = attributeList.toString();
        attributeList2 = cTDose2.getAttributeList();
        string33 = attributeList.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR AttributeList (from AttributeList alone) as as string", (String)string32, (String)string33);
    }

    public void testCTDoseConstructor_PropagationOfDescriptionToAttributeList_IfNoStudyDescriptionInCompositeInstanceContext() throws Exception {
        String string = "1.2.124.113532.172.16.11.4.20090807.144612.3424396";
        String string2 = "20010203043000+0000";
        String string3 = "20010203043500+0000";
        String string4 = "Wanted";
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string, string2, string3, string4);
        cTDose.setCompositeInstanceContext(this.compositeInstanceContext);
        TestCTDose.assertEquals((String)"Checking description is set correctly", (String)string4, (String)cTDose.getDescription());
        AttributeList attributeList = cTDose.getAttributeList();
        String string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDescription);
        TestCTDose.assertEquals((String)"Checking description is copied into StudyDescription", (String)string4, (String)string5);
    }

    public void testCTDoseConstructor_PropagationOfDescriptionToAttributeList_DoesNotOverwriteIfStudyDescriptionAlreadyInCompositeInstanceContext() throws Exception {
        String string = "1.2.124.113532.172.16.11.4.20090807.144612.3424396";
        String string2 = "20010203043000+0000";
        String string3 = "20010203043500+0000";
        String string4 = "Replacement";
        String string5 = "Existing";
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string, string2, string3, string4);
        Object object = new LongStringAttribute(TagFromName.StudyDescription);
        ((Attribute)object).addValue(string5);
        this.compositeInstanceContext.put((Attribute)object);
        cTDose.setCompositeInstanceContext(this.compositeInstanceContext);
        TestCTDose.assertEquals((String)"Checking description is set correctly", (String)string4, (String)cTDose.getDescription());
        object = cTDose.getAttributeList();
        String string6 = Attribute.getSingleStringValueOrEmptyString((AttributeList)object, TagFromName.StudyDescription);
        TestCTDose.assertEquals((String)"Checking description does not overwrite StudyDescription", (String)string5, (String)string6);
    }

    public void testCTDoseConstructor_WithSeparateHeadAndBodyTotalDLPConstructor() throws Exception {
        String string = "844.90";
        String string2 = "622.70";
        String string3 = "1045.15";
        int n = 0;
        String string4 = "1.2.124.113532.172.16.11.4.20090807.144612.3424396";
        String string5 = "20010203043000+0000";
        String string6 = "20010203043500+0000";
        String string7 = "HeadAndCAP";
        String string8 = "Dose\tPatient ID=" + this.patientID + "\tName=" + this.patientName + "\tSex=" + this.patientSex + "\tDOB=" + this.patientBirthDate + "\tAge=" + this.patientAge + "\tWeight=" + this.patientWeight + " kg\tHeight=" + this.patientSize + " m\tAccession=\tStart=" + string5 + "\tEnd=" + string6 + "\tModality=CT\tDescription=" + string7 + "\tScope=Study\tUID=" + string4 + "\tEvents=" + Integer.toString(n) + "\tDLP Total=" + string3 + " (BODY32) (HEAD16 " + string + ") (BODY32 " + string2 + ") mGy.cm\n";
        String string9 = "Dose\tPatient ID=" + this.patientID + "\tName=" + this.patientName + "\tSex=" + this.patientSex + "\tDOB=" + this.patientBirthDate + "\tAge=" + this.patientAge + "\tWeight=" + this.patientWeight + " kg\tHeight=" + this.patientSize + " m\tAccession=\tStart=" + string5 + "\tModality=CT\tDescription=" + string7 + "\tDLP Total=" + string3 + " (BODY32) (HEAD16 " + string + ") (BODY32 " + string2 + ") mGy.cm\n";
        String string10 = "<tr><td>" + this.patientID + "</td><td>" + this.patientName + "</td><td>" + this.patientSex + "</td><td>" + this.patientBirthDate + "</td><td align=right>" + this.patientAge + "</td><td align=right>" + this.patientWeight + "</td><td align=right>" + this.patientSize + "</td><td></td><td>2001/02/03 04:30:00</td><td>CT</td><td>" + string7 + "</td><td align=right>" + string3 + " (BODY32)</td><td align=right>" + string + "</td><td align=right>" + string2 + "</td><td>" + this.manufacturer + "</td><td>" + this.modelName + "</td><td>" + this.deviceName + "</td><td>MOD</td></tr>\n";
        String string11 = "<tr><th>ID</th><th>Name</th><th>Sex</th><th>DOB</th><th>Age</th><th>Weight kg</th><th>Height m</th><th>Accession</th><th>Date</th><th>Modality</th><th>Description</th><th>DLP Total mGy.cm</th><th>DLP HEAD16 mGy.cm</th><th>DLP BODY32 mGy.cm</th><th>Manufacturer</th><th>Model</th><th>Station</th><th>From</th></tr>\n<tr><td>" + this.patientID + "</td><td>" + this.patientName + "</td><td>" + this.patientSex + "</td><td>" + this.patientBirthDate + "</td><td align=right>" + this.patientAge + "</td><td align=right>" + this.patientWeight + "</td><td align=right>" + this.patientSize + "</td><td></td><td>2001/02/03 04:30:00</td><td>CT</td><td>" + string7 + "</td><td align=right>" + string3 + " (BODY32)</td><td align=right>" + string + "</td><td align=right>" + string2 + "</td><td>" + this.manufacturer + "</td><td>" + this.modelName + "</td><td>" + this.deviceName + "</td><td>MOD</td></tr>\n";
        CTDose cTDose = new CTDose(string, string2, n, ScopeOfDoseAccummulation.STUDY, string4, string5, string6, string7);
        cTDose.setObserverContext(this.observerContext);
        cTDose.setCompositeInstanceContext(this.compositeInstanceContext);
        TestCTDose.assertEquals((String)"Checking DLP Total", (String)string3, (String)cTDose.getDLPTotal());
        TestCTDose.assertEquals((String)"Checking DLP Total Head", (String)string, (String)cTDose.getDLPSubTotalHead());
        TestCTDose.assertEquals((String)"Checking DLP Total Body", (String)string2, (String)cTDose.getDLPSubTotalBody());
        TestCTDose.assertEquals((String)"Checking toString default", (String)string8, (String)cTDose.toString());
        TestCTDose.assertEquals((String)"Checking toString detail", (String)string8, (String)cTDose.toString(true, false));
        TestCTDose.assertEquals((String)"Checking toString no detail", (String)string9, (String)cTDose.toString(false, false));
        TestCTDose.assertEquals((String)"Checking getHTML no detail", (String)string10, (String)cTDose.getHTMLTableRow(false));
        TestCTDose.assertEquals((String)"Checking getHTML detail", (String)string11, (String)cTDose.getHTMLTableRow(true));
        StructuredReport structuredReport = cTDose.getStructuredReport();
        TestCTDose.assertFalse((String)"Checking SR is not null", (structuredReport == null ? 1 : 0) != 0);
        AttributeList attributeList = cTDose.getAttributeList();
        TestCTDose.assertFalse((String)"Checking SR AttributeList is not null", (attributeList == null ? 1 : 0) != 0);
        Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
        TestCTDose.assertFalse((String)"Checking SR document is not null", (document == null ? 1 : 0) != 0);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Total", (String)string3, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701' and concept/@csd='DCM']/container[concept/@cv='113811' and concept/@csd='DCM']/num[concept/@cv='113813' and concept/@csd='DCM']/value", document));
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Total units", (String)"mGy.cm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701' and concept/@csd='DCM']/container[concept/@cv='113811' and concept/@csd='DCM']/num[concept/@cv='113813' and concept/@csd='DCM']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking CTDIw Phantom Type", (String)"IEC Body Dosimetry Phantom", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701' and concept/@csd='DCM']/container[concept/@cv='113811' and concept/@csd='DCM']/num[concept/@cv='113813' and concept/@csd='DCM']/code[concept/@cv='113835' and concept/@csd='DCM']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Head Sub-Total", (String)string, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701' and concept/@csd='DCM']/container[concept/@cv='113811' and concept/@csd='DCM']/num[concept/@cv='113813' and concept/@csd='DCM']/num [concept/@cv='220005' and code/concept/@cv='113835' and code/concept/@csd='DCM' and code/value/@cv='113690' and code/value/@csd='DCM']/value", document));
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Body Sub-Total", (String)string2, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701' and concept/@csd='DCM']/container[concept/@cv='113811' and concept/@csd='DCM']/num[concept/@cv='113813' and concept/@csd='DCM']/num [concept/@cv='220005' and code/concept/@cv='113835' and code/concept/@csd='DCM' and code/value/@cv='113691' and code/value/@csd='DCM']/value", document));
        String string12 = "Root Content Item has Template Identifier DCMR:10011 (Manufacturer \"Acme\", Model \"Scanner\")\nFound XRayRadiationDoseSR IOD\nFound Root Template TID_10011 (CTRadiationDose)\nWarning: Template 10012 CTAccumulatedDoseData/[Row 1] CONTAINER (113811,DCM,\"CT Accumulated Dose Data\")/[Row 2] NUM (113812,DCM,\"Total Number of Irradiation Events\"): 1.12: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113811,DCM,\"CT Accumulated Dose Data\"): value of 0 for Total Number of Irradiation Events is not illegal, but is unlikely to be correct\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\"): within 1: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\"): Missing required content item\nRoot Template Validation Complete\nWarning: 1.12.2.1: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113811,DCM,\"CT Accumulated Dose Data\")/NUM (113813,DCM,\"CT Dose Length Product Total\")/CODE (113835,DCM,\"CTDIw Phantom Type\"): Content Item not in template\nWarning: 1.12.2.2: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113811,DCM,\"CT Accumulated Dose Data\")/NUM (113813,DCM,\"CT Dose Length Product Total\")/NUM (220005,99PMP,\"CT Dose Length Product Sub-Total\"): Content Item not in template\nWarning: 1.12.2.2.1: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113811,DCM,\"CT Accumulated Dose Data\")/NUM (113813,DCM,\"CT Dose Length Product Total\")/NUM (220005,99PMP,\"CT Dose Length Product Sub-Total\")/CODE (113835,DCM,\"CTDIw Phantom Type\"): Content Item not in template\nWarning: 1.12.2.3: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113811,DCM,\"CT Accumulated Dose Data\")/NUM (113813,DCM,\"CT Dose Length Product Total\")/NUM (220005,99PMP,\"CT Dose Length Product Sub-Total\"): Content Item not in template\nWarning: 1.12.2.3.1: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113811,DCM,\"CT Accumulated Dose Data\")/NUM (113813,DCM,\"CT Dose Length Product Total\")/NUM (220005,99PMP,\"CT Dose Length Product Sub-Total\")/CODE (113835,DCM,\"CTDIw Phantom Type\"): Content Item not in template\nIOD validation complete\n";
        DicomSRValidator dicomSRValidator = new DicomSRValidator();
        System.err.println("validate =\n" + dicomSRValidator.validate(attributeList));
        TestCTDose.assertEquals((String)"Checking validation from StructuredReport Document", (String)string12, (String)dicomSRValidator.validate(attributeList));
        String string13 = structuredReport.toString();
        CTDose cTDose2 = new CTDose(structuredReport);
        StructuredReport structuredReport2 = cTDose2.getStructuredReport(true);
        String string14 = structuredReport2.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR (from SR alone) as string", (String)string13, (String)string14);
        String string15 = attributeList.toString();
        AttributeList attributeList2 = cTDose2.getAttributeList();
        String string16 = attributeList.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR AttributeList (from SR alone) as string", (String)string15, (String)string16);
    }

    public void testCTDoseConstructor_WithSeparateHeadAndBodyTotalDLPSet() throws Exception {
        String string = "844.90";
        String string2 = "622.70";
        String string3 = "1045.15";
        int n = 0;
        String string4 = "1.2.124.113532.172.16.11.4.20090807.144612.3424396";
        String string5 = "20010203043000+0000";
        String string6 = "20010203043500+0000";
        String string7 = "HeadAndCAP";
        String string8 = "Dose\tPatient ID=3764913624\tName=Smith^Mary\tSex=F\tDOB=19600101\tAge=041Y\tWeight=68 kg\tHeight=1.55 m\tAccession=\tStart=" + string5 + "\tEnd=" + string6 + "\tModality=CT\tDescription=" + string7 + "\tScope=Study\tUID=" + string4 + "\tEvents=" + Integer.toString(n) + "\tDLP Total=" + string3 + " (BODY32) (HEAD16 " + string + ") (BODY32 " + string2 + ") mGy.cm\n";
        String string9 = "Dose\tPatient ID=3764913624\tName=Smith^Mary\tSex=F\tDOB=19600101\tAge=041Y\tWeight=68 kg\tHeight=1.55 m\tAccession=\tStart=" + string5 + "\tModality=CT\tDescription=" + string7 + "\tDLP Total=" + string3 + " (BODY32) (HEAD16 " + string + ") (BODY32 " + string2 + ") mGy.cm\n";
        String string10 = "<tr><td>" + this.patientID + "</td><td>" + this.patientName + "</td><td>" + this.patientSex + "</td><td>" + this.patientBirthDate + "</td><td align=right>" + this.patientAge + "</td><td align=right>" + this.patientWeight + "</td><td align=right>" + this.patientSize + "</td><td></td><td>2001/02/03 04:30:00</td><td>CT</td><td>" + string7 + "</td><td align=right>" + string3 + " (BODY32)</td><td align=right>" + string + "</td><td align=right>" + string2 + "</td><td></td><td></td><td></td><td>MOD</td></tr>\n";
        String string11 = "<tr><th>ID</th><th>Name</th><th>Sex</th><th>DOB</th><th>Age</th><th>Weight kg</th><th>Height m</th><th>Accession</th><th>Date</th><th>Modality</th><th>Description</th><th>DLP Total mGy.cm</th><th>DLP HEAD16 mGy.cm</th><th>DLP BODY32 mGy.cm</th><th>Manufacturer</th><th>Model</th><th>Station</th><th>From</th></tr>\n<tr><td>" + this.patientID + "</td><td>" + this.patientName + "</td><td>" + this.patientSex + "</td><td>" + this.patientBirthDate + "</td><td align=right>" + this.patientAge + "</td><td align=right>" + this.patientWeight + "</td><td align=right>" + this.patientSize + "</td><td></td><td>2001/02/03 04:30:00</td><td>CT</td><td>" + string7 + "</td><td align=right>" + string3 + " (BODY32)</td><td align=right>" + string + "</td><td align=right>" + string2 + "</td><td></td><td></td><td></td><td>MOD</td></tr>\n";
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string4, string5, string6, string7);
        cTDose.setDLPTotal(string, string2);
        cTDose.setCompositeInstanceContext(this.compositeInstanceContext);
        TestCTDose.assertEquals((String)"Checking DLP Total", (String)string3, (String)cTDose.getDLPTotal());
        TestCTDose.assertEquals((String)"Checking DLP Total Head", (String)string, (String)cTDose.getDLPSubTotalHead());
        TestCTDose.assertEquals((String)"Checking DLP Total Body", (String)string2, (String)cTDose.getDLPSubTotalBody());
        TestCTDose.assertEquals((String)"Checking toString default", (String)string8, (String)cTDose.toString());
        TestCTDose.assertEquals((String)"Checking toString detail", (String)string8, (String)cTDose.toString(true, false));
        TestCTDose.assertEquals((String)"Checking toString no detail", (String)string9, (String)cTDose.toString(false, false));
        TestCTDose.assertEquals((String)"Checking getHTML no detail", (String)string10, (String)cTDose.getHTMLTableRow(false));
        TestCTDose.assertEquals((String)"Checking getHTML detail", (String)string11, (String)cTDose.getHTMLTableRow(true));
        TestCTDose.assertFalse((String)"Checking SR is not null", (cTDose.getStructuredReport() == null ? 1 : 0) != 0);
    }

    public void testCTDoseConstructor_WithSeparateHeadAndBodyAcquisitions() throws Exception {
        String[] stringArray = new String[]{"14.80", "18.60", "16.80", "18.20"};
        String[] stringArray2 = new String[]{"318.60", "516.10", "462.30", "649.80"};
        String[] stringArray3 = new String[]{"21.53", "27.75", "27.52", "35.70"};
        String[] stringArray4 = new String[]{"HEAD16", "HEAD16", "BODY32", "BODY32"};
        String[] stringArray5 = new String[]{"Axial", "Helical", "Helical", "Helical"};
        String string = "1.2.124.113532.172.16.11.4.20090807.144612.3424396";
        CTDoseAcquisition cTDoseAcquisition = new CTDoseAcquisition(string, false, null, CTScanType.selectFromDescription(stringArray5[0]), null, stringArray[0], stringArray2[0], CTPhantomType.selectFromDescription(stringArray4[0]));
        CTDoseAcquisition cTDoseAcquisition2 = new CTDoseAcquisition(string, false, null, CTScanType.selectFromDescription(stringArray5[1]), null, stringArray[1], stringArray2[1], CTPhantomType.selectFromDescription(stringArray4[1]));
        CTDoseAcquisition cTDoseAcquisition3 = new CTDoseAcquisition(string, false, null, CTScanType.selectFromDescription(stringArray5[2]), null, stringArray[2], stringArray2[2], CTPhantomType.selectFromDescription(stringArray4[2]));
        CTDoseAcquisition cTDoseAcquisition4 = new CTDoseAcquisition(string, false, null, CTScanType.selectFromDescription(stringArray5[3]), null, stringArray[3], stringArray2[3], CTPhantomType.selectFromDescription(stringArray4[3]));
        String string2 = "834.70";
        String string3 = "1112.10";
        String string4 = "1529.45";
        int n = 4;
        String string5 = "20010203043000+0000";
        String string6 = "20010203043500+0000";
        String string7 = "HeadAndCAP";
        String string8 = "Dose\tPatient ID=" + this.patientID + "\tName=" + this.patientName + "\tSex=" + this.patientSex + "\tDOB=" + this.patientBirthDate + "\tAge=" + this.patientAge + "\tWeight=" + this.patientWeight + " kg\tHeight=" + this.patientSize + " m\tAccession=\tStart=" + string5 + "\tEnd=" + string6 + "\tModality=CT\tDescription=" + string7 + "\tScope=Study\tUID=" + string + "\tEvents=" + Integer.toString(n) + "\tDLP Total=" + string4 + " (BODY32) (HEAD16 " + string2 + ") (BODY32 " + string3 + ") mGy.cm\n\tAcq=null\t" + stringArray5[0] + "\tRange=null mm\tCTDIvol=" + stringArray[0] + " mGy\tDLP=" + stringArray2[0] + " mGy.cm\tPhantom=" + stringArray4[0] + "\n\tAcq=null\t" + stringArray5[1] + "\tRange=null mm\tCTDIvol=" + stringArray[1] + " mGy\tDLP=" + stringArray2[1] + " mGy.cm\tPhantom=" + stringArray4[1] + "\n\tAcq=null\t" + stringArray5[2] + "\tRange=null mm\tCTDIvol=" + stringArray[2] + " mGy\tDLP=" + stringArray2[2] + " mGy.cm\tPhantom=" + stringArray4[2] + "\n\tAcq=null\t" + stringArray5[3] + "\tRange=null mm\tCTDIvol=" + stringArray[3] + " mGy\tDLP=" + stringArray2[3] + " mGy.cm\tPhantom=" + stringArray4[3] + "\n";
        String string9 = "Dose\tPatient ID=" + this.patientID + "\tName=" + this.patientName + "\tSex=" + this.patientSex + "\tDOB=" + this.patientBirthDate + "\tAge=" + this.patientAge + "\tWeight=" + this.patientWeight + " kg\tHeight=" + this.patientSize + " m\tAccession=\tStart=" + string5 + "\tModality=CT\tDescription=" + string7 + "\tDLP Total=" + string4 + " (BODY32) (HEAD16 " + string2 + ") (BODY32 " + string3 + ") mGy.cm\n";
        String string10 = "<tr><td>" + this.patientID + "</td><td>" + this.patientName + "</td><td>" + this.patientSex + "</td><td>" + this.patientBirthDate + "</td><td align=right>" + this.patientAge + "</td><td align=right>" + this.patientWeight + "</td><td align=right>" + this.patientSize + "</td><td></td><td>2001/02/03 04:30:00</td><td>CT</td><td>" + string7 + "</td><td align=right>" + string4 + " (BODY32)</td><td align=right>" + string2 + "</td><td align=right>" + string3 + "</td><td>" + this.manufacturer + "</td><td>" + this.modelName + "</td><td>" + this.deviceName + "</td><td>MOD</td></tr>\n";
        String string11 = "<tr><th>ID</th><th>Name</th><th>Sex</th><th>DOB</th><th>Age</th><th>Weight kg</th><th>Height m</th><th>Accession</th><th>Date</th><th>Modality</th><th>Description</th><th>DLP Total mGy.cm</th><th>DLP HEAD16 mGy.cm</th><th>DLP BODY32 mGy.cm</th><th>Manufacturer</th><th>Model</th><th>Station</th><th>From</th></tr>\n<tr><td>" + this.patientID + "</td><td>" + this.patientName + "</td><td>" + this.patientSex + "</td><td>" + this.patientBirthDate + "</td><td align=right>" + this.patientAge + "</td><td align=right>" + this.patientWeight + "</td><td align=right>" + this.patientSize + "</td><td></td><td>2001/02/03 04:30:00</td><td>CT</td><td>" + string7 + "</td><td align=right>" + string4 + " (BODY32)</td><td align=right>" + string2 + "</td><td align=right>" + string3 + "</td><td>" + this.manufacturer + "</td><td>" + this.modelName + "</td><td>" + this.deviceName + "</td><td>MOD</td></tr>\n<tr><td colspan=2></td><td colspan=15><table><tr><th>Number</th><th>Type</th><th>Range mm</th><th>CTDIvol mGy</th><th>DLP mGy.cm</th><th>Phantom</th></tr>\n<tr><td></td><td>" + stringArray5[0] + "</td><td></td><td>" + stringArray[0] + "</td><td>" + stringArray2[0] + "</td><td>" + stringArray4[0] + "</td></tr>\n<tr><td></td><td>" + stringArray5[1] + "</td><td></td><td>" + stringArray[1] + "</td><td>" + stringArray2[1] + "</td><td>" + stringArray4[1] + "</td></tr>\n<tr><td></td><td>" + stringArray5[2] + "</td><td></td><td>" + stringArray[2] + "</td><td>" + stringArray2[2] + "</td><td>" + stringArray4[2] + "</td></tr>\n<tr><td></td><td>" + stringArray5[3] + "</td><td></td><td>" + stringArray[3] + "</td><td>" + stringArray2[3] + "</td><td>" + stringArray4[3] + "</td></tr>\n</table></td></tr>\n";
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string, string5, string6, string7);
        cTDose.setDLPTotal(string2, string3);
        cTDose.addAcquisition(cTDoseAcquisition);
        cTDose.addAcquisition(cTDoseAcquisition2);
        cTDose.addAcquisition(cTDoseAcquisition3);
        cTDose.addAcquisition(cTDoseAcquisition4);
        cTDose.setObserverContext(this.observerContext);
        cTDose.setCompositeInstanceContext(this.compositeInstanceContext);
        TestCTDose.assertEquals((String)"Checking DLP Total", (String)string4, (String)cTDose.getDLPTotal());
        TestCTDose.assertEquals((String)"Checking DLP Total (to use)", (String)string4, (String)cTDose.getDLPTotalToUse());
        TestCTDose.assertEquals((String)"Checking DLP Total (CombinedFromHeadAndBodyPhantomValues)", (String)string4, (String)cTDose.getDLPTotalCombinedFromHeadAndBodyPhantomValues());
        TestCTDose.assertEquals((String)"Checking DLP Total (from acquisitions)", (String)string4, (String)cTDose.getDLPTotalFromAcquisitions());
        TestCTDose.assertEquals((String)"Checking DLP Total Head", (String)string2, (String)cTDose.getDLPSubTotalHead());
        TestCTDose.assertEquals((String)"Checking DLP Total Body", (String)string3, (String)cTDose.getDLPSubTotalBody());
        TestCTDose.assertEquals((String)"Checking toString default", (String)string8, (String)cTDose.toString());
        TestCTDose.assertEquals((String)"Checking toString detail", (String)string8, (String)cTDose.toString(true, false));
        TestCTDose.assertEquals((String)"Checking toString no detail", (String)string9, (String)cTDose.toString(false, false));
        TestCTDose.assertEquals((String)"Checking getHTML no detail", (String)string10, (String)cTDose.getHTMLTableRow(false));
        TestCTDose.assertEquals((String)"Checking getHTML detail", (String)string11, (String)cTDose.getHTMLTableRow(true));
        StructuredReport structuredReport = cTDose.getStructuredReport();
        TestCTDose.assertFalse((String)"Checking SR is not null", (structuredReport == null ? 1 : 0) != 0);
        AttributeList attributeList = cTDose.getAttributeList();
        TestCTDose.assertFalse((String)"Checking SR AttributeList is not null", (attributeList == null ? 1 : 0) != 0);
        Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
        TestCTDose.assertFalse((String)"Checking SR document is not null", (document == null ? 1 : 0) != 0);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Total", (String)string4, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113813']/value", document));
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Total units", (String)"mGy.cm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113813']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking CTDIw Phantom Type", (String)"IEC Body Dosimetry Phantom", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113813']/code[concept/@cv='113835']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Head Sub-Total", (String)string2, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113813']/num[concept/@cv='220005' and code/concept/@cv='113835' and code/value/@cv='113690']/value", document));
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Body Sub-Total", (String)string3, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113813']/num[concept/@cv='220005' and code/concept/@cv='113835' and code/value/@cv='113691']/value", document));
        String string12 = "Root Content Item has Template Identifier DCMR:10011 (Manufacturer \"Acme\", Model \"Scanner\")\nFound XRayRadiationDoseSR IOD\nFound Root Template TID_10011 (CTRadiationDose)\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 8] NUM (113824,DCM,\"Exposure Time\"): within 1.13.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 10] NUM (113826,DCM,\"Nominal Single Collimation Width\"): within 1.13.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 11] NUM (113827,DCM,\"Nominal Total Collimation Width\"): within 1.13.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 12] NUM (113828,DCM,\"Pitch Factor\"): within 1.13.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing conditional content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 13] NUM (113823,DCM,\"Number of X-Ray Sources\"): within 1.13.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 14] CONTAINER (113831,DCM,\"CT X-Ray Source Parameters\"): within 1.13.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 8] NUM (113824,DCM,\"Exposure Time\"): within 1.14.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 10] NUM (113826,DCM,\"Nominal Single Collimation Width\"): within 1.14.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 11] NUM (113827,DCM,\"Nominal Total Collimation Width\"): within 1.14.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 12] NUM (113828,DCM,\"Pitch Factor\"): within 1.14.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing conditional content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 13] NUM (113823,DCM,\"Number of X-Ray Sources\"): within 1.14.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 14] CONTAINER (113831,DCM,\"CT X-Ray Source Parameters\"): within 1.14.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 8] NUM (113824,DCM,\"Exposure Time\"): within 1.15.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 10] NUM (113826,DCM,\"Nominal Single Collimation Width\"): within 1.15.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 11] NUM (113827,DCM,\"Nominal Total Collimation Width\"): within 1.15.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 12] NUM (113828,DCM,\"Pitch Factor\"): within 1.15.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing conditional content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 13] NUM (113823,DCM,\"Number of X-Ray Sources\"): within 1.15.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 14] CONTAINER (113831,DCM,\"CT X-Ray Source Parameters\"): within 1.15.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 8] NUM (113824,DCM,\"Exposure Time\"): within 1.16.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 10] NUM (113826,DCM,\"Nominal Single Collimation Width\"): within 1.16.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 11] NUM (113827,DCM,\"Nominal Total Collimation Width\"): within 1.16.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 12] NUM (113828,DCM,\"Pitch Factor\"): within 1.16.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing conditional content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 13] NUM (113823,DCM,\"Number of X-Ray Sources\"): within 1.16.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nError: Template 10013 CTIrradiationEventData/[Row 1] CONTAINER (113819,DCM,\"CT Acquisition\")/[Row 7] CONTAINER (113822,DCM,\"CT Acquisition Parameters\")/[Row 14] CONTAINER (113831,DCM,\"CT X-Ray Source Parameters\"): within 1.16.4: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113819,DCM,\"CT Acquisition\")/CONTAINER (113822,DCM,\"CT Acquisition Parameters\"): Missing required content item\nRoot Template Validation Complete\nWarning: 1.12.2.1: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113811,DCM,\"CT Accumulated Dose Data\")/NUM (113813,DCM,\"CT Dose Length Product Total\")/CODE (113835,DCM,\"CTDIw Phantom Type\"): Content Item not in template\nWarning: 1.12.2.2: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113811,DCM,\"CT Accumulated Dose Data\")/NUM (113813,DCM,\"CT Dose Length Product Total\")/NUM (220005,99PMP,\"CT Dose Length Product Sub-Total\"): Content Item not in template\nWarning: 1.12.2.2.1: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113811,DCM,\"CT Accumulated Dose Data\")/NUM (113813,DCM,\"CT Dose Length Product Total\")/NUM (220005,99PMP,\"CT Dose Length Product Sub-Total\")/CODE (113835,DCM,\"CTDIw Phantom Type\"): Content Item not in template\nWarning: 1.12.2.3: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113811,DCM,\"CT Accumulated Dose Data\")/NUM (113813,DCM,\"CT Dose Length Product Total\")/NUM (220005,99PMP,\"CT Dose Length Product Sub-Total\"): Content Item not in template\nWarning: 1.12.2.3.1: /CONTAINER (113701,DCM,\"X-Ray Radiation Dose Report\")/CONTAINER (113811,DCM,\"CT Accumulated Dose Data\")/NUM (113813,DCM,\"CT Dose Length Product Total\")/NUM (220005,99PMP,\"CT Dose Length Product Sub-Total\")/CODE (113835,DCM,\"CTDIw Phantom Type\"): Content Item not in template\nIOD validation complete\n";
        DicomSRValidator dicomSRValidator = new DicomSRValidator();
        System.err.println("validate =\n" + dicomSRValidator.validate(attributeList));
        TestCTDose.assertEquals((String)"Checking validation from StructuredReport Document", (String)string12, (String)dicomSRValidator.validate(attributeList));
        String string13 = structuredReport.toString();
        CTDose cTDose2 = new CTDose(structuredReport);
        StructuredReport structuredReport2 = cTDose2.getStructuredReport(true);
        String string14 = structuredReport2.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR (from SR alone) as string", (String)string13, (String)string14);
        String string15 = attributeList.toString();
        AttributeList attributeList2 = cTDose2.getAttributeList();
        String string16 = attributeList.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR AttributeList (from SR alone) as string", (String)string15, (String)string16);
    }
}

