/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnlimitedTextAttribute;
import com.pixelmed.utils.HexDump;
import java.io.ByteArrayOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCharacterSetTextAttribute
extends TestCase {
    public TestCharacterSetTextAttribute(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCharacterSetTextAttribute");
        testSuite.addTest((Test)new TestCharacterSetTextAttribute("TestCharacterSetTextAttribute_AddValueAndWriteItDefaultEncoding"));
        testSuite.addTest((Test)new TestCharacterSetTextAttribute("TestCharacterSetTextAttribute_AddValueAndWriteIt"));
        testSuite.addTest((Test)new TestCharacterSetTextAttribute("TestCharacterSetTextAttribute_SetValueAndWriteIt"));
        testSuite.addTest((Test)new TestCharacterSetTextAttribute("TestCharacterSetTextAttribute_AddStringValueFromByteArrayAndWriteIt"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestCharacterSetTextAttribute_AddValueAndWriteItDefaultEncoding() throws Exception {
        String string = "Doe^Jane";
        UnlimitedTextAttribute unlimitedTextAttribute = new UnlimitedTextAttribute(TagFromName.TextValue);
        unlimitedTextAttribute.addValue(string);
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.addValue() default encoding string", (String)string, (String)unlimitedTextAttribute.getStringValues()[0]);
        byte[] byArray = string.getBytes("ASCII");
        int n = byArray.length;
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.getVL() correct for bytes as default encoding string", (long)n, (long)unlimitedTextAttribute.getVL());
        int n2 = n % 2 == 0 ? n : n + 1;
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.getVL() correct for bytes as default encoding string", (long)n2, (long)unlimitedTextAttribute.getPaddedVL());
        byte[] byArray2 = unlimitedTextAttribute.getByteValues();
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.getByteValues() bytes as default encoding", (String)HexDump.byteArrayToHexString(byArray), (String)HexDump.byteArrayToHexString(byArray2, 0, n));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream(byteArrayOutputStream, "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.1");
        unlimitedTextAttribute.write(dicomOutputStream);
        dicomOutputStream.close();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.write() bytes as default encoding", (String)HexDump.byteArrayToHexString(byArray), (String)HexDump.byteArrayToHexString(byArray3, 144, n));
    }

    public void TestCharacterSetTextAttribute_AddValueAndWriteIt() throws Exception {
        String string = "\u00c4neas^R\u00fcdiger";
        UnlimitedTextAttribute unlimitedTextAttribute = new UnlimitedTextAttribute(TagFromName.TextValue, new SpecificCharacterSet(new String[]{"ISO_IR 192"}));
        unlimitedTextAttribute.addValue(string);
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.addValue() UTF-8 string", (String)string, (String)unlimitedTextAttribute.getStringValues()[0]);
        byte[] byArray = string.getBytes("UTF8");
        int n = byArray.length;
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.getVL() correct for bytes as UTF-8 string", (long)n, (long)unlimitedTextAttribute.getVL());
        int n2 = n % 2 == 0 ? n : n + 1;
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.getVL() correct for bytes as UTF-8 string", (long)n2, (long)unlimitedTextAttribute.getPaddedVL());
        byte[] byArray2 = unlimitedTextAttribute.getByteValues();
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.getByteValues() bytes as UTF-8", (String)HexDump.byteArrayToHexString(byArray), (String)HexDump.byteArrayToHexString(byArray2, 0, n));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream(byteArrayOutputStream, "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.1");
        unlimitedTextAttribute.write(dicomOutputStream);
        dicomOutputStream.close();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.write() bytes as UTF-8", (String)HexDump.byteArrayToHexString(byArray), (String)HexDump.byteArrayToHexString(byArray3, 144, n));
    }

    public void TestCharacterSetTextAttribute_SetValueAndWriteIt() throws Exception {
        String string = "\u00c4neas^R\u00fcdiger";
        UnlimitedTextAttribute unlimitedTextAttribute = new UnlimitedTextAttribute(TagFromName.TextValue, new SpecificCharacterSet(new String[]{"ISO_IR 192"}));
        unlimitedTextAttribute.setValue(string);
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.setValue() UTF-8 string", (String)string, (String)unlimitedTextAttribute.getStringValues()[0]);
        byte[] byArray = string.getBytes("UTF8");
        int n = byArray.length;
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.getVL() correct for bytes as UTF-8 string", (long)n, (long)unlimitedTextAttribute.getVL());
        int n2 = n % 2 == 0 ? n : n + 1;
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.getVL() correct for bytes as UTF-8 string", (long)n2, (long)unlimitedTextAttribute.getPaddedVL());
        byte[] byArray2 = unlimitedTextAttribute.getByteValues();
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.getByteValues() bytes as UTF-8", (String)HexDump.byteArrayToHexString(byArray), (String)HexDump.byteArrayToHexString(byArray2, 0, n));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream(byteArrayOutputStream, "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.1");
        unlimitedTextAttribute.write(dicomOutputStream);
        dicomOutputStream.close();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.write() bytes as UTF-8", (String)HexDump.byteArrayToHexString(byArray), (String)HexDump.byteArrayToHexString(byArray3, 144, n));
    }

    public void TestCharacterSetTextAttribute_AddStringValueFromByteArrayAndWriteIt() throws Exception {
        byte[] byArray = new byte[]{97, 32, 61, 32, 57, 48, -17, -65, -67, 32, 40, 50, 55, 48, -17, -65, -67, 41};
        String string = new String(byArray, "UTF8");
        UnlimitedTextAttribute unlimitedTextAttribute = new UnlimitedTextAttribute(TagFromName.TextValue, new SpecificCharacterSet(new String[]{"ISO_IR 192"}));
        unlimitedTextAttribute.addValue(string);
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.addValue() UTF-8 string", (String)string, (String)unlimitedTextAttribute.getStringValues()[0]);
        int n = byArray.length;
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.getVL() correct for bytes as UTF-8 string", (long)n, (long)unlimitedTextAttribute.getVL());
        int n2 = n % 2 == 0 ? n : n + 1;
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.getVL() correct for bytes as UTF-8 string", (long)n2, (long)unlimitedTextAttribute.getPaddedVL());
        byte[] byArray2 = unlimitedTextAttribute.getByteValues();
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.getByteValues() bytes as UTF-8", (String)HexDump.byteArrayToHexString(byArray), (String)HexDump.byteArrayToHexString(byArray2, 0, n));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream(byteArrayOutputStream, "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.1");
        unlimitedTextAttribute.write(dicomOutputStream);
        dicomOutputStream.close();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.write() bytes as UTF-8", (String)HexDump.byteArrayToHexString(byArray), (String)HexDump.byteArrayToHexString(byArray3, 144, n));
    }

    public void TestCharacterSetTextAttribute_SetByteArrayValuesAndWriteIt() throws Exception {
        byte[] byArray = new byte[]{97, 32, 61, 32, 57, 48, -17, -65, -67, 32, 40, 50, 55, 48, -17, -65, -67, 41};
        UnlimitedTextAttribute unlimitedTextAttribute = new UnlimitedTextAttribute(TagFromName.TextValue, new SpecificCharacterSet(new String[]{"ISO_IR 192"}));
        unlimitedTextAttribute.setValues(byArray);
        int n = byArray.length;
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.getVL() correct for bytes as UTF-8 string", (long)n, (long)unlimitedTextAttribute.getVL());
        int n2 = n % 2 == 0 ? n : n + 1;
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.getVL() correct for bytes as UTF-8 string", (long)n2, (long)unlimitedTextAttribute.getPaddedVL());
        byte[] byArray2 = unlimitedTextAttribute.getByteValues();
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.getByteValues() bytes as UTF-8", (String)HexDump.byteArrayToHexString(byArray), (String)HexDump.byteArrayToHexString(byArray2, 0, n));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream(byteArrayOutputStream, "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.1");
        unlimitedTextAttribute.write(dicomOutputStream);
        dicomOutputStream.close();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        TestCharacterSetTextAttribute.assertEquals((String)"Checking TextAttribute.write() bytes as UTF-8", (String)HexDump.byteArrayToHexString(byArray), (String)HexDump.byteArrayToHexString(byArray3, 144, n));
    }
}

