/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.TagFromName;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDecimalStringAttributeLocaleEffect
extends TestCase {
    public TestDecimalStringAttributeLocaleEffect(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestDecimalStringAttributeLocaleEffect");
        testSuite.addTest((Test)new TestDecimalStringAttributeLocaleEffect("TestDecimalStringAttributeLocaleEffect_Double_DefaultLocale"));
        testSuite.addTest((Test)new TestDecimalStringAttributeLocaleEffect("TestDecimalStringAttributeLocaleEffect_Double_AllAvailableLocales"));
        testSuite.addTest((Test)new TestDecimalStringAttributeLocaleEffect("TestDecimalStringAttributeLocaleEffect_Float_DefaultLocale"));
        testSuite.addTest((Test)new TestDecimalStringAttributeLocaleEffect("TestDecimalStringAttributeLocaleEffect_Float_AllAvailableLocales"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestDecimalStringAttributeLocaleEffect_Double_DefaultLocale() throws Exception {
        double d = 39.76;
        double d2 = -56356.457457;
        double d3 = 0.0;
        double d4 = 7.45345345E-21;
        DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.ContourData);
        ((Attribute)decimalStringAttribute).addValue(d);
        ((Attribute)decimalStringAttribute).addValue(d2);
        ((Attribute)decimalStringAttribute).addValue(d3);
        ((Attribute)decimalStringAttribute).addValue(d4);
        double[] dArray = ((Attribute)decimalStringAttribute).getDoubleValues();
        TestDecimalStringAttributeLocaleEffect.assertEquals((String)"Default", (Object)d, (Object)dArray[0]);
        TestDecimalStringAttributeLocaleEffect.assertEquals((String)"Default", (Object)d2, (Object)dArray[1]);
        TestDecimalStringAttributeLocaleEffect.assertEquals((String)"Default", (Object)d3, (Object)dArray[2]);
        TestDecimalStringAttributeLocaleEffect.assertEquals((String)"Default", (Object)d4, (Object)dArray[3]);
    }

    public void TestDecimalStringAttributeLocaleEffect_Double_AllAvailableLocales() throws Exception {
        Locale[] localeArray;
        double d = 39.76;
        double d2 = -56356.457457;
        double d3 = 0.0;
        double d4 = 7.45345345E-21;
        for (Locale locale : localeArray = Locale.getAvailableLocales()) {
            Locale.setDefault(locale);
            DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.ContourData);
            ((Attribute)decimalStringAttribute).addValue(d);
            ((Attribute)decimalStringAttribute).addValue(d2);
            ((Attribute)decimalStringAttribute).addValue(d3);
            ((Attribute)decimalStringAttribute).addValue(d4);
            double[] dArray = ((Attribute)decimalStringAttribute).getDoubleValues();
            TestDecimalStringAttributeLocaleEffect.assertEquals((String)locale.toString(), (Object)d, (Object)dArray[0]);
            TestDecimalStringAttributeLocaleEffect.assertEquals((String)locale.toString(), (Object)d2, (Object)dArray[1]);
            TestDecimalStringAttributeLocaleEffect.assertEquals((String)locale.toString(), (Object)d3, (Object)dArray[2]);
            TestDecimalStringAttributeLocaleEffect.assertEquals((String)locale.toString(), (Object)d4, (Object)dArray[3]);
        }
    }

    public void TestDecimalStringAttributeLocaleEffect_Float_DefaultLocale() throws Exception {
        float f = 39.76f;
        float f2 = -56356.457f;
        float f3 = 0.0f;
        float f4 = 7.453453E-21f;
        DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.ContourData);
        ((Attribute)decimalStringAttribute).addValue(f);
        ((Attribute)decimalStringAttribute).addValue(f2);
        ((Attribute)decimalStringAttribute).addValue(f3);
        ((Attribute)decimalStringAttribute).addValue(f4);
        float[] fArray = ((Attribute)decimalStringAttribute).getFloatValues();
        TestDecimalStringAttributeLocaleEffect.assertEquals((String)"Default", (Object)Float.valueOf(f), (Object)Float.valueOf(fArray[0]));
        TestDecimalStringAttributeLocaleEffect.assertEquals((String)"Default", (Object)Float.valueOf(f2), (Object)Float.valueOf(fArray[1]));
        TestDecimalStringAttributeLocaleEffect.assertEquals((String)"Default", (Object)Float.valueOf(f3), (Object)Float.valueOf(fArray[2]));
        TestDecimalStringAttributeLocaleEffect.assertEquals((String)"Default", (Object)Float.valueOf(f4), (Object)Float.valueOf(fArray[3]));
    }

    public void TestDecimalStringAttributeLocaleEffect_Float_AllAvailableLocales() throws Exception {
        Locale[] localeArray;
        float f = 39.76f;
        float f2 = -56356.457f;
        float f3 = 0.0f;
        float f4 = 7.453453E-21f;
        for (Locale locale : localeArray = Locale.getAvailableLocales()) {
            Locale.setDefault(locale);
            DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.ContourData);
            ((Attribute)decimalStringAttribute).addValue(f);
            ((Attribute)decimalStringAttribute).addValue(f2);
            ((Attribute)decimalStringAttribute).addValue(f3);
            ((Attribute)decimalStringAttribute).addValue(f4);
            float[] fArray = ((Attribute)decimalStringAttribute).getFloatValues();
            TestDecimalStringAttributeLocaleEffect.assertEquals((String)locale.toString(), (Object)Float.valueOf(f), (Object)Float.valueOf(fArray[0]));
            TestDecimalStringAttributeLocaleEffect.assertEquals((String)locale.toString(), (Object)Float.valueOf(f2), (Object)Float.valueOf(fArray[1]));
            TestDecimalStringAttributeLocaleEffect.assertEquals((String)locale.toString(), (Object)Float.valueOf(f3), (Object)Float.valueOf(fArray[2]));
            TestDecimalStringAttributeLocaleEffect.assertEquals((String)locale.toString(), (Object)Float.valueOf(f4), (Object)Float.valueOf(fArray[3]));
        }
    }
}

