/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeFactory;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestDeidentify
extends TestCase {
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;
    private String xmlConfidentialityProfileDataElementsResourceName = "/com/pixelmed/dicom/confidentialityprofiledataelementsandhandling.xml";
    private static final byte[] dirtyByteArray = new byte[]{69, 71, 69, 71, 69, 71, 69, 71};
    private static final short[] dirtyShortArray = new short[]{17735, 17735, 17735, 17735};
    private static final AttributeTag curveDataTag = new AttributeTag(20480, 0);
    private static final AttributeTag overlayDataTag = new AttributeTag(24576, 12288);
    private static final AttributeTag graphicAnnotationSequence = TagFromName.GraphicAnnotationSequence;
    private static final AttributeTag acquisitionContextSequence = TagFromName.AcquisitionContextSequence;
    private static final AttributeTag contentSequence = TagFromName.ContentSequence;

    public TestDeidentify(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestDeidentify");
        testSuite.addTest((Test)new TestDeidentify("TestDeidentify_NoOptions_CurrentAnnexE"));
        testSuite.addTest((Test)new TestDeidentify("TestDeidentify_NoOptions_Aryanto2016"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private Document readDataElementHandlingFile() throws IOException, ParserConfigurationException, SAXException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(this.xmlConfidentialityProfileDataElementsResourceName);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(inputStream);
    }

    private Set<AttributeTag> getAttributeTagsOfDataElementsFromFile() throws IOException, ParserConfigurationException, SAXException {
        HashSet<AttributeTag> hashSet = new HashSet<AttributeTag>();
        Document document = this.readDataElementHandlingFile();
        Element element = document.getDocumentElement();
        if (element.getTagName().equals("DataElements")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !((Element)node).getTagName().equals("DataElement")) continue;
                String string = "";
                String string2 = "";
                String string3 = "";
                String string4 = "";
                Object object = node.getAttributes();
                if (object != null) {
                    Node node2 = object.getNamedItem("name");
                    if (node2 != null) {
                        string = node2.getTextContent();
                    }
                    if ((node2 = object.getNamedItem("group")) != null) {
                        string2 = node2.getTextContent();
                    }
                    if ((node2 = object.getNamedItem("element")) != null) {
                        string3 = node2.getTextContent();
                    }
                    if ((node2 = object.getNamedItem("action")) != null) {
                        string4 = node2.getTextContent();
                    }
                }
                if (string2.length() > 0 && string3.length() > 0 && !string.toLowerCase().trim().equals("private attributes")) {
                    object = new AttributeTag(Integer.parseInt(string2.replaceAll("[Xx]", "0"), 16), Integer.parseInt(string3.replaceAll("[Xx]", "0"), 16));
                    hashSet.add((AttributeTag)object);
                    continue;
                }
                System.err.println("Ignoring " + string);
            }
        }
        return hashSet;
    }

    private Set<AttributeTag> getAttributeTagsOfDataElementsFromAryanto2016Paper() {
        HashSet<AttributeTag> hashSet = new HashSet<AttributeTag>();
        hashSet.add(dictionary.getTagFromName("StudyDate"));
        hashSet.add(dictionary.getTagFromName("SeriesDate"));
        hashSet.add(dictionary.getTagFromName("AcquisitionDate"));
        hashSet.add(dictionary.getTagFromName("ContentDate"));
        hashSet.add(dictionary.getTagFromName("OverlayDate"));
        hashSet.add(dictionary.getTagFromName("CurveDate"));
        hashSet.add(dictionary.getTagFromName("AcquisitionDateTime"));
        hashSet.add(dictionary.getTagFromName("StudyTime"));
        hashSet.add(dictionary.getTagFromName("SeriesTime"));
        hashSet.add(dictionary.getTagFromName("AcquisitionTime"));
        hashSet.add(dictionary.getTagFromName("ContentTime"));
        hashSet.add(dictionary.getTagFromName("OverlayTime"));
        hashSet.add(dictionary.getTagFromName("CurveTime"));
        hashSet.add(dictionary.getTagFromName("AccessionNumber"));
        hashSet.add(dictionary.getTagFromName("InstitutionName"));
        hashSet.add(dictionary.getTagFromName("InstitutionAddress"));
        hashSet.add(dictionary.getTagFromName("ReferringPhysicianName"));
        hashSet.add(dictionary.getTagFromName("ReferringPhysicianAddress"));
        hashSet.add(dictionary.getTagFromName("ReferringPhysicianTelephoneNumbers"));
        hashSet.add(dictionary.getTagFromName("ReferringPhysicianIdentificationSequence"));
        hashSet.add(dictionary.getTagFromName("InstitutionalDepartmentName"));
        hashSet.add(dictionary.getTagFromName("PhysiciansOfRecord"));
        hashSet.add(dictionary.getTagFromName("PhysiciansOfRecordIdentificationSequence"));
        hashSet.add(dictionary.getTagFromName("PerformingPhysicianName"));
        hashSet.add(dictionary.getTagFromName("PerformingPhysicianIdentificationSequence"));
        hashSet.add(dictionary.getTagFromName("NameOfPhysiciansReadingStudy"));
        hashSet.add(dictionary.getTagFromName("PhysiciansReadingStudyIdentificationSequence"));
        hashSet.add(dictionary.getTagFromName("OperatorsName"));
        hashSet.add(dictionary.getTagFromName("PatientName"));
        hashSet.add(dictionary.getTagFromName("PatientID"));
        hashSet.add(dictionary.getTagFromName("IssuerOfPatientID"));
        hashSet.add(dictionary.getTagFromName("PatientBirthDate"));
        hashSet.add(dictionary.getTagFromName("PatientBirthTime"));
        hashSet.add(dictionary.getTagFromName("PatientSex"));
        hashSet.add(dictionary.getTagFromName("OtherPatientIDs"));
        hashSet.add(dictionary.getTagFromName("OtherPatientNames"));
        hashSet.add(dictionary.getTagFromName("PatientBirthName"));
        hashSet.add(dictionary.getTagFromName("PatientAge"));
        hashSet.add(dictionary.getTagFromName("PatientAddress"));
        hashSet.add(dictionary.getTagFromName("PatientMotherBirthName"));
        hashSet.add(dictionary.getTagFromName("CountryOfResidence"));
        hashSet.add(dictionary.getTagFromName("RegionOfResidence"));
        hashSet.add(dictionary.getTagFromName("PatientTelephoneNumbers"));
        hashSet.add(dictionary.getTagFromName("StudyID"));
        hashSet.add(dictionary.getTagFromName("CurrentPatientLocation"));
        hashSet.add(dictionary.getTagFromName("PatientInstitutionResidence"));
        hashSet.add(dictionary.getTagFromName("DateTime"));
        hashSet.add(dictionary.getTagFromName("Date"));
        hashSet.add(dictionary.getTagFromName("Time"));
        hashSet.add(dictionary.getTagFromName("PersonName"));
        return hashSet;
    }

    private void createAttributeAndValuesAppropiateForVRAndAddToList(AttributeTag attributeTag, AttributeList attributeList, Map<AttributeTag, String> map) throws DicomException {
        Attribute attribute = AttributeFactory.newAttribute(attributeTag);
        String string = "";
        String string2 = "";
        byte[] byArray = attribute.getVR();
        if (ValueRepresentation.isApplicationEntityVR(byArray)) {
            string = "DIRTY";
            string2 = "";
        } else if (ValueRepresentation.isAgeStringVR(byArray)) {
            string = "037Y";
            string2 = "";
        } else if (!ValueRepresentation.isAttributeTagVR(byArray)) {
            if (ValueRepresentation.isCodeStringVR(byArray)) {
                string = "DIRTY";
                string2 = "";
            } else if (ValueRepresentation.isDateVR(byArray)) {
                string = "20180927";
                string2 = "";
            } else if (ValueRepresentation.isDateTimeVR(byArray)) {
                string = "20180927180143";
                string2 = "";
            } else if (ValueRepresentation.isDecimalStringVR(byArray)) {
                string = "37.2";
                string2 = "";
            } else if (ValueRepresentation.isFloatDoubleVR(byArray)) {
                string = "37.2";
                string2 = "";
            } else if (ValueRepresentation.isFloatSingleVR(byArray)) {
                string = "37.2";
                string2 = "";
            } else if (ValueRepresentation.isIntegerStringVR(byArray)) {
                string = "37";
                string2 = "";
            } else if (ValueRepresentation.isLongStringVR(byArray)) {
                string = "DIRTY";
                string2 = "";
            } else if (ValueRepresentation.isLongTextVR(byArray)) {
                string = "DIRTY";
                string2 = "";
            } else if (ValueRepresentation.isOtherByteVR(byArray)) {
                attribute.setValues(dirtyByteArray);
            } else if (ValueRepresentation.isOtherDoubleVR(byArray)) {
                attribute.setValues(dirtyByteArray);
            } else if (ValueRepresentation.isOtherFloatVR(byArray)) {
                attribute.setValues(dirtyByteArray);
            } else if (ValueRepresentation.isOtherLongVR(byArray)) {
                attribute.setValues(dirtyByteArray);
            } else if (ValueRepresentation.isOtherWordVR(byArray)) {
                attribute.setValues(dirtyShortArray);
            } else if (ValueRepresentation.isOtherUnspecifiedVR(byArray)) {
                attribute.setValues(dirtyByteArray);
            } else if (ValueRepresentation.isPersonNameVR(byArray)) {
                string = "SMITH^HARRY";
                string2 = "";
            } else if (ValueRepresentation.isSequenceVR(byArray)) {
                AttributeList attributeList2 = new AttributeList();
                CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.ImageType);
                ((Attribute)codeStringAttribute).addValue("DIRTY");
                attributeList2.put(codeStringAttribute);
                ((SequenceAttribute)attribute).addItem(attributeList2);
            } else if (ValueRepresentation.isShortStringVR(byArray)) {
                string = "DIRTY";
                string2 = "";
            } else if (ValueRepresentation.isSignedLongVR(byArray)) {
                string = "37";
                string2 = "";
            } else if (ValueRepresentation.isSignedShortVR(byArray)) {
                string = "37";
                string2 = "";
            } else if (ValueRepresentation.isShortTextVR(byArray)) {
                string = "DIRTY";
                string2 = "";
            } else if (ValueRepresentation.isTimeVR(byArray)) {
                string = "180143";
                string2 = "";
            } else if (ValueRepresentation.isUniqueIdentifierVR(byArray)) {
                string = "1.2.3.4";
                string2 = "";
            } else if (ValueRepresentation.isUnsignedLongVR(byArray)) {
                string = "37";
                string2 = "";
            } else if (!ValueRepresentation.isUnknownVR(byArray)) {
                if (ValueRepresentation.isUnsignedShortVR(byArray)) {
                    string = "37";
                    string2 = "";
                } else if (ValueRepresentation.isUnspecifiedShortVR(byArray)) {
                    string = "37";
                    string2 = "";
                } else if (ValueRepresentation.isUnspecifiedShortOrOtherWordVR(byArray)) {
                    string = "37";
                    string2 = "";
                } else if (ValueRepresentation.isUniversalResourceVR(byArray)) {
                    string = "http://www.pixelmed.com/";
                    string2 = "";
                } else if (ValueRepresentation.isUnlimitedCharactersVR(byArray)) {
                    string = "DIRTY";
                    string2 = "";
                } else if (ValueRepresentation.isUnlimitedTextVR(byArray)) {
                    string = "DIRTY";
                    string2 = "";
                }
            }
        }
        if (string.length() > 0) {
            attribute.addValue(string);
        }
        if (attribute.getVL() == 0L) {
            System.err.println("No value for unsupported VR for " + attributeTag);
        }
        attributeList.put(attribute);
        map.put(attributeTag, string);
    }

    private void checkIsDeidentifiedproperly(AttributeList attributeList, Set<AttributeTag> set, Map<AttributeTag, String> map) {
        for (AttributeTag attributeTag : set) {
            Object object;
            if (attributeTag.equals(curveDataTag)) {
                System.err.println("Not checking curveDataTag " + attributeTag);
                continue;
            }
            if (attributeTag.equals(overlayDataTag)) {
                System.err.println("Not checking overlayDataTag " + attributeTag);
                continue;
            }
            if (attributeTag.equals(graphicAnnotationSequence)) {
                System.err.println("Not checking graphicAnnotationSequence " + attributeTag);
                continue;
            }
            if (attributeTag.equals(acquisitionContextSequence)) {
                System.err.println("Not checking acquisitionContextSequence " + attributeTag);
                continue;
            }
            if (attributeTag.equals(contentSequence)) {
                System.err.println("Not checking contentSequence " + attributeTag);
                continue;
            }
            byte[] byArray = dictionary.getValueRepresentationFromTag(attributeTag);
            if (byArray == null || ValueRepresentation.isUnknownVR(byArray) || ValueRepresentation.isOtherByteVR(byArray) || ValueRepresentation.isOtherDoubleVR(byArray) || ValueRepresentation.isOtherFloatVR(byArray) || ValueRepresentation.isOtherLongVR(byArray) || ValueRepresentation.isOtherWordVR(byArray) || ValueRepresentation.isOtherUnspecifiedVR(byArray)) {
                object = attributeList.get(attributeTag);
                TestDeidentify.assertTrue((String)("Checking attribute has been removed or is empty " + attributeTag + " VR " + (byArray == null ? "null" : ValueRepresentation.getAsString(byArray))), (object == null || ((Attribute)object).getVL() == 0L ? 1 : 0) != 0);
                continue;
            }
            if (ValueRepresentation.isSequenceVR(byArray)) {
                object = attributeList.get(attributeTag);
                TestDeidentify.assertTrue((String)("Checking sequence attribute has been removed or is empty " + attributeTag), (object == null || ((SequenceAttribute)object).getNumberOfItems() == 0 ? 1 : 0) != 0);
                continue;
            }
            object = Attribute.getSingleStringValueOrEmptyString(attributeList, attributeTag);
            String string = map.get(attributeTag);
            TestDeidentify.assertTrue((String)("Checking is different value for " + attributeTag), (!((String)object).equals(string) ? 1 : 0) != 0);
        }
    }

    public void TestDeidentify_NoOptions_CurrentAnnexE() throws Exception {
        Set<AttributeTag> set = this.getAttributeTagsOfDataElementsFromFile();
        AttributeList attributeList = new AttributeList();
        HashMap<AttributeTag, String> hashMap = new HashMap<AttributeTag, String>();
        for (AttributeTag attributeTag : set) {
            this.createAttributeAndValuesAppropiateForVRAndAddToList(attributeTag, attributeList, hashMap);
        }
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 1, false, false, false, false, false, false, 1, null, null);
        ClinicalTrialsAttributes.removeClinicalTrialsAttributes(attributeList);
        this.checkIsDeidentifiedproperly(attributeList, set, hashMap);
    }

    public void TestDeidentify_NoOptions_Aryanto2016() throws Exception {
        Set<AttributeTag> set = this.getAttributeTagsOfDataElementsFromAryanto2016Paper();
        AttributeList attributeList = new AttributeList();
        HashMap<AttributeTag, String> hashMap = new HashMap<AttributeTag, String>();
        for (AttributeTag attributeTag : set) {
            this.createAttributeAndValuesAppropiateForVRAndAddToList(attributeTag, attributeList, hashMap);
        }
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 1, false, false, false, false, false, false, 1, null, null);
        this.checkIsDeidentifiedproperly(attributeList, set, hashMap);
    }
}

