/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomDirectoryRecord;
import com.pixelmed.dicom.DicomDirectoryRecordFactory;
import com.pixelmed.dicom.TagFromName;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDicomDirectoryRecordFactory
extends TestCase {
    public TestDicomDirectoryRecordFactory(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestDicomDirectoryRecordFactory");
        testSuite.addTest((Test)new TestDicomDirectoryRecordFactory("TestDicomDirectoryRecordFactory_MissingDirectoryRecordType"));
        testSuite.addTest((Test)new TestDicomDirectoryRecordFactory("TestDicomDirectoryRecordFactory_ZeroLengthDirectoryRecordType"));
        testSuite.addTest((Test)new TestDicomDirectoryRecordFactory("TestDicomDirectoryRecordFactory_UnrecognizableDirectoryRecordType"));
        testSuite.addTest((Test)new TestDicomDirectoryRecordFactory("TestDicomDirectoryRecordFactory_PatientDirectoryRecordType"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestDicomDirectoryRecordFactory_MissingDirectoryRecordType() throws Exception {
        AttributeList attributeList = new AttributeList();
        DicomDirectoryRecordFactory dicomDirectoryRecordFactory = new DicomDirectoryRecordFactory();
        DicomDirectoryRecord dicomDirectoryRecord = dicomDirectoryRecordFactory.getNewDicomDirectoryRecord(null, attributeList);
        TestDicomDirectoryRecordFactory.assertTrue((String)"DirectoryRecordType is Unrecognized", (boolean)(dicomDirectoryRecord instanceof DicomDirectoryRecordFactory.UnrecognizedDirectoryRecord));
    }

    public void TestDicomDirectoryRecordFactory_ZeroLengthDirectoryRecordType() throws Exception {
        String string = "  ";
        AttributeList attributeList = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.DirectoryRecordType);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        TestDicomDirectoryRecordFactory.assertTrue((String)"DirectoryRecordType is not zero length in originalStringValues in Attribute", (attributeList.get(TagFromName.DirectoryRecordType).getOriginalStringValues()[0].length() > 0 ? 1 : 0) != 0);
        TestDicomDirectoryRecordFactory.assertTrue((String)"DirectoryRecordType is zero length in getSingleStringValue in Attribute", (Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.DirectoryRecordType).length() == 0 ? 1 : 0) != 0);
        object = new DicomDirectoryRecordFactory();
        DicomDirectoryRecord dicomDirectoryRecord = ((DicomDirectoryRecordFactory)object).getNewDicomDirectoryRecord(null, attributeList);
        TestDicomDirectoryRecordFactory.assertTrue((String)"DirectoryRecordType is Unrecognized", (boolean)(dicomDirectoryRecord instanceof DicomDirectoryRecordFactory.UnrecognizedDirectoryRecord));
    }

    public void TestDicomDirectoryRecordFactory_UnrecognizableDirectoryRecordType() throws Exception {
        String string = "KASUFDGYUWQERF";
        AttributeList attributeList = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.DirectoryRecordType);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new DicomDirectoryRecordFactory();
        DicomDirectoryRecord dicomDirectoryRecord = ((DicomDirectoryRecordFactory)object).getNewDicomDirectoryRecord(null, attributeList);
        TestDicomDirectoryRecordFactory.assertTrue((String)"DirectoryRecordType is Unrecognized", (boolean)(dicomDirectoryRecord instanceof DicomDirectoryRecordFactory.UnrecognizedDirectoryRecord));
    }

    public void TestDicomDirectoryRecordFactory_PatientDirectoryRecordType() throws Exception {
        String string = "PATIENT";
        AttributeList attributeList = new AttributeList();
        Object object = new CodeStringAttribute(TagFromName.DirectoryRecordType);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = new DicomDirectoryRecordFactory();
        DicomDirectoryRecord dicomDirectoryRecord = ((DicomDirectoryRecordFactory)object).getNewDicomDirectoryRecord(null, attributeList);
        TestDicomDirectoryRecordFactory.assertTrue((String)"DirectoryRecordType is Patient", (boolean)(dicomDirectoryRecord instanceof DicomDirectoryRecordFactory.PatientDirectoryRecord));
    }

    public void TestDicomDirectoryRecordFactory_StudyRecord() throws Exception {
    }
}

