/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestHierarchicalFileName
extends TestCase {
    private static final String patientID = "1234";
    private static final String patientName = "Name^Me";
    private static final String studyDate = "19750304";
    private static final String studyTime = "111111";
    private static final String studyID = "5678";
    private static final String studyDescription = "Pretty study";
    private static final String seriesNumber = "32";
    private static final String modality = "MR";
    private static final String seriesDescription = "Nice series";
    private static final String sopInstanceUID = "1.2.3.4";

    public TestHierarchicalFileName(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestHierarchicalFileName");
        testSuite.addTest((Test)new TestHierarchicalFileName("TestHierarchicalFileName_Default"));
        testSuite.addTest((Test)new TestHierarchicalFileName("TestHierarchicalFileName_DefaultNoSOPInstanceUID"));
        testSuite.addTest((Test)new TestHierarchicalFileName("TestHierarchicalFileName_DefaultSpecialCharactersNotRemovedFromUID"));
        testSuite.addTest((Test)new TestHierarchicalFileName("TestHierarchicalFileName_SpecialCharactersRemovedFromUID"));
        testSuite.addTest((Test)new TestHierarchicalFileName("TestHierarchicalFileName_InstanceNumber_Strategy"));
        testSuite.addTest((Test)new TestHierarchicalFileName("TestHierarchicalFileName_NoInstanceNumberFallBackSOPInstanceUID_Strategy"));
        testSuite.addTest((Test)new TestHierarchicalFileName("TestHierarchicalFileName_InstanceNumber_Override"));
        testSuite.addTest((Test)new TestHierarchicalFileName("TestHierarchicalFileName_NoInstanceNumberFallBackSOPInstanceUID_Override"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private AttributeList createattributeList() throws DicomException {
        AttributeList attributeList = new AttributeList();
        StringAttribute stringAttribute = new ShortStringAttribute(TagFromName.PatientID);
        ((Attribute)stringAttribute).addValue(patientID);
        attributeList.put(stringAttribute);
        stringAttribute = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)stringAttribute).addValue(patientName);
        attributeList.put(stringAttribute);
        stringAttribute = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)stringAttribute).addValue(studyDate);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)stringAttribute).addValue(studyTime);
        attributeList.put(stringAttribute);
        stringAttribute = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)stringAttribute).addValue(studyID);
        attributeList.put(stringAttribute);
        stringAttribute = new LongStringAttribute(TagFromName.StudyDescription);
        ((Attribute)stringAttribute).addValue(studyDescription);
        attributeList.put(stringAttribute);
        stringAttribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)stringAttribute).addValue(seriesNumber);
        attributeList.put(stringAttribute);
        stringAttribute = new CodeStringAttribute(TagFromName.Modality);
        ((Attribute)stringAttribute).addValue(modality);
        attributeList.put(stringAttribute);
        stringAttribute = new LongStringAttribute(TagFromName.SeriesDescription);
        ((Attribute)stringAttribute).addValue(seriesDescription);
        attributeList.put(stringAttribute);
        stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)stringAttribute).addValue(sopInstanceUID);
        attributeList.put(stringAttribute);
        return attributeList;
    }

    public void TestHierarchicalFileName_Default() throws Exception {
        AttributeList attributeList = this.createattributeList();
        String string = "Name^Me [1234]/19750304 111111 [5678 - Pretty study]/Series 032 [MR - Nice series]/1.2.3.4.dcm";
        String string2 = MoveDicomFilesIntoHierarchy.makeHierarchicalPathFromAttributes(attributeList);
        TestHierarchicalFileName.assertEquals((String)"Checking pathName", (String)string, (String)string2);
    }

    public void TestHierarchicalFileName_DefaultNoSOPInstanceUID() throws Exception {
        AttributeList attributeList = this.createattributeList();
        attributeList.remove(TagFromName.SOPInstanceUID);
        String string = "";
        String string2 = MoveDicomFilesIntoHierarchy.makeHierarchicalPathFromAttributes(attributeList);
        TestHierarchicalFileName.assertEquals((String)"Checking pathName", (String)string, (String)string2);
    }

    public void TestHierarchicalFileName_DefaultSpecialCharactersNotRemovedFromUID() throws Exception {
        AttributeList attributeList = new AttributeList();
        Object object = new ShortStringAttribute(TagFromName.PatientID);
        ((Attribute)object).addValue(".+^/1234@#$%");
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(".+/Name^Me@#$%");
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object).addValue(".+/^19750304@#$%");
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)object).addValue("+/^111111@#$%");
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(".+/^5678@#$%");
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.StudyDescription);
        ((Attribute)object).addValue(".+/^Pretty study@#$%");
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(".+/^32@#$%");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Modality);
        ((Attribute)object).addValue(".+/^MR@#$%");
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.SeriesDescription);
        ((Attribute)object).addValue(".+/^Nice series@#$%");
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue("+/^1.2.3.4@#$%");
        attributeList.put((Attribute)object);
        object = "__Name^Me [1234]/19750304 111111 [5678 - Pretty study]/Series 032 [MR - Nice series]/+/^1.2.3.4@#$%.dcm";
        String string = MoveDicomFilesIntoHierarchy.makeHierarchicalPathFromAttributes(attributeList);
        TestHierarchicalFileName.assertEquals((String)"Checking pathName", (String)object, (String)string);
    }

    public void TestHierarchicalFileName_SpecialCharactersRemovedFromUID() throws Exception {
        AttributeList attributeList = new AttributeList();
        Object object = new ShortStringAttribute(TagFromName.PatientID);
        ((Attribute)object).addValue(".+^/1234@#$%");
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(".+/Name^Me@#$%");
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)object).addValue(".+/^19750304@#$%");
        attributeList.put((Attribute)object);
        object = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)object).addValue("+/^111111@#$%");
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(".+/^5678@#$%");
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.StudyDescription);
        ((Attribute)object).addValue(".+/^Pretty study@#$%");
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(".+/^32@#$%");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Modality);
        ((Attribute)object).addValue(".+/^MR@#$%");
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.SeriesDescription);
        ((Attribute)object).addValue(".+/^Nice series@#$%");
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue("+/^1.2.3.4@#$%");
        attributeList.put((Attribute)object);
        object = "__Name^Me [1234]/19750304 111111 [5678 - Pretty study]/Series 032 [MR - Nice series]/1.2.3.4.dcm";
        String string = new MoveDicomFilesIntoHierarchy().makeHierarchicalPathFromAttributes(attributeList, 0);
        TestHierarchicalFileName.assertEquals((String)"Checking pathName", (String)object, (String)string);
    }

    public void TestHierarchicalFileName_InstanceNumber_Strategy() throws Exception {
        String string = "41";
        AttributeList attributeList = this.createattributeList();
        Object object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(".+/^" + string);
        attributeList.put((Attribute)object);
        object = "Name^Me [1234]/19750304 111111 [5678 - Pretty study]/Series 032 [MR - Nice series]/0000" + string + ".dcm";
        String string2 = new MoveDicomFilesIntoHierarchy().makeHierarchicalPathFromAttributes(attributeList, 1);
        TestHierarchicalFileName.assertEquals((String)"Checking pathName", (String)object, (String)string2);
    }

    public void TestHierarchicalFileName_NoInstanceNumberFallBackSOPInstanceUID_Strategy() throws Exception {
        AttributeList attributeList = this.createattributeList();
        String string = "Name^Me [1234]/19750304 111111 [5678 - Pretty study]/Series 032 [MR - Nice series]/1.2.3.4.dcm";
        String string2 = new MoveDicomFilesIntoHierarchy().makeHierarchicalPathFromAttributes(attributeList, 1);
        TestHierarchicalFileName.assertEquals((String)"Checking pathName", (String)string, (String)string2);
    }

    public void TestHierarchicalFileName_InstanceNumber_Override() throws Exception {
        String string = "41";
        AttributeList attributeList = this.createattributeList();
        Object object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(".+/^" + string);
        attributeList.put((Attribute)object);
        object = "Name^Me [1234]/19750304 111111 [5678 - Pretty study]/Series 032 [MR - Nice series]/0" + string + ".dcm";
        String string2 = new InstanceNumberMoveDicomFilesIntoHierarchy().makeHierarchicalPathFromAttributes(attributeList, 0);
        TestHierarchicalFileName.assertEquals((String)"Checking pathName", (String)object, (String)string2);
    }

    public void TestHierarchicalFileName_NoInstanceNumberFallBackSOPInstanceUID_Override() throws Exception {
        AttributeList attributeList = this.createattributeList();
        String string = "Name^Me [1234]/19750304 111111 [5678 - Pretty study]/Series 032 [MR - Nice series]/1.2.3.4.dcm";
        String string2 = new InstanceNumberMoveDicomFilesIntoHierarchy().makeHierarchicalPathFromAttributes(attributeList, 0);
        TestHierarchicalFileName.assertEquals((String)"Checking pathName", (String)string, (String)string2);
    }

    protected class InstanceNumberMoveDicomFilesIntoHierarchy
    extends MoveDicomFilesIntoHierarchy {
        protected InstanceNumberMoveDicomFilesIntoHierarchy() {
        }

        @Override
        public String makeInstanceLabelFromAttributes(AttributeList attributeList, int n) {
            String string = "";
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InstanceNumber).replaceAll("[^0-9]", "").trim();
            if (string2.length() > 0) {
                while (string2.length() < 3) {
                    string2 = "0" + string2;
                }
                string = string2 + ".dcm";
            }
            if (string.length() == 0) {
                string = super.makeInstanceLabelFromAttributes(attributeList, 0);
            }
            return string;
        }
    }
}

