/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.ShortTextAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnlimitedCharactersAttribute;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRepairAttributeValues
extends TestCase {
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;
    private static String longerThan1024 = "It was the best of times,\nit was the worst of times,\nit was the age of wisdom,\nit was the age of foolishness,\nit was the epoch of belief,\nit was the epoch of incredulity,\nit was the season of Light,\nit was the season of Darkness,\nit was the spring of hope,\nit was the winter of despair,\nwe had everything before us,\nwe had nothing before us,\nwe were all going direct to Heaven,\nwe were all going direct the other way--\nin short, the period was so far like the present period, that some of its noisiest authorities insisted on its being received, for good or for evil, in the superlative degree of comparison only.\n\nThere were a king with a large jaw and a queen with a plain face, on the throne of England; there were a king with a large jaw and a queen with a fair face, on the throne of France. In both countries it was clearer than crystal to the lords of the State preserves of loaves and fishes, that things in general were settled for ever.\n\nIt was the year of Our Lord one thousand seven hundred and seventy-five. Spiritual revelations were conceded to England at that favoured period, as at this. Mrs. Southcott had recently attained her five-and-twentieth blessed birthday, of whom a prophetic private in the Life Guards had heralded the sublime appearance by announcing that arrangements were made for the swallowing up of London and Westminster. Even the Cock-lane ghost had been laid only a round dozen of years, after rapping out its messages, as the spirits of this very year last past (supernaturally deficient in originality) rapped out theirs. Mere messages in the earthly order of events had lately come to the English Crown and People, from a congress of British subjects in America: which, strange to relate, have proved more important to the human race than any communications yet received through any of the chickens of the Cock-lane brood.\n";

    public TestRepairAttributeValues(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestRepairAttributeValues");
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_CodeString_Good"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_CodeString_Trim"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_CodeString_TooLong"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_CodeString_ControlCharacter"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_CodeString_EmbeddedBadCharacter"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_ShortString_Good"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_ShortString_Trim"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_ShortString_TooLong"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_ShortString_ControlCharacter"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_ShortString_EmbeddedBackslash"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_LongString_Good"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_LongString_Trim"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_LongString_TooLong"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_LongString_ControlCharacter"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_LongString_EmbeddedBackslash"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_ShortText_Good"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_ShortText_Trim"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_ShortText_TooLong"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_DecimalString_EmbeddedBadCharacter"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_IntegerString_Good"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_IntegerString_Trim"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_IntegerString_TooLong"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_IntegerString_TooLargeAnIntegerValue"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_IntegerString_TooSmallAnIntegerValue"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_IntegerString_ControlCharacter"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_IntegerString_EmbeddedBadCharacter"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_UniqueIdentifier_Good"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_UniqueIdentifier_Trim"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_UniqueIdentifier_TooLong"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_UniqueIdentifier_BadTrailingSpace"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_UniqueIdentifier_EmbeddedBadCharacter"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_AgeString_GoodYear"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_AgeString_GoodMonth"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_AgeString_GoodWeek"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_AgeString_GoodDay"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_AgeString_BadUnit"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_AgeString_TooShort"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_AgeString_TooLong"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_Date_Good"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_Date_TooShort"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_Date_TooLong"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_Date_BadPeriods"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_Date_BadSlashes"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_DateTime_GoodWithTimezoneAndFullFraction"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_DateTime_GoodWithNoTimezoneAndNoFraction"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_DateTime_TooLong"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_DateTime_EmbeddedBadCharacter"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_Time_Good"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_Time_TooShort"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_Time_TooLong"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_Time_BadColons"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_UnlimitedCharacters_Good"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_UnlimitedCharacters_Trim"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_UnlimitedCharacters_ControlCharacter"));
        testSuite.addTest((Test)new TestRepairAttributeValues("TestRepairAttributeValues_UnlimitedCharacters_EmbeddedBackslash"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestRepairAttributeValues_CodeString_Good() throws Exception {
        int n;
        String string = "ORIGINAL";
        String string2 = "ORIGINAL";
        CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.ImageType);
        for (n = 0; n < 3; ++n) {
            ((Attribute)codeStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)codeStringAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)codeStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)codeStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_CodeString_Trim() throws Exception {
        int n;
        String string = "         ORIGINAL            ";
        String string2 = "ORIGINAL";
        CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.ImageType);
        for (n = 0; n < 3; ++n) {
            ((Attribute)codeStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)codeStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)codeStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)codeStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_CodeString_TooLong() throws Exception {
        int n;
        String string = "REALLY_REALLY ORIGINAL";
        String string2 = "REALLY_REALLY ORIGINAL";
        CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.ImageType);
        for (n = 0; n < 3; ++n) {
            ((Attribute)codeStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)codeStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)codeStringAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is still not valid", (!((Attribute)codeStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)codeStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)codeStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_CodeString_ControlCharacter() throws Exception {
        int n;
        String string = "ORIGINAL\nTOO";
        String string2 = "ORIGINAL\nTOO";
        CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.ImageType);
        for (n = 0; n < 3; ++n) {
            ((Attribute)codeStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is invalid", (!((Attribute)codeStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)codeStringAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is still not valid", (!((Attribute)codeStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)codeStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)codeStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_CodeString_EmbeddedBadCharacter() throws Exception {
        int n;
        String string = "ORIGINAL-TOO";
        String string2 = "ORIGINAL-TOO";
        CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.ImageType);
        for (n = 0; n < 3; ++n) {
            ((Attribute)codeStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is invalid", (!((Attribute)codeStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)codeStringAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is still not valid", (!((Attribute)codeStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)codeStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)codeStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_ShortString_Good() throws Exception {
        int n;
        String string = "Hello, world.";
        String string2 = "Hello, world.";
        ShortStringAttribute shortStringAttribute = new ShortStringAttribute(TagFromName.StudyID);
        for (n = 0; n < 3; ++n) {
            ((Attribute)shortStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)shortStringAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)shortStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)shortStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_ShortString_Trim() throws Exception {
        int n;
        String string = "         Hello, world.            ";
        String string2 = "Hello, world.";
        ShortStringAttribute shortStringAttribute = new ShortStringAttribute(TagFromName.StudyID);
        for (n = 0; n < 3; ++n) {
            ((Attribute)shortStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)shortStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)shortStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)shortStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_ShortString_TooLong() throws Exception {
        int n;
        String string = "It was the best of times, it was the worst of times, it was the age of wisdom, it was the age of foolishness, it was the epoch of belief, it was the epoch of incredulity, it was the season of Light, it was the season of Darkness, it was the spring of hope, it was the winter of despair, we had everything before us, we had nothing before us, we were all going direct to Heaven, we were all going direct the other way";
        String string2 = "It was the best";
        ShortStringAttribute shortStringAttribute = new ShortStringAttribute(TagFromName.StudyID);
        for (n = 0; n < 3; ++n) {
            ((Attribute)shortStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)shortStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)shortStringAttribute).repairValues());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)shortStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)shortStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_ShortString_ControlCharacter() throws Exception {
        int n;
        String string = "Hello,\nworld.";
        String string2 = "Hello, world.";
        ShortStringAttribute shortStringAttribute = new ShortStringAttribute(TagFromName.ImageType);
        for (n = 0; n < 3; ++n) {
            ((Attribute)shortStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is invalid", (!((Attribute)shortStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)shortStringAttribute).repairValues());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)shortStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)shortStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_ShortString_EmbeddedBackslash() throws Exception {
        int n;
        String string = "Hello,\\world.";
        String string2 = "Hello, world.";
        ShortStringAttribute shortStringAttribute = new ShortStringAttribute(TagFromName.ImageType);
        for (n = 0; n < 3; ++n) {
            ((Attribute)shortStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is invalid", (!((Attribute)shortStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)shortStringAttribute).repairValues());
        TestRepairAttributeValues.assertTrue((String)"Is valid after repair", (boolean)((Attribute)shortStringAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)shortStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)shortStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_LongString_Good() throws Exception {
        int n;
        String string = "It was the best of times, it was the worst of times, it was the ";
        String string2 = "It was the best of times, it was the worst of times, it was the";
        LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.StudyDescription);
        for (n = 0; n < 3; ++n) {
            ((Attribute)longStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)longStringAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)longStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)longStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_LongString_Trim() throws Exception {
        int n;
        String string = "         It was the best of times, it was the worst of times, it was the            ";
        String string2 = "It was the best of times, it was the worst of times, it was the";
        LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.StudyDescription);
        for (n = 0; n < 3; ++n) {
            ((Attribute)longStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Too long", (!((StringAttribute)longStringAttribute).areLengthsOfValuesValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Valid characters", (boolean)((StringAttribute)longStringAttribute).areCharactersInValuesValid());
        TestRepairAttributeValues.assertTrue((String)"Well formed", (boolean)((StringAttribute)longStringAttribute).areValuesWellFormed());
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)longStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)longStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)longStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_LongString_TooLong() throws Exception {
        int n;
        String string = "It was the best of times, it was the worst of times, it was the age of wisdom, it was the age of foolishness, it was the epoch of belief, it was the epoch of incredulity, it was the season of Light, it was the season of Darkness, it was the spring of hope, it was the winter of despair, we had everything before us, we had nothing before us, we were all going direct to Heaven, we were all going direct the other way";
        String string2 = "It was the best of times, it was the worst of times, it was the";
        LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.StudyDescription);
        for (n = 0; n < 3; ++n) {
            ((Attribute)longStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)longStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)longStringAttribute).repairValues());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)longStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)longStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_LongString_ControlCharacter() throws Exception {
        int n;
        String string = "Hello,\nworld.";
        String string2 = "Hello, world.";
        LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.ImageType);
        for (n = 0; n < 3; ++n) {
            ((Attribute)longStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is invalid", (!((Attribute)longStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)longStringAttribute).repairValues());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)longStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)longStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_LongString_EmbeddedBackslash() throws Exception {
        int n;
        String string = "Hello,\\world.";
        String string2 = "Hello, world.";
        LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.ImageType);
        for (n = 0; n < 3; ++n) {
            ((Attribute)longStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is invalid", (!((Attribute)longStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)longStringAttribute).repairValues());
        TestRepairAttributeValues.assertTrue((String)"Is valid after repair", (boolean)((Attribute)longStringAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)longStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)longStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_ShortText_Good() throws Exception {
        String string;
        String string2 = string = longerThan1024.substring(0, 1024);
        ShortTextAttribute shortTextAttribute = new ShortTextAttribute(dictionary.getTagFromName("ReasonForStudy"));
        ((Attribute)shortTextAttribute).addValue(string);
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)shortTextAttribute).isValid());
        TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)shortTextAttribute.getStringValues()[0]);
    }

    public void TestRepairAttributeValues_ShortText_Trim() throws Exception {
        String string = "         " + longerThan1024.substring(0, 1024) + "            ";
        ShortTextAttribute shortTextAttribute = new ShortTextAttribute(dictionary.getTagFromName("ReasonForStudy"));
        ((Attribute)shortTextAttribute).addValue(string);
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)shortTextAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)shortTextAttribute.getStringValues()[0]);
    }

    public void TestRepairAttributeValues_ShortText_TooLong() throws Exception {
        String string = longerThan1024;
        String string2 = longerThan1024.substring(0, 1024).trim();
        ShortTextAttribute shortTextAttribute = new ShortTextAttribute(dictionary.getTagFromName("ReasonForStudy"));
        ((Attribute)shortTextAttribute).addValue(string);
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)shortTextAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)shortTextAttribute).repairValues());
        TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)shortTextAttribute.getStringValues()[0]);
    }

    public void TestRepairAttributeValues_DecimalString_Good() throws Exception {
        int n;
        String string = "-23456.890123456";
        String string2 = "-23456.890123456";
        DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.ImagePositionPatient);
        for (n = 0; n < 3; ++n) {
            ((Attribute)decimalStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)decimalStringAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)decimalStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)decimalStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_DecimalString_Trim() throws Exception {
        int n;
        String string = "         -23456.890123456            ";
        String string2 = "-23456.890123456";
        DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.ImagePositionPatient);
        for (n = 0; n < 3; ++n) {
            ((Attribute)decimalStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)decimalStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)decimalStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)decimalStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_DecimalString_TooLong() throws Exception {
        int n;
        String string = "-23456.8901234567";
        String string2 = "-23456.890123457";
        DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.ImagePositionPatient);
        for (n = 0; n < 3; ++n) {
            ((Attribute)decimalStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)decimalStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)decimalStringAttribute).repairValues());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)decimalStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)decimalStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_DecimalString_ControlCharacter() throws Exception {
        int n;
        String string = "-23456.89012345\n";
        String string2 = "-23456.89012345";
        DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.ImagePositionPatient);
        for (n = 0; n < 3; ++n) {
            ((Attribute)decimalStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is invalid", (!((Attribute)decimalStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)decimalStringAttribute).repairValues());
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)decimalStringAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)decimalStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)decimalStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_DecimalString_EmbeddedBadCharacter() throws Exception {
        int n;
        String string = "-23456.8X0123456";
        String string2 = "-23456.8X0123456";
        DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.ImagePositionPatient);
        for (n = 0; n < 3; ++n) {
            ((Attribute)decimalStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is invalid", (!((Attribute)decimalStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)decimalStringAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is still not valid", (!((Attribute)decimalStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)decimalStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)decimalStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_IntegerString_Good() throws Exception {
        int n;
        String string = "-2147483648";
        String string2 = "-2147483648";
        IntegerStringAttribute integerStringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
        for (n = 0; n < 3; ++n) {
            ((Attribute)integerStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)integerStringAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)integerStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)integerStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_IntegerString_Trim() throws Exception {
        int n;
        String string = "         -2147483648            ";
        String string2 = "-2147483648";
        IntegerStringAttribute integerStringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
        for (n = 0; n < 3; ++n) {
            ((Attribute)integerStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)integerStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)integerStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)integerStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_IntegerString_TooLong() throws Exception {
        int n;
        String string = "-9223372036854775808";
        String string2 = "-9223372036854775808";
        IntegerStringAttribute integerStringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
        for (n = 0; n < 3; ++n) {
            ((Attribute)integerStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)integerStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)integerStringAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)integerStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)integerStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)integerStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_IntegerString_TooLargeAnIntegerValue() throws Exception {
        int n;
        String string = "4294967295";
        String string2 = "4294967295";
        IntegerStringAttribute integerStringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
        for (n = 0; n < 3; ++n) {
            ((Attribute)integerStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)integerStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)integerStringAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)integerStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)integerStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)integerStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_IntegerString_TooSmallAnIntegerValue() throws Exception {
        int n;
        String string = "-2147483649";
        String string2 = "-2147483649";
        IntegerStringAttribute integerStringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
        for (n = 0; n < 3; ++n) {
            ((Attribute)integerStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)integerStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)integerStringAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)integerStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)integerStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)integerStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_IntegerString_ControlCharacter() throws Exception {
        int n;
        String string = "-2147483648\n";
        String string2 = "-2147483648";
        IntegerStringAttribute integerStringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
        for (n = 0; n < 3; ++n) {
            ((Attribute)integerStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is invalid", (!((Attribute)integerStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)integerStringAttribute).repairValues());
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)integerStringAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)integerStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)integerStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_IntegerString_EmbeddedBadCharacter() throws Exception {
        int n;
        String string = "-214748X3648";
        String string2 = "-214748X3648";
        IntegerStringAttribute integerStringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
        for (n = 0; n < 3; ++n) {
            ((Attribute)integerStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is invalid", (!((Attribute)integerStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)integerStringAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is still not valid", (!((Attribute)integerStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)integerStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)integerStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_UniqueIdentifier_Good() throws Exception {
        int n;
        String string = "123456789.123456789.123456789.123456789.123456789.123456789.1234";
        String string2 = "123456789.123456789.123456789.123456789.123456789.123456789.1234";
        UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        for (n = 0; n < 3; ++n) {
            ((Attribute)uniqueIdentifierAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)uniqueIdentifierAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)uniqueIdentifierAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)uniqueIdentifierAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_UniqueIdentifier_Trim() throws Exception {
        int n;
        String string = "         123456789.123456789.123456789.123456789.123456789.123456789.1234            ";
        String string2 = "123456789.123456789.123456789.123456789.123456789.123456789.1234";
        UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        for (n = 0; n < 3; ++n) {
            ((Attribute)uniqueIdentifierAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)uniqueIdentifierAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)uniqueIdentifierAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)uniqueIdentifierAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_UniqueIdentifier_TooLong() throws Exception {
        int n;
        String string = "123456789.123456789.123456789.123456789.123456789.123456789.12345";
        String string2 = "123456789.123456789.123456789.123456789.123456789.123456789.12345";
        UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        for (n = 0; n < 3; ++n) {
            ((Attribute)uniqueIdentifierAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)uniqueIdentifierAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)uniqueIdentifierAttribute).repairValues() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)uniqueIdentifierAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)uniqueIdentifierAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_UniqueIdentifier_BadTrailingSpace() throws Exception {
        int n;
        String string = "123456789.123456789.123456789.123456789.123456789.123456789.123 ";
        String string2 = "123456789.123456789.123456789.123456789.123456789.123456789.123";
        UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        for (n = 0; n < 3; ++n) {
            ((Attribute)uniqueIdentifierAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)uniqueIdentifierAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)uniqueIdentifierAttribute).repairValues());
        TestRepairAttributeValues.assertTrue((String)"Is valid after repair", (boolean)((Attribute)uniqueIdentifierAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)uniqueIdentifierAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)uniqueIdentifierAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_UniqueIdentifier_EmbeddedBadCharacter() throws Exception {
        int n;
        String string = "123456789.123456789.123456789.123456789.123456789.123456789.X123";
        String string2 = "123456789.123456789.123456789.123456789.123456789.123456789.X123";
        UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        for (n = 0; n < 3; ++n) {
            ((Attribute)uniqueIdentifierAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)uniqueIdentifierAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)uniqueIdentifierAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is still not valid", (!((Attribute)uniqueIdentifierAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)uniqueIdentifierAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)uniqueIdentifierAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_AgeString_GoodYear() throws Exception {
        int n;
        String string = "039Y";
        String string2 = "039Y";
        AgeStringAttribute ageStringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
        for (n = 0; n < 3; ++n) {
            ((Attribute)ageStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)ageStringAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)ageStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)ageStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_AgeString_GoodMonth() throws Exception {
        int n;
        String string = "011M";
        String string2 = "011M";
        AgeStringAttribute ageStringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
        for (n = 0; n < 3; ++n) {
            ((Attribute)ageStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)ageStringAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)ageStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)ageStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_AgeString_GoodWeek() throws Exception {
        int n;
        String string = "032W";
        String string2 = "032W";
        AgeStringAttribute ageStringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
        for (n = 0; n < 3; ++n) {
            ((Attribute)ageStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)ageStringAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)ageStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)ageStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_AgeString_GoodDay() throws Exception {
        int n;
        String string = "021D";
        String string2 = "021D";
        AgeStringAttribute ageStringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
        for (n = 0; n < 3; ++n) {
            ((Attribute)ageStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)ageStringAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)ageStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)ageStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_AgeString_BadUnit() throws Exception {
        int n;
        String string = "039X";
        String string2 = "039X";
        AgeStringAttribute ageStringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
        for (n = 0; n < 3; ++n) {
            ((Attribute)ageStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)ageStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)ageStringAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is still not valid", (!((Attribute)ageStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)ageStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)ageStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_AgeString_TooShort() throws Exception {
        int n;
        String string = "39Y";
        String string2 = "39Y";
        AgeStringAttribute ageStringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
        for (n = 0; n < 3; ++n) {
            ((Attribute)ageStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)ageStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)ageStringAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is still not valid", (!((Attribute)ageStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)ageStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)ageStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_AgeString_TooLong() throws Exception {
        int n;
        String string = "0039Y";
        String string2 = "0039Y";
        AgeStringAttribute ageStringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
        for (n = 0; n < 3; ++n) {
            ((Attribute)ageStringAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)ageStringAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)ageStringAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is still not valid", (!((Attribute)ageStringAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)ageStringAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)ageStringAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_Date_Good() throws Exception {
        int n;
        String string = "20140203";
        String string2 = "20140203";
        DateAttribute dateAttribute = new DateAttribute(TagFromName.StudyDate);
        for (n = 0; n < 3; ++n) {
            ((Attribute)dateAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)dateAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)dateAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)dateAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_Date_TooShort() throws Exception {
        int n;
        String string = "201402";
        String string2 = "201402";
        DateAttribute dateAttribute = new DateAttribute(TagFromName.StudyDate);
        for (n = 0; n < 3; ++n) {
            ((Attribute)dateAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)dateAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)dateAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is still not valid", (!((Attribute)dateAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)dateAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)dateAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_Date_TooLong() throws Exception {
        int n;
        String string = "201402031";
        String string2 = "201402031";
        DateAttribute dateAttribute = new DateAttribute(TagFromName.StudyDate);
        for (n = 0; n < 3; ++n) {
            ((Attribute)dateAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)dateAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)dateAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is still not valid", (!((Attribute)dateAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)dateAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)dateAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_Date_BadPeriods() throws Exception {
        int n;
        String string = "2014.02.03";
        String string2 = "20140203";
        DateAttribute dateAttribute = new DateAttribute(TagFromName.StudyDate);
        for (n = 0; n < 3; ++n) {
            ((Attribute)dateAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)dateAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)dateAttribute).repairValues());
        TestRepairAttributeValues.assertTrue((String)"Is valid after repair", (boolean)((Attribute)dateAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)dateAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)dateAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_Date_BadSlashes() throws Exception {
        int n;
        String string = "2014/02/03";
        String string2 = "20140203";
        DateAttribute dateAttribute = new DateAttribute(TagFromName.StudyDate);
        for (n = 0; n < 3; ++n) {
            ((Attribute)dateAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)dateAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)dateAttribute).repairValues());
        TestRepairAttributeValues.assertTrue((String)"Is valid after repair", (boolean)((Attribute)dateAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)dateAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)dateAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_DateTime_GoodWithTimezoneAndFullFraction() throws Exception {
        int n;
        String string = "20140203191536.123456-0500";
        String string2 = "20140203191536.123456-0500";
        DateTimeAttribute dateTimeAttribute = new DateTimeAttribute(TagFromName.AcquisitionDateTime);
        for (n = 0; n < 3; ++n) {
            ((Attribute)dateTimeAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)dateTimeAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)dateTimeAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)dateTimeAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_DateTime_GoodWithNoTimezoneAndNoFraction() throws Exception {
        int n;
        String string = "20140203191536";
        String string2 = "20140203191536";
        DateTimeAttribute dateTimeAttribute = new DateTimeAttribute(TagFromName.AcquisitionDateTime);
        for (n = 0; n < 3; ++n) {
            ((Attribute)dateTimeAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)dateTimeAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)dateTimeAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)dateTimeAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_DateTime_TooLong() throws Exception {
        int n;
        String string = "         20140203191536.123456-0500            ";
        String string2 = "20140203191536.123456-0500";
        DateTimeAttribute dateTimeAttribute = new DateTimeAttribute(TagFromName.AcquisitionDateTime);
        for (n = 0; n < 3; ++n) {
            ((Attribute)dateTimeAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)dateTimeAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)dateTimeAttribute).repairValues());
        TestRepairAttributeValues.assertTrue((String)"Is valid after repair", (boolean)((Attribute)dateTimeAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)dateTimeAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)dateTimeAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_DateTime_EmbeddedBadCharacter() throws Exception {
        int n;
        String string = "20140203:191536";
        String string2 = "20140203:191536";
        DateTimeAttribute dateTimeAttribute = new DateTimeAttribute(TagFromName.AcquisitionDateTime);
        for (n = 0; n < 3; ++n) {
            ((Attribute)dateTimeAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)dateTimeAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)dateTimeAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is still not valid", (!((Attribute)dateTimeAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)dateTimeAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)dateTimeAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_Time_Good() throws Exception {
        int n;
        String string = "193217.123456 ";
        String string2 = "193217.123456";
        TimeAttribute timeAttribute = new TimeAttribute(TagFromName.StudyTime);
        for (n = 0; n < 3; ++n) {
            ((Attribute)timeAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)timeAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)timeAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)timeAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_Time_TooShort() throws Exception {
        int n;
        String string = "1";
        String string2 = "1";
        TimeAttribute timeAttribute = new TimeAttribute(TagFromName.StudyTime);
        for (n = 0; n < 3; ++n) {
            ((Attribute)timeAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)timeAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)timeAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is still not valid", (!((Attribute)timeAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)timeAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)timeAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_Time_TooLong() throws Exception {
        int n;
        String string = "193217.12345678";
        String string2 = "193217.12345678";
        TimeAttribute timeAttribute = new TimeAttribute(TagFromName.StudyTime);
        for (n = 0; n < 3; ++n) {
            ((Attribute)timeAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)timeAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair unsuccessful", (!((Attribute)timeAttribute).repairValues() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Is still not valid", (!((Attribute)timeAttribute).isValid() ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)timeAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)timeAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_Time_BadColons() throws Exception {
        int n;
        String string = "19:32:17.123";
        String string2 = "193217.123";
        TimeAttribute timeAttribute = new TimeAttribute(TagFromName.StudyTime);
        for (n = 0; n < 3; ++n) {
            ((Attribute)timeAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is not valid", (!((Attribute)timeAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)timeAttribute).repairValues());
        TestRepairAttributeValues.assertTrue((String)"Is valid after repair", (boolean)((Attribute)timeAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)timeAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)timeAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_UnlimitedCharacters_Good() throws Exception {
        int n;
        String string = "It was the best of times, it was the worst of times, it was the ";
        String string2 = "It was the best of times, it was the worst of times, it was the";
        UnlimitedCharactersAttribute unlimitedCharactersAttribute = new UnlimitedCharactersAttribute(TagFromName.StudyDescription);
        for (n = 0; n < 3; ++n) {
            ((Attribute)unlimitedCharactersAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)unlimitedCharactersAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)unlimitedCharactersAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)unlimitedCharactersAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_UnlimitedCharacters_Trim() throws Exception {
        int n;
        String string = "         It was the best of times, it was the worst of times, it was the            ";
        String string2 = "It was the best of times, it was the worst of times, it was the";
        UnlimitedCharactersAttribute unlimitedCharactersAttribute = new UnlimitedCharactersAttribute(TagFromName.StudyDescription);
        for (n = 0; n < 3; ++n) {
            ((Attribute)unlimitedCharactersAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Length OK", (boolean)((StringAttribute)unlimitedCharactersAttribute).areLengthsOfValuesValid());
        TestRepairAttributeValues.assertTrue((String)"Valid characters", (boolean)((StringAttribute)unlimitedCharactersAttribute).areCharactersInValuesValid());
        TestRepairAttributeValues.assertTrue((String)"Well formed", (boolean)((StringAttribute)unlimitedCharactersAttribute).areValuesWellFormed());
        TestRepairAttributeValues.assertTrue((String)"Is valid", (boolean)((Attribute)unlimitedCharactersAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string, (String)((Attribute)unlimitedCharactersAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)unlimitedCharactersAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_UnlimitedCharacters_ControlCharacter() throws Exception {
        int n;
        String string = "Hello,\nworld.";
        String string2 = "Hello, world.";
        UnlimitedCharactersAttribute unlimitedCharactersAttribute = new UnlimitedCharactersAttribute(TagFromName.ImageType);
        for (n = 0; n < 3; ++n) {
            ((Attribute)unlimitedCharactersAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Length OK", (boolean)((StringAttribute)unlimitedCharactersAttribute).areLengthsOfValuesValid());
        TestRepairAttributeValues.assertTrue((String)"Invalid characters", (!((StringAttribute)unlimitedCharactersAttribute).areCharactersInValuesValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Well formed", (boolean)((StringAttribute)unlimitedCharactersAttribute).areValuesWellFormed());
        TestRepairAttributeValues.assertTrue((String)"Is invalid", (!((Attribute)unlimitedCharactersAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)unlimitedCharactersAttribute).repairValues());
        TestRepairAttributeValues.assertTrue((String)"Is valid after repair", (boolean)((Attribute)unlimitedCharactersAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)unlimitedCharactersAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)unlimitedCharactersAttribute.getStringValues()[n]);
        }
    }

    public void TestRepairAttributeValues_UnlimitedCharacters_EmbeddedBackslash() throws Exception {
        int n;
        String string = "Hello,\\world.";
        String string2 = "Hello, world.";
        UnlimitedCharactersAttribute unlimitedCharactersAttribute = new UnlimitedCharactersAttribute(TagFromName.ImageType);
        for (n = 0; n < 3; ++n) {
            ((Attribute)unlimitedCharactersAttribute).addValue(string);
        }
        TestRepairAttributeValues.assertTrue((String)"Is invalid", (!((Attribute)unlimitedCharactersAttribute).isValid() ? 1 : 0) != 0);
        TestRepairAttributeValues.assertTrue((String)"Repair successful", (boolean)((Attribute)unlimitedCharactersAttribute).repairValues());
        TestRepairAttributeValues.assertTrue((String)"Is valid after repair", (boolean)((Attribute)unlimitedCharactersAttribute).isValid());
        for (n = 0; n < 3; ++n) {
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)((Attribute)unlimitedCharactersAttribute).getOriginalStringValues()[n]);
            TestRepairAttributeValues.assertEquals((String)"Checking ", (String)string2, (String)unlimitedCharactersAttribute.getStringValues()[n]);
        }
    }
}

